-- --------------------------------------------------------
-- Sunucu:                       127.0.0.1
-- Sunucu sürümü:                10.4.32-MariaDB - mariadb.org binary distribution
-- Sunucu İşletim Sistemi:       Win64
-- HeidiSQL Sürüm:               12.11.0.7065
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- sirrusdb için veritabanı yapısı dökülüyor
CREATE DATABASE IF NOT EXISTS `sirrusdb` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci */;
USE `sirrusdb`;

-- tablo yapısı dökülüyor sirrusdb.abonelikler
CREATE TABLE IF NOT EXISTS `abonelikler` (
  `abonelik_id` int(11) NOT NULL AUTO_INCREMENT,
  `uye_id` int(11) NOT NULL,
  `firma_id` int(11) NOT NULL,
  `plan_id` int(11) NOT NULL,
  `odeme_periyodu` enum('aylik','yillik') DEFAULT 'aylik',
  `baslangic_tarihi` date NOT NULL,
  `bitis_tarihi` date NOT NULL,
  `deneme_bitis` date DEFAULT NULL COMMENT 'Deneme sÃ¼resi bitiÅŸ tarihi',
  `deneme_mi` tinyint(1) DEFAULT 1 COMMENT 'Hala deneme sÃ¼resinde mi',
  `otomatik_yenileme` tinyint(1) DEFAULT 0 COMMENT 'Otomatik yenilensin mi (sorulacak)',
  `son_odeme_tarihi` date DEFAULT NULL,
  `sonraki_odeme_tarihi` date DEFAULT NULL,
  `tolerans_gun` int(11) DEFAULT 10 COMMENT 'Ã–deme gecikme toleransÄ±',
  `tolerans_bitis` date DEFAULT NULL COMMENT 'Tolerans bitiÅŸ tarihi',
  `durum` enum('deneme','aktif','beklemede','gecikmi','askida','iptal') DEFAULT 'deneme',
  `iptal_tarihi` date DEFAULT NULL,
  `iptal_nedeni` text DEFAULT NULL,
  `notlar` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`abonelik_id`),
  KEY `idx_uye_id` (`uye_id`),
  KEY `idx_firma_id` (`firma_id`),
  KEY `idx_plan_id` (`plan_id`),
  KEY `idx_durum` (`durum`),
  KEY `idx_bitis_tarihi` (`bitis_tarihi`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- sirrusdb.abonelikler: ~0 rows (yaklaşık) tablosu için veriler indiriliyor

-- tablo yapısı dökülüyor sirrusdb.abonelik_faturalar
CREATE TABLE IF NOT EXISTS `abonelik_faturalar` (
  `fatura_id` int(11) NOT NULL AUTO_INCREMENT,
  `odeme_id` int(11) NOT NULL,
  `abonelik_id` int(11) NOT NULL,
  `uye_id` int(11) NOT NULL,
  `firma_id` int(11) NOT NULL,
  `fatura_no` varchar(30) NOT NULL COMMENT 'Fatura numarasÄ± (SRS-2024-000001)',
  `fatura_seri` varchar(10) DEFAULT 'SRS',
  `fatura_tarihi` date NOT NULL,
  `fatura_turu` enum('satis','iade') DEFAULT 'satis',
  `musteri_adi` varchar(200) NOT NULL,
  `musteri_adres` text DEFAULT NULL,
  `musteri_vergi_no` varchar(20) DEFAULT NULL,
  `musteri_vergi_dairesi` varchar(100) DEFAULT NULL,
  `ara_toplam` decimal(10,2) NOT NULL,
  `kdv_oran` decimal(5,2) DEFAULT 20.00,
  `kdv_tutar` decimal(10,2) DEFAULT 0.00,
  `indirim_tutar` decimal(10,2) DEFAULT 0.00,
  `genel_toplam` decimal(10,2) NOT NULL,
  `para_birimi` varchar(3) DEFAULT 'TRY',
  `aciklama` text DEFAULT NULL,
  `pdf_url` varchar(255) DEFAULT NULL COMMENT 'Fatura PDF dosya yolu',
  `e_fatura_mi` tinyint(1) DEFAULT 0,
  `e_fatura_uuid` varchar(50) DEFAULT NULL,
  `durum` enum('taslak','kesildi','iptal') DEFAULT 'taslak',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`fatura_id`),
  UNIQUE KEY `uk_fatura_no` (`fatura_no`),
  KEY `idx_odeme_id` (`odeme_id`),
  KEY `idx_abonelik_id` (`abonelik_id`),
  KEY `idx_uye_id` (`uye_id`),
  KEY `idx_firma_id` (`firma_id`),
  KEY `idx_fatura_tarihi` (`fatura_tarihi`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- sirrusdb.abonelik_faturalar: ~0 rows (yaklaşık) tablosu için veriler indiriliyor

-- tablo yapısı dökülüyor sirrusdb.abonelik_odemeler
CREATE TABLE IF NOT EXISTS `abonelik_odemeler` (
  `odeme_id` int(11) NOT NULL AUTO_INCREMENT,
  `abonelik_id` int(11) NOT NULL,
  `uye_id` int(11) NOT NULL,
  `firma_id` int(11) NOT NULL,
  `odeme_no` varchar(30) NOT NULL COMMENT 'Benzersiz Ã¶deme numarasÄ±',
  `plan_id` int(11) NOT NULL,
  `odeme_periyodu` enum('aylik','yillik') DEFAULT 'aylik',
  `donem_baslangic` date NOT NULL COMMENT 'Ã–demenin kapsadÄ±ÄŸÄ± dÃ¶nem baÅŸlangÄ±cÄ±',
  `donem_bitis` date NOT NULL COMMENT 'Ã–demenin kapsadÄ±ÄŸÄ± dÃ¶nem bitiÅŸi',
  `tutar` decimal(10,2) NOT NULL,
  `kdv_oran` decimal(5,2) DEFAULT 20.00,
  `kdv_tutar` decimal(10,2) DEFAULT 0.00,
  `toplam_tutar` decimal(10,2) NOT NULL,
  `indirim_tutar` decimal(10,2) DEFAULT 0.00,
  `indirim_aciklama` varchar(255) DEFAULT NULL,
  `odeme_yontemi` enum('havale','eft','kredi_karti','nakit','diger') DEFAULT 'havale',
  `banka_adi` varchar(100) DEFAULT NULL,
  `dekont_no` varchar(50) DEFAULT NULL,
  `odeme_tarihi` date DEFAULT NULL COMMENT 'Fiili Ã¶deme tarihi',
  `vade_tarihi` date NOT NULL COMMENT 'Son Ã¶deme tarihi',
  `durum` enum('beklemede','onaylandi','iptal','iade') DEFAULT 'beklemede',
  `onay_tarihi` datetime DEFAULT NULL,
  `onaylayan_id` int(11) DEFAULT NULL COMMENT 'Admin kullanÄ±cÄ± ID',
  `aciklama` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`odeme_id`),
  UNIQUE KEY `uk_odeme_no` (`odeme_no`),
  KEY `idx_abonelik_id` (`abonelik_id`),
  KEY `idx_uye_id` (`uye_id`),
  KEY `idx_firma_id` (`firma_id`),
  KEY `idx_durum` (`durum`),
  KEY `idx_odeme_tarihi` (`odeme_tarihi`),
  KEY `fk_odeme_plan` (`plan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- sirrusdb.abonelik_odemeler: ~0 rows (yaklaşık) tablosu için veriler indiriliyor

-- tablo yapısı dökülüyor sirrusdb.abonelik_planlari
CREATE TABLE IF NOT EXISTS `abonelik_planlari` (
  `plan_id` int(11) NOT NULL AUTO_INCREMENT,
  `plan_kodu` varchar(20) NOT NULL COMMENT 'DEMO, BASLANGIC, PRO, KURUMSAL',
  `plan_adi` varchar(50) NOT NULL,
  `aciklama` text DEFAULT NULL,
  `max_sube` int(11) DEFAULT 1 COMMENT 'Maksimum ÅŸube sayÄ±sÄ± (0=sÄ±nÄ±rsÄ±z)',
  `max_kullanici` int(11) DEFAULT 1 COMMENT 'Maksimum kullanÄ±cÄ± sayÄ±sÄ± (0=sÄ±nÄ±rsÄ±z)',
  `max_urun` int(11) DEFAULT 100 COMMENT 'Maksimum Ã¼rÃ¼n sayÄ±sÄ± (0=sÄ±nÄ±rsÄ±z)',
  `max_cari` int(11) DEFAULT 50 COMMENT 'Maksimum cari sayÄ±sÄ± (0=sÄ±nÄ±rsÄ±z)',
  `max_aylik_satis` int(11) DEFAULT 500 COMMENT 'AylÄ±k maksimum satÄ±ÅŸ (0=sÄ±nÄ±rsÄ±z)',
  `ozellikler` longtext DEFAULT NULL COMMENT 'JSON - Ek Ã¶zellikler',
  `aylik_fiyat` decimal(10,2) DEFAULT 0.00,
  `yillik_fiyat` decimal(10,2) DEFAULT 0.00 COMMENT 'YÄ±llÄ±k Ã¶deme indirimi',
  `deneme_suresi_gun` int(11) DEFAULT 7 COMMENT 'Deneme sÃ¼resi (gÃ¼n)',
  `sira` int(11) DEFAULT 0 COMMENT 'GÃ¶rÃ¼ntÃ¼leme sÄ±rasÄ±',
  `aktif` tinyint(1) DEFAULT 1,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`plan_id`),
  UNIQUE KEY `uk_plan_kodu` (`plan_kodu`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- sirrusdb.abonelik_planlari: ~4 rows (yaklaşık) tablosu için veriler indiriliyor
REPLACE INTO `abonelik_planlari` (`plan_id`, `plan_kodu`, `plan_adi`, `aciklama`, `max_sube`, `max_kullanici`, `max_urun`, `max_cari`, `max_aylik_satis`, `ozellikler`, `aylik_fiyat`, `yillik_fiyat`, `deneme_suresi_gun`, `sira`, `aktif`, `created_at`, `updated_at`) VALUES
	(1, 'DEMO', 'Demo', '7 gÃ¼nlÃ¼k Ã¼cretsiz deneme', 1, 1, 100, 50, 500, '{"raporlar": false, "api_erisim": false, "destek": "email"}', 0.00, 0.00, 7, 1, 1, '2025-12-04 23:54:43', '2025-12-04 23:54:43'),
	(2, 'BASLANGIC', 'BaÅŸlangÄ±Ã§', 'KÃ¼Ã§Ã¼k iÅŸletmeler iÃ§in', 2, 3, 1000, 200, 2000, '{"raporlar": true, "api_erisim": false, "destek": "email"}', 299.00, 2990.00, 7, 2, 1, '2025-12-04 23:54:43', '2025-12-04 23:54:43'),
	(3, 'PRO', 'Profesyonel', 'BÃ¼yÃ¼yen iÅŸletmeler iÃ§in', 5, 10, 10000, 1000, 10000, '{"raporlar": true, "api_erisim": true, "destek": "telefon"}', 599.00, 5990.00, 7, 3, 1, '2025-12-04 23:54:43', '2025-12-04 23:54:43'),
	(4, 'KURUMSAL', 'Kurumsal', 'BÃ¼yÃ¼k iÅŸletmeler iÃ§in', 0, 0, 0, 0, 0, '{"raporlar": true, "api_erisim": true, "destek": "oncelikli"}', 999.00, 9990.00, 7, 4, 1, '2025-12-04 23:54:43', '2025-12-04 23:54:43');

-- tablo yapısı dökülüyor sirrusdb.alis_fatura
CREATE TABLE IF NOT EXISTS `alis_fatura` (
  `alis_fatura_id` int(11) NOT NULL AUTO_INCREMENT,
  `firma_id` int(11) NOT NULL DEFAULT 1,
  `sube_id` int(11) DEFAULT 1,
  `fatura_no` varchar(50) NOT NULL COMMENT 'Tedarikçi fatura numarası',
  `fatura_tarihi` date NOT NULL,
  `fatura_saati` time DEFAULT NULL,
  `kayit_no` varchar(20) DEFAULT NULL COMMENT 'Sistemdeki kayıt numarası (ALF2024000001)',
  `vade_tarihi` date DEFAULT NULL,
  `fatura_tipi` enum('ALIS','IADE','GIDER') NOT NULL DEFAULT 'ALIS' COMMENT 'ALIS=Normal alış, IADE=Tedarikçiye iade, GIDER=Gider faturası',
  `belge_turu` enum('FATURA','EFATURA','EARSIV','MUSTAHSIL','SERBEST_MESLEK','GIDER_PUSULASI','DIGER') DEFAULT 'FATURA',
  `efatura_mi` tinyint(1) DEFAULT 0,
  `ettn` varchar(36) DEFAULT NULL COMMENT 'Gelen e-fatura ETTN',
  `gelen_efatura_id` int(11) DEFAULT NULL COMMENT 'gelen_efatura tablosu referansı',
  `cari_id` int(11) DEFAULT NULL,
  `tedarikci_vkn` varchar(11) DEFAULT NULL,
  `tedarikci_tckn` varchar(11) DEFAULT NULL,
  `tedarikci_unvan` varchar(300) NOT NULL,
  `tedarikci_adres` text DEFAULT NULL,
  `tedarikci_il` varchar(100) DEFAULT NULL,
  `tedarikci_ilce` varchar(100) DEFAULT NULL,
  `tedarikci_vergi_dairesi` varchar(100) DEFAULT NULL,
  `tedarikci_telefon` varchar(30) DEFAULT NULL,
  `tedarikci_email` varchar(150) DEFAULT NULL,
  `para_birimi` varchar(3) NOT NULL DEFAULT 'TRY',
  `doviz_kuru` decimal(15,6) DEFAULT 1.000000,
  `kur_tarihi` date DEFAULT NULL,
  `mal_hizmet_toplami` decimal(18,4) NOT NULL DEFAULT 0.0000,
  `toplam_iskonto` decimal(18,4) DEFAULT 0.0000,
  `kdv_matrahi` decimal(18,4) DEFAULT 0.0000,
  `hesaplanan_kdv` decimal(18,4) DEFAULT 0.0000,
  `tevkifat_toplami` decimal(18,4) DEFAULT 0.0000 COMMENT 'Tevkifat varsa kesilen KDV',
  `odenecek_kdv` decimal(18,4) DEFAULT 0.0000 COMMENT 'Fiili ödenecek KDV (hesaplanan - tevkifat)',
  `diger_vergiler` decimal(18,4) DEFAULT 0.0000 COMMENT 'ÖTV, ÖİV vb.',
  `vergiler_dahil_toplam` decimal(18,4) DEFAULT 0.0000,
  `odenecek_tutar` decimal(18,4) NOT NULL DEFAULT 0.0000,
  `odeme_durumu` enum('ODENMEDI','KISMI_ODENDI','ODENDI') DEFAULT 'ODENMEDI',
  `odenen_tutar` decimal(18,4) DEFAULT 0.0000,
  `kalan_tutar` decimal(18,4) DEFAULT 0.0000,
  `odeme_sekli` varchar(50) DEFAULT NULL,
  `son_odeme_tarihi` date DEFAULT NULL,
  `irsaliye_no` varchar(50) DEFAULT NULL,
  `irsaliye_tarihi` date DEFAULT NULL,
  `iade_fatura_id` int(11) DEFAULT NULL COMMENT 'İade edilen orijinal fatura',
  `iade_fatura_no` varchar(50) DEFAULT NULL,
  `iade_nedeni` text DEFAULT NULL,
  `pdf_dosya` varchar(500) DEFAULT NULL,
  `xml_dosya` varchar(500) DEFAULT NULL,
  `ek_belgeler` text DEFAULT NULL COMMENT 'JSON - ek belge yolları',
  `stok_girisi_yapildi` tinyint(1) DEFAULT 0,
  `stok_giris_tarihi` datetime DEFAULT NULL,
  `muhasebe_fisi_kesildi` tinyint(1) DEFAULT 0,
  `muhasebe_fis_no` varchar(50) DEFAULT NULL,
  `aciklama` text DEFAULT NULL,
  `dahili_not` text DEFAULT NULL,
  `durum` enum('TASLAK','ONAY_BEKLIYOR','ONAYLANDI','IPTAL') DEFAULT 'TASLAK',
  `iptal_tarihi` datetime DEFAULT NULL,
  `iptal_nedeni` text DEFAULT NULL,
  `olusturan_id` int(11) DEFAULT NULL,
  `olusturma_tarihi` datetime DEFAULT current_timestamp(),
  `guncelleyen_id` int(11) DEFAULT NULL,
  `guncelleme_tarihi` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `onaylayan_id` int(11) DEFAULT NULL,
  `onay_tarihi` datetime DEFAULT NULL,
  PRIMARY KEY (`alis_fatura_id`),
  UNIQUE KEY `uk_firma_kayit_no` (`firma_id`,`kayit_no`),
  KEY `idx_firma_id` (`firma_id`),
  KEY `idx_cari_id` (`cari_id`),
  KEY `idx_fatura_tarihi` (`fatura_tarihi`),
  KEY `idx_fatura_tipi` (`fatura_tipi`),
  KEY `idx_tedarikci_vkn` (`tedarikci_vkn`),
  KEY `idx_durum` (`durum`),
  KEY `idx_odeme_durumu` (`odeme_durumu`),
  KEY `idx_ettn` (`ettn`),
  KEY `idx_gelen_efatura` (`gelen_efatura_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Alış Faturaları (Tedarikçiden Alım)';

-- sirrusdb.alis_fatura: ~0 rows (yaklaşık) tablosu için veriler indiriliyor

-- tablo yapısı dökülüyor sirrusdb.alis_fatura_kalem
CREATE TABLE IF NOT EXISTS `alis_fatura_kalem` (
  `kalem_id` int(11) NOT NULL AUTO_INCREMENT,
  `alis_fatura_id` int(11) NOT NULL,
  `sira_no` int(11) NOT NULL,
  `urun_id` int(11) DEFAULT NULL,
  `urun_kodu` varchar(50) DEFAULT NULL,
  `barkod` varchar(50) DEFAULT NULL,
  `urun_adi` varchar(300) NOT NULL,
  `urun_aciklama` text DEFAULT NULL,
  `miktar` decimal(18,4) NOT NULL,
  `birim_kodu` varchar(10) NOT NULL DEFAULT 'C62',
  `birim_adi` varchar(50) DEFAULT 'Adet',
  `birim_fiyat` decimal(18,4) NOT NULL COMMENT 'KDV hariç birim fiyat',
  `kdv_dahil_birim_fiyat` decimal(18,4) DEFAULT NULL,
  `iskonto1_oran` decimal(5,2) DEFAULT 0.00 COMMENT 'İskonto 1 Oranı %',
  `iskonto1_tutar` decimal(18,4) DEFAULT 0.0000 COMMENT 'İskonto 1 Tutarı',
  `iskonto1_neden` varchar(50) DEFAULT NULL COMMENT 'İskonto 1 Nedeni',
  `iskonto2_oran` decimal(5,2) DEFAULT 0.00 COMMENT 'İskonto 2 Oranı %',
  `iskonto2_tutar` decimal(18,4) DEFAULT 0.0000 COMMENT 'İskonto 2 Tutarı',
  `iskonto2_neden` varchar(50) DEFAULT NULL COMMENT 'İskonto 2 Nedeni',
  `iskonto3_oran` decimal(5,2) DEFAULT 0.00 COMMENT 'İskonto 3 Oranı %',
  `iskonto3_tutar` decimal(18,4) DEFAULT 0.0000 COMMENT 'İskonto 3 Tutarı',
  `iskonto3_neden` varchar(50) DEFAULT NULL COMMENT 'İskonto 3 Nedeni',
  `iskonto4_oran` decimal(5,2) DEFAULT 0.00 COMMENT 'İskonto 4 Oranı %',
  `iskonto4_tutar` decimal(18,4) DEFAULT 0.0000 COMMENT 'İskonto 4 Tutarı',
  `iskonto4_neden` varchar(50) DEFAULT NULL COMMENT 'İskonto 4 Nedeni',
  `iskonto5_oran` decimal(5,2) DEFAULT 0.00 COMMENT 'İskonto 5 Oranı %',
  `iskonto5_tutar` decimal(18,4) DEFAULT 0.0000 COMMENT 'İskonto 5 Tutarı',
  `iskonto5_neden` varchar(50) DEFAULT NULL COMMENT 'İskonto 5 Nedeni',
  `toplam_iskonto_tutar` decimal(18,4) DEFAULT 0.0000 COMMENT 'Satır Toplam İskonto Tutarı',
  `kdv_orani` decimal(5,2) NOT NULL DEFAULT 20.00,
  `kdv_tutari` decimal(18,4) NOT NULL DEFAULT 0.0000,
  `tevkifat_kodu` varchar(10) DEFAULT NULL,
  `tevkifat_orani` decimal(5,2) DEFAULT 0.00,
  `tevkifat_tutari` decimal(18,4) DEFAULT 0.0000,
  `otv_orani` decimal(5,2) DEFAULT 0.00,
  `otv_tutari` decimal(18,4) DEFAULT 0.0000,
  `kdv_matrah` decimal(18,4) NOT NULL DEFAULT 0.0000,
  `kdv_haric_tutar` decimal(18,4) NOT NULL DEFAULT 0.0000,
  `kdv_dahil_tutar` decimal(18,4) NOT NULL DEFAULT 0.0000,
  `satir_toplam` decimal(18,4) NOT NULL DEFAULT 0.0000,
  `stok_girisi_yapildi` tinyint(1) DEFAULT 0,
  `depo_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`kalem_id`),
  KEY `idx_alis_fatura_id` (`alis_fatura_id`),
  KEY `idx_urun_id` (`urun_id`),
  CONSTRAINT `fk_alis_kalem_fatura` FOREIGN KEY (`alis_fatura_id`) REFERENCES `alis_fatura` (`alis_fatura_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Alış Faturası Kalemleri';

-- sirrusdb.alis_fatura_kalem: ~0 rows (yaklaşık) tablosu için veriler indiriliyor

-- tablo yapısı dökülüyor sirrusdb.alis_fatura_kdv_ozet
CREATE TABLE IF NOT EXISTS `alis_fatura_kdv_ozet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alis_fatura_id` int(11) NOT NULL,
  `kdv_orani` decimal(5,2) NOT NULL,
  `kdv_matrahi` decimal(18,4) NOT NULL,
  `kdv_tutari` decimal(18,4) NOT NULL,
  `tevkifat_tutari` decimal(18,4) DEFAULT 0.0000,
  PRIMARY KEY (`id`),
  KEY `idx_alis_fatura_id` (`alis_fatura_id`),
  CONSTRAINT `fk_alis_kdv_fatura` FOREIGN KEY (`alis_fatura_id`) REFERENCES `alis_fatura` (`alis_fatura_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Alış Faturası KDV Özeti';

-- sirrusdb.alis_fatura_kdv_ozet: ~0 rows (yaklaşık) tablosu için veriler indiriliyor

-- tablo yapısı dökülüyor sirrusdb.alis_fatura_numara_serisi
CREATE TABLE IF NOT EXISTS `alis_fatura_numara_serisi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `firma_id` int(11) NOT NULL,
  `seri` varchar(3) NOT NULL DEFAULT 'ALF',
  `yil` int(4) NOT NULL,
  `son_sira` int(11) DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_firma_seri_yil` (`firma_id`,`seri`,`yil`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- sirrusdb.alis_fatura_numara_serisi: ~0 rows (yaklaşık) tablosu için veriler indiriliyor

-- tablo yapısı dökülüyor sirrusdb.alis_fatura_odeme
CREATE TABLE IF NOT EXISTS `alis_fatura_odeme` (
  `odeme_id` int(11) NOT NULL AUTO_INCREMENT,
  `alis_fatura_id` int(11) NOT NULL,
  `firma_id` int(11) NOT NULL,
  `cari_id` int(11) DEFAULT NULL,
  `odeme_no` varchar(30) DEFAULT NULL,
  `odeme_tarihi` date NOT NULL,
  `tutar` decimal(18,4) NOT NULL,
  `odeme_sekli` enum('NAKIT','HAVALE','EFT','CEK','SENET','KREDI_KARTI','DIGER') DEFAULT 'NAKIT',
  `banka_id` int(11) DEFAULT NULL,
  `banka_adi` varchar(100) DEFAULT NULL,
  `hesap_no` varchar(50) DEFAULT NULL,
  `cek_senet_no` varchar(50) DEFAULT NULL,
  `vade_tarihi` date DEFAULT NULL,
  `aciklama` text DEFAULT NULL,
  `durum` enum('BEKLEMEDE','TAMAMLANDI','IPTAL') DEFAULT 'TAMAMLANDI',
  `olusturan_id` int(11) DEFAULT NULL,
  `olusturma_tarihi` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`odeme_id`),
  KEY `idx_alis_fatura_id` (`alis_fatura_id`),
  KEY `idx_odeme_tarihi` (`odeme_tarihi`),
  CONSTRAINT `fk_alis_odeme_fatura` FOREIGN KEY (`alis_fatura_id`) REFERENCES `alis_fatura` (`alis_fatura_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Alış Faturası Ödemeleri';

-- sirrusdb.alis_fatura_odeme: ~0 rows (yaklaşık) tablosu için veriler indiriliyor

-- tablo yapısı dökülüyor sirrusdb.birimler
CREATE TABLE IF NOT EXISTS `birimler` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `birim_adi` varchar(50) NOT NULL,
  `birim_kodu` varchar(10) DEFAULT NULL,
  `aciklama` varchar(100) DEFAULT NULL,
  `aktif` tinyint(1) DEFAULT 1,
  `olusturma_tarihi` datetime DEFAULT current_timestamp(),
  `guncelleme_tarihi` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `ubl_kod` varchar(5) DEFAULT NULL COMMENT 'UBL-TR birim kodu (C62, KGM, LTR vb.)',
  `gib_kod` varchar(10) DEFAULT NULL COMMENT 'GİB birim kodu',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- sirrusdb.birimler: ~22 rows (yaklaşık) tablosu için veriler indiriliyor
REPLACE INTO `birimler` (`id`, `birim_adi`, `birim_kodu`, `aciklama`, `aktif`, `olusturma_tarihi`, `guncelleme_tarihi`, `ubl_kod`, `gib_kod`) VALUES
	(1, 'ADET', 'C62', 'Adet', 1, '2025-11-21 02:41:54', '2025-12-12 23:13:30', 'C62', NULL),
	(2, 'ÇİFT', 'PR', 'Çift', 1, '2025-11-21 02:41:54', '2025-11-27 00:56:16', NULL, NULL),
	(3, 'KG', 'KGM', 'Kilogram', 1, '2025-11-21 02:41:54', '2025-11-27 00:57:23', NULL, NULL),
	(4, 'GR', 'GRM', 'Gram', 1, '2025-11-21 02:41:54', '2025-11-27 00:57:36', NULL, NULL),
	(5, 'TON', 'TNE', 'Ton (Metrelik Ton)', 1, '2025-11-21 02:41:54', '2025-11-27 00:58:02', NULL, NULL),
	(6, 'LİTRE', 'LTR', 'Litre', 1, '2025-11-21 02:41:54', '2025-12-12 23:13:30', 'LTR', NULL),
	(7, 'PAKET', 'PA', 'Paket (Packet)', 1, '2025-11-21 02:41:54', '2025-11-27 00:58:29', NULL, NULL),
	(8, 'PAKET (Pack)', 'PK', 'Paket (Pack)', 1, '2025-11-21 02:41:54', '2025-11-27 00:58:42', NULL, NULL),
	(9, 'KUTU', 'BX', 'Kutu', 1, '2025-11-21 02:41:54', '2025-11-27 00:58:53', NULL, NULL),
	(10, 'METRE', 'MTR', 'Metre', 1, '2025-11-21 02:41:54', '2025-12-12 23:13:30', 'MTR', NULL),
	(11, 'M KARE', 'MTK', 'Metrekare', 1, '2025-11-21 02:41:54', '2025-11-27 00:59:19', NULL, NULL),
	(12, 'M KÜP', 'MTQ', 'Metreküp', 1, '2025-11-21 02:41:54', '2025-11-27 00:59:32', NULL, NULL),
	(13, 'CM', 'CMT', 'Santi Metre Kare', 1, '2025-11-21 02:41:54', '2025-11-27 01:00:10', NULL, NULL),
	(14, 'CM KARE', 'CMK', 'Santi Metre Kare', 1, '2025-11-21 02:41:54', '2025-11-27 01:00:41', NULL, NULL),
	(15, 'CM KÜP', 'CMQ', 'Santi Metre Küp', 1, '2025-11-21 02:41:54', '2025-11-27 01:01:04', NULL, NULL),
	(16, 'RULO', 'ROLL', 'Rulo', 1, '2025-11-21 02:41:54', '2025-11-27 01:01:16', NULL, NULL),
	(17, 'SET', 'SET', 'Set', 1, '2025-11-21 02:41:54', '2025-11-27 01:01:25', NULL, NULL),
	(18, 'DEKAR', 'UBL-U-001', 'Dekar', 1, '2025-11-21 02:41:54', '2025-11-27 01:01:35', NULL, NULL),
	(19, 'DÖNÜM', 'UBL-U-002', 'Dönüm', 1, '2025-11-21 02:41:54', '2025-11-27 01:01:46', NULL, NULL),
	(20, 'KİLOMETRE', 'KTM', 'Kilometre', 1, '2025-11-21 02:41:54', '2025-12-12 23:13:30', 'KGM', NULL),
	(21, 'KG-METRE KARE', 'B32', 'Kg-Metre Kare', 1, '2025-11-21 02:41:54', '2025-12-12 23:13:30', 'MTR', NULL),
	(22, 'KOLİ', NULL, 'Koli', 1, '2025-11-21 02:41:54', '2025-11-27 01:02:26', NULL, NULL);

-- tablo yapısı dökülüyor sirrusdb.cari_hareket
CREATE TABLE IF NOT EXISTS `cari_hareket` (
  `hareket_id` int(11) NOT NULL AUTO_INCREMENT,
  `firma_id` int(11) DEFAULT 1,
  `sube_id` int(11) DEFAULT 1,
  `user_id` int(11) DEFAULT 1,
  `hareket_no` varchar(20) NOT NULL,
  `hareket_tipi` enum('tahsilat','odeme','alacak','borc') NOT NULL,
  `cari_id` int(11) NOT NULL,
  `tarih` date NOT NULL,
  `saat` time DEFAULT NULL,
  `borc_tutar` decimal(18,4) NOT NULL DEFAULT 0.0000,
  `alacak_tutar` decimal(18,4) NOT NULL DEFAULT 0.0000,
  `odeme_turu` varchar(20) DEFAULT 'nakit',
  `belge_turu` varchar(50) DEFAULT NULL,
  `belge_no` varchar(50) DEFAULT NULL,
  `aciklama` text DEFAULT NULL,
  `durum` varchar(20) DEFAULT 'tamamlandi',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`hareket_id`),
  KEY `idx_cari` (`cari_id`),
  KEY `idx_tarih` (`tarih`),
  KEY `idx_tip` (`hareket_tipi`),
  KEY `idx_durum` (`durum`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- sirrusdb.cari_hareket: ~14 rows (yaklaşık) tablosu için veriler indiriliyor
REPLACE INTO `cari_hareket` (`hareket_id`, `firma_id`, `sube_id`, `user_id`, `hareket_no`, `hareket_tipi`, `cari_id`, `tarih`, `saat`, `borc_tutar`, `alacak_tutar`, `odeme_turu`, `belge_turu`, `belge_no`, `aciklama`, `durum`, `created_at`, `updated_at`) VALUES
	(18, 1, 1, 1, 'TH-0000001', 'tahsilat', 1, '2025-12-07', '22:23:49', 0.0000, 100.0000, 'nakit', NULL, NULL, NULL, 'tamamlandi', '2025-12-07 19:23:49', '2025-12-07 19:24:30'),
	(19, 1, 1, 1, 'OD-0000001', 'odeme', 1, '2025-12-07', '22:24:53', 200.0000, 0.0000, 'nakit', NULL, NULL, NULL, 'tamamlandi', '2025-12-07 19:24:53', '2025-12-07 19:24:53'),
	(20, 1, 1, 1, 'AL-0000001', 'alacak', 1, '2025-12-07', '22:25:29', 0.0000, 500.0000, 'nakit', NULL, NULL, NULL, 'tamamlandi', '2025-12-07 19:25:29', '2025-12-07 19:25:29'),
	(21, 1, 1, 1, 'BR-0000001', 'borc', 1, '2025-12-07', '22:26:08', 1000.0000, 0.0000, 'nakit', NULL, NULL, NULL, 'tamamlandi', '2025-12-07 19:26:08', '2025-12-07 19:26:08'),
	(22, 1, 1, 1, 'THS-5743488108', 'tahsilat', 1, '2025-12-14', '23:18:08', 0.0000, 340.0000, 'nakit', 'Veresiye Tahsilat', '00000000000000317', 'Fiş No: 00000000000000317 tahsilatı', 'tamamlandi', '2025-12-14 20:18:08', '2025-12-14 20:18:08'),
	(23, 1, 1, 1, 'THS-5744822725', 'tahsilat', 1, '2025-12-14', '23:40:22', 0.0000, 340.0000, 'nakit', 'Veresiye Tahsilat', '00000000000000316', 'Fiş No: 00000000000000316 tahsilatı', 'tamamlandi', '2025-12-14 20:40:22', '2025-12-14 20:40:22'),
	(24, 1, 1, 1, 'THS-5744866458', 'tahsilat', 1, '2025-12-14', '23:41:06', 0.0000, 340.0000, 'nakit', 'Veresiye Tahsilat', '00000000000000315', 'Fiş No: 00000000000000315 tahsilatı', 'tamamlandi', '2025-12-14 20:41:06', '2025-12-14 20:41:06'),
	(25, 1, 1, 1, 'THS-5744878059', 'tahsilat', 1, '2025-12-14', '23:41:18', 0.0000, 340.0000, 'nakit', 'Veresiye Tahsilat', '00000000000000309', 'Fiş No: 00000000000000309 tahsilatı', 'tamamlandi', '2025-12-14 20:41:18', '2025-12-14 20:41:18'),
	(26, 1, 1, 1, 'THS-5766508810', 'tahsilat', 1, '2025-12-15', '05:41:48', 0.0000, 340.0000, 'nakit', 'Veresiye Tahsilat', '00000000000000318', 'Veresiye Fiş No: 00000000000000318 tahsilatı', 'tamamlandi', '2025-12-15 02:41:48', '2025-12-15 02:41:48'),
	(27, 1, 1, 1, 'THS-5766530933', 'tahsilat', 1, '2025-12-15', '05:42:10', 0.0000, 385.0000, 'nakit', 'Veresiye Tahsilat', '00000000000000319', 'Veresiye Fiş No: 00000000000000319 tahsilatı', 'tamamlandi', '2025-12-15 02:42:10', '2025-12-15 02:42:10'),
	(28, 1, 1, 1, 'THS-5766622837', 'tahsilat', 1, '2025-12-15', '05:43:42', 0.0000, 680.0000, 'nakit', 'Veresiye Tahsilat', '00000000000000308', 'Veresiye Fiş No: 00000000000000308 tahsilatı', 'tamamlandi', '2025-12-15 02:43:42', '2025-12-15 02:43:42'),
	(29, 1, 1, 1, 'THS-5767250737', 'tahsilat', 1, '2025-12-15', '05:54:10', 0.0000, 340.0000, 'nakit', 'Veresiye Tahsilat', '00000000000000320', 'Veresiye Fiş No: 00000000000000320 tahsilatı', 'tamamlandi', '2025-12-15 02:54:10', '2025-12-15 02:54:10'),
	(30, 1, 1, 1, 'THS-5767793466', 'tahsilat', 1, '2025-12-15', '06:03:13', 0.0000, 385.0000, 'parcali', 'Veresiye Tahsilat', '00000000000000321', 'Veresiye Fiş No: 00000000000000321 parçalı tahsilatı (Nakit: 200.00, Kredi: 185.00)', 'tamamlandi', '2025-12-15 03:03:13', '2025-12-15 03:03:13'),
	(31, 1, 1, 1, 'THS-5772441170', 'tahsilat', 1, '2025-12-15', '07:20:41', 0.0000, 385.0000, 'parcali', 'Veresiye Tahsilat', '00000000000000322', 'Parçalı tahsilat (N:200.00 K:185.00)', 'tamamlandi', '2025-12-15 04:20:41', '2025-12-15 04:20:41'),
	(32, 1, 1, 1, 'THS-5976702325', 'tahsilat', 2, '2025-12-17', '16:05:02', 0.0000, 90.0000, 'nakit', 'Veresiye Tahsilat', '00000000000000333', 'Veresiye tahsilatı: 00000000000000333', 'tamamlandi', '2025-12-17 13:05:02', '2025-12-17 13:05:02');

-- tablo yapısı dökülüyor sirrusdb.cari_kart
CREATE TABLE IF NOT EXISTS `cari_kart` (
  `cari_id` int(11) NOT NULL AUTO_INCREMENT,
  `firma_id` int(11) NOT NULL DEFAULT 1,
  `sube_id` int(11) DEFAULT NULL,
  `cari_kod` varchar(50) NOT NULL,
  `cari_adi` varchar(100) DEFAULT NULL,
  `type` enum('customer','supplier','both') DEFAULT 'customer',
  `telefon` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `il` varchar(100) DEFAULT NULL,
  `ilce` varchar(100) DEFAULT NULL,
  `vergi_numarasi` varchar(50) DEFAULT NULL,
  `vergi_dairesi` varchar(100) DEFAULT NULL,
  `kredi_limit` decimal(18,4) DEFAULT 0.0000,
  `ekstra_bilgi` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '{}' CHECK (json_valid(`ekstra_bilgi`)),
  `aktif_mi` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `borc` decimal(18,4) DEFAULT NULL,
  `alacak` decimal(18,4) DEFAULT NULL,
  `bakiye` decimal(18,4) DEFAULT NULL,
  `cari_uuid` varchar(36) DEFAULT NULL,
  `sube_uuid` varchar(36) DEFAULT NULL,
  `efatura_mukellef` tinyint(1) DEFAULT 0 COMMENT 'E-Fatura mükellefi mi?',
  `efatura_kontrol_tarihi` datetime DEFAULT NULL COMMENT 'Son mükellef kontrol tarihi',
  `gb_etiketi` varchar(50) DEFAULT NULL COMMENT 'Gönderici Birim Etiketi',
  `pk_etiketi` varchar(50) DEFAULT NULL COMMENT 'Posta Kutusu Etiketi',
  `fatura_profili` varchar(20) DEFAULT 'TICARIFATURA' COMMENT 'Tercih edilen fatura profili',
  `ulke_kodu` varchar(2) DEFAULT 'TR' COMMENT 'ISO ülke kodu',
  `posta_kodu` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`cari_id`),
  UNIQUE KEY `customers_company_id_code_key` (`firma_id`,`cari_kod`),
  KEY `created_by` (`created_by`),
  KEY `idx_customers_company` (`firma_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1126 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- sirrusdb.cari_kart: ~18 rows (yaklaşık) tablosu için veriler indiriliyor
REPLACE INTO `cari_kart` (`cari_id`, `firma_id`, `sube_id`, `cari_kod`, `cari_adi`, `type`, `telefon`, `email`, `address`, `il`, `ilce`, `vergi_numarasi`, `vergi_dairesi`, `kredi_limit`, `ekstra_bilgi`, `aktif_mi`, `created_by`, `created_at`, `updated_at`, `borc`, `alacak`, `bakiye`, `cari_uuid`, `sube_uuid`, `efatura_mukellef`, `efatura_kontrol_tarihi`, `gb_etiketi`, `pk_etiketi`, `fatura_profili`, `ulke_kodu`, `posta_kodu`) VALUES
	(1, 1, NULL, 'MUST001', 'Ahmet Yılmaz', 'customer', '0555 111 2233', 'ahmet@email.com', 'ffff', 'il', 'ilçesi', '1234567890', 'meram', 0.0000, '{}', 1, NULL, '2025-11-18 00:04:05', '2025-12-20 20:55:38', 400.0000, 0.0000, 400.0000, 'fa473317-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(2, 1, NULL, 'MUST002', 'Ayşe Demir', 'customer', '0555 222 3344', 'ayse@email.com', '', '', '', '1230147781', '', 0.0000, '{}', 1, NULL, '2025-11-18 00:04:05', '2025-12-20 21:00:39', 770.0000, 0.0000, 770.0000, 'fa4735df-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(3, 1, NULL, 'MUST003', 'Mehmet Kaya', 'customer', '0555 333 4455', 'mehmet@email.com', '', NULL, NULL, '', '', 0.0000, '{}', 1, NULL, '2025-11-18 00:04:05', '2025-12-07 18:42:57', 0.0000, 0.0000, 0.0000, 'fa473678-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(4, 1, NULL, '3231', 'ffffffccc', 'customer', '', '', '', '', '', '', '', 0.0000, '{}', 1, 1, '2025-11-20 00:56:56', '2025-12-12 23:32:47', 0.0000, 0.0000, 0.0000, 'fa4736f4-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(5, 1, NULL, 'sss', 'sssslşkşşkşkşkş', 'customer', '', '', '', NULL, NULL, '', '', 0.0000, '{}', 1, 1, '2025-11-20 00:57:04', '2025-12-07 00:46:10', 0.0000, 0.0000, 0.0000, 'fa47375b-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1111, 1, NULL, 'a1111', 'sdsadadasd', 'customer', '4353453453', NULL, NULL, NULL, NULL, NULL, NULL, 0.0000, '{}', 1, NULL, '2025-11-20 01:02:15', '2025-12-07 18:42:50', 0.0000, 0.0000, 0.0000, 'fa4737ba-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1112, 1, NULL, 'aaaaaaaaaaaaaaaaa', 'aaaaaaaaaaaaaaaaaaaaa', 'customer', '', '', '', NULL, NULL, '', '', 0.0000, '{}', 0, 1, '2025-11-20 01:10:51', '2025-12-07 00:46:10', 0.0000, 0.0000, 0.0000, 'fa473822-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1113, 1, NULL, 'fsdfsd', 'sdfsdfdsf', 'customer', '', '', '', '', '', '', '', 0.0000, '{}', 1, 1, '2025-11-20 01:25:16', '2025-12-09 01:49:37', 0.0000, 0.0000, 0.0000, 'fa473887-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1114, 1, NULL, '555555555', '5555555555555555', 'customer', '', '', '', NULL, NULL, '', '', 0.0000, '{}', 0, 1, '2025-11-20 01:25:26', '2025-12-07 00:46:10', 0.0000, 0.0000, 0.0000, 'fa4738e2-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1115, 1, NULL, 'dd', 'dddssss', 'customer', '', '', '', '', '', '', '', 0.0000, '{}', 1, 1, '2025-11-20 01:39:37', '2025-12-12 23:31:10', 0.0000, 0.0000, 0.0000, 'fa47393b-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1116, 1, NULL, 'CARI001', 'ddddddcc', 'customer', '', '', '', '', '', '', 'asda', 0.0000, '{}', 1, NULL, '2025-11-27 02:10:34', '2025-12-12 23:37:31', 0.0000, 0.0000, 0.0000, 'fa473998-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1117, 1, NULL, 'CARI002', 'dasdsadas', 'customer', '', '', '', NULL, NULL, '', '', 0.0000, '{}', 0, NULL, '2025-11-27 02:10:49', '2025-12-07 00:46:10', 0.0000, 0.0000, 0.0000, 'fa4739f7-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1118, 1, NULL, 'CARI003', 'zczxczxczxczc', 'customer', '', '', '', NULL, NULL, '', '', 0.0000, '{}', 1, NULL, '2025-11-27 02:11:14', '2025-12-07 00:46:10', 0.0000, 0.0000, 0.0000, 'fa473a54-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1119, 1, NULL, '1111111', 'fffffffaaaaaaaaaaaaaaa', 'customer', '', '', '', '', '', '', '', 0.0000, '{}', 0, NULL, '2025-12-05 02:04:33', '2025-12-15 09:53:07', 0.0000, 0.0000, 0.0000, 'fa473aad-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1121, 1, NULL, 'hfghf', 'fghfghgfhgf', 'customer', '', '', '', '', '', '', '', 0.0000, '{}', 1, NULL, '2025-12-05 03:10:39', '2025-12-07 00:46:10', 0.0000, 0.0000, 0.0000, 'fa473b09-d2ec-11f0-8ced-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1122, 1, NULL, '0001', 'ffffffff', 'customer', '', '', '', '', '', '', '', 0.0000, '{}', 0, NULL, '2025-12-12 23:28:04', '2025-12-15 09:53:10', 0.0000, 0.0000, 0.0000, '0fc63978-d799-11f0-856d-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1123, 1, NULL, '00011', 'ffffff', 'customer', '', '', '', '', '', '', '', 0.0000, '{}', 0, NULL, '2025-12-12 23:28:19', '2025-12-15 09:53:04', 0.0000, 0.0000, 0.0000, '18ca23e2-d799-11f0-856d-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1124, 1, NULL, '0001121', 'fdsfsdfds', 'customer', '', '', '', '', '', '', '', 0.0000, '{}', 1, NULL, '2025-12-12 23:37:53', '2025-12-12 23:37:53', 0.0000, 0.0000, 0.0000, '6ebc429f-d79a-11f0-856d-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL),
	(1125, 1, NULL, '1111112', 'dsssssssssssssssssssssss', 'customer', '', '', '', '', '', '', '', 0.0000, '{}', 0, NULL, '2025-12-12 23:45:32', '2025-12-15 09:53:00', 0.0000, 0.0000, 0.0000, '804d4d5e-d79b-11f0-856d-98e7435bb2fa', NULL, 0, NULL, NULL, NULL, 'TICARIFATURA', 'TR', NULL);

-- tablo yapısı dökülüyor sirrusdb.cari_odeme
CREATE TABLE IF NOT EXISTS `cari_odeme` (
  `odeme_id` int(11) NOT NULL AUTO_INCREMENT,
  `firma_id` int(11) NOT NULL DEFAULT 1,
  `sube_id` int(11) NOT NULL DEFAULT 1 COMMENT 'Şube ID',
  `user_id` int(11) NOT NULL COMMENT 'İşlemi yapan kullanıcı ID',
  `cari_id` int(11) NOT NULL,
  `odeme_no` varchar(50) NOT NULL COMMENT 'Ödeme makbuz numarası (OD-2024120001)',
  `tarih` date NOT NULL COMMENT 'Ödeme tarihi',
  `saat` time DEFAULT NULL COMMENT 'Ödeme saati',
  `tutar` decimal(15,2) NOT NULL DEFAULT 0.00 COMMENT 'Ödeme tutarı',
  `belge_turu` enum('alis_faturasi','acik_hesap_alis','gider_faturasi','irsaliye','fatura_iade','avans','maas','vergi','diger') NOT NULL DEFAULT 'acik_hesap_alis' COMMENT 'Ödemenin ait olduğu belge türü',
  `belge_id` int(11) DEFAULT NULL COMMENT 'İlişkili belgenin ID si (alis.id, gider.id vs.)',
  `belge_no` varchar(50) DEFAULT NULL COMMENT 'İlişkili belge numarası (Fatura No vs.)',
  `belge_toplam_tutar` decimal(15,2) DEFAULT NULL COMMENT 'İlişkili belgenin toplam tutarı',
  `onceki_odeme` decimal(15,2) DEFAULT 0.00 COMMENT 'Bu belgeden önceki ödemeler toplamı',
  `kalan_borc` decimal(15,2) DEFAULT NULL COMMENT 'Bu ödemeden sonra kalan borç',
  `odeme_turu` enum('nakit','kredi_karti','havale','eft','cek','senet','diger') NOT NULL DEFAULT 'nakit',
  `banka_adi` varchar(100) DEFAULT NULL COMMENT 'Havale/EFT için banka adı',
  `banka_hesap_no` varchar(50) DEFAULT NULL COMMENT 'Banka hesap/IBAN numarası',
  `cek_senet_no` varchar(50) DEFAULT NULL COMMENT 'Çek veya senet numarası',
  `vade_tarihi` date DEFAULT NULL COMMENT 'Çek/Senet vade tarihi',
  `aciklama` text DEFAULT NULL COMMENT 'Ödeme açıklaması/notu',
  `durum` enum('beklemede','tamamlandi','iptal') NOT NULL DEFAULT 'tamamlandi',
  `iptal_nedeni` varchar(255) DEFAULT NULL,
  `iptal_tarihi` datetime DEFAULT NULL,
  `iptal_eden_id` int(11) DEFAULT NULL COMMENT 'İptal eden kullanıcı ID',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `odeme_uuid` varchar(36) DEFAULT NULL,
  `cari_uuid` varchar(36) DEFAULT NULL,
  `sube_uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`odeme_id`),
  KEY `idx_firma_id` (`firma_id`),
  KEY `idx_sube_id` (`sube_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_cari_id` (`cari_id`),
  KEY `idx_tarih` (`tarih`),
  KEY `idx_odeme_no` (`odeme_no`),
  KEY `idx_belge_turu` (`belge_turu`),
  KEY `idx_belge_id` (`belge_id`),
  KEY `idx_odeme_yontemi` (`odeme_turu`),
  KEY `idx_durum` (`durum`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Cariye yapılan ödemeler (para verme)';

-- sirrusdb.cari_odeme: ~0 rows (yaklaşık) tablosu için veriler indiriliyor
REPLACE INTO `cari_odeme` (`odeme_id`, `firma_id`, `sube_id`, `user_id`, `cari_id`, `odeme_no`, `tarih`, `saat`, `tutar`, `belge_turu`, `belge_id`, `belge_no`, `belge_toplam_tutar`, `onceki_odeme`, `kalan_borc`, `odeme_turu`, `banka_adi`, `banka_hesap_no`, `cek_senet_no`, `vade_tarihi`, `aciklama`, `durum`, `iptal_nedeni`, `iptal_tarihi`, `iptal_eden_id`, `created_at`, `updated_at`, `odeme_uuid`, `cari_uuid`, `sube_uuid`) VALUES
	(1, 1, 1, 1, 1, 'OD-2025120001', '2025-12-04', '22:03:29', 600.00, 'acik_hesap_alis', NULL, NULL, NULL, 0.00, NULL, 'nakit', NULL, NULL, NULL, NULL, NULL, 'tamamlandi', NULL, NULL, NULL, '2025-12-04 19:03:29', '2025-12-06 21:46:10', 'fa47e4ff-d2ec-11f0-8ced-98e7435bb2fa', NULL, NULL);

-- tablo yapısı dökülüyor sirrusdb.cari_tahsilat
CREATE TABLE IF NOT EXISTS `cari_tahsilat` (
  `tahsilat_id` int(11) NOT NULL AUTO_INCREMENT,
  `firma_id` int(11) NOT NULL DEFAULT 1,
  `sube_id` int(11) NOT NULL DEFAULT 1 COMMENT 'Şube ID',
  `user_id` int(11) NOT NULL COMMENT 'İşlemi yapan kullanıcı ID',
  `cari_id` int(11) NOT NULL,
  `tahsilat_no` varchar(50) NOT NULL COMMENT 'Tahsilat makbuz numarası (TH-2024120001)',
  `tarih` date NOT NULL COMMENT 'Tahsilat tarihi',
  `saat` time DEFAULT NULL COMMENT 'Tahsilat saati',
  `tutar` decimal(15,2) NOT NULL DEFAULT 0.00 COMMENT 'Tahsilat tutarı',
  `belge_turu` enum('satis_faturasi','acik_hesap_satis','hizli_satis','irsaliye','fatura_iade','avans','diger') NOT NULL DEFAULT 'acik_hesap_satis' COMMENT 'Tahsilatın ait olduğu belge türü',
  `belge_id` int(11) DEFAULT NULL COMMENT 'İlişkili belgenin ID si (satis.id, irsaliye.id vs.)',
  `belge_no` varchar(50) DEFAULT NULL COMMENT 'İlişkili belge numarası (Fatura No, Fiş No vs.)',
  `belge_toplam_tutar` decimal(15,2) DEFAULT NULL COMMENT 'İlişkili belgenin toplam tutarı',
  `onceki_tahsilat` decimal(15,2) DEFAULT 0.00 COMMENT 'Bu belgeden önceki tahsilatlar toplamı',
  `kalan_borc` decimal(15,2) DEFAULT NULL COMMENT 'Bu tahsilattan sonra kalan borç',
  `odeme_turu` enum('nakit','kredi_karti','havale','eft','cek','senet','diger') NOT NULL DEFAULT 'nakit',
  `banka_adi` varchar(100) DEFAULT NULL COMMENT 'Havale/EFT için banka adı',
  `banka_hesap_no` varchar(50) DEFAULT NULL COMMENT 'Banka hesap/IBAN numarası',
  `cek_senet_no` varchar(50) DEFAULT NULL COMMENT 'Çek veya senet numarası',
  `vade_tarihi` date DEFAULT NULL COMMENT 'Çek/Senet vade tarihi',
  `aciklama` text DEFAULT NULL COMMENT 'Tahsilat açıklaması/notu',
  `durum` enum('beklemede','tamamlandi','iptal') NOT NULL DEFAULT 'tamamlandi',
  `iptal_nedeni` varchar(255) DEFAULT NULL,
  `iptal_tarihi` datetime DEFAULT NULL,
  `iptal_eden_id` int(11) DEFAULT NULL COMMENT 'İptal eden kullanıcı ID',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `tahsilat_uuid` varchar(36) DEFAULT NULL,
  `cari_uuid` varchar(36) DEFAULT NULL,
  `sube_uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`tahsilat_id`),
  KEY `idx_firma_id` (`firma_id`),
  KEY `idx_sube_id` (`sube_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_cari_id` (`cari_id`),
  KEY `idx_tarih` (`tarih`),
  KEY `idx_tahsilat_no` (`tahsilat_no`),
  KEY `idx_belge_turu` (`belge_turu`),
  KEY `idx_belge_id` (`belge_id`),
  KEY `idx_odeme_turu` (`odeme_turu`),
  KEY `idx_durum` (`durum`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Cariden yapılan tahsilatlar (para alma)';

-- sirrusdb.cari_tahsilat: ~3 rows (yaklaşık) tablosu için veriler indiriliyor
REPLACE INTO `cari_tahsilat` (`tahsilat_id`, `firma_id`, `sube_id`, `user_id`, `cari_id`, `tahsilat_no`, `tarih`, `saat`, `tutar`, `belge_turu`, `belge_id`, `belge_no`, `belge_toplam_tutar`, `onceki_tahsilat`, `kalan_borc`, `odeme_turu`, `banka_adi`, `banka_hesap_no`, `cek_senet_no`, `vade_tarihi`, `aciklama`, `durum`, `iptal_nedeni`, `iptal_tarihi`, `iptal_eden_id`, `created_at`, `updated_at`, `tahsilat_uuid`, `cari_uuid`, `sube_uuid`) VALUES
	(1, 1, 1, 1, 1, 'TH-2025120001', '2025-12-04', '21:28:54', 500.00, 'satis_faturasi', NULL, NULL, NULL, 0.00, NULL, 'nakit', NULL, NULL, NULL, NULL, NULL, 'tamamlandi', NULL, NULL, NULL, '2025-12-04 18:28:54', '2025-12-06 21:46:10', 'fa4883fc-d2ec-11f0-8ced-98e7435bb2fa', NULL, NULL),
	(2, 1, 1, 1, 3, 'TH-2025120002', '2025-12-04', '21:30:02', 600.00, 'acik_hesap_satis', NULL, NULL, NULL, 0.00, NULL, 'nakit', NULL, NULL, NULL, NULL, NULL, 'tamamlandi', NULL, NULL, NULL, '2025-12-04 18:30:02', '2025-12-06 21:46:10', 'fa48860a-d2ec-11f0-8ced-98e7435bb2fa', NULL, NULL),
	(3, 1, 1, 1, 2, 'TH-2025120003', '2025-12-04', '22:03:02', 120.00, 'acik_hesap_satis', NULL, NULL, NULL, 0.00, NULL, 'nakit', NULL, NULL, NULL, NULL, NULL, 'tamamlandi', NULL, NULL, NULL, '2025-12-04 19:03:02', '2025-12-06 21:46:10', 'fa4886da-d2ec-11f0-8ced-98e7435bb2fa', NULL, NULL);

-- tablo yapısı dökülüyor sirrusdb.dogrulama_kodlari
CREATE TABLE IF NOT EXISTS `dogrulama_kodlari` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uye_id` int(11) DEFAULT NULL,
  `tip` enum('email','sms','sifre_sifirlama') NOT NULL,
  `hedef` varchar(100) NOT NULL COMMENT 'E-posta veya telefon',
  `kod` varchar(10) NOT NULL,
  `token` varchar(100) DEFAULT NULL COMMENT 'Link iÃ§in token',
  `gecerlilik_suresi` datetime NOT NULL,
  `kullanildi` tinyint(1) DEFAULT 0,
  `kullanilma_tarihi` datetime DEFAULT NULL,
  `deneme_sayisi` int(11) DEFAULT 0,
  `ip_adresi` varchar(45) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_uye_id` (`uye_id`),
  KEY `idx_tip_hedef` (`tip`,`hedef`),
  KEY `idx_kod` (`kod`),
  KEY `idx_token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- sirrusdb.dogrulama_kodlari: ~0 rows (yaklaşık) tablosu için veriler indiriliyor

-- tablo yapısı dökülüyor sirrusdb.doviz_ayarlari
CREATE TABLE IF NOT EXISTS `doviz_ayarlari` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `firma_id` int(11) DEFAULT 1,
  `setting_key` varchar(50) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_setting` (`firma_id`,`setting_key`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- sirrusdb.doviz_ayarlari: ~0 rows (yaklaşık) tablosu için veriler indiriliyor
REPLACE INTO `doviz_ayarlari` (`id`, `firma_id`, `setting_key`, `setting_value`, `updated_at`) VALUES
	(1, 1, 'update_interval', '7200000', '2025-12-07 21:43:09');

-- tablo yapısı dökülüyor sirrusdb.doviz_kurlari
CREATE TABLE IF NOT EXISTS `doviz_kurlari` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `firma_id` int(11) DEFAULT 1,
  `base_currency` varchar(5) DEFAULT 'TRY',
  `currency_code` varchar(5) NOT NULL,
  `currency_name` varchar(50) DEFAULT NULL,
  `currency_symbol` varchar(10) DEFAULT NULL,
  `buying_rate` decimal(15,6) DEFAULT 0.000000,
  `selling_rate` decimal(15,6) DEFAULT 0.000000,
  `rate` decimal(15,6) DEFAULT 0.000000,
  `change_rate` decimal(10,4) DEFAULT 0.0000,
  `change_percent` decimal(10,4) DEFAULT 0.0000,
  `source` varchar(50) DEFAULT 'manual',
  `is_active` tinyint(1) DEFAULT 1,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_currency` (`firma_id`,`currency_code`)
) ENGINE=InnoDB AUTO_INCREMENT=33409 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- sirrusdb.doviz_kurlari: ~24 rows (yaklaşık) tablosu için veriler indiriliyor
REPLACE INTO `doviz_kurlari` (`id`, `firma_id`, `base_currency`, `currency_code`, `currency_name`, `currency_symbol`, `buying_rate`, `selling_rate`, `rate`, `change_rate`, `change_percent`, `source`, `is_active`, `updated_at`, `created_at`) VALUES
	(1, 1, 'TRY', 'TRY', 'Türk Lirası', '₺', 1.000000, 1.000000, 1.000000, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(2, 1, 'TRY', 'USD', 'ABD DOLARI', '$', 42.747400, 42.824400, 42.785900, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(3, 1, 'TRY', 'AUD', 'AVUSTRALYA DOLARI', 'A$', 28.509400, 28.695300, 28.602350, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(4, 1, 'TRY', 'DKK', 'DANİMARKA KRONU', 'kr', 6.734700, 6.767700, 6.751200, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(5, 1, 'TRY', 'EUR', 'EURO', '€', 50.385700, 50.476400, 50.431050, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(6, 1, 'TRY', 'GBP', 'İNGİLİZ STERLİNİ', '£', 57.622900, 57.923300, 57.773100, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(7, 1, 'TRY', 'CHF', 'İSVİÇRE FRANGI', 'CHF', 54.060200, 54.407300, 54.233750, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(8, 1, 'TRY', 'SEK', 'İSVEÇ KRONU', 'kr', 4.626700, 4.674600, 4.650650, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(9, 1, 'TRY', 'CAD', 'KANADA DOLARI', 'C$', 31.118700, 31.259000, 31.188850, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(10, 1, 'TRY', 'KWD', 'KUVEYT DİNARI', 'KD', 138.395000, 140.206000, 139.300500, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(11, 1, 'TRY', 'NOK', 'NORVEÇ KRONU', 'kr', 4.232000, 4.260500, 4.246250, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(12, 1, 'TRY', 'SAR', 'SUUDİ ARABİSTAN RİYALİ', 'SR', 11.397100, 11.417700, 11.407400, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(13, 1, 'TRY', 'JPY', 'JAPON YENİ', '¥', 0.273353, 0.275163, 0.274258, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(14, 1, 'TRY', 'BGN', 'BULGAR LEVASI', 'лв', 25.614200, 25.949300, 25.781750, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(15, 1, 'TRY', 'RON', 'RUMEN LEYİ', 'lei', 9.846900, 9.975800, 9.911350, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(16, 1, 'TRY', 'RUB', 'RUS RUBLESİ', '₽', 0.542180, 0.549270, 0.545725, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(17, 1, 'TRY', 'CNY', 'ÇİN YUANI', '¥', 6.048100, 6.127300, 6.087700, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(18, 1, 'TRY', 'PKR', 'PAKİSTAN RUPİSİ', 'PKR', 0.151750, 0.153730, 0.152740, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(19, 1, 'TRY', 'QAR', 'KATAR RİYALİ', 'QAR', 11.661500, 11.814100, 11.737800, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(20, 1, 'TRY', 'KRW', 'GÜNEY KORE WONU', 'KRW', 0.028680, 0.029060, 0.028870, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(21, 1, 'TRY', 'AZN', 'AZERBAYCAN YENİ MANATI', 'AZN', 25.004600, 25.331800, 25.168200, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(22, 1, 'TRY', 'AED', 'BİRLEŞİK ARAP EMİRLİKLERİ DİRHEMİ', 'AED', 11.574200, 11.725700, 11.649950, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(23, 1, 'TRY', 'KZT', 'KAZAKİSTAN TENGESİ', 'KZT', 0.083350, 0.084440, 0.083895, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41'),
	(24, 1, 'TRY', 'XDR', 'ÖZEL ÇEKME HAKKI (SDR)                            ', 'XDR', 58.640100, 0.000000, 29.320050, 0.0000, 0.0000, 'tcmb', 1, '2025-12-23 19:58:26', '2025-12-07 21:42:41');

-- tablo yapısı dökülüyor sirrusdb.doviz_kur_gecmisi
CREATE TABLE IF NOT EXISTS `doviz_kur_gecmisi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `firma_id` int(11) DEFAULT 1,
  `currency_code` varchar(5) NOT NULL,
  `rate` decimal(15,6) DEFAULT 0.000000,
  `buying_rate` decimal(15,6) DEFAULT 0.000000,
  `selling_rate` decimal(15,6) DEFAULT 0.000000,
  `source` varchar(50) DEFAULT NULL,
  `recorded_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_currency_date` (`currency_code`,`recorded_at`)
) ENGINE=InnoDB AUTO_INCREMENT=32017 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- sirrusdb.doviz_kur_gecmisi: ~18.694 rows (yaklaşık) tablosu için veriler indiriliyor
REPLACE INTO `doviz_kur_gecmisi` (`id`, `firma_id`, `currency_code`, `rate`, `buying_rate`, `selling_rate`, `source`, `recorded_at`) VALUES
	(1, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 21:42:41'),
	(2, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 21:42:41'),
	(3, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 21:42:41'),
	(4, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 21:42:41'),
	(5, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 21:42:41'),
	(6, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 21:42:41'),
	(7, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 21:42:41'),
	(8, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 21:42:41'),
	(9, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 21:42:41'),
	(10, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 21:42:41'),
	(11, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 21:42:41'),
	(12, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 21:42:41'),
	(13, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 21:42:41'),
	(14, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 21:42:41'),
	(15, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 21:42:41'),
	(16, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 21:42:41'),
	(17, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 21:42:41'),
	(18, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 21:42:41'),
	(19, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 21:42:41'),
	(20, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 21:42:41'),
	(21, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 21:42:41'),
	(22, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 21:42:41'),
	(23, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 21:42:41'),
	(24, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 21:49:46'),
	(25, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 21:49:46'),
	(26, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 21:49:46'),
	(27, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 21:49:46'),
	(28, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 21:49:46'),
	(29, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 21:49:46'),
	(30, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 21:49:46'),
	(31, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 21:49:46'),
	(32, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 21:49:46'),
	(33, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 21:49:46'),
	(34, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 21:49:46'),
	(35, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 21:49:46'),
	(36, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 21:49:46'),
	(37, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 21:49:46'),
	(38, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 21:49:46'),
	(39, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 21:49:46'),
	(40, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 21:49:46'),
	(41, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 21:49:46'),
	(42, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 21:49:46'),
	(43, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 21:49:46'),
	(44, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 21:49:46'),
	(45, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 21:49:46'),
	(46, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 21:49:46'),
	(47, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 21:51:04'),
	(48, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 21:51:04'),
	(49, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 21:51:04'),
	(50, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 21:51:04'),
	(51, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 21:51:04'),
	(52, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 21:51:04'),
	(53, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 21:51:04'),
	(54, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 21:51:04'),
	(55, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 21:51:04'),
	(56, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 21:51:04'),
	(57, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 21:51:04'),
	(58, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 21:51:04'),
	(59, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 21:51:04'),
	(60, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 21:51:04'),
	(61, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 21:51:04'),
	(62, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 21:51:04'),
	(63, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 21:51:04'),
	(64, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 21:51:04'),
	(65, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 21:51:04'),
	(66, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 21:51:04'),
	(67, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 21:51:04'),
	(68, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 21:51:04'),
	(69, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 21:51:04'),
	(70, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 21:52:46'),
	(71, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 21:52:46'),
	(72, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 21:52:46'),
	(73, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 21:52:46'),
	(74, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 21:52:46'),
	(75, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 21:52:46'),
	(76, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 21:52:46'),
	(77, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 21:52:46'),
	(78, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 21:52:46'),
	(79, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 21:52:46'),
	(80, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 21:52:46'),
	(81, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 21:52:46'),
	(82, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 21:52:46'),
	(83, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 21:52:46'),
	(84, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 21:52:46'),
	(85, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 21:52:46'),
	(86, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 21:52:46'),
	(87, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 21:52:46'),
	(88, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 21:52:46'),
	(89, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 21:52:46'),
	(90, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 21:52:46'),
	(91, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 21:52:46'),
	(92, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 21:52:46'),
	(93, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 21:53:24'),
	(94, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 21:53:24'),
	(95, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 21:53:24'),
	(96, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 21:53:24'),
	(97, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 21:53:24'),
	(98, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 21:53:24'),
	(99, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 21:53:24'),
	(100, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 21:53:24'),
	(101, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 21:53:24'),
	(102, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 21:53:24'),
	(103, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 21:53:24'),
	(104, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 21:53:24'),
	(105, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 21:53:24'),
	(106, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 21:53:24'),
	(107, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 21:53:24'),
	(108, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 21:53:24'),
	(109, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 21:53:24'),
	(110, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 21:53:24'),
	(111, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 21:53:24'),
	(112, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 21:53:24'),
	(113, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 21:53:24'),
	(114, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 21:53:24'),
	(115, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 21:53:24'),
	(116, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 21:54:08'),
	(117, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 21:54:08'),
	(118, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 21:54:08'),
	(119, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 21:54:08'),
	(120, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 21:54:08'),
	(121, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 21:54:08'),
	(122, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 21:54:08'),
	(123, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 21:54:08'),
	(124, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 21:54:08'),
	(125, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 21:54:08'),
	(126, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 21:54:08'),
	(127, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 21:54:08'),
	(128, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 21:54:08'),
	(129, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 21:54:08'),
	(130, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 21:54:08'),
	(131, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 21:54:08'),
	(132, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 21:54:08'),
	(133, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 21:54:08'),
	(134, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 21:54:08'),
	(135, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 21:54:08'),
	(136, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 21:54:08'),
	(137, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 21:54:08'),
	(138, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 21:54:08'),
	(139, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 21:55:20'),
	(140, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 21:55:20'),
	(141, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 21:55:20'),
	(142, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 21:55:20'),
	(143, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 21:55:20'),
	(144, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 21:55:20'),
	(145, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 21:55:20'),
	(146, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 21:55:20'),
	(147, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 21:55:20'),
	(148, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 21:55:20'),
	(149, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 21:55:20'),
	(150, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 21:55:20'),
	(151, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 21:55:20'),
	(152, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 21:55:20'),
	(153, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 21:55:20'),
	(154, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 21:55:20'),
	(155, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 21:55:20'),
	(156, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 21:55:20'),
	(157, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 21:55:20'),
	(158, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 21:55:20'),
	(159, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 21:55:20'),
	(160, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 21:55:20'),
	(161, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 21:55:20'),
	(162, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:05:25'),
	(163, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:05:25'),
	(164, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:05:25'),
	(165, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:05:25'),
	(166, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:05:25'),
	(167, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:05:25'),
	(168, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:05:25'),
	(169, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:05:25'),
	(170, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:05:25'),
	(171, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:05:25'),
	(172, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:05:25'),
	(173, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:05:25'),
	(174, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:05:25'),
	(175, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:05:25'),
	(176, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:05:25'),
	(177, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:05:25'),
	(178, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:05:25'),
	(179, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:05:25'),
	(180, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:05:25'),
	(181, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:05:25'),
	(182, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:05:25'),
	(183, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:05:25'),
	(184, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:05:25'),
	(185, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:09:46'),
	(186, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:09:46'),
	(187, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:09:46'),
	(188, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:09:46'),
	(189, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:09:46'),
	(190, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:09:46'),
	(191, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:09:46'),
	(192, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:09:46'),
	(193, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:09:46'),
	(194, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:09:46'),
	(195, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:09:46'),
	(196, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:09:46'),
	(197, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:09:46'),
	(198, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:09:46'),
	(199, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:09:46'),
	(200, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:09:46'),
	(201, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:09:46'),
	(202, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:09:46'),
	(203, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:09:46'),
	(204, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:09:46'),
	(205, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:09:46'),
	(206, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:09:46'),
	(207, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:09:46'),
	(208, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:11:12'),
	(209, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:11:12'),
	(210, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:11:12'),
	(211, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:11:12'),
	(212, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:11:12'),
	(213, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:11:12'),
	(214, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:11:12'),
	(215, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:11:12'),
	(216, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:11:12'),
	(217, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:11:12'),
	(218, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:11:12'),
	(219, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:11:12'),
	(220, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:11:12'),
	(221, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:11:12'),
	(222, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:11:12'),
	(223, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:11:12'),
	(224, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:11:12'),
	(225, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:11:12'),
	(226, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:11:12'),
	(227, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:11:12'),
	(228, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:11:12'),
	(229, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:11:12'),
	(230, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:11:12'),
	(231, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:15:12'),
	(232, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:15:12'),
	(233, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:15:12'),
	(234, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:15:12'),
	(235, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:15:12'),
	(236, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:15:12'),
	(237, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:15:12'),
	(238, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:15:12'),
	(239, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:15:12'),
	(240, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:15:12'),
	(241, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:15:12'),
	(242, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:15:12'),
	(243, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:15:12'),
	(244, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:15:12'),
	(245, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:15:12'),
	(246, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:15:12'),
	(247, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:15:12'),
	(248, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:15:12'),
	(249, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:15:12'),
	(250, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:15:12'),
	(251, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:15:12'),
	(252, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:15:12'),
	(253, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:15:12'),
	(254, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:16:53'),
	(255, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:16:53'),
	(256, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:16:53'),
	(257, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:16:53'),
	(258, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:16:53'),
	(259, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:16:53'),
	(260, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:16:53'),
	(261, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:16:53'),
	(262, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:16:53'),
	(263, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:16:53'),
	(264, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:16:53'),
	(265, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:16:53'),
	(266, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:16:53'),
	(267, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:16:53'),
	(268, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:16:53'),
	(269, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:16:53'),
	(270, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:16:53'),
	(271, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:16:53'),
	(272, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:16:53'),
	(273, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:16:53'),
	(274, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:16:53'),
	(275, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:16:53'),
	(276, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:16:53'),
	(277, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:19:34'),
	(278, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:19:34'),
	(279, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:19:34'),
	(280, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:19:34'),
	(281, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:19:34'),
	(282, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:19:34'),
	(283, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:19:34'),
	(284, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:19:34'),
	(285, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:19:34'),
	(286, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:19:34'),
	(287, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:19:34'),
	(288, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:19:34'),
	(289, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:19:34'),
	(290, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:19:34'),
	(291, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:19:34'),
	(292, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:19:34'),
	(293, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:19:34'),
	(294, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:19:34'),
	(295, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:19:34'),
	(296, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:19:34'),
	(297, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:19:34'),
	(298, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:19:34'),
	(299, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:19:34'),
	(300, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:21:49'),
	(301, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:21:49'),
	(302, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:21:49'),
	(303, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:21:49'),
	(304, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:21:49'),
	(305, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:21:49'),
	(306, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:21:49'),
	(307, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:21:49'),
	(308, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:21:49'),
	(309, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:21:49'),
	(310, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:21:49'),
	(311, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:21:49'),
	(312, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:21:49'),
	(313, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:21:49'),
	(314, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:21:49'),
	(315, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:21:49'),
	(316, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:21:49'),
	(317, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:21:49'),
	(318, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:21:49'),
	(319, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:21:49'),
	(320, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:21:49'),
	(321, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:21:49'),
	(322, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:21:49'),
	(323, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:22:25'),
	(324, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:22:25'),
	(325, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:22:25'),
	(326, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:22:25'),
	(327, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:22:25'),
	(328, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:22:25'),
	(329, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:22:25'),
	(330, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:22:25'),
	(331, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:22:25'),
	(332, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:22:25'),
	(333, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:22:25'),
	(334, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:22:25'),
	(335, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:22:25'),
	(336, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:22:25'),
	(337, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:22:25'),
	(338, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:22:25'),
	(339, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:22:25'),
	(340, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:22:25'),
	(341, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:22:25'),
	(342, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:22:25'),
	(343, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:22:25'),
	(344, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:22:25'),
	(345, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:22:25'),
	(346, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:25:38'),
	(347, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:25:38'),
	(348, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:25:38'),
	(349, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:25:38'),
	(350, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:25:38'),
	(351, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:25:38'),
	(352, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:25:38'),
	(353, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:25:38'),
	(354, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:25:38'),
	(355, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:25:38'),
	(356, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:25:38'),
	(357, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:25:38'),
	(358, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:25:38'),
	(359, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:25:38'),
	(360, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:25:38'),
	(361, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:25:38'),
	(362, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:25:38'),
	(363, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:25:38'),
	(364, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:25:38'),
	(365, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:25:38'),
	(366, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:25:38'),
	(367, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:25:38'),
	(368, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:25:38'),
	(369, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:26:41'),
	(370, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:26:41'),
	(371, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:26:41'),
	(372, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:26:41'),
	(373, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:26:41'),
	(374, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:26:41'),
	(375, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:26:41'),
	(376, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:26:41'),
	(377, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:26:41'),
	(378, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:26:41'),
	(379, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:26:41'),
	(380, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:26:41'),
	(381, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:26:41'),
	(382, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:26:41'),
	(383, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:26:41'),
	(384, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:26:41'),
	(385, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:26:41'),
	(386, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:26:41'),
	(387, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:26:41'),
	(388, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:26:41'),
	(389, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:26:41'),
	(390, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:26:41'),
	(391, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:26:41'),
	(392, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:27:35'),
	(393, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:27:35'),
	(394, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:27:35'),
	(395, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:27:35'),
	(396, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:27:35'),
	(397, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:27:35'),
	(398, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:27:35'),
	(399, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:27:35'),
	(400, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:27:35'),
	(401, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:27:35'),
	(402, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:27:35'),
	(403, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:27:35'),
	(404, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:27:35'),
	(405, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:27:35'),
	(406, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:27:35'),
	(407, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:27:35'),
	(408, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:27:35'),
	(409, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:27:35'),
	(410, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:27:35'),
	(411, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:27:35'),
	(412, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:27:35'),
	(413, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:27:35'),
	(414, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:27:35'),
	(415, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:29:52'),
	(416, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:29:52'),
	(417, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:29:52'),
	(418, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:29:52'),
	(419, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:29:52'),
	(420, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:29:52'),
	(421, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:29:52'),
	(422, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:29:52'),
	(423, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:29:52'),
	(424, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:29:52'),
	(425, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:29:52'),
	(426, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:29:52'),
	(427, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:29:52'),
	(428, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:29:52'),
	(429, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:29:52'),
	(430, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:29:52'),
	(431, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:29:52'),
	(432, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:29:52'),
	(433, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:29:52'),
	(434, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:29:52'),
	(435, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:29:52'),
	(436, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:29:52'),
	(437, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:29:52'),
	(438, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:32:12'),
	(439, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:32:12'),
	(440, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:32:12'),
	(441, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:32:12'),
	(442, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:32:12'),
	(443, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:32:12'),
	(444, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:32:12'),
	(445, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:32:12'),
	(446, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:32:12'),
	(447, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:32:12'),
	(448, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:32:12'),
	(449, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:32:12'),
	(450, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:32:12'),
	(451, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:32:12'),
	(452, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:32:12'),
	(453, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:32:12'),
	(454, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:32:12'),
	(455, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:32:12'),
	(456, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:32:12'),
	(457, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:32:12'),
	(458, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:32:12'),
	(459, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:32:12'),
	(460, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:32:12'),
	(461, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:41:50'),
	(462, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:41:50'),
	(463, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:41:50'),
	(464, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:41:50'),
	(465, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:41:50'),
	(466, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:41:50'),
	(467, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:41:50'),
	(468, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:41:50'),
	(469, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:41:50'),
	(470, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:41:50'),
	(471, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:41:50'),
	(472, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:41:50'),
	(473, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:41:50'),
	(474, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:41:50'),
	(475, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:41:50'),
	(476, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:41:50'),
	(477, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:41:50'),
	(478, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:41:50'),
	(479, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:41:50'),
	(480, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:41:50'),
	(481, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:41:50'),
	(482, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:41:50'),
	(483, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:41:50'),
	(484, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:44:41'),
	(485, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:44:41'),
	(486, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:44:41'),
	(487, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:44:41'),
	(488, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:44:41'),
	(489, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:44:41'),
	(490, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:44:41'),
	(491, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:44:41'),
	(492, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:44:41'),
	(493, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:44:41'),
	(494, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:44:41'),
	(495, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:44:41'),
	(496, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:44:41'),
	(497, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:44:41'),
	(498, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:44:41'),
	(499, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:44:41'),
	(500, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:44:41'),
	(501, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:44:41'),
	(502, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:44:41'),
	(503, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:44:41'),
	(504, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:44:41'),
	(505, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:44:41'),
	(506, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:44:41'),
	(507, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:46:19'),
	(508, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:46:19'),
	(509, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:46:19'),
	(510, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:46:19'),
	(511, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:46:19'),
	(512, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:46:19'),
	(513, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:46:19'),
	(514, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:46:19'),
	(515, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:46:19'),
	(516, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:46:19'),
	(517, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:46:19'),
	(518, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:46:19'),
	(519, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:46:19'),
	(520, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:46:19'),
	(521, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:46:19'),
	(522, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:46:19'),
	(523, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:46:19'),
	(524, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:46:19'),
	(525, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:46:19'),
	(526, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:46:19'),
	(527, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:46:19'),
	(528, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:46:19'),
	(529, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:46:19'),
	(530, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:47:54'),
	(531, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:47:54'),
	(532, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:47:54'),
	(533, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:47:54'),
	(534, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:47:54'),
	(535, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:47:54'),
	(536, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:47:54'),
	(537, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:47:54'),
	(538, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:47:54'),
	(539, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:47:54'),
	(540, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:47:54'),
	(541, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:47:54'),
	(542, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:47:54'),
	(543, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:47:54'),
	(544, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:47:54'),
	(545, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:47:54'),
	(546, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:47:54'),
	(547, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:47:54'),
	(548, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:47:54'),
	(549, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:47:54'),
	(550, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:47:54'),
	(551, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:47:54'),
	(552, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:47:54'),
	(553, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:49:36'),
	(554, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:49:36'),
	(555, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:49:36'),
	(556, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:49:36'),
	(557, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:49:36'),
	(558, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:49:36'),
	(559, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:49:36'),
	(560, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:49:36'),
	(561, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:49:36'),
	(562, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:49:36'),
	(563, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:49:36'),
	(564, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:49:36'),
	(565, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:49:36'),
	(566, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:49:36'),
	(567, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:49:36'),
	(568, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:49:36'),
	(569, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:49:36'),
	(570, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:49:36'),
	(571, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:49:36'),
	(572, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:49:36'),
	(573, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:49:36'),
	(574, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:49:36'),
	(575, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:49:36'),
	(576, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:52:18'),
	(577, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:52:18'),
	(578, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:52:18'),
	(579, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:52:18'),
	(580, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:52:18'),
	(581, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:52:18'),
	(582, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:52:18'),
	(583, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:52:18'),
	(584, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:52:18'),
	(585, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:52:18'),
	(586, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:52:18'),
	(587, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:52:18'),
	(588, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:52:18'),
	(589, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:52:18'),
	(590, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:52:18'),
	(591, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:52:18'),
	(592, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:52:18'),
	(593, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:52:18'),
	(594, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:52:18'),
	(595, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:52:18'),
	(596, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:52:18'),
	(597, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:52:18'),
	(598, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:52:18'),
	(599, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:54:21'),
	(600, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:54:21'),
	(601, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:54:21'),
	(602, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:54:21'),
	(603, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:54:21'),
	(604, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:54:21'),
	(605, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:54:21'),
	(606, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:54:21'),
	(607, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:54:21'),
	(608, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:54:21'),
	(609, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:54:21'),
	(610, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:54:21'),
	(611, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:54:21'),
	(612, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:54:21'),
	(613, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:54:21'),
	(614, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:54:21'),
	(615, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:54:21'),
	(616, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:54:21'),
	(617, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:54:21'),
	(618, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:54:21'),
	(619, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:54:21'),
	(620, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:54:21'),
	(621, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:54:21'),
	(622, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:55:47'),
	(623, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:55:47'),
	(624, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:55:47'),
	(625, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:55:47'),
	(626, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:55:47'),
	(627, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:55:47'),
	(628, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:55:47'),
	(629, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:55:47'),
	(630, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:55:47'),
	(631, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:55:47'),
	(632, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:55:47'),
	(633, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:55:47'),
	(634, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:55:47'),
	(635, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:55:47'),
	(636, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:55:47'),
	(637, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:55:47'),
	(638, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:55:47'),
	(639, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:55:47'),
	(640, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:55:47'),
	(641, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:55:47'),
	(642, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:55:47'),
	(643, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:55:47'),
	(644, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:55:47'),
	(645, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:57:11'),
	(646, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:57:11'),
	(647, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:57:11'),
	(648, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:57:11'),
	(649, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:57:11'),
	(650, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:57:11'),
	(651, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:57:11'),
	(652, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:57:11'),
	(653, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:57:11'),
	(654, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:57:11'),
	(655, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:57:11'),
	(656, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:57:11'),
	(657, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:57:11'),
	(658, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:57:11'),
	(659, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:57:11'),
	(660, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:57:11'),
	(661, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:57:11'),
	(662, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:57:11'),
	(663, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:57:11'),
	(664, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:57:11'),
	(665, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:57:11'),
	(666, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:57:11'),
	(667, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:57:11'),
	(668, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 22:57:38'),
	(669, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 22:57:38'),
	(670, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 22:57:38'),
	(671, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 22:57:38'),
	(672, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 22:57:38'),
	(673, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 22:57:38'),
	(674, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 22:57:38'),
	(675, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 22:57:38'),
	(676, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 22:57:38'),
	(677, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 22:57:38'),
	(678, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 22:57:38'),
	(679, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 22:57:38'),
	(680, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 22:57:38'),
	(681, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 22:57:38'),
	(682, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 22:57:38'),
	(683, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 22:57:38'),
	(684, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 22:57:38'),
	(685, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 22:57:38'),
	(686, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 22:57:38'),
	(687, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 22:57:38'),
	(688, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 22:57:38'),
	(689, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 22:57:38'),
	(690, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 22:57:38'),
	(691, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:00:21'),
	(692, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:00:21'),
	(693, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:00:21'),
	(694, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:00:21'),
	(695, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:00:21'),
	(696, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:00:21'),
	(697, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:00:21'),
	(698, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:00:21'),
	(699, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:00:21'),
	(700, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:00:21'),
	(701, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:00:21'),
	(702, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:00:21'),
	(703, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:00:21'),
	(704, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:00:21'),
	(705, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:00:21'),
	(706, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:00:21'),
	(707, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:00:21'),
	(708, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:00:21'),
	(709, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:00:21'),
	(710, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:00:21'),
	(711, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:00:21'),
	(712, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:00:21'),
	(713, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:00:21'),
	(714, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:06:25'),
	(715, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:06:25'),
	(716, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:06:25'),
	(717, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:06:25'),
	(718, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:06:25'),
	(719, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:06:25'),
	(720, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:06:25'),
	(721, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:06:25'),
	(722, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:06:25'),
	(723, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:06:25'),
	(724, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:06:25'),
	(725, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:06:25'),
	(726, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:06:25'),
	(727, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:06:25'),
	(728, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:06:25'),
	(729, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:06:25'),
	(730, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:06:25'),
	(731, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:06:25'),
	(732, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:06:25'),
	(733, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:06:25'),
	(734, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:06:25'),
	(735, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:06:25'),
	(736, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:06:25'),
	(737, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:07:33'),
	(738, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:07:33'),
	(739, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:07:33'),
	(740, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:07:33'),
	(741, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:07:33'),
	(742, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:07:33'),
	(743, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:07:33'),
	(744, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:07:33'),
	(745, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:07:33'),
	(746, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:07:33'),
	(747, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:07:33'),
	(748, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:07:33'),
	(749, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:07:33'),
	(750, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:07:33'),
	(751, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:07:33'),
	(752, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:07:33'),
	(753, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:07:33'),
	(754, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:07:33'),
	(755, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:07:33'),
	(756, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:07:33'),
	(757, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:07:33'),
	(758, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:07:33'),
	(759, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:07:33'),
	(760, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:07:58'),
	(761, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:07:58'),
	(762, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:07:58'),
	(763, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:07:58'),
	(764, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:07:58'),
	(765, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:07:58'),
	(766, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:07:58'),
	(767, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:07:58'),
	(768, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:07:58'),
	(769, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:07:58'),
	(770, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:07:58'),
	(771, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:07:58'),
	(772, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:07:58'),
	(773, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:07:58'),
	(774, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:07:58'),
	(775, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:07:58'),
	(776, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:07:58'),
	(777, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:07:58'),
	(778, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:07:58'),
	(779, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:07:58'),
	(780, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:07:58'),
	(781, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:07:58'),
	(782, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:07:58'),
	(783, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:09:04'),
	(784, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:09:04'),
	(785, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:09:04'),
	(786, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:09:04'),
	(787, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:09:04'),
	(788, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:09:04'),
	(789, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:09:04'),
	(790, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:09:04'),
	(791, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:09:04'),
	(792, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:09:04'),
	(793, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:09:04'),
	(794, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:09:04'),
	(795, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:09:04'),
	(796, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:09:04'),
	(797, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:09:04'),
	(798, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:09:04'),
	(799, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:09:04'),
	(800, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:09:04'),
	(801, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:09:04'),
	(802, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:09:04'),
	(803, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:09:04'),
	(804, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:09:04'),
	(805, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:09:04'),
	(806, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:13:24'),
	(807, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:13:24'),
	(808, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:13:24'),
	(809, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:13:24'),
	(810, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:13:24'),
	(811, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:13:24'),
	(812, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:13:24'),
	(813, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:13:24'),
	(814, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:13:24'),
	(815, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:13:24'),
	(816, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:13:24'),
	(817, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:13:24'),
	(818, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:13:24'),
	(819, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:13:24'),
	(820, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:13:24'),
	(821, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:13:24'),
	(822, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:13:24'),
	(823, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:13:24'),
	(824, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:13:24'),
	(825, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:13:24'),
	(826, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:13:24'),
	(827, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:13:24'),
	(828, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:13:24'),
	(829, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:23:18'),
	(830, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:23:18'),
	(831, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:23:18'),
	(832, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:23:18'),
	(833, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:23:18'),
	(834, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:23:18'),
	(835, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:23:18'),
	(836, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:23:18'),
	(837, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:23:18'),
	(838, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:23:18'),
	(839, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:23:18'),
	(840, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:23:18'),
	(841, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:23:18'),
	(842, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:23:18'),
	(843, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:23:18'),
	(844, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:23:18'),
	(845, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:23:18'),
	(846, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:23:18'),
	(847, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:23:18'),
	(848, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:23:18'),
	(849, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:23:18'),
	(850, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:23:18'),
	(851, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:23:18'),
	(852, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:26:44'),
	(853, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:26:44'),
	(854, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:26:44'),
	(855, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:26:44'),
	(856, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:26:44'),
	(857, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:26:44'),
	(858, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:26:44'),
	(859, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:26:44'),
	(860, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:26:44'),
	(861, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:26:44'),
	(862, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:26:44'),
	(863, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:26:44'),
	(864, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:26:44'),
	(865, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:26:44'),
	(866, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:26:44'),
	(867, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:26:44'),
	(868, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:26:44'),
	(869, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:26:44'),
	(870, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:26:44'),
	(871, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:26:44'),
	(872, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:26:44'),
	(873, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:26:44'),
	(874, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:26:44'),
	(875, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:31:42'),
	(876, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:31:42'),
	(877, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:31:42'),
	(878, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:31:42'),
	(879, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:31:42'),
	(880, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:31:42'),
	(881, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:31:42'),
	(882, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:31:42'),
	(883, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:31:42'),
	(884, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:31:42'),
	(885, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:31:42'),
	(886, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:31:42'),
	(887, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:31:42'),
	(888, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:31:42'),
	(889, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:31:42'),
	(890, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:31:42'),
	(891, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:31:42'),
	(892, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:31:42'),
	(893, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:31:42'),
	(894, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:31:42'),
	(895, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:31:42'),
	(896, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:31:42'),
	(897, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:31:42'),
	(898, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:33:58'),
	(899, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:33:58'),
	(900, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:33:58'),
	(901, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:33:58'),
	(902, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:33:58'),
	(903, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:33:58'),
	(904, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:33:58'),
	(905, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:33:58'),
	(906, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:33:58'),
	(907, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:33:58'),
	(908, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:33:58'),
	(909, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:33:58'),
	(910, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:33:58'),
	(911, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:33:58'),
	(912, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:33:58'),
	(913, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:33:58'),
	(914, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:33:58'),
	(915, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:33:58'),
	(916, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:33:58'),
	(917, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:33:58'),
	(918, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:33:58'),
	(919, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:33:58'),
	(920, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:33:58'),
	(921, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:37:43'),
	(922, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:37:43'),
	(923, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:37:43'),
	(924, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:37:43'),
	(925, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:37:43'),
	(926, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:37:43'),
	(927, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:37:43'),
	(928, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:37:43'),
	(929, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:37:43'),
	(930, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:37:43'),
	(931, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:37:43'),
	(932, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:37:43'),
	(933, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:37:43'),
	(934, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:37:43'),
	(935, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:37:43'),
	(936, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:37:43'),
	(937, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:37:43'),
	(938, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:37:43'),
	(939, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:37:43'),
	(940, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:37:43'),
	(941, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:37:43'),
	(942, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:37:43'),
	(943, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:37:43'),
	(944, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:41:33'),
	(945, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:41:33'),
	(946, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:41:33'),
	(947, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:41:33'),
	(948, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:41:33'),
	(949, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:41:33'),
	(950, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:41:33'),
	(951, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:41:33'),
	(952, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:41:33'),
	(953, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:41:33'),
	(954, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:41:33'),
	(955, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:41:33'),
	(956, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:41:33'),
	(957, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:41:33'),
	(958, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:41:33'),
	(959, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:41:33'),
	(960, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:41:33'),
	(961, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:41:33'),
	(962, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:41:33'),
	(963, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:41:33'),
	(964, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:41:33'),
	(965, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:41:33'),
	(966, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:41:33'),
	(967, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:46:34'),
	(968, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:46:34'),
	(969, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:46:34'),
	(970, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:46:34'),
	(971, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:46:34'),
	(972, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:46:34'),
	(973, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:46:34'),
	(974, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:46:34'),
	(975, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:46:34'),
	(976, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:46:34'),
	(977, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:46:34'),
	(978, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:46:34'),
	(979, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:46:34'),
	(980, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:46:34'),
	(981, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:46:34'),
	(982, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:46:34'),
	(983, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:46:34'),
	(984, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:46:34'),
	(985, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:46:34'),
	(986, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:46:34'),
	(987, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:46:34'),
	(988, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:46:34'),
	(989, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:46:34'),
	(990, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:48:36'),
	(991, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:48:36'),
	(992, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:48:36'),
	(993, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:48:36'),
	(994, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:48:36'),
	(995, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:48:36'),
	(996, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:48:36'),
	(997, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:48:36'),
	(998, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:48:36'),
	(999, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:48:36'),
	(1000, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:48:36'),
	(1001, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:48:36'),
	(1002, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:48:36'),
	(1003, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:48:36'),
	(1004, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:48:36'),
	(1005, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:48:36'),
	(1006, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:48:36'),
	(1007, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:48:36'),
	(1008, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:48:36'),
	(1009, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:48:36'),
	(1010, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:48:36'),
	(1011, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:48:36'),
	(1012, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:48:36'),
	(1013, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:52:28'),
	(1014, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:52:28'),
	(1015, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:52:28'),
	(1016, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:52:28'),
	(1017, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:52:28'),
	(1018, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:52:28'),
	(1019, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:52:28'),
	(1020, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:52:28'),
	(1021, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:52:28'),
	(1022, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:52:28'),
	(1023, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:52:28'),
	(1024, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:52:28'),
	(1025, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:52:28'),
	(1026, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:52:28'),
	(1027, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:52:28'),
	(1028, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:52:28'),
	(1029, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:52:28'),
	(1030, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:52:28'),
	(1031, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:52:28'),
	(1032, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:52:28'),
	(1033, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:52:28'),
	(1034, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:52:28'),
	(1035, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:52:28'),
	(1036, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-07 23:55:41'),
	(1037, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-07 23:55:41'),
	(1038, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-07 23:55:41'),
	(1039, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-07 23:55:41'),
	(1040, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-07 23:55:41'),
	(1041, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-07 23:55:41'),
	(1042, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-07 23:55:41'),
	(1043, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-07 23:55:41'),
	(1044, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-07 23:55:41'),
	(1045, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-07 23:55:41'),
	(1046, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-07 23:55:41'),
	(1047, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-07 23:55:41'),
	(1048, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-07 23:55:41'),
	(1049, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-07 23:55:41'),
	(1050, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-07 23:55:41'),
	(1051, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-07 23:55:41'),
	(1052, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-07 23:55:41'),
	(1053, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-07 23:55:41'),
	(1054, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-07 23:55:41'),
	(1055, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-07 23:55:41'),
	(1056, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-07 23:55:41'),
	(1057, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-07 23:55:41'),
	(1058, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-07 23:55:41'),
	(1059, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-08 00:03:19'),
	(1060, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-08 00:03:19'),
	(1061, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-08 00:03:19'),
	(1062, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-08 00:03:19'),
	(1063, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-08 00:03:19'),
	(1064, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-08 00:03:19'),
	(1065, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-08 00:03:19'),
	(1066, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-08 00:03:19'),
	(1067, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-08 00:03:19'),
	(1068, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-08 00:03:19'),
	(1069, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-08 00:03:19'),
	(1070, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-08 00:03:19'),
	(1071, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-08 00:03:19'),
	(1072, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-08 00:03:19'),
	(1073, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-08 00:03:19'),
	(1074, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-08 00:03:19'),
	(1075, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-08 00:03:19'),
	(1076, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-08 00:03:19'),
	(1077, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-08 00:03:19'),
	(1078, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-08 00:03:19'),
	(1079, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-08 00:03:19'),
	(1080, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-08 00:03:19'),
	(1081, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-08 00:03:19'),
	(1082, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-08 00:05:08'),
	(1083, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-08 00:05:08'),
	(1084, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-08 00:05:08'),
	(1085, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-08 00:05:08'),
	(1086, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-08 00:05:08'),
	(1087, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-08 00:05:08'),
	(1088, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-08 00:05:08'),
	(1089, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-08 00:05:08'),
	(1090, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-08 00:05:08'),
	(1091, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-08 00:05:08'),
	(1092, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-08 00:05:08'),
	(1093, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-08 00:05:08'),
	(1094, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-08 00:05:08'),
	(1095, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-08 00:05:08'),
	(1096, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-08 00:05:08'),
	(1097, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-08 00:05:08'),
	(1098, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-08 00:05:08'),
	(1099, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-08 00:05:08'),
	(1100, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-08 00:05:08'),
	(1101, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-08 00:05:08'),
	(1102, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-08 00:05:08'),
	(1103, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-08 00:05:08'),
	(1104, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-08 00:05:08'),
	(1105, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-08 00:05:39'),
	(1106, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-08 00:05:39'),
	(1107, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-08 00:05:39'),
	(1108, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-08 00:05:39'),
	(1109, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-08 00:05:39'),
	(1110, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-08 00:05:39'),
	(1111, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-08 00:05:39'),
	(1112, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-08 00:05:39'),
	(1113, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-08 00:05:39'),
	(1114, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-08 00:05:39'),
	(1115, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-08 00:05:39'),
	(1116, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-08 00:05:39'),
	(1117, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-08 00:05:39'),
	(1118, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-08 00:05:39'),
	(1119, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-08 00:05:39'),
	(1120, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-08 00:05:39'),
	(1121, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-08 00:05:39'),
	(1122, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-08 00:05:39'),
	(1123, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-08 00:05:39'),
	(1124, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-08 00:05:39'),
	(1125, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-08 00:05:39'),
	(1126, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-08 00:05:39'),
	(1127, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-08 00:05:39'),
	(1128, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-08 00:07:53'),
	(1129, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-08 00:07:53'),
	(1130, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-08 00:07:53'),
	(1131, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-08 00:07:53'),
	(1132, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-08 00:07:53'),
	(1133, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-08 00:07:53'),
	(1134, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-08 00:07:53'),
	(1135, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-08 00:07:53'),
	(1136, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-08 00:07:53'),
	(1137, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-08 00:07:53'),
	(1138, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-08 00:07:53'),
	(1139, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-08 00:07:53'),
	(1140, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-08 00:07:53'),
	(1141, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-08 00:07:53'),
	(1142, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-08 00:07:53'),
	(1143, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-08 00:07:53'),
	(1144, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-08 00:07:53'),
	(1145, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-08 00:07:53'),
	(1146, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-08 00:07:53'),
	(1147, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-08 00:07:53'),
	(1148, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-08 00:07:53'),
	(1149, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-08 00:07:53'),
	(1150, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-08 00:07:53'),
	(1151, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-08 00:09:53'),
	(1152, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-08 00:09:53'),
	(1153, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-08 00:09:53'),
	(1154, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-08 00:09:53'),
	(1155, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-08 00:09:53'),
	(1156, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-08 00:09:53'),
	(1157, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-08 00:09:53'),
	(1158, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-08 00:09:53'),
	(1159, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-08 00:09:53'),
	(1160, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-08 00:09:53'),
	(1161, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-08 00:09:53'),
	(1162, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-08 00:09:53'),
	(1163, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-08 00:09:53'),
	(1164, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-08 00:09:53'),
	(1165, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-08 00:09:53'),
	(1166, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-08 00:09:53'),
	(1167, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-08 00:09:53'),
	(1168, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-08 00:09:53'),
	(1169, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-08 00:09:53'),
	(1170, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-08 00:09:53'),
	(1171, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-08 00:09:53'),
	(1172, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-08 00:09:53'),
	(1173, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-08 00:09:53'),
	(1174, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-08 00:10:58'),
	(1175, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-08 00:10:58'),
	(1176, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-08 00:10:58'),
	(1177, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-08 00:10:58'),
	(1178, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-08 00:10:58'),
	(1179, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-08 00:10:58'),
	(1180, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-08 00:10:58'),
	(1181, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-08 00:10:58'),
	(1182, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-08 00:10:58'),
	(1183, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-08 00:10:58'),
	(1184, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-08 00:10:58'),
	(1185, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-08 00:10:58'),
	(1186, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-08 00:10:58'),
	(1187, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-08 00:10:58'),
	(1188, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-08 00:10:58'),
	(1189, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-08 00:10:58'),
	(1190, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-08 00:10:58'),
	(1191, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-08 00:10:58'),
	(1192, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-08 00:10:58'),
	(1193, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-08 00:10:58'),
	(1194, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-08 00:10:58'),
	(1195, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-08 00:10:58'),
	(1196, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-08 00:10:58'),
	(1197, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-08 00:12:55'),
	(1198, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-08 00:12:55'),
	(1199, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-08 00:12:55'),
	(1200, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-08 00:12:55'),
	(1201, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-08 00:12:55'),
	(1202, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-08 00:12:55'),
	(1203, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-08 00:12:55'),
	(1204, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-08 00:12:55'),
	(1205, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-08 00:12:55'),
	(1206, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-08 00:12:55'),
	(1207, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-08 00:12:55'),
	(1208, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-08 00:12:55'),
	(1209, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-08 00:12:55'),
	(1210, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-08 00:12:55'),
	(1211, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-08 00:12:55'),
	(1212, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-08 00:12:55'),
	(1213, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-08 00:12:55'),
	(1214, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-08 00:12:55'),
	(1215, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-08 00:12:55'),
	(1216, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-08 00:12:55'),
	(1217, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-08 00:12:55'),
	(1218, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-08 00:12:55'),
	(1219, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-08 00:12:55'),
	(1220, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-08 00:14:33'),
	(1221, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-08 00:14:33'),
	(1222, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-08 00:14:33'),
	(1223, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-08 00:14:33'),
	(1224, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-08 00:14:33'),
	(1225, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-08 00:14:33'),
	(1226, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-08 00:14:33'),
	(1227, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-08 00:14:33'),
	(1228, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-08 00:14:33'),
	(1229, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-08 00:14:33'),
	(1230, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-08 00:14:33'),
	(1231, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-08 00:14:33'),
	(1232, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-08 00:14:33'),
	(1233, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-08 00:14:33'),
	(1234, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-08 00:14:33'),
	(1235, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-08 00:14:33'),
	(1236, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-08 00:14:33'),
	(1237, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-08 00:14:33'),
	(1238, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-08 00:14:33'),
	(1239, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-08 00:14:33'),
	(1240, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-08 00:14:33'),
	(1241, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-08 00:14:33'),
	(1242, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-08 00:14:33'),
	(1243, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-08 00:15:31'),
	(1244, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-08 00:15:31'),
	(1245, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-08 00:15:31'),
	(1246, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-08 00:15:31'),
	(1247, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-08 00:15:31'),
	(1248, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-08 00:15:31'),
	(1249, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-08 00:15:31'),
	(1250, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-08 00:15:31'),
	(1251, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-08 00:15:31'),
	(1252, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-08 00:15:31'),
	(1253, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-08 00:15:31'),
	(1254, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-08 00:15:31'),
	(1255, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-08 00:15:31'),
	(1256, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-08 00:15:31'),
	(1257, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-08 00:15:31'),
	(1258, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-08 00:15:31'),
	(1259, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-08 00:15:31'),
	(1260, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-08 00:15:31'),
	(1261, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-08 00:15:31'),
	(1262, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-08 00:15:31'),
	(1263, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-08 00:15:31'),
	(1264, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-08 00:15:31'),
	(1265, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-08 00:15:31'),
	(1266, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-08 00:16:45'),
	(1267, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-08 00:16:45'),
	(1268, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-08 00:16:45'),
	(1269, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-08 00:16:45'),
	(1270, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-08 00:16:45'),
	(1271, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-08 00:16:45'),
	(1272, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-08 00:16:45'),
	(1273, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-08 00:16:45'),
	(1274, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-08 00:16:45'),
	(1275, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-08 00:16:45'),
	(1276, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-08 00:16:45'),
	(1277, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-08 00:16:45'),
	(1278, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-08 00:16:45'),
	(1279, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-08 00:16:45'),
	(1280, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-08 00:16:45'),
	(1281, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-08 00:16:45'),
	(1282, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-08 00:16:45'),
	(1283, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-08 00:16:45'),
	(1284, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-08 00:16:45'),
	(1285, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-08 00:16:45'),
	(1286, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-08 00:16:45'),
	(1287, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-08 00:16:45'),
	(1288, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-08 00:16:45'),
	(1289, 1, 'USD', 42.398750, 42.360600, 42.436900, 'tcmb', '2025-12-08 00:17:44'),
	(1290, 1, 'AUD', 28.105450, 28.014100, 28.196800, 'tcmb', '2025-12-08 00:17:44'),
	(1291, 1, 'DKK', 6.616200, 6.600000, 6.632400, 'tcmb', '2025-12-08 00:17:44'),
	(1292, 1, 'EUR', 49.414350, 49.369900, 49.458800, 'tcmb', '2025-12-08 00:17:44'),
	(1293, 1, 'GBP', 56.585400, 56.438300, 56.732500, 'tcmb', '2025-12-08 00:17:44'),
	(1294, 1, 'CHF', 52.804300, 52.635300, 52.973300, 'tcmb', '2025-12-08 00:17:44'),
	(1295, 1, 'SEK', 4.505300, 4.482100, 4.528500, 'tcmb', '2025-12-08 00:17:44'),
	(1296, 1, 'CAD', 30.402300, 30.333900, 30.470700, 'tcmb', '2025-12-08 00:17:44'),
	(1297, 1, 'KWD', 138.157700, 137.259700, 139.055700, 'tcmb', '2025-12-08 00:17:44'),
	(1298, 1, 'NOK', 4.196150, 4.182100, 4.210200, 'tcmb', '2025-12-08 00:17:44'),
	(1299, 1, 'SAR', 11.297700, 11.287500, 11.307900, 'tcmb', '2025-12-08 00:17:44'),
	(1300, 1, 'JPY', 0.273756, 0.272852, 0.274659, 'tcmb', '2025-12-08 00:17:44'),
	(1301, 1, 'BGN', 25.268350, 25.104100, 25.432600, 'tcmb', '2025-12-08 00:17:44'),
	(1302, 1, 'RON', 9.704450, 9.641400, 9.767500, 'tcmb', '2025-12-08 00:17:44'),
	(1303, 1, 'RUB', 0.556155, 0.552540, 0.559770, 'tcmb', '2025-12-08 00:17:44'),
	(1304, 1, 'CNY', 5.997450, 5.958500, 6.036400, 'tcmb', '2025-12-08 00:17:44'),
	(1305, 1, 'PKR', 0.151235, 0.150250, 0.152220, 'tcmb', '2025-12-08 00:17:44'),
	(1306, 1, 'QAR', 11.632000, 11.556400, 11.707600, 'tcmb', '2025-12-08 00:17:44'),
	(1307, 1, 'KRW', 0.028815, 0.028630, 0.029000, 'tcmb', '2025-12-08 00:17:45'),
	(1308, 1, 'AZN', 24.940450, 24.778300, 25.102600, 'tcmb', '2025-12-08 00:17:45'),
	(1309, 1, 'AED', 11.543950, 11.468900, 11.619000, 'tcmb', '2025-12-08 00:17:45'),
	(1310, 1, 'KZT', 0.084125, 0.083580, 0.084670, 'tcmb', '2025-12-08 00:17:45'),
	(1311, 1, 'XDR', 28.917100, 57.834200, 0.000000, 'tcmb', '2025-12-08 00:17:45'),
	(1312, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 16:00:51'),
	(1313, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 16:00:51'),
	(1314, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 16:00:51'),
	(1315, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 16:00:51'),
	(1316, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 16:00:51'),
	(1317, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 16:00:51'),
	(1318, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 16:00:51'),
	(1319, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 16:00:51'),
	(1320, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 16:00:51'),
	(1321, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 16:00:51'),
	(1322, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 16:00:51'),
	(1323, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 16:00:51'),
	(1324, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 16:00:51'),
	(1325, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 16:00:51'),
	(1326, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 16:00:51'),
	(1327, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 16:00:51'),
	(1328, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 16:00:51'),
	(1329, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 16:00:51'),
	(1330, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 16:00:51'),
	(1331, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 16:00:51'),
	(1332, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 16:00:51'),
	(1333, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 16:00:51'),
	(1334, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 16:00:51'),
	(1335, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 16:46:54'),
	(1336, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 16:46:54'),
	(1337, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 16:46:54'),
	(1338, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 16:46:54'),
	(1339, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 16:46:54'),
	(1340, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 16:46:54'),
	(1341, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 16:46:54'),
	(1342, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 16:46:54'),
	(1343, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 16:46:54'),
	(1344, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 16:46:54'),
	(1345, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 16:46:54'),
	(1346, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 16:46:54'),
	(1347, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 16:46:54'),
	(1348, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 16:46:54'),
	(1349, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 16:46:54'),
	(1350, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 16:46:54'),
	(1351, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 16:46:54'),
	(1352, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 16:46:54'),
	(1353, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 16:46:54'),
	(1354, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 16:46:54'),
	(1355, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 16:46:54'),
	(1356, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 16:46:54'),
	(1357, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 16:46:54'),
	(1358, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 16:47:30'),
	(1359, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 16:47:30'),
	(1360, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 16:47:30'),
	(1361, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 16:47:30'),
	(1362, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 16:47:30'),
	(1363, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 16:47:30'),
	(1364, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 16:47:30'),
	(1365, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 16:47:30'),
	(1366, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 16:47:30'),
	(1367, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 16:47:30'),
	(1368, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 16:47:30'),
	(1369, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 16:47:30'),
	(1370, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 16:47:30'),
	(1371, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 16:47:30'),
	(1372, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 16:47:30'),
	(1373, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 16:47:30'),
	(1374, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 16:47:30'),
	(1375, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 16:47:30'),
	(1376, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 16:47:30'),
	(1377, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 16:47:30'),
	(1378, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 16:47:30'),
	(1379, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 16:47:30'),
	(1380, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 16:47:30'),
	(1381, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 16:49:13'),
	(1382, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 16:49:13'),
	(1383, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 16:49:13'),
	(1384, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 16:49:13'),
	(1385, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 16:49:13'),
	(1386, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 16:49:13'),
	(1387, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 16:49:13'),
	(1388, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 16:49:13'),
	(1389, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 16:49:13'),
	(1390, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 16:49:13'),
	(1391, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 16:49:13'),
	(1392, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 16:49:13'),
	(1393, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 16:49:13'),
	(1394, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 16:49:13'),
	(1395, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 16:49:13'),
	(1396, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 16:49:13'),
	(1397, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 16:49:13'),
	(1398, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 16:49:13'),
	(1399, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 16:49:13'),
	(1400, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 16:49:13'),
	(1401, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 16:49:13'),
	(1402, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 16:49:13'),
	(1403, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 16:49:13'),
	(1404, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 16:51:23'),
	(1405, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 16:51:23'),
	(1406, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 16:51:23'),
	(1407, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 16:51:23'),
	(1408, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 16:51:23'),
	(1409, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 16:51:23'),
	(1410, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 16:51:23'),
	(1411, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 16:51:23'),
	(1412, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 16:51:23'),
	(1413, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 16:51:23'),
	(1414, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 16:51:23'),
	(1415, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 16:51:23'),
	(1416, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 16:51:23'),
	(1417, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 16:51:23'),
	(1418, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 16:51:23'),
	(1419, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 16:51:23'),
	(1420, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 16:51:23'),
	(1421, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 16:51:23'),
	(1422, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 16:51:23'),
	(1423, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 16:51:23'),
	(1424, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 16:51:23'),
	(1425, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 16:51:23'),
	(1426, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 16:51:23'),
	(1427, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 16:55:26'),
	(1428, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 16:55:26'),
	(1429, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 16:55:26'),
	(1430, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 16:55:26'),
	(1431, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 16:55:26'),
	(1432, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 16:55:26'),
	(1433, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 16:55:26'),
	(1434, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 16:55:26'),
	(1435, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 16:55:26'),
	(1436, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 16:55:26'),
	(1437, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 16:55:26'),
	(1438, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 16:55:26'),
	(1439, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 16:55:26'),
	(1440, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 16:55:26'),
	(1441, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 16:55:26'),
	(1442, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 16:55:26'),
	(1443, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 16:55:26'),
	(1444, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 16:55:26'),
	(1445, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 16:55:26'),
	(1446, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 16:55:26'),
	(1447, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 16:55:26'),
	(1448, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 16:55:26'),
	(1449, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 16:55:26'),
	(1450, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 17:08:29'),
	(1451, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 17:08:29'),
	(1452, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 17:08:29'),
	(1453, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 17:08:29'),
	(1454, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 17:08:29'),
	(1455, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 17:08:29'),
	(1456, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 17:08:29'),
	(1457, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 17:08:29'),
	(1458, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 17:08:29'),
	(1459, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 17:08:29'),
	(1460, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 17:08:29'),
	(1461, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 17:08:29'),
	(1462, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 17:08:29'),
	(1463, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 17:08:29'),
	(1464, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 17:08:29'),
	(1465, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 17:08:29'),
	(1466, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 17:08:29'),
	(1467, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 17:08:29'),
	(1468, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 17:08:29'),
	(1469, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 17:08:29'),
	(1470, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 17:08:29'),
	(1471, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 17:08:29'),
	(1472, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 17:08:29'),
	(1473, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 17:11:14'),
	(1474, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 17:11:14'),
	(1475, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 17:11:14'),
	(1476, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 17:11:14'),
	(1477, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 17:11:14'),
	(1478, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 17:11:14'),
	(1479, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 17:11:14'),
	(1480, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 17:11:14'),
	(1481, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 17:11:14'),
	(1482, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 17:11:14'),
	(1483, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 17:11:14'),
	(1484, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 17:11:14'),
	(1485, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 17:11:14'),
	(1486, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 17:11:14'),
	(1487, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 17:11:14'),
	(1488, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 17:11:14'),
	(1489, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 17:11:14'),
	(1490, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 17:11:14'),
	(1491, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 17:11:14'),
	(1492, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 17:11:14'),
	(1493, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 17:11:14'),
	(1494, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 17:11:14'),
	(1495, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 17:11:14'),
	(1496, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 17:16:02'),
	(1497, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 17:16:02'),
	(1498, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 17:16:02'),
	(1499, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 17:16:02'),
	(1500, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 17:16:02'),
	(1501, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 17:16:02'),
	(1502, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 17:16:02'),
	(1503, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 17:16:02'),
	(1504, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 17:16:02'),
	(1505, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 17:16:02'),
	(1506, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 17:16:02'),
	(1507, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 17:16:02'),
	(1508, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 17:16:02'),
	(1509, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 17:16:02'),
	(1510, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 17:16:02'),
	(1511, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 17:16:02'),
	(1512, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 17:16:02'),
	(1513, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 17:16:02'),
	(1514, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 17:16:02'),
	(1515, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 17:16:02'),
	(1516, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 17:16:02'),
	(1517, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 17:16:02'),
	(1518, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 17:16:02'),
	(1519, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 17:18:51'),
	(1520, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 17:18:51'),
	(1521, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 17:18:51'),
	(1522, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 17:18:51'),
	(1523, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 17:18:51'),
	(1524, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 17:18:51'),
	(1525, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 17:18:51'),
	(1526, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 17:18:51'),
	(1527, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 17:18:51'),
	(1528, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 17:18:51'),
	(1529, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 17:18:51'),
	(1530, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 17:18:51'),
	(1531, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 17:18:51'),
	(1532, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 17:18:51'),
	(1533, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 17:18:51'),
	(1534, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 17:18:51'),
	(1535, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 17:18:51'),
	(1536, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 17:18:51'),
	(1537, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 17:18:51'),
	(1538, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 17:18:51'),
	(1539, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 17:18:51'),
	(1540, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 17:18:51'),
	(1541, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 17:18:51'),
	(1542, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 17:24:58'),
	(1543, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 17:24:58'),
	(1544, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 17:24:58'),
	(1545, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 17:24:58'),
	(1546, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 17:24:58'),
	(1547, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 17:24:58'),
	(1548, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 17:24:58'),
	(1549, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 17:24:58'),
	(1550, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 17:24:58'),
	(1551, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 17:24:58'),
	(1552, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 17:24:58'),
	(1553, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 17:24:58'),
	(1554, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 17:24:58'),
	(1555, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 17:24:58'),
	(1556, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 17:24:58'),
	(1557, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 17:24:58'),
	(1558, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 17:24:58'),
	(1559, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 17:24:58'),
	(1560, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 17:24:58'),
	(1561, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 17:24:58'),
	(1562, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 17:24:58'),
	(1563, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 17:24:58'),
	(1564, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 17:24:58'),
	(1565, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 17:31:12'),
	(1566, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 17:31:12'),
	(1567, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 17:31:12'),
	(1568, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 17:31:12'),
	(1569, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 17:31:12'),
	(1570, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 17:31:12'),
	(1571, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 17:31:12'),
	(1572, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 17:31:12'),
	(1573, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 17:31:12'),
	(1574, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 17:31:12'),
	(1575, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 17:31:12'),
	(1576, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 17:31:12'),
	(1577, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 17:31:12'),
	(1578, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 17:31:12'),
	(1579, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 17:31:12'),
	(1580, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 17:31:12'),
	(1581, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 17:31:12'),
	(1582, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 17:31:12'),
	(1583, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 17:31:12'),
	(1584, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 17:31:12'),
	(1585, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 17:31:12'),
	(1586, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 17:31:12'),
	(1587, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 17:31:12'),
	(1588, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 17:34:29'),
	(1589, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 17:34:29'),
	(1590, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 17:34:29'),
	(1591, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 17:34:29'),
	(1592, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 17:34:29'),
	(1593, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 17:34:29'),
	(1594, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 17:34:29'),
	(1595, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 17:34:29'),
	(1596, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 17:34:29'),
	(1597, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 17:34:29'),
	(1598, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 17:34:29'),
	(1599, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 17:34:29'),
	(1600, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 17:34:29'),
	(1601, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 17:34:29'),
	(1602, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 17:34:29'),
	(1603, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 17:34:29'),
	(1604, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 17:34:29'),
	(1605, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 17:34:29'),
	(1606, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 17:34:29'),
	(1607, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 17:34:29'),
	(1608, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 17:34:29'),
	(1609, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 17:34:29'),
	(1610, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 17:34:29'),
	(1611, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 17:38:30'),
	(1612, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 17:38:30'),
	(1613, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 17:38:30'),
	(1614, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 17:38:30'),
	(1615, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 17:38:30'),
	(1616, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 17:38:30'),
	(1617, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 17:38:30'),
	(1618, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 17:38:30'),
	(1619, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 17:38:30'),
	(1620, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 17:38:30'),
	(1621, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 17:38:30'),
	(1622, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 17:38:30'),
	(1623, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 17:38:30'),
	(1624, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 17:38:30'),
	(1625, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 17:38:30'),
	(1626, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 17:38:30'),
	(1627, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 17:38:30'),
	(1628, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 17:38:30'),
	(1629, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 17:38:30'),
	(1630, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 17:38:30'),
	(1631, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 17:38:30'),
	(1632, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 17:38:30'),
	(1633, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 17:38:30'),
	(1634, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 17:42:16'),
	(1635, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 17:42:16'),
	(1636, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 17:42:16'),
	(1637, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 17:42:16'),
	(1638, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 17:42:16'),
	(1639, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 17:42:16'),
	(1640, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 17:42:16'),
	(1641, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 17:42:16'),
	(1642, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 17:42:16'),
	(1643, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 17:42:16'),
	(1644, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 17:42:16'),
	(1645, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 17:42:16'),
	(1646, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 17:42:16'),
	(1647, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 17:42:16'),
	(1648, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 17:42:16'),
	(1649, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 17:42:16'),
	(1650, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 17:42:16'),
	(1651, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 17:42:16'),
	(1652, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 17:42:16'),
	(1653, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 17:42:16'),
	(1654, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 17:42:16'),
	(1655, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 17:42:16'),
	(1656, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 17:42:16'),
	(1657, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 17:46:00'),
	(1658, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 17:46:00'),
	(1659, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 17:46:00'),
	(1660, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 17:46:00'),
	(1661, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 17:46:00'),
	(1662, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 17:46:00'),
	(1663, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 17:46:00'),
	(1664, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 17:46:00'),
	(1665, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 17:46:00'),
	(1666, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 17:46:00'),
	(1667, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 17:46:00'),
	(1668, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 17:46:00'),
	(1669, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 17:46:00'),
	(1670, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 17:46:00'),
	(1671, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 17:46:00'),
	(1672, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 17:46:00'),
	(1673, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 17:46:00'),
	(1674, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 17:46:00'),
	(1675, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 17:46:00'),
	(1676, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 17:46:00'),
	(1677, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 17:46:00'),
	(1678, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 17:46:00'),
	(1679, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 17:46:00'),
	(1680, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 17:50:28'),
	(1681, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 17:50:28'),
	(1682, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 17:50:28'),
	(1683, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 17:50:28'),
	(1684, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 17:50:28'),
	(1685, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 17:50:28'),
	(1686, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 17:50:28'),
	(1687, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 17:50:28'),
	(1688, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 17:50:28'),
	(1689, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 17:50:28'),
	(1690, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 17:50:28'),
	(1691, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 17:50:28'),
	(1692, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 17:50:28'),
	(1693, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 17:50:28'),
	(1694, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 17:50:28'),
	(1695, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 17:50:28'),
	(1696, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 17:50:28'),
	(1697, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 17:50:28'),
	(1698, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 17:50:28'),
	(1699, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 17:50:28'),
	(1700, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 17:50:28'),
	(1701, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 17:50:28'),
	(1702, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 17:50:28'),
	(1703, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 17:55:32'),
	(1704, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 17:55:32'),
	(1705, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 17:55:32'),
	(1706, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 17:55:32'),
	(1707, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 17:55:32'),
	(1708, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 17:55:32'),
	(1709, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 17:55:32'),
	(1710, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 17:55:32'),
	(1711, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 17:55:32'),
	(1712, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 17:55:32'),
	(1713, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 17:55:32'),
	(1714, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 17:55:32'),
	(1715, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 17:55:32'),
	(1716, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 17:55:32'),
	(1717, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 17:55:32'),
	(1718, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 17:55:32'),
	(1719, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 17:55:32'),
	(1720, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 17:55:32'),
	(1721, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 17:55:32'),
	(1722, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 17:55:32'),
	(1723, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 17:55:32'),
	(1724, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 17:55:32'),
	(1725, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 17:55:32'),
	(1726, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:00:07'),
	(1727, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:00:07'),
	(1728, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:00:07'),
	(1729, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:00:07'),
	(1730, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:00:07'),
	(1731, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:00:07'),
	(1732, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:00:07'),
	(1733, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:00:07'),
	(1734, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:00:07'),
	(1735, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:00:07'),
	(1736, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:00:07'),
	(1737, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:00:07'),
	(1738, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:00:07'),
	(1739, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:00:07'),
	(1740, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:00:07'),
	(1741, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:00:07'),
	(1742, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:00:07'),
	(1743, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:00:07'),
	(1744, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:00:07'),
	(1745, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:00:07'),
	(1746, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:00:07'),
	(1747, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:00:07'),
	(1748, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:00:07'),
	(1749, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:01:57'),
	(1750, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:01:57'),
	(1751, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:01:57'),
	(1752, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:01:57'),
	(1753, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:01:57'),
	(1754, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:01:57'),
	(1755, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:01:57'),
	(1756, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:01:57'),
	(1757, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:01:57'),
	(1758, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:01:57'),
	(1759, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:01:57'),
	(1760, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:01:57'),
	(1761, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:01:57'),
	(1762, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:01:57'),
	(1763, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:01:57'),
	(1764, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:01:57'),
	(1765, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:01:57'),
	(1766, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:01:57'),
	(1767, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:01:57'),
	(1768, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:01:57'),
	(1769, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:01:57'),
	(1770, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:01:57'),
	(1771, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:01:57'),
	(1772, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:03:01'),
	(1773, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:03:01'),
	(1774, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:03:01'),
	(1775, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:03:01'),
	(1776, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:03:01'),
	(1777, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:03:01'),
	(1778, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:03:01'),
	(1779, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:03:01'),
	(1780, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:03:01'),
	(1781, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:03:01'),
	(1782, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:03:01'),
	(1783, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:03:01'),
	(1784, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:03:01'),
	(1785, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:03:01'),
	(1786, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:03:01'),
	(1787, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:03:01'),
	(1788, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:03:01'),
	(1789, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:03:01'),
	(1790, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:03:01'),
	(1791, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:03:01'),
	(1792, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:03:01'),
	(1793, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:03:01'),
	(1794, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:03:01'),
	(1795, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:04:52'),
	(1796, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:04:52'),
	(1797, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:04:52'),
	(1798, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:04:52'),
	(1799, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:04:52'),
	(1800, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:04:52'),
	(1801, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:04:52'),
	(1802, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:04:52'),
	(1803, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:04:52'),
	(1804, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:04:52'),
	(1805, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:04:52'),
	(1806, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:04:52'),
	(1807, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:04:52'),
	(1808, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:04:52'),
	(1809, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:04:52'),
	(1810, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:04:52'),
	(1811, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:04:52'),
	(1812, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:04:52'),
	(1813, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:04:52'),
	(1814, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:04:52'),
	(1815, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:04:52'),
	(1816, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:04:52'),
	(1817, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:04:52'),
	(1818, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:07:36'),
	(1819, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:07:36'),
	(1820, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:07:36'),
	(1821, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:07:36'),
	(1822, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:07:36'),
	(1823, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:07:36'),
	(1824, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:07:36'),
	(1825, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:07:36'),
	(1826, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:07:36'),
	(1827, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:07:36'),
	(1828, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:07:36'),
	(1829, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:07:36'),
	(1830, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:07:36'),
	(1831, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:07:36'),
	(1832, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:07:36'),
	(1833, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:07:36'),
	(1834, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:07:36'),
	(1835, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:07:36'),
	(1836, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:07:36'),
	(1837, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:07:36'),
	(1838, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:07:36'),
	(1839, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:07:36'),
	(1840, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:07:36'),
	(1841, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:15:32'),
	(1842, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:15:32'),
	(1843, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:15:32'),
	(1844, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:15:32'),
	(1845, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:15:32'),
	(1846, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:15:32'),
	(1847, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:15:32'),
	(1848, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:15:32'),
	(1849, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:15:32'),
	(1850, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:15:32'),
	(1851, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:15:32'),
	(1852, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:15:32'),
	(1853, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:15:32'),
	(1854, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:15:32'),
	(1855, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:15:32'),
	(1856, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:15:32'),
	(1857, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:15:32'),
	(1858, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:15:32'),
	(1859, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:15:32'),
	(1860, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:15:32'),
	(1861, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:15:32'),
	(1862, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:15:32'),
	(1863, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:15:32'),
	(1864, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:19:13'),
	(1865, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:19:13'),
	(1866, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:19:13'),
	(1867, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:19:13'),
	(1868, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:19:13'),
	(1869, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:19:13'),
	(1870, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:19:13'),
	(1871, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:19:13'),
	(1872, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:19:13'),
	(1873, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:19:13'),
	(1874, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:19:13'),
	(1875, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:19:13'),
	(1876, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:19:13'),
	(1877, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:19:13'),
	(1878, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:19:13'),
	(1879, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:19:13'),
	(1880, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:19:13'),
	(1881, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:19:13'),
	(1882, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:19:13'),
	(1883, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:19:13'),
	(1884, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:19:13'),
	(1885, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:19:13'),
	(1886, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:19:13'),
	(1887, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:23:22'),
	(1888, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:23:22'),
	(1889, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:23:22'),
	(1890, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:23:22'),
	(1891, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:23:22'),
	(1892, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:23:22'),
	(1893, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:23:22'),
	(1894, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:23:22'),
	(1895, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:23:22'),
	(1896, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:23:22'),
	(1897, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:23:22'),
	(1898, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:23:22'),
	(1899, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:23:22'),
	(1900, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:23:22'),
	(1901, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:23:22'),
	(1902, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:23:22'),
	(1903, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:23:22'),
	(1904, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:23:22'),
	(1905, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:23:22'),
	(1906, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:23:22'),
	(1907, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:23:22'),
	(1908, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:23:22'),
	(1909, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:23:22'),
	(1910, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:24:23'),
	(1911, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:24:23'),
	(1912, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:24:23'),
	(1913, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:24:23'),
	(1914, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:24:23'),
	(1915, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:24:23'),
	(1916, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:24:23'),
	(1917, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:24:23'),
	(1918, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:24:23'),
	(1919, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:24:23'),
	(1920, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:24:23'),
	(1921, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:24:23'),
	(1922, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:24:23'),
	(1923, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:24:23'),
	(1924, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:24:23'),
	(1925, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:24:23'),
	(1926, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:24:23'),
	(1927, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:24:23'),
	(1928, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:24:23'),
	(1929, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:24:23'),
	(1930, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:24:23'),
	(1931, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:24:23'),
	(1932, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:24:23'),
	(1933, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:25:45'),
	(1934, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:25:45'),
	(1935, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:25:45'),
	(1936, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:25:45'),
	(1937, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:25:45'),
	(1938, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:25:45'),
	(1939, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:25:45'),
	(1940, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:25:45'),
	(1941, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:25:45'),
	(1942, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:25:45'),
	(1943, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:25:45'),
	(1944, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:25:45'),
	(1945, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:25:45'),
	(1946, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:25:45'),
	(1947, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:25:45'),
	(1948, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:25:45'),
	(1949, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:25:45'),
	(1950, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:25:45'),
	(1951, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:25:45'),
	(1952, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:25:45'),
	(1953, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:25:45'),
	(1954, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:25:45'),
	(1955, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:25:45'),
	(1956, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:32:04'),
	(1957, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:32:04'),
	(1958, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:32:04'),
	(1959, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:32:04'),
	(1960, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:32:04'),
	(1961, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:32:04'),
	(1962, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:32:04'),
	(1963, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:32:04'),
	(1964, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:32:04'),
	(1965, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:32:04'),
	(1966, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:32:04'),
	(1967, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:32:04'),
	(1968, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:32:04'),
	(1969, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:32:04'),
	(1970, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:32:04'),
	(1971, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:32:04'),
	(1972, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:32:04'),
	(1973, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:32:04'),
	(1974, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:32:04'),
	(1975, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:32:04'),
	(1976, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:32:04'),
	(1977, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:32:04'),
	(1978, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:32:04'),
	(1979, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:32:58'),
	(1980, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:32:58'),
	(1981, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:32:58'),
	(1982, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:32:58'),
	(1983, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:32:58'),
	(1984, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:32:58'),
	(1985, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:32:58'),
	(1986, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:32:58'),
	(1987, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:32:58'),
	(1988, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:32:58'),
	(1989, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:32:58'),
	(1990, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:32:58'),
	(1991, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:32:58'),
	(1992, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:32:58'),
	(1993, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:32:58'),
	(1994, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:32:58'),
	(1995, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:32:58'),
	(1996, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:32:58'),
	(1997, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:32:58'),
	(1998, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:32:58'),
	(1999, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:32:58'),
	(2000, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:32:58'),
	(2001, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:32:58'),
	(2002, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:36:32'),
	(2003, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:36:32'),
	(2004, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:36:32'),
	(2005, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:36:32'),
	(2006, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:36:32'),
	(2007, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:36:32'),
	(2008, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:36:32'),
	(2009, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:36:32'),
	(2010, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:36:32'),
	(2011, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:36:32'),
	(2012, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:36:32'),
	(2013, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:36:32'),
	(2014, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:36:32'),
	(2015, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:36:32'),
	(2016, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:36:32'),
	(2017, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:36:32'),
	(2018, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:36:32'),
	(2019, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:36:32'),
	(2020, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:36:32'),
	(2021, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:36:32'),
	(2022, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:36:32'),
	(2023, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:36:32'),
	(2024, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:36:32'),
	(2025, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:38:11'),
	(2026, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:38:11'),
	(2027, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:38:11'),
	(2028, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:38:11'),
	(2029, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:38:11'),
	(2030, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:38:11'),
	(2031, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:38:11'),
	(2032, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:38:11'),
	(2033, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:38:11'),
	(2034, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:38:11'),
	(2035, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:38:11'),
	(2036, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:38:11'),
	(2037, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:38:11'),
	(2038, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:38:11'),
	(2039, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:38:11'),
	(2040, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:38:11'),
	(2041, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:38:11'),
	(2042, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:38:11'),
	(2043, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:38:11'),
	(2044, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:38:11'),
	(2045, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:38:11'),
	(2046, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:38:11'),
	(2047, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:38:11'),
	(2048, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:44:24'),
	(2049, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:44:24'),
	(2050, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:44:24'),
	(2051, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:44:24'),
	(2052, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:44:24'),
	(2053, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:44:24'),
	(2054, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:44:24'),
	(2055, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:44:24'),
	(2056, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:44:24'),
	(2057, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:44:24'),
	(2058, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:44:24'),
	(2059, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:44:24'),
	(2060, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:44:24'),
	(2061, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:44:24'),
	(2062, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:44:24'),
	(2063, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:44:24'),
	(2064, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:44:24'),
	(2065, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:44:24'),
	(2066, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:44:24'),
	(2067, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:44:24'),
	(2068, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:44:24'),
	(2069, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:44:24'),
	(2070, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:44:24'),
	(2071, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:49:25'),
	(2072, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:49:25'),
	(2073, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:49:25'),
	(2074, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:49:25'),
	(2075, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:49:25'),
	(2076, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:49:25'),
	(2077, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:49:25'),
	(2078, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:49:25'),
	(2079, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:49:25'),
	(2080, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:49:25'),
	(2081, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:49:25'),
	(2082, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:49:25'),
	(2083, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:49:25'),
	(2084, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:49:25'),
	(2085, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:49:25'),
	(2086, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:49:25'),
	(2087, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:49:25'),
	(2088, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:49:25'),
	(2089, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:49:25'),
	(2090, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:49:25'),
	(2091, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:49:25'),
	(2092, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:49:25'),
	(2093, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:49:25'),
	(2094, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:50:26'),
	(2095, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:50:26'),
	(2096, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:50:26'),
	(2097, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:50:26'),
	(2098, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:50:26'),
	(2099, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:50:26'),
	(2100, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:50:26'),
	(2101, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:50:26'),
	(2102, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:50:26'),
	(2103, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:50:26'),
	(2104, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:50:26'),
	(2105, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:50:26'),
	(2106, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:50:26'),
	(2107, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:50:26'),
	(2108, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:50:26'),
	(2109, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:50:26'),
	(2110, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:50:26'),
	(2111, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:50:26'),
	(2112, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:50:26'),
	(2113, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:50:26'),
	(2114, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:50:26'),
	(2115, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:50:26'),
	(2116, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:50:26'),
	(2117, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:54:23'),
	(2118, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:54:23'),
	(2119, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:54:23'),
	(2120, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:54:23'),
	(2121, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:54:23'),
	(2122, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:54:23'),
	(2123, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:54:23'),
	(2124, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:54:23'),
	(2125, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:54:23'),
	(2126, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:54:23'),
	(2127, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:54:23'),
	(2128, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:54:23'),
	(2129, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:54:23'),
	(2130, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:54:23'),
	(2131, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:54:23'),
	(2132, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:54:23'),
	(2133, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:54:23'),
	(2134, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:54:23'),
	(2135, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:54:23'),
	(2136, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:54:23'),
	(2137, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:54:23'),
	(2138, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:54:23'),
	(2139, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:54:23'),
	(2140, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:55:25'),
	(2141, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:55:25'),
	(2142, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:55:25'),
	(2143, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:55:25'),
	(2144, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:55:25'),
	(2145, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:55:25'),
	(2146, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:55:25'),
	(2147, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:55:25'),
	(2148, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:55:25'),
	(2149, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:55:25'),
	(2150, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:55:25'),
	(2151, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:55:25'),
	(2152, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:55:25'),
	(2153, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:55:25'),
	(2154, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:55:25'),
	(2155, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:55:25'),
	(2156, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:55:25'),
	(2157, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:55:25'),
	(2158, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:55:25'),
	(2159, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:55:25'),
	(2160, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:55:25'),
	(2161, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:55:25'),
	(2162, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:55:25'),
	(2163, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 18:58:34'),
	(2164, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 18:58:34'),
	(2165, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 18:58:34'),
	(2166, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 18:58:34'),
	(2167, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 18:58:34'),
	(2168, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 18:58:34'),
	(2169, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 18:58:34'),
	(2170, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 18:58:34'),
	(2171, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 18:58:34'),
	(2172, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 18:58:34'),
	(2173, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 18:58:34'),
	(2174, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 18:58:34'),
	(2175, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 18:58:34'),
	(2176, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 18:58:34'),
	(2177, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 18:58:34'),
	(2178, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 18:58:34'),
	(2179, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 18:58:34'),
	(2180, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 18:58:34'),
	(2181, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 18:58:34'),
	(2182, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 18:58:34'),
	(2183, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 18:58:34'),
	(2184, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 18:58:34'),
	(2185, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 18:58:34'),
	(2186, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 19:02:46'),
	(2187, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 19:02:46'),
	(2188, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 19:02:46'),
	(2189, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 19:02:46'),
	(2190, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 19:02:46'),
	(2191, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 19:02:46'),
	(2192, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 19:02:46'),
	(2193, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 19:02:46'),
	(2194, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 19:02:46'),
	(2195, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 19:02:46'),
	(2196, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 19:02:46'),
	(2197, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 19:02:46'),
	(2198, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 19:02:46'),
	(2199, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 19:02:46'),
	(2200, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 19:02:46'),
	(2201, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 19:02:46'),
	(2202, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 19:02:46'),
	(2203, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 19:02:46'),
	(2204, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 19:02:46'),
	(2205, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 19:02:46'),
	(2206, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 19:02:46'),
	(2207, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 19:02:46'),
	(2208, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 19:02:46'),
	(2209, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 19:05:44'),
	(2210, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 19:05:44'),
	(2211, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 19:05:44'),
	(2212, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 19:05:44'),
	(2213, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 19:05:44'),
	(2214, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 19:05:44'),
	(2215, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 19:05:44'),
	(2216, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 19:05:44'),
	(2217, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 19:05:44'),
	(2218, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 19:05:44'),
	(2219, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 19:05:44'),
	(2220, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 19:05:44'),
	(2221, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 19:05:44'),
	(2222, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 19:05:44'),
	(2223, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 19:05:44'),
	(2224, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 19:05:44'),
	(2225, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 19:05:44'),
	(2226, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 19:05:44'),
	(2227, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 19:05:44'),
	(2228, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 19:05:44'),
	(2229, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 19:05:44'),
	(2230, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 19:05:44'),
	(2231, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 19:05:44'),
	(2232, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 19:11:50'),
	(2233, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 19:11:50'),
	(2234, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 19:11:50'),
	(2235, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 19:11:50'),
	(2236, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 19:11:50'),
	(2237, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 19:11:50'),
	(2238, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 19:11:50'),
	(2239, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 19:11:50'),
	(2240, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 19:11:50'),
	(2241, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 19:11:50'),
	(2242, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 19:11:50'),
	(2243, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 19:11:50'),
	(2244, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 19:11:50'),
	(2245, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 19:11:50'),
	(2246, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 19:11:50'),
	(2247, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 19:11:50'),
	(2248, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 19:11:50'),
	(2249, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 19:11:50'),
	(2250, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 19:11:50'),
	(2251, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 19:11:50'),
	(2252, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 19:11:50'),
	(2253, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 19:11:50'),
	(2254, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 19:11:50'),
	(2255, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 20:09:18'),
	(2256, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 20:09:18'),
	(2257, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 20:09:18'),
	(2258, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 20:09:18'),
	(2259, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 20:09:18'),
	(2260, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 20:09:18'),
	(2261, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 20:09:18'),
	(2262, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 20:09:18'),
	(2263, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 20:09:18'),
	(2264, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 20:09:18'),
	(2265, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 20:09:18'),
	(2266, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 20:09:18'),
	(2267, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 20:09:18'),
	(2268, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 20:09:18'),
	(2269, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 20:09:18'),
	(2270, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 20:09:18'),
	(2271, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 20:09:18'),
	(2272, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 20:09:18'),
	(2273, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 20:09:18'),
	(2274, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 20:09:18'),
	(2275, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 20:09:18'),
	(2276, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 20:09:18'),
	(2277, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 20:09:18'),
	(2278, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 20:16:46'),
	(2279, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 20:16:46'),
	(2280, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 20:16:46'),
	(2281, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 20:16:46'),
	(2282, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 20:16:46'),
	(2283, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 20:16:46'),
	(2284, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 20:16:46'),
	(2285, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 20:16:46'),
	(2286, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 20:16:46'),
	(2287, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 20:16:46'),
	(2288, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 20:16:46'),
	(2289, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 20:16:46'),
	(2290, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 20:16:46'),
	(2291, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 20:16:46'),
	(2292, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 20:16:46'),
	(2293, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 20:16:46'),
	(2294, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 20:16:46'),
	(2295, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 20:16:46'),
	(2296, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 20:16:46'),
	(2297, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 20:16:46'),
	(2298, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 20:16:46'),
	(2299, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 20:16:46'),
	(2300, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 20:16:46'),
	(2301, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 20:23:19'),
	(2302, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 20:23:19'),
	(2303, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 20:23:19'),
	(2304, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 20:23:19'),
	(2305, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 20:23:19'),
	(2306, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 20:23:19'),
	(2307, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 20:23:19'),
	(2308, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 20:23:19'),
	(2309, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 20:23:19'),
	(2310, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 20:23:19'),
	(2311, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 20:23:19'),
	(2312, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 20:23:19'),
	(2313, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 20:23:19'),
	(2314, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 20:23:19'),
	(2315, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 20:23:19'),
	(2316, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 20:23:19'),
	(2317, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 20:23:19'),
	(2318, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 20:23:19'),
	(2319, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 20:23:19'),
	(2320, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 20:23:19'),
	(2321, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 20:23:19'),
	(2322, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 20:23:19'),
	(2323, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 20:23:19'),
	(2324, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 20:26:55'),
	(2325, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 20:26:55'),
	(2326, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 20:26:55'),
	(2327, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 20:26:55'),
	(2328, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 20:26:55'),
	(2329, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 20:26:55'),
	(2330, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 20:26:55'),
	(2331, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 20:26:55'),
	(2332, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 20:26:55'),
	(2333, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 20:26:55'),
	(2334, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 20:26:55'),
	(2335, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 20:26:55'),
	(2336, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 20:26:55'),
	(2337, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 20:26:55'),
	(2338, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 20:26:55'),
	(2339, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 20:26:55'),
	(2340, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 20:26:55'),
	(2341, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 20:26:55'),
	(2342, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 20:26:55'),
	(2343, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 20:26:55'),
	(2344, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 20:26:55'),
	(2345, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 20:26:55'),
	(2346, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 20:26:55'),
	(2347, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 20:31:24'),
	(2348, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 20:31:24'),
	(2349, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 20:31:24'),
	(2350, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 20:31:24'),
	(2351, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 20:31:24'),
	(2352, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 20:31:24'),
	(2353, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 20:31:24'),
	(2354, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 20:31:24'),
	(2355, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 20:31:24'),
	(2356, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 20:31:24'),
	(2357, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 20:31:24'),
	(2358, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 20:31:24'),
	(2359, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 20:31:24'),
	(2360, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 20:31:24'),
	(2361, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 20:31:24'),
	(2362, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 20:31:24'),
	(2363, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 20:31:24'),
	(2364, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 20:31:24'),
	(2365, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 20:31:24'),
	(2366, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 20:31:24'),
	(2367, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 20:31:24'),
	(2368, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 20:31:24'),
	(2369, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 20:31:24'),
	(2370, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 21:26:20'),
	(2371, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 21:26:20'),
	(2372, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 21:26:20'),
	(2373, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 21:26:20'),
	(2374, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 21:26:20'),
	(2375, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 21:26:20'),
	(2376, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 21:26:20'),
	(2377, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 21:26:20'),
	(2378, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 21:26:20'),
	(2379, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 21:26:20'),
	(2380, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 21:26:20'),
	(2381, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 21:26:20'),
	(2382, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 21:26:20'),
	(2383, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 21:26:20'),
	(2384, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 21:26:20'),
	(2385, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 21:26:20'),
	(2386, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 21:26:20'),
	(2387, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 21:26:20'),
	(2388, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 21:26:20'),
	(2389, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 21:26:20'),
	(2390, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 21:26:20'),
	(2391, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 21:26:20'),
	(2392, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 21:26:20'),
	(2393, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 21:28:22'),
	(2394, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 21:28:22'),
	(2395, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 21:28:22'),
	(2396, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 21:28:22'),
	(2397, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 21:28:22'),
	(2398, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 21:28:22'),
	(2399, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 21:28:22'),
	(2400, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 21:28:22'),
	(2401, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 21:28:22'),
	(2402, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 21:28:22'),
	(2403, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 21:28:22'),
	(2404, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 21:28:22'),
	(2405, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 21:28:22'),
	(2406, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 21:28:22'),
	(2407, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 21:28:22'),
	(2408, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 21:28:22'),
	(2409, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 21:28:22'),
	(2410, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 21:28:22'),
	(2411, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 21:28:22'),
	(2412, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 21:28:22'),
	(2413, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 21:28:22'),
	(2414, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 21:28:22'),
	(2415, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 21:28:22'),
	(2416, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 21:30:09'),
	(2417, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 21:30:09'),
	(2418, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 21:30:09'),
	(2419, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 21:30:09'),
	(2420, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 21:30:09'),
	(2421, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 21:30:09'),
	(2422, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 21:30:09'),
	(2423, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 21:30:09'),
	(2424, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 21:30:09'),
	(2425, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 21:30:09'),
	(2426, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 21:30:09'),
	(2427, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 21:30:09'),
	(2428, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 21:30:09'),
	(2429, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 21:30:09'),
	(2430, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 21:30:09'),
	(2431, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 21:30:09'),
	(2432, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 21:30:09'),
	(2433, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 21:30:09'),
	(2434, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 21:30:09'),
	(2435, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 21:30:09'),
	(2436, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 21:30:09'),
	(2437, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 21:30:09'),
	(2438, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 21:30:09'),
	(2439, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 21:35:49'),
	(2440, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 21:35:49'),
	(2441, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 21:35:49'),
	(2442, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 21:35:49'),
	(2443, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 21:35:49'),
	(2444, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 21:35:49'),
	(2445, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 21:35:49'),
	(2446, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 21:35:49'),
	(2447, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 21:35:49'),
	(2448, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 21:35:49'),
	(2449, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 21:35:49'),
	(2450, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 21:35:49'),
	(2451, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 21:35:49'),
	(2452, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 21:35:49'),
	(2453, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 21:35:49'),
	(2454, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 21:35:49'),
	(2455, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 21:35:49'),
	(2456, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 21:35:49'),
	(2457, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 21:35:49'),
	(2458, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 21:35:49'),
	(2459, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 21:35:49'),
	(2460, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 21:35:49'),
	(2461, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 21:35:49'),
	(2462, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 21:40:09'),
	(2463, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 21:40:09'),
	(2464, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 21:40:09'),
	(2465, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 21:40:09'),
	(2466, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 21:40:09'),
	(2467, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 21:40:09'),
	(2468, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 21:40:09'),
	(2469, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 21:40:09'),
	(2470, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 21:40:09'),
	(2471, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 21:40:09'),
	(2472, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 21:40:09'),
	(2473, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 21:40:09'),
	(2474, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 21:40:09'),
	(2475, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 21:40:09'),
	(2476, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 21:40:09'),
	(2477, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 21:40:09'),
	(2478, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 21:40:09'),
	(2479, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 21:40:09'),
	(2480, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 21:40:09'),
	(2481, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 21:40:09'),
	(2482, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 21:40:09'),
	(2483, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 21:40:09'),
	(2484, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 21:40:09'),
	(2485, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 21:40:20'),
	(2486, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 21:40:20'),
	(2487, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 21:40:20'),
	(2488, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 21:40:20'),
	(2489, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 21:40:20'),
	(2490, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 21:40:20'),
	(2491, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 21:40:20'),
	(2492, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 21:40:20'),
	(2493, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 21:40:20'),
	(2494, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 21:40:20'),
	(2495, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 21:40:20'),
	(2496, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 21:40:20'),
	(2497, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 21:40:20'),
	(2498, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 21:40:20'),
	(2499, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 21:40:20'),
	(2500, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 21:40:20'),
	(2501, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 21:40:20'),
	(2502, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 21:40:20'),
	(2503, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 21:40:20'),
	(2504, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 21:40:20'),
	(2505, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 21:40:20'),
	(2506, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 21:40:20'),
	(2507, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 21:40:20'),
	(2508, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 21:40:27'),
	(2509, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 21:40:27'),
	(2510, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 21:40:27'),
	(2511, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 21:40:27'),
	(2512, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 21:40:27'),
	(2513, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 21:40:27'),
	(2514, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 21:40:27'),
	(2515, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 21:40:27'),
	(2516, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 21:40:27'),
	(2517, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 21:40:27'),
	(2518, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 21:40:27'),
	(2519, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 21:40:27'),
	(2520, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 21:40:27'),
	(2521, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 21:40:27'),
	(2522, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 21:40:27'),
	(2523, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 21:40:27'),
	(2524, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 21:40:27'),
	(2525, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 21:40:27'),
	(2526, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 21:40:27'),
	(2527, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 21:40:27'),
	(2528, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 21:40:27'),
	(2529, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 21:40:27'),
	(2530, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 21:40:27'),
	(2531, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 21:40:41'),
	(2532, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 21:40:41'),
	(2533, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 21:40:41'),
	(2534, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 21:40:41'),
	(2535, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 21:40:41'),
	(2536, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 21:40:41'),
	(2537, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 21:40:41'),
	(2538, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 21:40:41'),
	(2539, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 21:40:41'),
	(2540, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 21:40:41'),
	(2541, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 21:40:41'),
	(2542, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 21:40:41'),
	(2543, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 21:40:41'),
	(2544, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 21:40:41'),
	(2545, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 21:40:41'),
	(2546, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 21:40:41'),
	(2547, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 21:40:41'),
	(2548, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 21:40:41'),
	(2549, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 21:40:41'),
	(2550, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 21:40:41'),
	(2551, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 21:40:41'),
	(2552, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 21:40:41'),
	(2553, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 21:40:41'),
	(2554, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 21:41:22'),
	(2555, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 21:41:22'),
	(2556, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 21:41:22'),
	(2557, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 21:41:22'),
	(2558, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 21:41:22'),
	(2559, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 21:41:22'),
	(2560, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 21:41:22'),
	(2561, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 21:41:22'),
	(2562, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 21:41:22'),
	(2563, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 21:41:22'),
	(2564, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 21:41:22'),
	(2565, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 21:41:22'),
	(2566, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 21:41:22'),
	(2567, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 21:41:22'),
	(2568, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 21:41:22'),
	(2569, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 21:41:22'),
	(2570, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 21:41:22'),
	(2571, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 21:41:22'),
	(2572, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 21:41:22'),
	(2573, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 21:41:22'),
	(2574, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 21:41:22'),
	(2575, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 21:41:22'),
	(2576, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 21:41:22'),
	(2577, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 21:44:30'),
	(2578, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 21:44:30'),
	(2579, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 21:44:30'),
	(2580, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 21:44:30'),
	(2581, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 21:44:30'),
	(2582, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 21:44:30'),
	(2583, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 21:44:30'),
	(2584, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 21:44:30'),
	(2585, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 21:44:30'),
	(2586, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 21:44:30'),
	(2587, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 21:44:30'),
	(2588, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 21:44:30'),
	(2589, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 21:44:30'),
	(2590, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 21:44:30'),
	(2591, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 21:44:30'),
	(2592, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 21:44:30'),
	(2593, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 21:44:30'),
	(2594, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 21:44:30'),
	(2595, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 21:44:30'),
	(2596, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 21:44:30'),
	(2597, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 21:44:30'),
	(2598, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 21:44:30'),
	(2599, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 21:44:30'),
	(2600, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 21:50:13'),
	(2601, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 21:50:13'),
	(2602, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 21:50:13'),
	(2603, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 21:50:13'),
	(2604, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 21:50:13'),
	(2605, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 21:50:13'),
	(2606, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 21:50:13'),
	(2607, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 21:50:13'),
	(2608, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 21:50:13'),
	(2609, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 21:50:13'),
	(2610, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 21:50:13'),
	(2611, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 21:50:13'),
	(2612, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 21:50:13'),
	(2613, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 21:50:13'),
	(2614, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 21:50:13'),
	(2615, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 21:50:13'),
	(2616, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 21:50:13'),
	(2617, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 21:50:13'),
	(2618, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 21:50:13'),
	(2619, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 21:50:13'),
	(2620, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 21:50:13'),
	(2621, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 21:50:13'),
	(2622, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 21:50:13'),
	(2623, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 21:57:13'),
	(2624, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 21:57:13'),
	(2625, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 21:57:13'),
	(2626, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 21:57:13'),
	(2627, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 21:57:13'),
	(2628, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 21:57:13'),
	(2629, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 21:57:13'),
	(2630, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 21:57:13'),
	(2631, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 21:57:13'),
	(2632, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 21:57:13'),
	(2633, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 21:57:13'),
	(2634, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 21:57:13'),
	(2635, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 21:57:13'),
	(2636, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 21:57:13'),
	(2637, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 21:57:13'),
	(2638, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 21:57:13'),
	(2639, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 21:57:13'),
	(2640, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 21:57:13'),
	(2641, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 21:57:13'),
	(2642, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 21:57:13'),
	(2643, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 21:57:13'),
	(2644, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 21:57:13'),
	(2645, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 21:57:13'),
	(2646, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 22:25:11'),
	(2647, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 22:25:11'),
	(2648, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 22:25:11'),
	(2649, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 22:25:11'),
	(2650, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 22:25:11'),
	(2651, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 22:25:11'),
	(2652, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 22:25:11'),
	(2653, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 22:25:11'),
	(2654, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 22:25:11'),
	(2655, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 22:25:11'),
	(2656, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 22:25:11'),
	(2657, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 22:25:11'),
	(2658, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 22:25:11'),
	(2659, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 22:25:11'),
	(2660, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 22:25:11'),
	(2661, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 22:25:11'),
	(2662, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 22:25:11'),
	(2663, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 22:25:11'),
	(2664, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 22:25:11'),
	(2665, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 22:25:11'),
	(2666, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 22:25:11'),
	(2667, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 22:25:11'),
	(2668, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 22:25:11'),
	(2669, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 22:39:19'),
	(2670, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 22:39:19'),
	(2671, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 22:39:19'),
	(2672, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 22:39:19'),
	(2673, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 22:39:19'),
	(2674, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 22:39:19'),
	(2675, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 22:39:19'),
	(2676, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 22:39:19'),
	(2677, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 22:39:19'),
	(2678, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 22:39:19'),
	(2679, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 22:39:19'),
	(2680, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 22:39:19'),
	(2681, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 22:39:19'),
	(2682, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 22:39:19'),
	(2683, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 22:39:19'),
	(2684, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 22:39:19'),
	(2685, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 22:39:19'),
	(2686, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 22:39:19'),
	(2687, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 22:39:19'),
	(2688, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 22:39:19'),
	(2689, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 22:39:19'),
	(2690, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 22:39:19'),
	(2691, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 22:39:19'),
	(2692, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 22:48:40'),
	(2693, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 22:48:40'),
	(2694, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 22:48:40'),
	(2695, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 22:48:40'),
	(2696, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 22:48:40'),
	(2697, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 22:48:40'),
	(2698, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 22:48:40'),
	(2699, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 22:48:40'),
	(2700, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 22:48:40'),
	(2701, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 22:48:40'),
	(2702, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 22:48:40'),
	(2703, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 22:48:40'),
	(2704, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 22:48:40'),
	(2705, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 22:48:40'),
	(2706, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 22:48:40'),
	(2707, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 22:48:40'),
	(2708, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 22:48:40'),
	(2709, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 22:48:40'),
	(2710, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 22:48:40'),
	(2711, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 22:48:40'),
	(2712, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 22:48:40'),
	(2713, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 22:48:40'),
	(2714, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 22:48:40'),
	(2715, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 22:49:11'),
	(2716, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 22:49:11'),
	(2717, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 22:49:11'),
	(2718, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 22:49:11'),
	(2719, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 22:49:11'),
	(2720, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 22:49:11'),
	(2721, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 22:49:11'),
	(2722, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 22:49:11'),
	(2723, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 22:49:11'),
	(2724, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 22:49:11'),
	(2725, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 22:49:11'),
	(2726, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 22:49:11'),
	(2727, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 22:49:11'),
	(2728, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 22:49:11'),
	(2729, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 22:49:11'),
	(2730, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 22:49:11'),
	(2731, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 22:49:11'),
	(2732, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 22:49:11'),
	(2733, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 22:49:11'),
	(2734, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 22:49:11'),
	(2735, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 22:49:11'),
	(2736, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 22:49:11'),
	(2737, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 22:49:11'),
	(2738, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 22:49:53'),
	(2739, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 22:49:53'),
	(2740, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 22:49:53'),
	(2741, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 22:49:53'),
	(2742, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 22:49:53'),
	(2743, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 22:49:53'),
	(2744, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 22:49:53'),
	(2745, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 22:49:53'),
	(2746, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 22:49:53'),
	(2747, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 22:49:53'),
	(2748, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 22:49:53'),
	(2749, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 22:49:53'),
	(2750, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 22:49:53'),
	(2751, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 22:49:53'),
	(2752, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 22:49:53'),
	(2753, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 22:49:53'),
	(2754, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 22:49:53'),
	(2755, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 22:49:53'),
	(2756, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 22:49:53'),
	(2757, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 22:49:53'),
	(2758, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 22:49:53'),
	(2759, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 22:49:53'),
	(2760, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 22:49:53'),
	(2761, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 22:59:25'),
	(2762, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 22:59:25'),
	(2763, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 22:59:25'),
	(2764, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 22:59:25'),
	(2765, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 22:59:25'),
	(2766, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 22:59:25'),
	(2767, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 22:59:25'),
	(2768, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 22:59:25'),
	(2769, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 22:59:25'),
	(2770, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 22:59:25'),
	(2771, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 22:59:25'),
	(2772, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 22:59:25'),
	(2773, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 22:59:25'),
	(2774, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 22:59:25'),
	(2775, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 22:59:25'),
	(2776, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 22:59:25'),
	(2777, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 22:59:25'),
	(2778, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 22:59:25'),
	(2779, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 22:59:25'),
	(2780, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 22:59:25'),
	(2781, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 22:59:25'),
	(2782, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 22:59:25'),
	(2783, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 22:59:25'),
	(2784, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:01:01'),
	(2785, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:01:01'),
	(2786, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:01:01'),
	(2787, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:01:01'),
	(2788, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:01:01'),
	(2789, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:01:01'),
	(2790, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:01:01'),
	(2791, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:01:01'),
	(2792, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:01:01'),
	(2793, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:01:01'),
	(2794, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:01:01'),
	(2795, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:01:01'),
	(2796, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:01:01'),
	(2797, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:01:01'),
	(2798, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:01:01'),
	(2799, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:01:01'),
	(2800, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:01:01'),
	(2801, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:01:01'),
	(2802, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:01:01'),
	(2803, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:01:01'),
	(2804, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:01:01'),
	(2805, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:01:01'),
	(2806, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:01:01'),
	(2807, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:09:37'),
	(2808, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:09:37'),
	(2809, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:09:37'),
	(2810, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:09:37'),
	(2811, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:09:37'),
	(2812, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:09:37'),
	(2813, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:09:37'),
	(2814, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:09:37'),
	(2815, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:09:37'),
	(2816, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:09:37'),
	(2817, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:09:37'),
	(2818, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:09:37'),
	(2819, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:09:37'),
	(2820, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:09:37'),
	(2821, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:09:37'),
	(2822, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:09:37'),
	(2823, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:09:37'),
	(2824, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:09:37'),
	(2825, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:09:37'),
	(2826, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:09:37'),
	(2827, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:09:37'),
	(2828, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:09:37'),
	(2829, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:09:37'),
	(2830, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:10:49'),
	(2831, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:10:49'),
	(2832, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:10:49'),
	(2833, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:10:49'),
	(2834, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:10:49'),
	(2835, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:10:49'),
	(2836, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:10:49'),
	(2837, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:10:49'),
	(2838, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:10:49'),
	(2839, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:10:49'),
	(2840, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:10:49'),
	(2841, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:10:49'),
	(2842, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:10:49'),
	(2843, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:10:49'),
	(2844, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:10:49'),
	(2845, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:10:49'),
	(2846, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:10:49'),
	(2847, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:10:49'),
	(2848, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:10:49'),
	(2849, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:10:49'),
	(2850, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:10:49'),
	(2851, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:10:49'),
	(2852, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:10:49'),
	(2853, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:12:15'),
	(2854, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:12:15'),
	(2855, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:12:15'),
	(2856, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:12:15'),
	(2857, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:12:15'),
	(2858, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:12:15'),
	(2859, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:12:15'),
	(2860, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:12:15'),
	(2861, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:12:15'),
	(2862, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:12:15'),
	(2863, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:12:15'),
	(2864, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:12:15'),
	(2865, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:12:15'),
	(2866, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:12:15'),
	(2867, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:12:15'),
	(2868, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:12:15'),
	(2869, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:12:15'),
	(2870, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:12:15'),
	(2871, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:12:15'),
	(2872, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:12:15'),
	(2873, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:12:15'),
	(2874, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:12:15'),
	(2875, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:12:15'),
	(2876, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:12:32'),
	(2877, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:12:32'),
	(2878, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:12:32'),
	(2879, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:12:32'),
	(2880, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:12:32'),
	(2881, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:12:32'),
	(2882, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:12:32'),
	(2883, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:12:32'),
	(2884, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:12:32'),
	(2885, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:12:32'),
	(2886, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:12:32'),
	(2887, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:12:32'),
	(2888, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:12:32'),
	(2889, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:12:32'),
	(2890, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:12:32'),
	(2891, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:12:32'),
	(2892, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:12:32'),
	(2893, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:12:32'),
	(2894, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:12:32'),
	(2895, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:12:32'),
	(2896, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:12:32'),
	(2897, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:12:32'),
	(2898, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:12:32'),
	(2899, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:15:18'),
	(2900, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:15:18'),
	(2901, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:15:18'),
	(2902, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:15:18'),
	(2903, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:15:18'),
	(2904, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:15:18'),
	(2905, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:15:18'),
	(2906, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:15:18'),
	(2907, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:15:18'),
	(2908, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:15:18'),
	(2909, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:15:18'),
	(2910, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:15:18'),
	(2911, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:15:18'),
	(2912, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:15:18'),
	(2913, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:15:18'),
	(2914, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:15:18'),
	(2915, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:15:18'),
	(2916, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:15:18'),
	(2917, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:15:18'),
	(2918, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:15:18'),
	(2919, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:15:18'),
	(2920, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:15:18'),
	(2921, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:15:18'),
	(2922, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:18:16'),
	(2923, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:18:16'),
	(2924, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:18:16'),
	(2925, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:18:16'),
	(2926, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:18:16'),
	(2927, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:18:16'),
	(2928, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:18:16'),
	(2929, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:18:16'),
	(2930, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:18:16'),
	(2931, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:18:16'),
	(2932, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:18:16'),
	(2933, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:18:16'),
	(2934, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:18:16'),
	(2935, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:18:16'),
	(2936, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:18:16'),
	(2937, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:18:16'),
	(2938, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:18:16'),
	(2939, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:18:16'),
	(2940, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:18:16'),
	(2941, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:18:16'),
	(2942, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:18:16'),
	(2943, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:18:16'),
	(2944, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:18:16'),
	(2945, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:18:46'),
	(2946, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:18:46'),
	(2947, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:18:46'),
	(2948, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:18:46'),
	(2949, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:18:46'),
	(2950, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:18:46'),
	(2951, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:18:46'),
	(2952, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:18:46'),
	(2953, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:18:46'),
	(2954, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:18:46'),
	(2955, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:18:46'),
	(2956, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:18:46'),
	(2957, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:18:46'),
	(2958, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:18:46'),
	(2959, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:18:46'),
	(2960, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:18:46'),
	(2961, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:18:46'),
	(2962, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:18:46'),
	(2963, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:18:46'),
	(2964, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:18:46'),
	(2965, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:18:46'),
	(2966, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:18:46'),
	(2967, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:18:46'),
	(2968, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:24:41'),
	(2969, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:24:41'),
	(2970, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:24:41'),
	(2971, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:24:41'),
	(2972, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:24:41'),
	(2973, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:24:41'),
	(2974, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:24:41'),
	(2975, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:24:41'),
	(2976, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:24:41'),
	(2977, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:24:41'),
	(2978, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:24:41'),
	(2979, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:24:41'),
	(2980, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:24:41'),
	(2981, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:24:41'),
	(2982, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:24:41'),
	(2983, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:24:41'),
	(2984, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:24:41'),
	(2985, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:24:41'),
	(2986, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:24:41'),
	(2987, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:24:41'),
	(2988, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:24:41'),
	(2989, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:24:41'),
	(2990, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:24:41'),
	(2991, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:31:28'),
	(2992, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:31:28'),
	(2993, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:31:28'),
	(2994, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:31:28'),
	(2995, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:31:28'),
	(2996, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:31:28'),
	(2997, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:31:28'),
	(2998, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:31:28'),
	(2999, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:31:28'),
	(3000, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:31:28'),
	(3001, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:31:28'),
	(3002, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:31:28'),
	(3003, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:31:28'),
	(3004, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:31:28'),
	(3005, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:31:28'),
	(3006, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:31:28'),
	(3007, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:31:28'),
	(3008, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:31:28'),
	(3009, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:31:28'),
	(3010, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:31:28'),
	(3011, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:31:28'),
	(3012, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:31:28'),
	(3013, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:31:28'),
	(3014, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:36:08'),
	(3015, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:36:08'),
	(3016, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:36:08'),
	(3017, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:36:08'),
	(3018, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:36:08'),
	(3019, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:36:08'),
	(3020, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:36:08'),
	(3021, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:36:08'),
	(3022, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:36:08'),
	(3023, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:36:08'),
	(3024, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:36:08'),
	(3025, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:36:08'),
	(3026, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:36:08'),
	(3027, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:36:08'),
	(3028, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:36:08'),
	(3029, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:36:08'),
	(3030, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:36:08'),
	(3031, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:36:08'),
	(3032, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:36:08'),
	(3033, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:36:08'),
	(3034, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:36:08'),
	(3035, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:36:08'),
	(3036, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:36:08'),
	(3037, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:40:08'),
	(3038, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:40:08'),
	(3039, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:40:08'),
	(3040, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:40:08'),
	(3041, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:40:08'),
	(3042, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:40:08'),
	(3043, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:40:08'),
	(3044, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:40:08'),
	(3045, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:40:08'),
	(3046, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:40:08'),
	(3047, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:40:08'),
	(3048, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:40:08'),
	(3049, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:40:08'),
	(3050, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:40:08'),
	(3051, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:40:08'),
	(3052, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:40:08'),
	(3053, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:40:08'),
	(3054, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:40:08'),
	(3055, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:40:08'),
	(3056, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:40:08'),
	(3057, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:40:08'),
	(3058, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:40:08'),
	(3059, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:40:08'),
	(3060, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:45:57'),
	(3061, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:45:57'),
	(3062, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:45:57'),
	(3063, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:45:57'),
	(3064, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:45:57'),
	(3065, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:45:57'),
	(3066, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:45:57'),
	(3067, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:45:57'),
	(3068, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:45:57'),
	(3069, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:45:57'),
	(3070, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:45:57'),
	(3071, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:45:57'),
	(3072, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:45:57'),
	(3073, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:45:57'),
	(3074, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:45:57'),
	(3075, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:45:57'),
	(3076, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:45:57'),
	(3077, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:45:57'),
	(3078, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:45:57'),
	(3079, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:45:57'),
	(3080, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:45:57'),
	(3081, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:45:57'),
	(3082, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:45:57'),
	(3083, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:47:40'),
	(3084, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:47:40'),
	(3085, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:47:40'),
	(3086, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:47:40'),
	(3087, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:47:40'),
	(3088, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:47:40'),
	(3089, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:47:40'),
	(3090, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:47:40'),
	(3091, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:47:40'),
	(3092, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:47:40'),
	(3093, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:47:40'),
	(3094, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:47:40'),
	(3095, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:47:40'),
	(3096, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:47:40'),
	(3097, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:47:40'),
	(3098, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:47:40'),
	(3099, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:47:40'),
	(3100, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:47:40'),
	(3101, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:47:40'),
	(3102, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:47:40'),
	(3103, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:47:40'),
	(3104, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:47:40'),
	(3105, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:47:40'),
	(3106, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:49:24'),
	(3107, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:49:24'),
	(3108, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:49:24'),
	(3109, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:49:24'),
	(3110, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:49:24'),
	(3111, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:49:24'),
	(3112, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:49:24'),
	(3113, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:49:24'),
	(3114, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:49:24'),
	(3115, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:49:24'),
	(3116, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:49:24'),
	(3117, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:49:24'),
	(3118, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:49:24'),
	(3119, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:49:24'),
	(3120, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:49:24'),
	(3121, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:49:24'),
	(3122, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:49:24'),
	(3123, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:49:24'),
	(3124, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:49:24'),
	(3125, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:49:24'),
	(3126, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:49:24'),
	(3127, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:49:24'),
	(3128, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:49:24'),
	(3129, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:53:19'),
	(3130, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:53:19'),
	(3131, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:53:19'),
	(3132, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:53:19'),
	(3133, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:53:19'),
	(3134, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:53:19'),
	(3135, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:53:19'),
	(3136, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:53:19'),
	(3137, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:53:19'),
	(3138, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:53:19'),
	(3139, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:53:19'),
	(3140, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:53:19'),
	(3141, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:53:19'),
	(3142, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:53:19'),
	(3143, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:53:19'),
	(3144, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:53:19'),
	(3145, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:53:19'),
	(3146, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:53:19'),
	(3147, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:53:19'),
	(3148, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:53:19'),
	(3149, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:53:19'),
	(3150, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:53:19'),
	(3151, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:53:19'),
	(3152, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:55:35'),
	(3153, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:55:35'),
	(3154, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:55:35'),
	(3155, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:55:35'),
	(3156, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:55:35'),
	(3157, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:55:35'),
	(3158, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:55:35'),
	(3159, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:55:35'),
	(3160, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:55:35'),
	(3161, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:55:35'),
	(3162, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:55:35'),
	(3163, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:55:35'),
	(3164, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:55:35'),
	(3165, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:55:35'),
	(3166, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:55:35'),
	(3167, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:55:35'),
	(3168, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:55:35'),
	(3169, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:55:35'),
	(3170, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:55:35'),
	(3171, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:55:35'),
	(3172, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:55:35'),
	(3173, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:55:35'),
	(3174, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:55:35'),
	(3175, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-08 23:58:13'),
	(3176, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-08 23:58:13'),
	(3177, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-08 23:58:13'),
	(3178, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-08 23:58:13'),
	(3179, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-08 23:58:13'),
	(3180, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-08 23:58:13'),
	(3181, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-08 23:58:13'),
	(3182, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-08 23:58:13'),
	(3183, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-08 23:58:13'),
	(3184, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-08 23:58:13'),
	(3185, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-08 23:58:13'),
	(3186, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-08 23:58:13'),
	(3187, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-08 23:58:13'),
	(3188, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-08 23:58:13'),
	(3189, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-08 23:58:13'),
	(3190, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-08 23:58:13'),
	(3191, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-08 23:58:13'),
	(3192, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-08 23:58:13'),
	(3193, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-08 23:58:13'),
	(3194, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-08 23:58:13'),
	(3195, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-08 23:58:13'),
	(3196, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-08 23:58:13'),
	(3197, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-08 23:58:13'),
	(3198, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:03:07'),
	(3199, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:03:07'),
	(3200, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:03:07'),
	(3201, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:03:07'),
	(3202, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:03:07'),
	(3203, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:03:07'),
	(3204, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:03:07'),
	(3205, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:03:07'),
	(3206, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:03:07'),
	(3207, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:03:07'),
	(3208, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:03:07'),
	(3209, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:03:07'),
	(3210, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:03:07'),
	(3211, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:03:07'),
	(3212, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:03:07'),
	(3213, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:03:07'),
	(3214, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:03:07'),
	(3215, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:03:07'),
	(3216, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:03:07'),
	(3217, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:03:07'),
	(3218, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:03:07'),
	(3219, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:03:07'),
	(3220, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:03:07'),
	(3221, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:11:10'),
	(3222, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:11:10'),
	(3223, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:11:10'),
	(3224, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:11:10'),
	(3225, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:11:10'),
	(3226, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:11:10'),
	(3227, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:11:10'),
	(3228, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:11:10'),
	(3229, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:11:10'),
	(3230, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:11:10'),
	(3231, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:11:10'),
	(3232, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:11:10'),
	(3233, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:11:10'),
	(3234, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:11:10'),
	(3235, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:11:10'),
	(3236, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:11:10'),
	(3237, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:11:10'),
	(3238, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:11:10'),
	(3239, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:11:10'),
	(3240, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:11:10'),
	(3241, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:11:10'),
	(3242, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:11:10'),
	(3243, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:11:10'),
	(3244, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:12:11'),
	(3245, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:12:11'),
	(3246, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:12:11'),
	(3247, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:12:11'),
	(3248, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:12:11'),
	(3249, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:12:11'),
	(3250, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:12:11'),
	(3251, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:12:11'),
	(3252, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:12:11'),
	(3253, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:12:11'),
	(3254, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:12:11'),
	(3255, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:12:11'),
	(3256, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:12:11'),
	(3257, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:12:11'),
	(3258, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:12:11'),
	(3259, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:12:11'),
	(3260, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:12:11'),
	(3261, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:12:11'),
	(3262, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:12:11'),
	(3263, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:12:11'),
	(3264, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:12:11'),
	(3265, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:12:11'),
	(3266, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:12:11'),
	(3267, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:19:50'),
	(3268, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:19:50'),
	(3269, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:19:50'),
	(3270, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:19:50'),
	(3271, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:19:50'),
	(3272, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:19:50'),
	(3273, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:19:50'),
	(3274, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:19:50'),
	(3275, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:19:50'),
	(3276, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:19:50'),
	(3277, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:19:50'),
	(3278, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:19:50'),
	(3279, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:19:50'),
	(3280, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:19:50'),
	(3281, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:19:50'),
	(3282, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:19:50'),
	(3283, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:19:50'),
	(3284, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:19:50'),
	(3285, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:19:50'),
	(3286, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:19:50'),
	(3287, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:19:50'),
	(3288, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:19:50'),
	(3289, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:19:50'),
	(3290, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:23:16'),
	(3291, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:23:16'),
	(3292, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:23:16'),
	(3293, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:23:16'),
	(3294, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:23:16'),
	(3295, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:23:16'),
	(3296, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:23:16'),
	(3297, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:23:16'),
	(3298, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:23:16'),
	(3299, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:23:16'),
	(3300, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:23:16'),
	(3301, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:23:16'),
	(3302, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:23:16'),
	(3303, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:23:16'),
	(3304, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:23:16'),
	(3305, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:23:16'),
	(3306, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:23:16'),
	(3307, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:23:16'),
	(3308, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:23:16'),
	(3309, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:23:16'),
	(3310, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:23:16'),
	(3311, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:23:16'),
	(3312, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:23:16'),
	(3313, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:28:03'),
	(3314, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:28:03'),
	(3315, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:28:03'),
	(3316, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:28:03'),
	(3317, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:28:03'),
	(3318, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:28:03'),
	(3319, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:28:03'),
	(3320, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:28:03'),
	(3321, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:28:03'),
	(3322, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:28:03'),
	(3323, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:28:03'),
	(3324, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:28:03'),
	(3325, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:28:03'),
	(3326, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:28:03'),
	(3327, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:28:03'),
	(3328, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:28:03'),
	(3329, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:28:03'),
	(3330, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:28:03'),
	(3331, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:28:03'),
	(3332, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:28:03'),
	(3333, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:28:03'),
	(3334, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:28:03'),
	(3335, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:28:03'),
	(3336, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:30:22'),
	(3337, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:30:22'),
	(3338, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:30:22'),
	(3339, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:30:22'),
	(3340, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:30:22'),
	(3341, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:30:22'),
	(3342, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:30:22'),
	(3343, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:30:22'),
	(3344, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:30:22'),
	(3345, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:30:22'),
	(3346, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:30:22'),
	(3347, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:30:22'),
	(3348, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:30:22'),
	(3349, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:30:22'),
	(3350, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:30:22'),
	(3351, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:30:22'),
	(3352, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:30:22'),
	(3353, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:30:22'),
	(3354, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:30:22'),
	(3355, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:30:22'),
	(3356, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:30:22'),
	(3357, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:30:22'),
	(3358, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:30:22'),
	(3359, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:33:54'),
	(3360, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:33:54'),
	(3361, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:33:54'),
	(3362, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:33:54'),
	(3363, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:33:54'),
	(3364, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:33:54'),
	(3365, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:33:54'),
	(3366, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:33:54'),
	(3367, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:33:54'),
	(3368, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:33:54'),
	(3369, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:33:54'),
	(3370, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:33:54'),
	(3371, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:33:54'),
	(3372, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:33:54'),
	(3373, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:33:54'),
	(3374, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:33:54'),
	(3375, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:33:54'),
	(3376, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:33:54'),
	(3377, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:33:54'),
	(3378, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:33:54'),
	(3379, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:33:54'),
	(3380, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:33:54'),
	(3381, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:33:54'),
	(3382, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:37:15'),
	(3383, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:37:15'),
	(3384, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:37:15'),
	(3385, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:37:15'),
	(3386, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:37:15'),
	(3387, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:37:15'),
	(3388, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:37:15'),
	(3389, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:37:15'),
	(3390, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:37:15'),
	(3391, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:37:15'),
	(3392, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:37:15'),
	(3393, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:37:15'),
	(3394, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:37:15'),
	(3395, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:37:15'),
	(3396, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:37:15'),
	(3397, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:37:15'),
	(3398, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:37:15'),
	(3399, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:37:15'),
	(3400, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:37:15'),
	(3401, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:37:15'),
	(3402, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:37:15'),
	(3403, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:37:15'),
	(3404, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:37:15'),
	(3405, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:41:06'),
	(3406, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:41:06'),
	(3407, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:41:06'),
	(3408, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:41:06'),
	(3409, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:41:06'),
	(3410, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:41:06'),
	(3411, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:41:06'),
	(3412, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:41:06'),
	(3413, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:41:06'),
	(3414, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:41:06'),
	(3415, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:41:06'),
	(3416, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:41:06'),
	(3417, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:41:06'),
	(3418, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:41:06'),
	(3419, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:41:06'),
	(3420, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:41:06'),
	(3421, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:41:06'),
	(3422, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:41:06'),
	(3423, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:41:06'),
	(3424, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:41:06'),
	(3425, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:41:06'),
	(3426, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:41:06'),
	(3427, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:41:06'),
	(3428, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:43:01'),
	(3429, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:43:01'),
	(3430, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:43:01'),
	(3431, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:43:01'),
	(3432, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:43:01'),
	(3433, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:43:01'),
	(3434, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:43:01'),
	(3435, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:43:01'),
	(3436, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:43:01'),
	(3437, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:43:01'),
	(3438, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:43:01'),
	(3439, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:43:01'),
	(3440, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:43:01'),
	(3441, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:43:01'),
	(3442, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:43:01'),
	(3443, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:43:01'),
	(3444, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:43:01'),
	(3445, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:43:01'),
	(3446, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:43:01'),
	(3447, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:43:01'),
	(3448, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:43:01'),
	(3449, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:43:01'),
	(3450, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:43:01'),
	(3451, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:44:01'),
	(3452, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:44:01'),
	(3453, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:44:01'),
	(3454, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:44:01'),
	(3455, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:44:01'),
	(3456, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:44:01'),
	(3457, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:44:01'),
	(3458, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:44:01'),
	(3459, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:44:01'),
	(3460, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:44:01'),
	(3461, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:44:01'),
	(3462, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:44:01'),
	(3463, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:44:01'),
	(3464, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:44:01'),
	(3465, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:44:01'),
	(3466, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:44:01'),
	(3467, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:44:01'),
	(3468, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:44:01'),
	(3469, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:44:01'),
	(3470, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:44:01'),
	(3471, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:44:01'),
	(3472, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:44:01'),
	(3473, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:44:01'),
	(3474, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:47:24'),
	(3475, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:47:24'),
	(3476, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:47:24'),
	(3477, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:47:24'),
	(3478, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:47:24'),
	(3479, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:47:24'),
	(3480, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:47:24'),
	(3481, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:47:24'),
	(3482, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:47:24'),
	(3483, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:47:24'),
	(3484, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:47:24'),
	(3485, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:47:24'),
	(3486, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:47:24'),
	(3487, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:47:24'),
	(3488, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:47:24'),
	(3489, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:47:24'),
	(3490, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:47:24'),
	(3491, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:47:24'),
	(3492, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:47:24'),
	(3493, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:47:24'),
	(3494, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:47:24'),
	(3495, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:47:24'),
	(3496, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:47:24'),
	(3497, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:52:25'),
	(3498, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:52:25'),
	(3499, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:52:25'),
	(3500, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:52:25'),
	(3501, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:52:25'),
	(3502, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:52:25'),
	(3503, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:52:25'),
	(3504, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:52:25'),
	(3505, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:52:25'),
	(3506, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:52:25'),
	(3507, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:52:25'),
	(3508, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:52:25'),
	(3509, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:52:25'),
	(3510, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:52:25'),
	(3511, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:52:25'),
	(3512, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:52:25'),
	(3513, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:52:25'),
	(3514, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:52:25'),
	(3515, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:52:25'),
	(3516, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:52:25'),
	(3517, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:52:25'),
	(3518, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:52:25'),
	(3519, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:52:25'),
	(3520, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 00:55:47'),
	(3521, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 00:55:47'),
	(3522, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 00:55:47'),
	(3523, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 00:55:47'),
	(3524, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 00:55:47'),
	(3525, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 00:55:47'),
	(3526, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 00:55:47'),
	(3527, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 00:55:47'),
	(3528, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 00:55:47'),
	(3529, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 00:55:47'),
	(3530, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 00:55:47'),
	(3531, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 00:55:47'),
	(3532, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 00:55:47'),
	(3533, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 00:55:47'),
	(3534, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 00:55:47'),
	(3535, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 00:55:47'),
	(3536, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 00:55:47'),
	(3537, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 00:55:47'),
	(3538, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 00:55:47'),
	(3539, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 00:55:47'),
	(3540, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 00:55:47'),
	(3541, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 00:55:47'),
	(3542, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 00:55:47'),
	(3543, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:07:22'),
	(3544, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:07:22'),
	(3545, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:07:22'),
	(3546, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:07:22'),
	(3547, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:07:22'),
	(3548, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:07:22'),
	(3549, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:07:22'),
	(3550, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:07:22'),
	(3551, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:07:22'),
	(3552, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:07:22'),
	(3553, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:07:22'),
	(3554, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:07:22'),
	(3555, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:07:22'),
	(3556, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:07:22'),
	(3557, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:07:22'),
	(3558, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:07:22'),
	(3559, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:07:22'),
	(3560, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:07:22'),
	(3561, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:07:22'),
	(3562, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:07:22'),
	(3563, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:07:22'),
	(3564, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:07:22'),
	(3565, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:07:22'),
	(3566, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:09:26'),
	(3567, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:09:26'),
	(3568, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:09:26'),
	(3569, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:09:26'),
	(3570, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:09:26'),
	(3571, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:09:26'),
	(3572, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:09:26'),
	(3573, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:09:26'),
	(3574, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:09:26'),
	(3575, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:09:26'),
	(3576, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:09:26'),
	(3577, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:09:26'),
	(3578, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:09:26'),
	(3579, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:09:26'),
	(3580, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:09:26'),
	(3581, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:09:26'),
	(3582, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:09:26'),
	(3583, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:09:26'),
	(3584, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:09:26'),
	(3585, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:09:26'),
	(3586, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:09:26'),
	(3587, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:09:26'),
	(3588, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:09:26'),
	(3589, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:12:14'),
	(3590, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:12:14'),
	(3591, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:12:14'),
	(3592, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:12:14'),
	(3593, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:12:14'),
	(3594, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:12:14'),
	(3595, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:12:14'),
	(3596, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:12:14'),
	(3597, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:12:14'),
	(3598, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:12:14'),
	(3599, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:12:14'),
	(3600, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:12:14'),
	(3601, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:12:14'),
	(3602, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:12:14'),
	(3603, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:12:14'),
	(3604, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:12:14'),
	(3605, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:12:14'),
	(3606, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:12:14'),
	(3607, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:12:14'),
	(3608, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:12:14'),
	(3609, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:12:14'),
	(3610, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:12:14'),
	(3611, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:12:14'),
	(3612, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:30:35'),
	(3613, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:30:35'),
	(3614, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:30:35'),
	(3615, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:30:35'),
	(3616, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:30:35'),
	(3617, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:30:35'),
	(3618, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:30:35'),
	(3619, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:30:35'),
	(3620, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:30:35'),
	(3621, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:30:35'),
	(3622, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:30:35'),
	(3623, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:30:35'),
	(3624, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:30:35'),
	(3625, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:30:35'),
	(3626, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:30:35'),
	(3627, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:30:35'),
	(3628, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:30:35'),
	(3629, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:30:35'),
	(3630, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:30:35'),
	(3631, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:30:35'),
	(3632, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:30:35'),
	(3633, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:30:35'),
	(3634, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:30:35'),
	(3635, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:35:25'),
	(3636, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:35:25'),
	(3637, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:35:25'),
	(3638, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:35:25'),
	(3639, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:35:25'),
	(3640, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:35:25'),
	(3641, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:35:25'),
	(3642, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:35:25'),
	(3643, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:35:25'),
	(3644, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:35:25'),
	(3645, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:35:25'),
	(3646, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:35:25'),
	(3647, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:35:25'),
	(3648, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:35:25'),
	(3649, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:35:25'),
	(3650, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:35:25'),
	(3651, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:35:25'),
	(3652, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:35:25'),
	(3653, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:35:25'),
	(3654, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:35:25'),
	(3655, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:35:25'),
	(3656, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:35:25'),
	(3657, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:35:25'),
	(3658, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:36:01'),
	(3659, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:36:01'),
	(3660, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:36:01'),
	(3661, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:36:01'),
	(3662, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:36:01'),
	(3663, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:36:01'),
	(3664, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:36:01'),
	(3665, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:36:01'),
	(3666, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:36:01'),
	(3667, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:36:01'),
	(3668, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:36:01'),
	(3669, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:36:01'),
	(3670, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:36:01'),
	(3671, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:36:01'),
	(3672, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:36:01'),
	(3673, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:36:01'),
	(3674, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:36:01'),
	(3675, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:36:01'),
	(3676, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:36:01'),
	(3677, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:36:01'),
	(3678, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:36:01'),
	(3679, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:36:01'),
	(3680, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:36:01'),
	(3681, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:43:14'),
	(3682, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:43:14'),
	(3683, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:43:14'),
	(3684, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:43:14'),
	(3685, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:43:14'),
	(3686, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:43:14'),
	(3687, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:43:14'),
	(3688, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:43:14'),
	(3689, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:43:14'),
	(3690, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:43:14'),
	(3691, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:43:14'),
	(3692, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:43:14'),
	(3693, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:43:14'),
	(3694, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:43:14'),
	(3695, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:43:14'),
	(3696, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:43:14'),
	(3697, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:43:14'),
	(3698, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:43:14'),
	(3699, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:43:14'),
	(3700, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:43:14'),
	(3701, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:43:14'),
	(3702, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:43:14'),
	(3703, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:43:14'),
	(3704, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:45:51'),
	(3705, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:45:51'),
	(3706, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:45:51'),
	(3707, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:45:51'),
	(3708, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:45:51'),
	(3709, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:45:51'),
	(3710, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:45:51'),
	(3711, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:45:51'),
	(3712, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:45:51'),
	(3713, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:45:51'),
	(3714, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:45:51'),
	(3715, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:45:51'),
	(3716, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:45:51'),
	(3717, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:45:51'),
	(3718, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:45:51'),
	(3719, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:45:51'),
	(3720, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:45:51'),
	(3721, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:45:51'),
	(3722, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:45:51'),
	(3723, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:45:51'),
	(3724, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:45:51'),
	(3725, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:45:51'),
	(3726, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:45:51'),
	(3727, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:48:12'),
	(3728, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:48:12'),
	(3729, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:48:12'),
	(3730, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:48:12'),
	(3731, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:48:12'),
	(3732, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:48:12'),
	(3733, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:48:12'),
	(3734, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:48:12'),
	(3735, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:48:12'),
	(3736, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:48:12'),
	(3737, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:48:12'),
	(3738, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:48:12'),
	(3739, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:48:12'),
	(3740, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:48:12'),
	(3741, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:48:12'),
	(3742, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:48:12'),
	(3743, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:48:12'),
	(3744, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:48:12'),
	(3745, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:48:12'),
	(3746, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:48:12'),
	(3747, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:48:12'),
	(3748, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:48:12'),
	(3749, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:48:12'),
	(3750, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:49:47'),
	(3751, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:49:47'),
	(3752, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:49:47'),
	(3753, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:49:47'),
	(3754, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:49:47'),
	(3755, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:49:47'),
	(3756, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:49:47'),
	(3757, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:49:47'),
	(3758, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:49:47'),
	(3759, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:49:47'),
	(3760, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:49:47'),
	(3761, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:49:47'),
	(3762, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:49:47'),
	(3763, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:49:47'),
	(3764, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:49:47'),
	(3765, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:49:47'),
	(3766, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:49:47'),
	(3767, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:49:47'),
	(3768, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:49:47'),
	(3769, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:49:47'),
	(3770, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:49:47'),
	(3771, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:49:47'),
	(3772, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:49:47'),
	(3773, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:51:44'),
	(3774, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:51:44'),
	(3775, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:51:44'),
	(3776, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:51:44'),
	(3777, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:51:44'),
	(3778, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:51:44'),
	(3779, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:51:44'),
	(3780, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:51:44'),
	(3781, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:51:44'),
	(3782, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:51:44'),
	(3783, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:51:44'),
	(3784, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:51:44'),
	(3785, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:51:44'),
	(3786, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:51:44'),
	(3787, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:51:44'),
	(3788, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:51:44'),
	(3789, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:51:44'),
	(3790, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:51:44'),
	(3791, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:51:44'),
	(3792, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:51:44'),
	(3793, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:51:44'),
	(3794, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:51:44'),
	(3795, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:51:44'),
	(3796, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:54:20'),
	(3797, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:54:20'),
	(3798, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:54:20'),
	(3799, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:54:20'),
	(3800, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:54:20'),
	(3801, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:54:20'),
	(3802, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:54:20'),
	(3803, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:54:20'),
	(3804, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:54:20'),
	(3805, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:54:20'),
	(3806, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:54:20'),
	(3807, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:54:20'),
	(3808, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:54:20'),
	(3809, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:54:20'),
	(3810, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:54:20'),
	(3811, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:54:20'),
	(3812, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:54:20'),
	(3813, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:54:20'),
	(3814, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:54:20'),
	(3815, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:54:20'),
	(3816, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:54:20'),
	(3817, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:54:20'),
	(3818, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:54:20'),
	(3819, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 01:57:32'),
	(3820, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 01:57:32'),
	(3821, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 01:57:32'),
	(3822, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 01:57:32'),
	(3823, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 01:57:32'),
	(3824, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 01:57:32'),
	(3825, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 01:57:32'),
	(3826, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 01:57:32'),
	(3827, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 01:57:32'),
	(3828, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 01:57:32'),
	(3829, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 01:57:32'),
	(3830, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 01:57:32'),
	(3831, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 01:57:32'),
	(3832, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 01:57:32'),
	(3833, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 01:57:32'),
	(3834, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 01:57:32'),
	(3835, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 01:57:32'),
	(3836, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 01:57:32'),
	(3837, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 01:57:32'),
	(3838, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 01:57:32'),
	(3839, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 01:57:32'),
	(3840, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 01:57:32'),
	(3841, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 01:57:32'),
	(3842, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 02:01:20'),
	(3843, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 02:01:20'),
	(3844, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 02:01:20'),
	(3845, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 02:01:20'),
	(3846, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 02:01:20'),
	(3847, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 02:01:20'),
	(3848, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 02:01:20'),
	(3849, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 02:01:20'),
	(3850, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 02:01:20'),
	(3851, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 02:01:20'),
	(3852, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 02:01:20'),
	(3853, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 02:01:20'),
	(3854, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 02:01:20'),
	(3855, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 02:01:20'),
	(3856, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 02:01:20'),
	(3857, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 02:01:20'),
	(3858, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 02:01:20'),
	(3859, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 02:01:20'),
	(3860, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 02:01:20'),
	(3861, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 02:01:20'),
	(3862, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 02:01:20'),
	(3863, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 02:01:20'),
	(3864, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 02:01:20'),
	(3865, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 02:02:20'),
	(3866, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 02:02:20'),
	(3867, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 02:02:20'),
	(3868, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 02:02:20'),
	(3869, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 02:02:20'),
	(3870, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 02:02:20'),
	(3871, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 02:02:20'),
	(3872, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 02:02:20'),
	(3873, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 02:02:20'),
	(3874, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 02:02:20'),
	(3875, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 02:02:20'),
	(3876, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 02:02:20'),
	(3877, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 02:02:20'),
	(3878, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 02:02:20'),
	(3879, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 02:02:20'),
	(3880, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 02:02:20'),
	(3881, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 02:02:20'),
	(3882, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 02:02:20'),
	(3883, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 02:02:20'),
	(3884, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 02:02:20'),
	(3885, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 02:02:20'),
	(3886, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 02:02:20'),
	(3887, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 02:02:20'),
	(3888, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 02:03:43'),
	(3889, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 02:03:43'),
	(3890, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 02:03:43'),
	(3891, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 02:03:43'),
	(3892, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 02:03:43'),
	(3893, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 02:03:43'),
	(3894, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 02:03:43'),
	(3895, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 02:03:43'),
	(3896, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 02:03:43'),
	(3897, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 02:03:43'),
	(3898, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 02:03:43'),
	(3899, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 02:03:43'),
	(3900, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 02:03:43'),
	(3901, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 02:03:43'),
	(3902, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 02:03:43'),
	(3903, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 02:03:43'),
	(3904, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 02:03:43'),
	(3905, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 02:03:43'),
	(3906, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 02:03:43'),
	(3907, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 02:03:43'),
	(3908, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 02:03:43'),
	(3909, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 02:03:43'),
	(3910, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 02:03:43'),
	(3911, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 02:05:08'),
	(3912, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 02:05:08'),
	(3913, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 02:05:08'),
	(3914, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 02:05:08'),
	(3915, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 02:05:08'),
	(3916, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 02:05:08'),
	(3917, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 02:05:08'),
	(3918, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 02:05:08'),
	(3919, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 02:05:08'),
	(3920, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 02:05:08'),
	(3921, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 02:05:08'),
	(3922, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 02:05:08'),
	(3923, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 02:05:08'),
	(3924, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 02:05:08'),
	(3925, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 02:05:08'),
	(3926, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 02:05:08'),
	(3927, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 02:05:08'),
	(3928, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 02:05:08'),
	(3929, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 02:05:08'),
	(3930, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 02:05:08'),
	(3931, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 02:05:08'),
	(3932, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 02:05:08'),
	(3933, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 02:05:08'),
	(3934, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 02:06:01'),
	(3935, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 02:06:01'),
	(3936, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 02:06:01'),
	(3937, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 02:06:01'),
	(3938, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 02:06:01'),
	(3939, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 02:06:01'),
	(3940, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 02:06:01'),
	(3941, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 02:06:01'),
	(3942, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 02:06:01'),
	(3943, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 02:06:01'),
	(3944, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 02:06:01'),
	(3945, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 02:06:01'),
	(3946, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 02:06:01'),
	(3947, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 02:06:01'),
	(3948, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 02:06:01'),
	(3949, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 02:06:01'),
	(3950, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 02:06:01'),
	(3951, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 02:06:01'),
	(3952, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 02:06:01'),
	(3953, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 02:06:01'),
	(3954, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 02:06:01'),
	(3955, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 02:06:01'),
	(3956, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 02:06:01'),
	(3957, 1, 'USD', 42.511750, 42.473500, 42.550000, 'tcmb', '2025-12-09 02:06:48'),
	(3958, 1, 'AUD', 28.223200, 28.131500, 28.314900, 'tcmb', '2025-12-09 02:06:48'),
	(3959, 1, 'DKK', 6.633550, 6.617300, 6.649800, 'tcmb', '2025-12-09 02:06:48'),
	(3960, 1, 'EUR', 49.545000, 49.500400, 49.589600, 'tcmb', '2025-12-09 02:06:48'),
	(3961, 1, 'GBP', 56.643750, 56.496500, 56.791000, 'tcmb', '2025-12-09 02:06:48'),
	(3962, 1, 'CHF', 52.863250, 52.694100, 53.032400, 'tcmb', '2025-12-09 02:06:48'),
	(3963, 1, 'SEK', 4.523300, 4.500000, 4.546600, 'tcmb', '2025-12-09 02:06:48'),
	(3964, 1, 'CAD', 30.756200, 30.687000, 30.825400, 'tcmb', '2025-12-09 02:06:48'),
	(3965, 1, 'KWD', 138.471800, 137.571700, 139.371900, 'tcmb', '2025-12-09 02:06:48'),
	(3966, 1, 'NOK', 4.203150, 4.189100, 4.217200, 'tcmb', '2025-12-09 02:06:48'),
	(3967, 1, 'SAR', 11.325350, 11.315200, 11.335500, 'tcmb', '2025-12-09 02:06:48'),
	(3968, 1, 'JPY', 0.273518, 0.272615, 0.274421, 'tcmb', '2025-12-09 02:06:48'),
	(3969, 1, 'BGN', 25.340200, 25.175500, 25.504900, 'tcmb', '2025-12-09 02:06:48'),
	(3970, 1, 'RON', 9.734400, 9.671100, 9.797700, 'tcmb', '2025-12-09 02:06:48'),
	(3971, 1, 'RUB', 0.553345, 0.549750, 0.556940, 'tcmb', '2025-12-09 02:06:48'),
	(3972, 1, 'CNY', 6.013900, 5.974800, 6.053000, 'tcmb', '2025-12-09 02:06:48'),
	(3973, 1, 'PKR', 0.150505, 0.149530, 0.151480, 'tcmb', '2025-12-09 02:06:48'),
	(3974, 1, 'QAR', 11.665900, 11.590100, 11.741700, 'tcmb', '2025-12-09 02:06:48'),
	(3975, 1, 'KRW', 0.028965, 0.028780, 0.029150, 'tcmb', '2025-12-09 02:06:48'),
	(3976, 1, 'AZN', 25.006950, 24.844400, 25.169500, 'tcmb', '2025-12-09 02:06:48'),
	(3977, 1, 'AED', 11.574850, 11.499600, 11.650100, 'tcmb', '2025-12-09 02:06:48'),
	(3978, 1, 'KZT', 0.083475, 0.082930, 0.084020, 'tcmb', '2025-12-09 02:06:48'),
	(3979, 1, 'XDR', 28.983950, 57.967900, 0.000000, 'tcmb', '2025-12-09 02:06:48'),
	(3980, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 13:54:00'),
	(3981, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 13:54:00'),
	(3982, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 13:54:00'),
	(3983, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 13:54:00'),
	(3984, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 13:54:00'),
	(3985, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 13:54:00'),
	(3986, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 13:54:00'),
	(3987, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 13:54:00'),
	(3988, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 13:54:00'),
	(3989, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 13:54:00'),
	(3990, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 13:54:00'),
	(3991, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 13:54:00'),
	(3992, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 13:54:00'),
	(3993, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 13:54:00'),
	(3994, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 13:54:00'),
	(3995, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 13:54:00'),
	(3996, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 13:54:00'),
	(3997, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 13:54:00'),
	(3998, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 13:54:00'),
	(3999, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 13:54:00'),
	(4000, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 13:54:00'),
	(4001, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 13:54:00'),
	(4002, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 13:54:00'),
	(4003, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 14:08:48'),
	(4004, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 14:08:48'),
	(4005, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 14:08:48'),
	(4006, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 14:08:48'),
	(4007, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 14:08:48'),
	(4008, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 14:08:48'),
	(4009, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 14:08:48'),
	(4010, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 14:08:48'),
	(4011, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 14:08:48'),
	(4012, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 14:08:48'),
	(4013, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 14:08:48'),
	(4014, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 14:08:48'),
	(4015, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 14:08:48'),
	(4016, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 14:08:48'),
	(4017, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 14:08:48'),
	(4018, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 14:08:48'),
	(4019, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 14:08:48'),
	(4020, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 14:08:48'),
	(4021, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 14:08:48'),
	(4022, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 14:08:48'),
	(4023, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 14:08:48'),
	(4024, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 14:08:48'),
	(4025, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 14:08:48'),
	(4026, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 14:41:12'),
	(4027, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 14:41:12'),
	(4028, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 14:41:12'),
	(4029, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 14:41:12'),
	(4030, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 14:41:12'),
	(4031, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 14:41:12'),
	(4032, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 14:41:12'),
	(4033, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 14:41:12'),
	(4034, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 14:41:12'),
	(4035, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 14:41:12'),
	(4036, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 14:41:12'),
	(4037, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 14:41:12'),
	(4038, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 14:41:12'),
	(4039, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 14:41:12'),
	(4040, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 14:41:12'),
	(4041, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 14:41:12'),
	(4042, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 14:41:12'),
	(4043, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 14:41:12'),
	(4044, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 14:41:12'),
	(4045, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 14:41:12'),
	(4046, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 14:41:12'),
	(4047, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 14:41:12'),
	(4048, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 14:41:12'),
	(4049, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 15:12:07'),
	(4050, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 15:12:07'),
	(4051, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 15:12:07'),
	(4052, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 15:12:07'),
	(4053, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 15:12:07'),
	(4054, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 15:12:07'),
	(4055, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 15:12:07'),
	(4056, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 15:12:07'),
	(4057, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 15:12:07'),
	(4058, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 15:12:07'),
	(4059, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 15:12:07'),
	(4060, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 15:12:07'),
	(4061, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 15:12:07'),
	(4062, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 15:12:07'),
	(4063, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 15:12:07'),
	(4064, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 15:12:07'),
	(4065, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 15:12:07'),
	(4066, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 15:12:07'),
	(4067, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 15:12:07'),
	(4068, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 15:12:07'),
	(4069, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 15:12:07'),
	(4070, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 15:12:07'),
	(4071, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 15:12:07'),
	(4072, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 15:20:18'),
	(4073, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 15:20:18'),
	(4074, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 15:20:18'),
	(4075, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 15:20:18'),
	(4076, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 15:20:18'),
	(4077, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 15:20:18'),
	(4078, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 15:20:18'),
	(4079, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 15:20:18'),
	(4080, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 15:20:18'),
	(4081, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 15:20:18'),
	(4082, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 15:20:18'),
	(4083, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 15:20:18'),
	(4084, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 15:20:18'),
	(4085, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 15:20:18'),
	(4086, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 15:20:18'),
	(4087, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 15:20:18'),
	(4088, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 15:20:18'),
	(4089, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 15:20:18'),
	(4090, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 15:20:18'),
	(4091, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 15:20:18'),
	(4092, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 15:20:18'),
	(4093, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 15:20:19'),
	(4094, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 15:20:19'),
	(4095, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 15:25:41'),
	(4096, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 15:25:41'),
	(4097, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 15:25:41'),
	(4098, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 15:25:41'),
	(4099, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 15:25:41'),
	(4100, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 15:25:41'),
	(4101, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 15:25:41'),
	(4102, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 15:25:41'),
	(4103, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 15:25:41'),
	(4104, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 15:25:41'),
	(4105, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 15:25:41'),
	(4106, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 15:25:41'),
	(4107, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 15:25:41'),
	(4108, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 15:25:41'),
	(4109, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 15:25:41'),
	(4110, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 15:25:41'),
	(4111, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 15:25:41'),
	(4112, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 15:25:41'),
	(4113, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 15:25:41'),
	(4114, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 15:25:41'),
	(4115, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 15:25:41'),
	(4116, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 15:25:41'),
	(4117, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 15:25:41'),
	(4118, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 15:36:24'),
	(4119, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 15:36:24'),
	(4120, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 15:36:24'),
	(4121, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 15:36:24'),
	(4122, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 15:36:24'),
	(4123, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 15:36:24'),
	(4124, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 15:36:24'),
	(4125, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 15:36:24'),
	(4126, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 15:36:24'),
	(4127, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 15:36:24'),
	(4128, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 15:36:24'),
	(4129, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 15:36:24'),
	(4130, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 15:36:24'),
	(4131, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 15:36:24'),
	(4132, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 15:36:24'),
	(4133, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 15:36:24'),
	(4134, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 15:36:24'),
	(4135, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 15:36:24'),
	(4136, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 15:36:24'),
	(4137, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 15:36:24'),
	(4138, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 15:36:24'),
	(4139, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 15:36:24'),
	(4140, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 15:36:24'),
	(4141, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 15:36:52'),
	(4142, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 15:36:52'),
	(4143, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 15:36:52'),
	(4144, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 15:36:52'),
	(4145, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 15:36:52'),
	(4146, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 15:36:52'),
	(4147, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 15:36:52'),
	(4148, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 15:36:52'),
	(4149, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 15:36:52'),
	(4150, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 15:36:52'),
	(4151, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 15:36:52'),
	(4152, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 15:36:52'),
	(4153, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 15:36:52'),
	(4154, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 15:36:52'),
	(4155, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 15:36:52'),
	(4156, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 15:36:52'),
	(4157, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 15:36:52'),
	(4158, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 15:36:52'),
	(4159, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 15:36:52'),
	(4160, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 15:36:52'),
	(4161, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 15:36:52'),
	(4162, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 15:36:52'),
	(4163, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 15:36:52'),
	(4164, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 15:40:35'),
	(4165, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 15:40:35'),
	(4166, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 15:40:35'),
	(4167, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 15:40:35'),
	(4168, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 15:40:35'),
	(4169, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 15:40:35'),
	(4170, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 15:40:35'),
	(4171, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 15:40:35'),
	(4172, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 15:40:35'),
	(4173, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 15:40:35'),
	(4174, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 15:40:35'),
	(4175, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 15:40:35'),
	(4176, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 15:40:35'),
	(4177, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 15:40:35'),
	(4178, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 15:40:35'),
	(4179, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 15:40:35'),
	(4180, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 15:40:35'),
	(4181, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 15:40:35'),
	(4182, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 15:40:35'),
	(4183, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 15:40:35'),
	(4184, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 15:40:35'),
	(4185, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 15:40:35'),
	(4186, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 15:40:35'),
	(4187, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 16:02:09'),
	(4188, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 16:02:09'),
	(4189, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 16:02:09'),
	(4190, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 16:02:09'),
	(4191, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 16:02:09'),
	(4192, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 16:02:09'),
	(4193, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 16:02:09'),
	(4194, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 16:02:09'),
	(4195, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 16:02:09'),
	(4196, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 16:02:09'),
	(4197, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 16:02:09'),
	(4198, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 16:02:09'),
	(4199, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 16:02:09'),
	(4200, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 16:02:09'),
	(4201, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 16:02:09'),
	(4202, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 16:02:09'),
	(4203, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 16:02:09'),
	(4204, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 16:02:09'),
	(4205, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 16:02:09'),
	(4206, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 16:02:09'),
	(4207, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 16:02:09'),
	(4208, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 16:02:09'),
	(4209, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 16:02:09'),
	(4210, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 16:18:52'),
	(4211, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 16:18:52'),
	(4212, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 16:18:52'),
	(4213, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 16:18:52'),
	(4214, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 16:18:52'),
	(4215, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 16:18:52'),
	(4216, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 16:18:52'),
	(4217, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 16:18:52'),
	(4218, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 16:18:52'),
	(4219, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 16:18:52'),
	(4220, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 16:18:52'),
	(4221, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 16:18:52'),
	(4222, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 16:18:52'),
	(4223, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 16:18:52'),
	(4224, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 16:18:52'),
	(4225, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 16:18:52'),
	(4226, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 16:18:52'),
	(4227, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 16:18:52'),
	(4228, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 16:18:52'),
	(4229, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 16:18:52'),
	(4230, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 16:18:52'),
	(4231, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 16:18:52'),
	(4232, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 16:18:52'),
	(4233, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 18:54:26'),
	(4234, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 18:54:26'),
	(4235, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 18:54:26'),
	(4236, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 18:54:26'),
	(4237, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 18:54:26'),
	(4238, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 18:54:26'),
	(4239, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 18:54:26'),
	(4240, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 18:54:26'),
	(4241, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 18:54:26'),
	(4242, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 18:54:26'),
	(4243, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 18:54:26'),
	(4244, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 18:54:26'),
	(4245, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 18:54:26'),
	(4246, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 18:54:26'),
	(4247, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 18:54:26'),
	(4248, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 18:54:26'),
	(4249, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 18:54:26'),
	(4250, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 18:54:26'),
	(4251, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 18:54:26'),
	(4252, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 18:54:26'),
	(4253, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 18:54:26'),
	(4254, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 18:54:26'),
	(4255, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 18:54:26'),
	(4256, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 18:56:31'),
	(4257, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 18:56:31'),
	(4258, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 18:56:31'),
	(4259, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 18:56:31'),
	(4260, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 18:56:31'),
	(4261, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 18:56:31'),
	(4262, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 18:56:31'),
	(4263, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 18:56:31'),
	(4264, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 18:56:31'),
	(4265, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 18:56:31'),
	(4266, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 18:56:31'),
	(4267, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 18:56:31'),
	(4268, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 18:56:31'),
	(4269, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 18:56:31'),
	(4270, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 18:56:31'),
	(4271, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 18:56:31'),
	(4272, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 18:56:31'),
	(4273, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 18:56:31'),
	(4274, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 18:56:31'),
	(4275, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 18:56:31'),
	(4276, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 18:56:31'),
	(4277, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 18:56:31'),
	(4278, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 18:56:31'),
	(4279, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 18:59:52'),
	(4280, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 18:59:52'),
	(4281, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 18:59:52'),
	(4282, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 18:59:52'),
	(4283, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 18:59:52'),
	(4284, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 18:59:52'),
	(4285, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 18:59:52'),
	(4286, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 18:59:52'),
	(4287, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 18:59:52'),
	(4288, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 18:59:52'),
	(4289, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 18:59:52'),
	(4290, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 18:59:52'),
	(4291, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 18:59:52'),
	(4292, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 18:59:52'),
	(4293, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 18:59:52'),
	(4294, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 18:59:52'),
	(4295, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 18:59:52'),
	(4296, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 18:59:52'),
	(4297, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 18:59:52'),
	(4298, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 18:59:52'),
	(4299, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 18:59:52'),
	(4300, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 18:59:52'),
	(4301, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 18:59:52'),
	(4302, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 19:00:33'),
	(4303, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 19:00:33'),
	(4304, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 19:00:33'),
	(4305, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 19:00:33'),
	(4306, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 19:00:33'),
	(4307, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 19:00:33'),
	(4308, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 19:00:33'),
	(4309, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 19:00:33'),
	(4310, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 19:00:33'),
	(4311, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 19:00:33'),
	(4312, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 19:00:33'),
	(4313, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 19:00:33'),
	(4314, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 19:00:33'),
	(4315, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 19:00:33'),
	(4316, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 19:00:33'),
	(4317, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 19:00:33'),
	(4318, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 19:00:33'),
	(4319, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 19:00:33'),
	(4320, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 19:00:33'),
	(4321, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 19:00:33'),
	(4322, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 19:00:33'),
	(4323, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 19:00:33'),
	(4324, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 19:00:33'),
	(4325, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 19:00:56'),
	(4326, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 19:00:56'),
	(4327, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 19:00:56'),
	(4328, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 19:00:56'),
	(4329, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 19:00:56'),
	(4330, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 19:00:56'),
	(4331, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 19:00:56'),
	(4332, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 19:00:56'),
	(4333, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 19:00:56'),
	(4334, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 19:00:56'),
	(4335, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 19:00:56'),
	(4336, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 19:00:56'),
	(4337, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 19:00:56'),
	(4338, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 19:00:56'),
	(4339, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 19:00:56'),
	(4340, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 19:00:56'),
	(4341, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 19:00:56'),
	(4342, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 19:00:56'),
	(4343, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 19:00:56'),
	(4344, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 19:00:56'),
	(4345, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 19:00:56'),
	(4346, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 19:00:56'),
	(4347, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 19:00:56'),
	(4348, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 19:08:33'),
	(4349, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 19:08:33'),
	(4350, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 19:08:33'),
	(4351, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 19:08:33'),
	(4352, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 19:08:33'),
	(4353, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 19:08:33'),
	(4354, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 19:08:33'),
	(4355, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 19:08:33'),
	(4356, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 19:08:33'),
	(4357, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 19:08:33'),
	(4358, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 19:08:33'),
	(4359, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 19:08:33'),
	(4360, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 19:08:33'),
	(4361, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 19:08:33'),
	(4362, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 19:08:33'),
	(4363, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 19:08:33'),
	(4364, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 19:08:33'),
	(4365, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 19:08:33'),
	(4366, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 19:08:33'),
	(4367, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 19:08:33'),
	(4368, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 19:08:33'),
	(4369, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 19:08:33'),
	(4370, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 19:08:33'),
	(4371, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 19:14:12'),
	(4372, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 19:14:12'),
	(4373, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 19:14:12'),
	(4374, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 19:14:12'),
	(4375, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 19:14:12'),
	(4376, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 19:14:12'),
	(4377, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 19:14:12'),
	(4378, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 19:14:12'),
	(4379, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 19:14:12'),
	(4380, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 19:14:12'),
	(4381, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 19:14:12'),
	(4382, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 19:14:12'),
	(4383, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 19:14:12'),
	(4384, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 19:14:12'),
	(4385, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 19:14:12'),
	(4386, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 19:14:12'),
	(4387, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 19:14:12'),
	(4388, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 19:14:12'),
	(4389, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 19:14:12'),
	(4390, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 19:14:12'),
	(4391, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 19:14:12'),
	(4392, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 19:14:12'),
	(4393, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 19:14:12'),
	(4394, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 19:14:40'),
	(4395, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 19:14:40'),
	(4396, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 19:14:40'),
	(4397, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 19:14:40'),
	(4398, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 19:14:40'),
	(4399, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 19:14:40'),
	(4400, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 19:14:40'),
	(4401, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 19:14:40'),
	(4402, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 19:14:40'),
	(4403, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 19:14:40'),
	(4404, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 19:14:40'),
	(4405, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 19:14:40'),
	(4406, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 19:14:40'),
	(4407, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 19:14:40'),
	(4408, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 19:14:40'),
	(4409, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 19:14:40'),
	(4410, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 19:14:40'),
	(4411, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 19:14:40'),
	(4412, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 19:14:40'),
	(4413, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 19:14:40'),
	(4414, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 19:14:40'),
	(4415, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 19:14:40'),
	(4416, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 19:14:40'),
	(4417, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 19:17:21'),
	(4418, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 19:17:21'),
	(4419, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 19:17:21'),
	(4420, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 19:17:21'),
	(4421, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 19:17:21'),
	(4422, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 19:17:21'),
	(4423, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 19:17:21'),
	(4424, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 19:17:21'),
	(4425, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 19:17:21'),
	(4426, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 19:17:21'),
	(4427, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 19:17:21'),
	(4428, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 19:17:21'),
	(4429, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 19:17:21'),
	(4430, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 19:17:21'),
	(4431, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 19:17:21'),
	(4432, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 19:17:21'),
	(4433, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 19:17:21'),
	(4434, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 19:17:21'),
	(4435, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 19:17:21'),
	(4436, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 19:17:21'),
	(4437, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 19:17:21'),
	(4438, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 19:17:21'),
	(4439, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 19:17:21'),
	(4440, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 19:21:45'),
	(4441, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 19:21:45'),
	(4442, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 19:21:45'),
	(4443, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 19:21:45'),
	(4444, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 19:21:45'),
	(4445, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 19:21:45'),
	(4446, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 19:21:45'),
	(4447, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 19:21:45'),
	(4448, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 19:21:45'),
	(4449, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 19:21:45'),
	(4450, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 19:21:45'),
	(4451, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 19:21:45'),
	(4452, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 19:21:45'),
	(4453, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 19:21:45'),
	(4454, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 19:21:45'),
	(4455, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 19:21:45'),
	(4456, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 19:21:45'),
	(4457, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 19:21:45'),
	(4458, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 19:21:45'),
	(4459, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 19:21:45'),
	(4460, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 19:21:45'),
	(4461, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 19:21:45'),
	(4462, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 19:21:45'),
	(4463, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 19:26:33'),
	(4464, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 19:26:33'),
	(4465, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 19:26:33'),
	(4466, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 19:26:33'),
	(4467, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 19:26:33'),
	(4468, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 19:26:33'),
	(4469, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 19:26:33'),
	(4470, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 19:26:33'),
	(4471, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 19:26:33'),
	(4472, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 19:26:33'),
	(4473, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 19:26:33'),
	(4474, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 19:26:33'),
	(4475, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 19:26:33'),
	(4476, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 19:26:33'),
	(4477, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 19:26:33'),
	(4478, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 19:26:33'),
	(4479, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 19:26:33'),
	(4480, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 19:26:33'),
	(4481, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 19:26:33'),
	(4482, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 19:26:33'),
	(4483, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 19:26:33'),
	(4484, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 19:26:33'),
	(4485, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 19:26:33'),
	(4486, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 19:30:40'),
	(4487, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 19:30:40'),
	(4488, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 19:30:40'),
	(4489, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 19:30:40'),
	(4490, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 19:30:40'),
	(4491, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 19:30:40'),
	(4492, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 19:30:40'),
	(4493, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 19:30:40'),
	(4494, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 19:30:40'),
	(4495, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 19:30:40'),
	(4496, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 19:30:40'),
	(4497, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 19:30:40'),
	(4498, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 19:30:40'),
	(4499, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 19:30:40'),
	(4500, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 19:30:40'),
	(4501, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 19:30:40'),
	(4502, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 19:30:40'),
	(4503, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 19:30:40'),
	(4504, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 19:30:40'),
	(4505, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 19:30:40'),
	(4506, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 19:30:40'),
	(4507, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 19:30:40'),
	(4508, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 19:30:40'),
	(4509, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 19:32:27'),
	(4510, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 19:32:27'),
	(4511, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 19:32:27'),
	(4512, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 19:32:27'),
	(4513, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 19:32:27'),
	(4514, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 19:32:27'),
	(4515, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 19:32:27'),
	(4516, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 19:32:27'),
	(4517, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 19:32:27'),
	(4518, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 19:32:27'),
	(4519, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 19:32:27'),
	(4520, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 19:32:27'),
	(4521, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 19:32:27'),
	(4522, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 19:32:27'),
	(4523, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 19:32:27'),
	(4524, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 19:32:27'),
	(4525, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 19:32:27'),
	(4526, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 19:32:27'),
	(4527, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 19:32:27'),
	(4528, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 19:32:27'),
	(4529, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 19:32:27'),
	(4530, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 19:32:27'),
	(4531, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 19:32:27'),
	(4532, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 19:39:19'),
	(4533, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 19:39:19'),
	(4534, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 19:39:19'),
	(4535, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 19:39:19'),
	(4536, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 19:39:19'),
	(4537, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 19:39:19'),
	(4538, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 19:39:19'),
	(4539, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 19:39:19'),
	(4540, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 19:39:19'),
	(4541, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 19:39:19'),
	(4542, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 19:39:19'),
	(4543, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 19:39:19'),
	(4544, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 19:39:19'),
	(4545, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 19:39:19'),
	(4546, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 19:39:19'),
	(4547, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 19:39:19'),
	(4548, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 19:39:19'),
	(4549, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 19:39:19'),
	(4550, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 19:39:19'),
	(4551, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 19:39:19'),
	(4552, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 19:39:19'),
	(4553, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 19:39:19'),
	(4554, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 19:39:19'),
	(4555, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 19:40:15'),
	(4556, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 19:40:15'),
	(4557, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 19:40:15'),
	(4558, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 19:40:15'),
	(4559, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 19:40:15'),
	(4560, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 19:40:15'),
	(4561, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 19:40:15'),
	(4562, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 19:40:15'),
	(4563, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 19:40:15'),
	(4564, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 19:40:15'),
	(4565, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 19:40:15'),
	(4566, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 19:40:15'),
	(4567, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 19:40:15'),
	(4568, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 19:40:15'),
	(4569, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 19:40:15'),
	(4570, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 19:40:15'),
	(4571, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 19:40:15'),
	(4572, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 19:40:15'),
	(4573, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 19:40:15'),
	(4574, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 19:40:15'),
	(4575, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 19:40:15'),
	(4576, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 19:40:15'),
	(4577, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 19:40:15'),
	(4578, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 21:49:39'),
	(4579, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 21:49:39'),
	(4580, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 21:49:39'),
	(4581, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 21:49:39'),
	(4582, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 21:49:39'),
	(4583, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 21:49:39'),
	(4584, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 21:49:39'),
	(4585, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 21:49:39'),
	(4586, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 21:49:39'),
	(4587, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 21:49:39'),
	(4588, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 21:49:39'),
	(4589, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 21:49:39'),
	(4590, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 21:49:39'),
	(4591, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 21:49:39'),
	(4592, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 21:49:39'),
	(4593, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 21:49:39'),
	(4594, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 21:49:39'),
	(4595, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 21:49:39'),
	(4596, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 21:49:39'),
	(4597, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 21:49:39'),
	(4598, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 21:49:39'),
	(4599, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 21:49:39'),
	(4600, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 21:49:39'),
	(4601, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:00:16'),
	(4602, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:00:16'),
	(4603, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:00:16'),
	(4604, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:00:16'),
	(4605, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:00:16'),
	(4606, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:00:16'),
	(4607, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:00:16'),
	(4608, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:00:16'),
	(4609, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:00:16'),
	(4610, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:00:16'),
	(4611, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:00:16'),
	(4612, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:00:16'),
	(4613, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:00:16'),
	(4614, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:00:16'),
	(4615, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:00:16'),
	(4616, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:00:16'),
	(4617, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:00:16'),
	(4618, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:00:16'),
	(4619, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:00:16'),
	(4620, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:00:16'),
	(4621, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:00:16'),
	(4622, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:00:16'),
	(4623, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:00:16'),
	(4624, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:01:58'),
	(4625, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:01:58'),
	(4626, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:01:58'),
	(4627, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:01:58'),
	(4628, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:01:58'),
	(4629, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:01:58'),
	(4630, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:01:58'),
	(4631, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:01:58'),
	(4632, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:01:58'),
	(4633, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:01:58'),
	(4634, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:01:58'),
	(4635, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:01:58'),
	(4636, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:01:58'),
	(4637, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:01:58'),
	(4638, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:01:58'),
	(4639, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:01:58'),
	(4640, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:01:58'),
	(4641, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:01:58'),
	(4642, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:01:58'),
	(4643, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:01:58'),
	(4644, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:01:58'),
	(4645, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:01:58'),
	(4646, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:01:58'),
	(4647, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:10:50'),
	(4648, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:10:50'),
	(4649, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:10:50'),
	(4650, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:10:50'),
	(4651, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:10:50'),
	(4652, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:10:50'),
	(4653, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:10:50'),
	(4654, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:10:50'),
	(4655, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:10:50'),
	(4656, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:10:50'),
	(4657, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:10:50'),
	(4658, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:10:50'),
	(4659, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:10:50'),
	(4660, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:10:50'),
	(4661, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:10:50'),
	(4662, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:10:50'),
	(4663, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:10:50'),
	(4664, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:10:50'),
	(4665, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:10:51'),
	(4666, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:10:51'),
	(4667, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:10:51'),
	(4668, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:10:51'),
	(4669, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:10:51'),
	(4670, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:17:31'),
	(4671, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:17:31'),
	(4672, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:17:31'),
	(4673, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:17:31'),
	(4674, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:17:31'),
	(4675, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:17:31'),
	(4676, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:17:31'),
	(4677, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:17:31'),
	(4678, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:17:31'),
	(4679, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:17:31'),
	(4680, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:17:31'),
	(4681, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:17:31'),
	(4682, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:17:31'),
	(4683, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:17:31'),
	(4684, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:17:31'),
	(4685, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:17:31'),
	(4686, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:17:31'),
	(4687, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:17:31'),
	(4688, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:17:31'),
	(4689, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:17:31'),
	(4690, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:17:31'),
	(4691, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:17:31'),
	(4692, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:17:31'),
	(4693, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:22:43'),
	(4694, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:22:43'),
	(4695, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:22:43'),
	(4696, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:22:43'),
	(4697, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:22:43'),
	(4698, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:22:43'),
	(4699, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:22:43'),
	(4700, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:22:43'),
	(4701, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:22:43'),
	(4702, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:22:43'),
	(4703, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:22:43'),
	(4704, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:22:43'),
	(4705, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:22:43'),
	(4706, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:22:43'),
	(4707, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:22:43'),
	(4708, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:22:43'),
	(4709, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:22:43'),
	(4710, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:22:43'),
	(4711, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:22:43'),
	(4712, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:22:43'),
	(4713, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:22:43'),
	(4714, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:22:43'),
	(4715, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:22:43'),
	(4716, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:29:07'),
	(4717, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:29:07'),
	(4718, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:29:07'),
	(4719, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:29:07'),
	(4720, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:29:07'),
	(4721, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:29:07'),
	(4722, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:29:07'),
	(4723, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:29:07'),
	(4724, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:29:07'),
	(4725, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:29:07'),
	(4726, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:29:07'),
	(4727, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:29:07'),
	(4728, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:29:07'),
	(4729, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:29:07'),
	(4730, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:29:07'),
	(4731, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:29:07'),
	(4732, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:29:07'),
	(4733, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:29:07'),
	(4734, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:29:07'),
	(4735, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:29:07'),
	(4736, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:29:07'),
	(4737, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:29:07'),
	(4738, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:29:07'),
	(4739, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:33:14'),
	(4740, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:33:14'),
	(4741, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:33:14'),
	(4742, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:33:14'),
	(4743, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:33:14'),
	(4744, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:33:14'),
	(4745, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:33:14'),
	(4746, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:33:14'),
	(4747, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:33:14'),
	(4748, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:33:14'),
	(4749, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:33:14'),
	(4750, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:33:14'),
	(4751, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:33:14'),
	(4752, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:33:14'),
	(4753, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:33:14'),
	(4754, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:33:14'),
	(4755, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:33:14'),
	(4756, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:33:14'),
	(4757, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:33:14'),
	(4758, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:33:14'),
	(4759, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:33:14'),
	(4760, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:33:14'),
	(4761, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:33:14'),
	(4762, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:35:34'),
	(4763, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:35:34'),
	(4764, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:35:34'),
	(4765, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:35:34'),
	(4766, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:35:34'),
	(4767, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:35:34'),
	(4768, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:35:34'),
	(4769, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:35:34'),
	(4770, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:35:34'),
	(4771, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:35:34'),
	(4772, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:35:34'),
	(4773, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:35:34'),
	(4774, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:35:34'),
	(4775, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:35:34'),
	(4776, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:35:34'),
	(4777, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:35:34'),
	(4778, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:35:34'),
	(4779, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:35:34'),
	(4780, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:35:34'),
	(4781, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:35:34'),
	(4782, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:35:34'),
	(4783, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:35:34'),
	(4784, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:35:34'),
	(4785, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:36:12'),
	(4786, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:36:12'),
	(4787, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:36:12'),
	(4788, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:36:12'),
	(4789, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:36:12'),
	(4790, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:36:12'),
	(4791, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:36:12'),
	(4792, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:36:12'),
	(4793, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:36:12'),
	(4794, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:36:12'),
	(4795, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:36:12'),
	(4796, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:36:12'),
	(4797, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:36:12'),
	(4798, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:36:12'),
	(4799, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:36:12'),
	(4800, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:36:12'),
	(4801, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:36:12'),
	(4802, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:36:12'),
	(4803, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:36:12'),
	(4804, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:36:12'),
	(4805, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:36:12'),
	(4806, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:36:12'),
	(4807, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:36:12'),
	(4808, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:40:52'),
	(4809, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:40:52'),
	(4810, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:40:52'),
	(4811, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:40:52'),
	(4812, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:40:52'),
	(4813, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:40:52'),
	(4814, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:40:52'),
	(4815, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:40:52'),
	(4816, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:40:52'),
	(4817, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:40:52'),
	(4818, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:40:52'),
	(4819, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:40:52'),
	(4820, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:40:52'),
	(4821, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:40:52'),
	(4822, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:40:52'),
	(4823, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:40:52'),
	(4824, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:40:52'),
	(4825, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:40:52'),
	(4826, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:40:52'),
	(4827, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:40:52'),
	(4828, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:40:52'),
	(4829, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:40:52'),
	(4830, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:40:52'),
	(4831, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:44:02'),
	(4832, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:44:02'),
	(4833, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:44:02'),
	(4834, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:44:02'),
	(4835, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:44:02'),
	(4836, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:44:02'),
	(4837, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:44:02'),
	(4838, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:44:02'),
	(4839, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:44:02'),
	(4840, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:44:02'),
	(4841, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:44:02'),
	(4842, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:44:02'),
	(4843, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:44:02'),
	(4844, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:44:02'),
	(4845, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:44:02'),
	(4846, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:44:02'),
	(4847, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:44:02'),
	(4848, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:44:02'),
	(4849, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:44:02'),
	(4850, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:44:02'),
	(4851, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:44:02'),
	(4852, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:44:02'),
	(4853, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:44:02'),
	(4854, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:44:50'),
	(4855, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:44:50'),
	(4856, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:44:50'),
	(4857, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:44:50'),
	(4858, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:44:50'),
	(4859, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:44:50'),
	(4860, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:44:50'),
	(4861, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:44:50'),
	(4862, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:44:50'),
	(4863, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:44:50'),
	(4864, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:44:50'),
	(4865, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:44:50'),
	(4866, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:44:50'),
	(4867, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:44:50'),
	(4868, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:44:50'),
	(4869, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:44:50'),
	(4870, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:44:50'),
	(4871, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:44:50'),
	(4872, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:44:50'),
	(4873, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:44:50'),
	(4874, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:44:50'),
	(4875, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:44:50'),
	(4876, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:44:50'),
	(4877, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:47:20'),
	(4878, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:47:20'),
	(4879, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:47:20'),
	(4880, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:47:20'),
	(4881, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:47:20'),
	(4882, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:47:20'),
	(4883, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:47:20'),
	(4884, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:47:20'),
	(4885, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:47:20'),
	(4886, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:47:20'),
	(4887, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:47:20'),
	(4888, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:47:20'),
	(4889, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:47:20'),
	(4890, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:47:20'),
	(4891, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:47:20'),
	(4892, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:47:20'),
	(4893, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:47:20'),
	(4894, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:47:20'),
	(4895, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:47:20'),
	(4896, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:47:20'),
	(4897, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:47:20'),
	(4898, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:47:20'),
	(4899, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:47:20'),
	(4900, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 22:53:13'),
	(4901, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 22:53:13'),
	(4902, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 22:53:13'),
	(4903, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 22:53:13'),
	(4904, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 22:53:13'),
	(4905, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 22:53:13'),
	(4906, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 22:53:13'),
	(4907, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 22:53:13'),
	(4908, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 22:53:13'),
	(4909, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 22:53:13'),
	(4910, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 22:53:13'),
	(4911, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 22:53:13'),
	(4912, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 22:53:13'),
	(4913, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 22:53:13'),
	(4914, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 22:53:13'),
	(4915, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 22:53:13'),
	(4916, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 22:53:13'),
	(4917, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 22:53:13'),
	(4918, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 22:53:13'),
	(4919, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 22:53:13'),
	(4920, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 22:53:13'),
	(4921, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 22:53:13'),
	(4922, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 22:53:13'),
	(4923, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 23:05:04'),
	(4924, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 23:05:04'),
	(4925, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 23:05:04'),
	(4926, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 23:05:04'),
	(4927, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 23:05:04'),
	(4928, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 23:05:04'),
	(4929, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 23:05:04'),
	(4930, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 23:05:04'),
	(4931, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 23:05:04'),
	(4932, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 23:05:04'),
	(4933, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 23:05:04'),
	(4934, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 23:05:04'),
	(4935, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 23:05:04'),
	(4936, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 23:05:04'),
	(4937, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 23:05:04'),
	(4938, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 23:05:04'),
	(4939, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 23:05:04'),
	(4940, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 23:05:04'),
	(4941, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 23:05:04'),
	(4942, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 23:05:04'),
	(4943, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 23:05:04'),
	(4944, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 23:05:04'),
	(4945, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 23:05:04'),
	(4946, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 23:15:42'),
	(4947, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 23:15:42'),
	(4948, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 23:15:42'),
	(4949, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 23:15:42'),
	(4950, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 23:15:42'),
	(4951, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 23:15:42'),
	(4952, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 23:15:42'),
	(4953, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 23:15:42'),
	(4954, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 23:15:42'),
	(4955, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 23:15:42'),
	(4956, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 23:15:42'),
	(4957, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 23:15:42'),
	(4958, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 23:15:42'),
	(4959, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 23:15:42'),
	(4960, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 23:15:42'),
	(4961, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 23:15:42'),
	(4962, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 23:15:42'),
	(4963, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 23:15:42'),
	(4964, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 23:15:42'),
	(4965, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 23:15:42'),
	(4966, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 23:15:42'),
	(4967, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 23:15:42'),
	(4968, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 23:15:42'),
	(4969, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 23:21:42'),
	(4970, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 23:21:42'),
	(4971, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 23:21:42'),
	(4972, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 23:21:42'),
	(4973, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 23:21:42'),
	(4974, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 23:21:42'),
	(4975, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 23:21:42'),
	(4976, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 23:21:42'),
	(4977, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 23:21:42'),
	(4978, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 23:21:42'),
	(4979, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 23:21:42'),
	(4980, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 23:21:42'),
	(4981, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 23:21:42'),
	(4982, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 23:21:42'),
	(4983, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 23:21:42'),
	(4984, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 23:21:42'),
	(4985, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 23:21:42'),
	(4986, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 23:21:42'),
	(4987, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 23:21:42'),
	(4988, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 23:21:42'),
	(4989, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 23:21:42'),
	(4990, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 23:21:42'),
	(4991, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 23:21:42'),
	(4992, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 23:25:48'),
	(4993, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 23:25:48'),
	(4994, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 23:25:48'),
	(4995, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 23:25:48'),
	(4996, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 23:25:48'),
	(4997, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 23:25:48'),
	(4998, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 23:25:48'),
	(4999, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 23:25:48'),
	(5000, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 23:25:48'),
	(5001, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 23:25:48'),
	(5002, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 23:25:48'),
	(5003, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 23:25:48'),
	(5004, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 23:25:48'),
	(5005, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 23:25:48'),
	(5006, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 23:25:48'),
	(5007, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 23:25:48'),
	(5008, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 23:25:48'),
	(5009, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 23:25:48'),
	(5010, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 23:25:48'),
	(5011, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 23:25:48'),
	(5012, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 23:25:48'),
	(5013, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 23:25:48'),
	(5014, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 23:25:48'),
	(5015, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 23:29:04'),
	(5016, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 23:29:04'),
	(5017, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 23:29:04'),
	(5018, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 23:29:04'),
	(5019, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 23:29:04'),
	(5020, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 23:29:04'),
	(5021, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 23:29:04'),
	(5022, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 23:29:04'),
	(5023, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 23:29:04'),
	(5024, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 23:29:04'),
	(5025, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 23:29:04'),
	(5026, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 23:29:04'),
	(5027, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 23:29:04'),
	(5028, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 23:29:04'),
	(5029, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 23:29:04'),
	(5030, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 23:29:04'),
	(5031, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 23:29:04'),
	(5032, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 23:29:04'),
	(5033, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 23:29:04'),
	(5034, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 23:29:04'),
	(5035, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 23:29:04'),
	(5036, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 23:29:04'),
	(5037, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 23:29:04'),
	(5038, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 23:32:50'),
	(5039, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 23:32:50'),
	(5040, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 23:32:50'),
	(5041, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 23:32:50'),
	(5042, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 23:32:50'),
	(5043, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 23:32:50'),
	(5044, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 23:32:50'),
	(5045, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 23:32:50'),
	(5046, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 23:32:50'),
	(5047, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 23:32:50'),
	(5048, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 23:32:50'),
	(5049, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 23:32:50'),
	(5050, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 23:32:50'),
	(5051, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 23:32:50'),
	(5052, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 23:32:50'),
	(5053, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 23:32:50'),
	(5054, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 23:32:50'),
	(5055, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 23:32:50'),
	(5056, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 23:32:50'),
	(5057, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 23:32:50'),
	(5058, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 23:32:50'),
	(5059, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 23:32:50'),
	(5060, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 23:32:50'),
	(5061, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 23:36:30'),
	(5062, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 23:36:30'),
	(5063, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 23:36:30'),
	(5064, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 23:36:30'),
	(5065, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 23:36:30'),
	(5066, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 23:36:30'),
	(5067, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 23:36:30'),
	(5068, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 23:36:30'),
	(5069, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 23:36:30'),
	(5070, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 23:36:30'),
	(5071, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 23:36:30'),
	(5072, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 23:36:30'),
	(5073, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 23:36:30'),
	(5074, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 23:36:30'),
	(5075, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 23:36:30'),
	(5076, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 23:36:30'),
	(5077, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 23:36:30'),
	(5078, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 23:36:30'),
	(5079, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 23:36:30'),
	(5080, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 23:36:30'),
	(5081, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 23:36:30'),
	(5082, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 23:36:30'),
	(5083, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 23:36:30'),
	(5084, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 23:41:37'),
	(5085, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 23:41:37'),
	(5086, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 23:41:37'),
	(5087, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 23:41:37'),
	(5088, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 23:41:37'),
	(5089, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 23:41:37'),
	(5090, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 23:41:37'),
	(5091, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 23:41:37'),
	(5092, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 23:41:37'),
	(5093, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 23:41:37'),
	(5094, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 23:41:37'),
	(5095, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 23:41:37'),
	(5096, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 23:41:37'),
	(5097, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 23:41:37'),
	(5098, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 23:41:37'),
	(5099, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 23:41:37'),
	(5100, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 23:41:37'),
	(5101, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 23:41:37'),
	(5102, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 23:41:37'),
	(5103, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 23:41:37'),
	(5104, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 23:41:37'),
	(5105, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 23:41:37'),
	(5106, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 23:41:37'),
	(5107, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-09 23:59:37'),
	(5108, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-09 23:59:37'),
	(5109, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-09 23:59:37'),
	(5110, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-09 23:59:37'),
	(5111, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-09 23:59:37'),
	(5112, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-09 23:59:37'),
	(5113, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-09 23:59:37'),
	(5114, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-09 23:59:37'),
	(5115, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-09 23:59:37'),
	(5116, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-09 23:59:37'),
	(5117, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-09 23:59:37'),
	(5118, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-09 23:59:37'),
	(5119, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-09 23:59:37'),
	(5120, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-09 23:59:37'),
	(5121, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-09 23:59:37'),
	(5122, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-09 23:59:37'),
	(5123, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-09 23:59:37'),
	(5124, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-09 23:59:37'),
	(5125, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-09 23:59:37'),
	(5126, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-09 23:59:37'),
	(5127, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-09 23:59:37'),
	(5128, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-09 23:59:37'),
	(5129, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-09 23:59:37'),
	(5130, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:00:06'),
	(5131, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:00:06'),
	(5132, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:00:06'),
	(5133, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:00:06'),
	(5134, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:00:06'),
	(5135, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:00:06'),
	(5136, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:00:06'),
	(5137, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:00:06'),
	(5138, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:00:06'),
	(5139, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:00:06'),
	(5140, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:00:06'),
	(5141, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:00:06'),
	(5142, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:00:06'),
	(5143, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:00:06'),
	(5144, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:00:06'),
	(5145, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:00:06'),
	(5146, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:00:06'),
	(5147, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:00:06'),
	(5148, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:00:06'),
	(5149, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:00:06'),
	(5150, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:00:06'),
	(5151, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:00:06'),
	(5152, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:00:06'),
	(5153, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:01:37'),
	(5154, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:01:37'),
	(5155, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:01:37'),
	(5156, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:01:37'),
	(5157, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:01:37'),
	(5158, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:01:37'),
	(5159, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:01:37'),
	(5160, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:01:37'),
	(5161, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:01:37'),
	(5162, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:01:37'),
	(5163, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:01:37'),
	(5164, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:01:37'),
	(5165, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:01:37'),
	(5166, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:01:37'),
	(5167, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:01:37'),
	(5168, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:01:37'),
	(5169, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:01:37'),
	(5170, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:01:37'),
	(5171, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:01:37'),
	(5172, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:01:37'),
	(5173, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:01:37'),
	(5174, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:01:37'),
	(5175, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:01:37'),
	(5176, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:04:34'),
	(5177, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:04:34'),
	(5178, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:04:34'),
	(5179, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:04:34'),
	(5180, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:04:34'),
	(5181, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:04:34'),
	(5182, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:04:34'),
	(5183, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:04:34'),
	(5184, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:04:34'),
	(5185, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:04:34'),
	(5186, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:04:34'),
	(5187, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:04:34'),
	(5188, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:04:34'),
	(5189, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:04:34'),
	(5190, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:04:34'),
	(5191, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:04:34'),
	(5192, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:04:34'),
	(5193, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:04:34'),
	(5194, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:04:34'),
	(5195, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:04:34'),
	(5196, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:04:34'),
	(5197, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:04:34'),
	(5198, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:04:34'),
	(5199, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:07:28'),
	(5200, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:07:28'),
	(5201, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:07:28'),
	(5202, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:07:28'),
	(5203, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:07:28'),
	(5204, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:07:28'),
	(5205, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:07:28'),
	(5206, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:07:28'),
	(5207, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:07:28'),
	(5208, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:07:28'),
	(5209, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:07:28'),
	(5210, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:07:28'),
	(5211, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:07:28'),
	(5212, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:07:28'),
	(5213, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:07:28'),
	(5214, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:07:28'),
	(5215, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:07:28'),
	(5216, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:07:28'),
	(5217, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:07:28'),
	(5218, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:07:28'),
	(5219, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:07:28'),
	(5220, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:07:28'),
	(5221, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:07:28'),
	(5222, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:10:46'),
	(5223, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:10:46'),
	(5224, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:10:46'),
	(5225, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:10:46'),
	(5226, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:10:46'),
	(5227, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:10:46'),
	(5228, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:10:46'),
	(5229, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:10:46'),
	(5230, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:10:46'),
	(5231, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:10:46'),
	(5232, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:10:46'),
	(5233, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:10:46'),
	(5234, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:10:46'),
	(5235, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:10:46'),
	(5236, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:10:46'),
	(5237, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:10:46'),
	(5238, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:10:46'),
	(5239, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:10:46'),
	(5240, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:10:46'),
	(5241, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:10:46'),
	(5242, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:10:46'),
	(5243, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:10:46'),
	(5244, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:10:46'),
	(5245, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:13:59'),
	(5246, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:13:59'),
	(5247, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:13:59'),
	(5248, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:13:59'),
	(5249, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:13:59'),
	(5250, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:13:59'),
	(5251, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:13:59'),
	(5252, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:13:59'),
	(5253, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:13:59'),
	(5254, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:13:59'),
	(5255, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:13:59'),
	(5256, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:13:59'),
	(5257, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:13:59'),
	(5258, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:13:59'),
	(5259, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:13:59'),
	(5260, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:13:59'),
	(5261, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:13:59'),
	(5262, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:13:59'),
	(5263, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:13:59'),
	(5264, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:13:59'),
	(5265, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:13:59'),
	(5266, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:13:59'),
	(5267, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:13:59'),
	(5268, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:16:48'),
	(5269, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:16:48'),
	(5270, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:16:48'),
	(5271, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:16:48'),
	(5272, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:16:48'),
	(5273, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:16:48'),
	(5274, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:16:48'),
	(5275, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:16:48'),
	(5276, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:16:48'),
	(5277, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:16:48'),
	(5278, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:16:48'),
	(5279, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:16:48'),
	(5280, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:16:48'),
	(5281, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:16:48'),
	(5282, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:16:48'),
	(5283, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:16:48'),
	(5284, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:16:48'),
	(5285, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:16:48'),
	(5286, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:16:48'),
	(5287, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:16:48'),
	(5288, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:16:48'),
	(5289, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:16:48'),
	(5290, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:16:48'),
	(5291, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:19:03'),
	(5292, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:19:03'),
	(5293, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:19:03'),
	(5294, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:19:03'),
	(5295, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:19:03'),
	(5296, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:19:03'),
	(5297, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:19:03'),
	(5298, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:19:03'),
	(5299, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:19:03'),
	(5300, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:19:03'),
	(5301, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:19:03'),
	(5302, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:19:03'),
	(5303, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:19:03'),
	(5304, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:19:03'),
	(5305, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:19:03'),
	(5306, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:19:03'),
	(5307, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:19:03'),
	(5308, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:19:03'),
	(5309, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:19:03'),
	(5310, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:19:03'),
	(5311, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:19:03'),
	(5312, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:19:03'),
	(5313, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:19:03'),
	(5314, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:24:45'),
	(5315, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:24:45'),
	(5316, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:24:45'),
	(5317, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:24:45'),
	(5318, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:24:45'),
	(5319, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:24:45'),
	(5320, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:24:45'),
	(5321, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:24:45'),
	(5322, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:24:45'),
	(5323, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:24:45'),
	(5324, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:24:45'),
	(5325, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:24:45'),
	(5326, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:24:45'),
	(5327, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:24:45'),
	(5328, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:24:45'),
	(5329, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:24:45'),
	(5330, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:24:45'),
	(5331, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:24:45'),
	(5332, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:24:45'),
	(5333, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:24:45'),
	(5334, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:24:45'),
	(5335, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:24:45'),
	(5336, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:24:45'),
	(5337, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:26:48'),
	(5338, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:26:48'),
	(5339, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:26:48'),
	(5340, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:26:48'),
	(5341, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:26:48'),
	(5342, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:26:48'),
	(5343, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:26:48'),
	(5344, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:26:48'),
	(5345, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:26:48'),
	(5346, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:26:48'),
	(5347, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:26:48'),
	(5348, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:26:48'),
	(5349, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:26:48'),
	(5350, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:26:48'),
	(5351, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:26:48'),
	(5352, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:26:48'),
	(5353, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:26:48'),
	(5354, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:26:48'),
	(5355, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:26:48'),
	(5356, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:26:48'),
	(5357, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:26:48'),
	(5358, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:26:48'),
	(5359, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:26:48'),
	(5360, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:28:12'),
	(5361, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:28:12'),
	(5362, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:28:12'),
	(5363, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:28:12'),
	(5364, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:28:12'),
	(5365, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:28:12'),
	(5366, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:28:12'),
	(5367, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:28:12'),
	(5368, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:28:12'),
	(5369, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:28:12'),
	(5370, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:28:12'),
	(5371, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:28:12'),
	(5372, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:28:12'),
	(5373, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:28:12'),
	(5374, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:28:12'),
	(5375, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:28:12'),
	(5376, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:28:12'),
	(5377, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:28:12'),
	(5378, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:28:12'),
	(5379, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:28:12'),
	(5380, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:28:12'),
	(5381, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:28:12'),
	(5382, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:28:12'),
	(5383, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:29:57'),
	(5384, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:29:57'),
	(5385, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:29:57'),
	(5386, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:29:57'),
	(5387, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:29:57'),
	(5388, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:29:57'),
	(5389, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:29:57'),
	(5390, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:29:57'),
	(5391, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:29:57'),
	(5392, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:29:57'),
	(5393, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:29:57'),
	(5394, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:29:57'),
	(5395, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:29:57'),
	(5396, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:29:57'),
	(5397, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:29:57'),
	(5398, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:29:57'),
	(5399, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:29:57'),
	(5400, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:29:57'),
	(5401, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:29:57'),
	(5402, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:29:57'),
	(5403, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:29:57'),
	(5404, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:29:57'),
	(5405, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:29:57'),
	(5406, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:31:19'),
	(5407, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:31:19'),
	(5408, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:31:19'),
	(5409, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:31:19'),
	(5410, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:31:19'),
	(5411, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:31:19'),
	(5412, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:31:19'),
	(5413, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:31:19'),
	(5414, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:31:19'),
	(5415, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:31:19'),
	(5416, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:31:19'),
	(5417, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:31:19'),
	(5418, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:31:19'),
	(5419, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:31:19'),
	(5420, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:31:19'),
	(5421, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:31:19'),
	(5422, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:31:19'),
	(5423, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:31:19'),
	(5424, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:31:19'),
	(5425, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:31:19'),
	(5426, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:31:19'),
	(5427, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:31:19'),
	(5428, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:31:19'),
	(5429, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:37:45'),
	(5430, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:37:45'),
	(5431, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:37:45'),
	(5432, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:37:45'),
	(5433, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:37:45'),
	(5434, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:37:45'),
	(5435, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:37:45'),
	(5436, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:37:45'),
	(5437, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:37:45'),
	(5438, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:37:45'),
	(5439, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:37:45'),
	(5440, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:37:45'),
	(5441, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:37:45'),
	(5442, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:37:45'),
	(5443, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:37:45'),
	(5444, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:37:45'),
	(5445, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:37:45'),
	(5446, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:37:45'),
	(5447, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:37:45'),
	(5448, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:37:45'),
	(5449, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:37:45'),
	(5450, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:37:45'),
	(5451, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:37:45'),
	(5452, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:42:26'),
	(5453, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:42:26'),
	(5454, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:42:26'),
	(5455, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:42:26'),
	(5456, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:42:26'),
	(5457, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:42:26'),
	(5458, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:42:26'),
	(5459, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:42:26'),
	(5460, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:42:26'),
	(5461, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:42:26'),
	(5462, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:42:26'),
	(5463, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:42:26'),
	(5464, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:42:26'),
	(5465, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:42:26'),
	(5466, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:42:26'),
	(5467, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:42:26'),
	(5468, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:42:26'),
	(5469, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:42:26'),
	(5470, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:42:26'),
	(5471, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:42:26'),
	(5472, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:42:26'),
	(5473, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:42:26'),
	(5474, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:42:26'),
	(5475, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:45:54'),
	(5476, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:45:54'),
	(5477, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:45:54'),
	(5478, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:45:54'),
	(5479, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:45:54'),
	(5480, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:45:54'),
	(5481, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:45:54'),
	(5482, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:45:54'),
	(5483, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:45:54'),
	(5484, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:45:54'),
	(5485, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:45:54'),
	(5486, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:45:54'),
	(5487, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:45:54'),
	(5488, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:45:54'),
	(5489, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:45:54'),
	(5490, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:45:54'),
	(5491, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:45:54'),
	(5492, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:45:54'),
	(5493, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:45:54'),
	(5494, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:45:54'),
	(5495, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:45:54'),
	(5496, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:45:54'),
	(5497, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:45:54'),
	(5498, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:48:21'),
	(5499, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:48:21'),
	(5500, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:48:21'),
	(5501, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:48:21'),
	(5502, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:48:21'),
	(5503, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:48:21'),
	(5504, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:48:21'),
	(5505, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:48:21'),
	(5506, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:48:21'),
	(5507, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:48:21'),
	(5508, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:48:21'),
	(5509, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:48:21'),
	(5510, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:48:21'),
	(5511, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:48:21'),
	(5512, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:48:21'),
	(5513, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:48:21'),
	(5514, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:48:21'),
	(5515, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:48:21'),
	(5516, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:48:21'),
	(5517, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:48:21'),
	(5518, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:48:21'),
	(5519, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:48:21'),
	(5520, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:48:21'),
	(5521, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:51:49'),
	(5522, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:51:49'),
	(5523, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:51:49'),
	(5524, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:51:49'),
	(5525, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:51:49'),
	(5526, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:51:49'),
	(5527, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:51:49'),
	(5528, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:51:49'),
	(5529, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:51:49'),
	(5530, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:51:49'),
	(5531, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:51:49'),
	(5532, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:51:49'),
	(5533, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:51:49'),
	(5534, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:51:49'),
	(5535, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:51:49'),
	(5536, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:51:49'),
	(5537, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:51:49'),
	(5538, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:51:49'),
	(5539, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:51:49'),
	(5540, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:51:49'),
	(5541, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:51:49'),
	(5542, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:51:49'),
	(5543, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:51:49'),
	(5544, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:54:40'),
	(5545, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:54:40'),
	(5546, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:54:40'),
	(5547, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:54:40'),
	(5548, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:54:40'),
	(5549, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:54:40'),
	(5550, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:54:40'),
	(5551, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:54:40'),
	(5552, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:54:40'),
	(5553, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:54:40'),
	(5554, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:54:40'),
	(5555, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:54:40'),
	(5556, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:54:40'),
	(5557, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:54:40'),
	(5558, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:54:40'),
	(5559, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:54:40'),
	(5560, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:54:40'),
	(5561, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:54:40'),
	(5562, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:54:40'),
	(5563, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:54:40'),
	(5564, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:54:40'),
	(5565, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:54:40'),
	(5566, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:54:40'),
	(5567, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 00:58:49'),
	(5568, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 00:58:49'),
	(5569, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 00:58:49'),
	(5570, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 00:58:49'),
	(5571, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 00:58:49'),
	(5572, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 00:58:49'),
	(5573, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 00:58:49'),
	(5574, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 00:58:49'),
	(5575, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 00:58:49'),
	(5576, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 00:58:49'),
	(5577, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 00:58:49'),
	(5578, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 00:58:49'),
	(5579, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 00:58:49'),
	(5580, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 00:58:49'),
	(5581, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 00:58:49'),
	(5582, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 00:58:49'),
	(5583, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 00:58:49'),
	(5584, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 00:58:49'),
	(5585, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 00:58:49'),
	(5586, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 00:58:49'),
	(5587, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 00:58:49'),
	(5588, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 00:58:49'),
	(5589, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 00:58:49'),
	(5590, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 01:02:23'),
	(5591, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 01:02:23'),
	(5592, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 01:02:23'),
	(5593, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 01:02:23'),
	(5594, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 01:02:23'),
	(5595, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 01:02:23'),
	(5596, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 01:02:23'),
	(5597, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 01:02:23'),
	(5598, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 01:02:23'),
	(5599, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 01:02:23'),
	(5600, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 01:02:23'),
	(5601, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 01:02:23'),
	(5602, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 01:02:23'),
	(5603, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 01:02:23'),
	(5604, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 01:02:23'),
	(5605, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 01:02:23'),
	(5606, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 01:02:23'),
	(5607, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 01:02:23'),
	(5608, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 01:02:23'),
	(5609, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 01:02:23'),
	(5610, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 01:02:23'),
	(5611, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 01:02:23'),
	(5612, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 01:02:23'),
	(5613, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 01:05:39'),
	(5614, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 01:05:39'),
	(5615, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 01:05:39'),
	(5616, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 01:05:39'),
	(5617, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 01:05:39'),
	(5618, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 01:05:39'),
	(5619, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 01:05:39'),
	(5620, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 01:05:39'),
	(5621, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 01:05:39'),
	(5622, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 01:05:39'),
	(5623, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 01:05:39'),
	(5624, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 01:05:39'),
	(5625, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 01:05:39'),
	(5626, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 01:05:39'),
	(5627, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 01:05:39'),
	(5628, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 01:05:39'),
	(5629, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 01:05:39'),
	(5630, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 01:05:39'),
	(5631, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 01:05:39'),
	(5632, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 01:05:39'),
	(5633, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 01:05:39'),
	(5634, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 01:05:39'),
	(5635, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 01:05:39'),
	(5636, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 01:09:17'),
	(5637, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 01:09:17'),
	(5638, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 01:09:17'),
	(5639, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 01:09:17'),
	(5640, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 01:09:17'),
	(5641, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 01:09:17'),
	(5642, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 01:09:17'),
	(5643, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 01:09:17'),
	(5644, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 01:09:17'),
	(5645, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 01:09:17'),
	(5646, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 01:09:17'),
	(5647, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 01:09:17'),
	(5648, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 01:09:17'),
	(5649, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 01:09:17'),
	(5650, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 01:09:17'),
	(5651, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 01:09:17'),
	(5652, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 01:09:17'),
	(5653, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 01:09:17'),
	(5654, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 01:09:17'),
	(5655, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 01:09:17'),
	(5656, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 01:09:17'),
	(5657, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 01:09:17'),
	(5658, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 01:09:17'),
	(5659, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 01:13:34'),
	(5660, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 01:13:34'),
	(5661, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 01:13:34'),
	(5662, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 01:13:34'),
	(5663, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 01:13:34'),
	(5664, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 01:13:34'),
	(5665, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 01:13:34'),
	(5666, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 01:13:34'),
	(5667, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 01:13:34'),
	(5668, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 01:13:34'),
	(5669, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 01:13:34'),
	(5670, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 01:13:34'),
	(5671, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 01:13:34'),
	(5672, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 01:13:34'),
	(5673, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 01:13:34'),
	(5674, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 01:13:34'),
	(5675, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 01:13:34'),
	(5676, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 01:13:34'),
	(5677, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 01:13:34'),
	(5678, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 01:13:34'),
	(5679, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 01:13:34'),
	(5680, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 01:13:34'),
	(5681, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 01:13:34'),
	(5682, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 01:17:03'),
	(5683, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 01:17:03'),
	(5684, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 01:17:03'),
	(5685, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 01:17:03'),
	(5686, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 01:17:03'),
	(5687, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 01:17:03'),
	(5688, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 01:17:03'),
	(5689, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 01:17:03'),
	(5690, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 01:17:03'),
	(5691, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 01:17:03'),
	(5692, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 01:17:03'),
	(5693, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 01:17:03'),
	(5694, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 01:17:03'),
	(5695, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 01:17:03'),
	(5696, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 01:17:03'),
	(5697, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 01:17:03'),
	(5698, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 01:17:03'),
	(5699, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 01:17:03'),
	(5700, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 01:17:03'),
	(5701, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 01:17:03'),
	(5702, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 01:17:03'),
	(5703, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 01:17:03'),
	(5704, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 01:17:03'),
	(5705, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 01:19:32'),
	(5706, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 01:19:32'),
	(5707, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 01:19:32'),
	(5708, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 01:19:32'),
	(5709, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 01:19:32'),
	(5710, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 01:19:32'),
	(5711, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 01:19:32'),
	(5712, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 01:19:32'),
	(5713, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 01:19:32'),
	(5714, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 01:19:32'),
	(5715, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 01:19:32'),
	(5716, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 01:19:32'),
	(5717, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 01:19:32'),
	(5718, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 01:19:32'),
	(5719, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 01:19:32'),
	(5720, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 01:19:32'),
	(5721, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 01:19:32'),
	(5722, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 01:19:32'),
	(5723, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 01:19:32'),
	(5724, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 01:19:32'),
	(5725, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 01:19:32'),
	(5726, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 01:19:32'),
	(5727, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 01:19:32'),
	(5728, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 01:22:30'),
	(5729, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 01:22:30'),
	(5730, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 01:22:30'),
	(5731, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 01:22:30'),
	(5732, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 01:22:30'),
	(5733, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 01:22:30'),
	(5734, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 01:22:30'),
	(5735, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 01:22:30'),
	(5736, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 01:22:30'),
	(5737, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 01:22:30'),
	(5738, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 01:22:30'),
	(5739, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 01:22:30'),
	(5740, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 01:22:30'),
	(5741, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 01:22:30'),
	(5742, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 01:22:30'),
	(5743, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 01:22:30'),
	(5744, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 01:22:30'),
	(5745, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 01:22:30'),
	(5746, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 01:22:30'),
	(5747, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 01:22:30'),
	(5748, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 01:22:30'),
	(5749, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 01:22:30'),
	(5750, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 01:22:30'),
	(5751, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 01:26:10'),
	(5752, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 01:26:10'),
	(5753, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 01:26:10'),
	(5754, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 01:26:10'),
	(5755, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 01:26:10'),
	(5756, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 01:26:10'),
	(5757, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 01:26:10'),
	(5758, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 01:26:10'),
	(5759, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 01:26:10'),
	(5760, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 01:26:10'),
	(5761, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 01:26:10'),
	(5762, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 01:26:10'),
	(5763, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 01:26:10'),
	(5764, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 01:26:10'),
	(5765, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 01:26:10'),
	(5766, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 01:26:10'),
	(5767, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 01:26:10'),
	(5768, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 01:26:10'),
	(5769, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 01:26:10'),
	(5770, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 01:26:10'),
	(5771, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 01:26:10'),
	(5772, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 01:26:10'),
	(5773, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 01:26:10'),
	(5774, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 01:29:09'),
	(5775, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 01:29:09'),
	(5776, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 01:29:09'),
	(5777, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 01:29:09'),
	(5778, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 01:29:09'),
	(5779, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 01:29:09'),
	(5780, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 01:29:09'),
	(5781, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 01:29:09'),
	(5782, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 01:29:09'),
	(5783, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 01:29:09'),
	(5784, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 01:29:09'),
	(5785, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 01:29:09'),
	(5786, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 01:29:09'),
	(5787, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 01:29:09'),
	(5788, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 01:29:09'),
	(5789, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 01:29:09'),
	(5790, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 01:29:09'),
	(5791, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 01:29:09'),
	(5792, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 01:29:09'),
	(5793, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 01:29:09'),
	(5794, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 01:29:09'),
	(5795, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 01:29:09'),
	(5796, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 01:29:09'),
	(5797, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 01:32:04'),
	(5798, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 01:32:04'),
	(5799, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 01:32:04'),
	(5800, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 01:32:04'),
	(5801, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 01:32:04'),
	(5802, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 01:32:04'),
	(5803, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 01:32:04'),
	(5804, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 01:32:04'),
	(5805, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 01:32:04'),
	(5806, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 01:32:04'),
	(5807, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 01:32:04'),
	(5808, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 01:32:04'),
	(5809, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 01:32:04'),
	(5810, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 01:32:04'),
	(5811, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 01:32:04'),
	(5812, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 01:32:04'),
	(5813, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 01:32:04'),
	(5814, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 01:32:04'),
	(5815, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 01:32:04'),
	(5816, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 01:32:04'),
	(5817, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 01:32:04'),
	(5818, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 01:32:04'),
	(5819, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 01:32:04'),
	(5820, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 01:35:50'),
	(5821, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 01:35:50'),
	(5822, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 01:35:50'),
	(5823, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 01:35:50'),
	(5824, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 01:35:50'),
	(5825, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 01:35:50'),
	(5826, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 01:35:50'),
	(5827, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 01:35:50'),
	(5828, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 01:35:50'),
	(5829, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 01:35:50'),
	(5830, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 01:35:50'),
	(5831, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 01:35:50'),
	(5832, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 01:35:50'),
	(5833, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 01:35:50'),
	(5834, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 01:35:50'),
	(5835, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 01:35:50'),
	(5836, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 01:35:50'),
	(5837, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 01:35:50'),
	(5838, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 01:35:50'),
	(5839, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 01:35:50'),
	(5840, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 01:35:50'),
	(5841, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 01:35:50'),
	(5842, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 01:35:50'),
	(5843, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 01:42:50'),
	(5844, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 01:42:50'),
	(5845, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 01:42:50'),
	(5846, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 01:42:50'),
	(5847, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 01:42:50'),
	(5848, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 01:42:50'),
	(5849, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 01:42:50'),
	(5850, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 01:42:50'),
	(5851, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 01:42:50'),
	(5852, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 01:42:50'),
	(5853, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 01:42:50'),
	(5854, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 01:42:50'),
	(5855, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 01:42:50'),
	(5856, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 01:42:50'),
	(5857, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 01:42:50'),
	(5858, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 01:42:50'),
	(5859, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 01:42:50'),
	(5860, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 01:42:50'),
	(5861, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 01:42:50'),
	(5862, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 01:42:50'),
	(5863, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 01:42:50'),
	(5864, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 01:42:50'),
	(5865, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 01:42:50'),
	(5866, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 03:15:34'),
	(5867, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 03:15:34'),
	(5868, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 03:15:34'),
	(5869, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 03:15:34'),
	(5870, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 03:15:34'),
	(5871, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 03:15:34'),
	(5872, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 03:15:34'),
	(5873, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 03:15:34'),
	(5874, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 03:15:34'),
	(5875, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 03:15:34'),
	(5876, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 03:15:34'),
	(5877, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 03:15:34'),
	(5878, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 03:15:34'),
	(5879, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 03:15:34'),
	(5880, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 03:15:34'),
	(5881, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 03:15:34'),
	(5882, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 03:15:34'),
	(5883, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 03:15:34'),
	(5884, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 03:15:34'),
	(5885, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 03:15:34'),
	(5886, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 03:15:34'),
	(5887, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 03:15:34'),
	(5888, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 03:15:34'),
	(5889, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 03:27:48'),
	(5890, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 03:27:48'),
	(5891, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 03:27:48'),
	(5892, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 03:27:48'),
	(5893, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 03:27:48'),
	(5894, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 03:27:48'),
	(5895, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 03:27:48'),
	(5896, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 03:27:48'),
	(5897, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 03:27:48'),
	(5898, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 03:27:48'),
	(5899, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 03:27:48'),
	(5900, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 03:27:48'),
	(5901, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 03:27:48'),
	(5902, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 03:27:48'),
	(5903, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 03:27:48'),
	(5904, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 03:27:48'),
	(5905, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 03:27:48'),
	(5906, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 03:27:48'),
	(5907, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 03:27:48'),
	(5908, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 03:27:48'),
	(5909, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 03:27:48'),
	(5910, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 03:27:48'),
	(5911, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 03:27:48'),
	(5912, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 03:34:48'),
	(5913, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 03:34:48'),
	(5914, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 03:34:48'),
	(5915, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 03:34:48'),
	(5916, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 03:34:48'),
	(5917, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 03:34:48'),
	(5918, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 03:34:48'),
	(5919, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 03:34:48'),
	(5920, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 03:34:48'),
	(5921, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 03:34:48'),
	(5922, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 03:34:48'),
	(5923, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 03:34:48'),
	(5924, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 03:34:48'),
	(5925, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 03:34:48'),
	(5926, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 03:34:48'),
	(5927, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 03:34:48'),
	(5928, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 03:34:48'),
	(5929, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 03:34:48'),
	(5930, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 03:34:48'),
	(5931, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 03:34:48'),
	(5932, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 03:34:48'),
	(5933, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 03:34:48'),
	(5934, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 03:34:48'),
	(5935, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 03:38:43'),
	(5936, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 03:38:43'),
	(5937, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 03:38:43'),
	(5938, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 03:38:43'),
	(5939, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 03:38:43'),
	(5940, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 03:38:43'),
	(5941, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 03:38:43'),
	(5942, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 03:38:43'),
	(5943, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 03:38:43'),
	(5944, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 03:38:43'),
	(5945, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 03:38:43'),
	(5946, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 03:38:43'),
	(5947, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 03:38:43'),
	(5948, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 03:38:43'),
	(5949, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 03:38:43'),
	(5950, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 03:38:43'),
	(5951, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 03:38:43'),
	(5952, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 03:38:43'),
	(5953, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 03:38:43'),
	(5954, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 03:38:43'),
	(5955, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 03:38:43'),
	(5956, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 03:38:43'),
	(5957, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 03:38:43'),
	(5958, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 03:41:01'),
	(5959, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 03:41:01'),
	(5960, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 03:41:01'),
	(5961, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 03:41:01'),
	(5962, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 03:41:01'),
	(5963, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 03:41:01'),
	(5964, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 03:41:01'),
	(5965, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 03:41:01'),
	(5966, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 03:41:01'),
	(5967, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 03:41:01'),
	(5968, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 03:41:01'),
	(5969, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 03:41:01'),
	(5970, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 03:41:01'),
	(5971, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 03:41:01'),
	(5972, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 03:41:01'),
	(5973, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 03:41:01'),
	(5974, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 03:41:01'),
	(5975, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 03:41:01'),
	(5976, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 03:41:01'),
	(5977, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 03:41:01'),
	(5978, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 03:41:01'),
	(5979, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 03:41:01'),
	(5980, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 03:41:01'),
	(5981, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 03:43:22'),
	(5982, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 03:43:22'),
	(5983, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 03:43:22'),
	(5984, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 03:43:22'),
	(5985, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 03:43:22'),
	(5986, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 03:43:22'),
	(5987, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 03:43:22'),
	(5988, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 03:43:22'),
	(5989, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 03:43:22'),
	(5990, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 03:43:22'),
	(5991, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 03:43:22'),
	(5992, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 03:43:22'),
	(5993, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 03:43:22'),
	(5994, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 03:43:22'),
	(5995, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 03:43:22'),
	(5996, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 03:43:22'),
	(5997, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 03:43:22'),
	(5998, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 03:43:22'),
	(5999, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 03:43:22'),
	(6000, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 03:43:22'),
	(6001, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 03:43:22'),
	(6002, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 03:43:22'),
	(6003, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 03:43:22'),
	(6004, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 03:48:37'),
	(6005, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 03:48:37'),
	(6006, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 03:48:37'),
	(6007, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 03:48:37'),
	(6008, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 03:48:37'),
	(6009, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 03:48:37'),
	(6010, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 03:48:37'),
	(6011, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 03:48:37'),
	(6012, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 03:48:37'),
	(6013, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 03:48:37'),
	(6014, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 03:48:37'),
	(6015, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 03:48:37'),
	(6016, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 03:48:37'),
	(6017, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 03:48:37'),
	(6018, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 03:48:37'),
	(6019, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 03:48:37'),
	(6020, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 03:48:37'),
	(6021, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 03:48:37'),
	(6022, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 03:48:37'),
	(6023, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 03:48:37'),
	(6024, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 03:48:37'),
	(6025, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 03:48:37'),
	(6026, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 03:48:37'),
	(6027, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 03:49:33'),
	(6028, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 03:49:33'),
	(6029, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 03:49:33'),
	(6030, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 03:49:33'),
	(6031, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 03:49:33'),
	(6032, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 03:49:33'),
	(6033, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 03:49:33'),
	(6034, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 03:49:33'),
	(6035, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 03:49:33'),
	(6036, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 03:49:33'),
	(6037, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 03:49:33'),
	(6038, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 03:49:33'),
	(6039, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 03:49:33'),
	(6040, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 03:49:33'),
	(6041, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 03:49:33'),
	(6042, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 03:49:33'),
	(6043, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 03:49:33'),
	(6044, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 03:49:33'),
	(6045, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 03:49:33'),
	(6046, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 03:49:33'),
	(6047, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 03:49:33'),
	(6048, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 03:49:33'),
	(6049, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 03:49:33'),
	(6050, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 03:53:42'),
	(6051, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 03:53:42'),
	(6052, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 03:53:42'),
	(6053, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 03:53:42'),
	(6054, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 03:53:42'),
	(6055, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 03:53:42'),
	(6056, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 03:53:42'),
	(6057, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 03:53:42'),
	(6058, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 03:53:42'),
	(6059, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 03:53:42'),
	(6060, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 03:53:42'),
	(6061, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 03:53:42'),
	(6062, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 03:53:42'),
	(6063, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 03:53:42'),
	(6064, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 03:53:42'),
	(6065, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 03:53:42'),
	(6066, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 03:53:42'),
	(6067, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 03:53:42'),
	(6068, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 03:53:42'),
	(6069, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 03:53:42'),
	(6070, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 03:53:42'),
	(6071, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 03:53:42'),
	(6072, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 03:53:42'),
	(6073, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 03:57:43'),
	(6074, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 03:57:43'),
	(6075, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 03:57:43'),
	(6076, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 03:57:43'),
	(6077, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 03:57:43'),
	(6078, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 03:57:43'),
	(6079, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 03:57:43'),
	(6080, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 03:57:43'),
	(6081, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 03:57:43'),
	(6082, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 03:57:43'),
	(6083, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 03:57:43'),
	(6084, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 03:57:43'),
	(6085, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 03:57:43'),
	(6086, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 03:57:43'),
	(6087, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 03:57:43'),
	(6088, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 03:57:43'),
	(6089, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 03:57:43'),
	(6090, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 03:57:43'),
	(6091, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 03:57:43'),
	(6092, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 03:57:43'),
	(6093, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 03:57:43'),
	(6094, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 03:57:43'),
	(6095, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 03:57:43'),
	(6096, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 03:58:32'),
	(6097, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 03:58:32'),
	(6098, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 03:58:32'),
	(6099, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 03:58:32'),
	(6100, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 03:58:32'),
	(6101, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 03:58:32'),
	(6102, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 03:58:32'),
	(6103, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 03:58:32'),
	(6104, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 03:58:32'),
	(6105, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 03:58:32'),
	(6106, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 03:58:32'),
	(6107, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 03:58:32'),
	(6108, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 03:58:32'),
	(6109, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 03:58:32'),
	(6110, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 03:58:32'),
	(6111, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 03:58:32'),
	(6112, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 03:58:32'),
	(6113, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 03:58:32'),
	(6114, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 03:58:32'),
	(6115, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 03:58:32'),
	(6116, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 03:58:32'),
	(6117, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 03:58:32'),
	(6118, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 03:58:32'),
	(6119, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 04:02:58'),
	(6120, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 04:02:58'),
	(6121, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 04:02:58'),
	(6122, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 04:02:58'),
	(6123, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 04:02:58'),
	(6124, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 04:02:58'),
	(6125, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 04:02:58'),
	(6126, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 04:02:58'),
	(6127, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 04:02:58'),
	(6128, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 04:02:58'),
	(6129, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 04:02:58'),
	(6130, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 04:02:58'),
	(6131, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 04:02:58'),
	(6132, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 04:02:58'),
	(6133, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 04:02:58'),
	(6134, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 04:02:58'),
	(6135, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 04:02:58'),
	(6136, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 04:02:58'),
	(6137, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 04:02:58'),
	(6138, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 04:02:58'),
	(6139, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 04:02:58'),
	(6140, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 04:02:58'),
	(6141, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 04:02:58'),
	(6142, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 04:05:41'),
	(6143, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 04:05:41'),
	(6144, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 04:05:41'),
	(6145, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 04:05:41'),
	(6146, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 04:05:41'),
	(6147, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 04:05:41'),
	(6148, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 04:05:41'),
	(6149, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 04:05:41'),
	(6150, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 04:05:41'),
	(6151, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 04:05:41'),
	(6152, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 04:05:41'),
	(6153, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 04:05:41'),
	(6154, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 04:05:41'),
	(6155, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 04:05:41'),
	(6156, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 04:05:41'),
	(6157, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 04:05:41'),
	(6158, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 04:05:41'),
	(6159, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 04:05:41'),
	(6160, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 04:05:41'),
	(6161, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 04:05:41'),
	(6162, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 04:05:41'),
	(6163, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 04:05:41'),
	(6164, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 04:05:41'),
	(6165, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 04:22:26'),
	(6166, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 04:22:26'),
	(6167, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 04:22:26'),
	(6168, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 04:22:26'),
	(6169, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 04:22:26'),
	(6170, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 04:22:26'),
	(6171, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 04:22:26'),
	(6172, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 04:22:26'),
	(6173, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 04:22:26'),
	(6174, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 04:22:26'),
	(6175, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 04:22:26'),
	(6176, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 04:22:26'),
	(6177, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 04:22:26'),
	(6178, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 04:22:26'),
	(6179, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 04:22:26'),
	(6180, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 04:22:26'),
	(6181, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 04:22:26'),
	(6182, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 04:22:26'),
	(6183, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 04:22:26'),
	(6184, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 04:22:26'),
	(6185, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 04:22:26'),
	(6186, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 04:22:26'),
	(6187, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 04:22:26'),
	(6188, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 04:25:25'),
	(6189, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 04:25:25'),
	(6190, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 04:25:25'),
	(6191, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 04:25:25'),
	(6192, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 04:25:25'),
	(6193, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 04:25:25'),
	(6194, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 04:25:25'),
	(6195, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 04:25:25'),
	(6196, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 04:25:25'),
	(6197, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 04:25:25'),
	(6198, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 04:25:25'),
	(6199, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 04:25:25'),
	(6200, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 04:25:25'),
	(6201, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 04:25:25'),
	(6202, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 04:25:25'),
	(6203, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 04:25:25'),
	(6204, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 04:25:25'),
	(6205, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 04:25:25'),
	(6206, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 04:25:25'),
	(6207, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 04:25:25'),
	(6208, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 04:25:25'),
	(6209, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 04:25:25'),
	(6210, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 04:25:25'),
	(6211, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 04:28:40'),
	(6212, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 04:28:40'),
	(6213, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 04:28:40'),
	(6214, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 04:28:40'),
	(6215, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 04:28:40'),
	(6216, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 04:28:40'),
	(6217, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 04:28:40'),
	(6218, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 04:28:40'),
	(6219, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 04:28:40'),
	(6220, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 04:28:40'),
	(6221, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 04:28:40'),
	(6222, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 04:28:40'),
	(6223, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 04:28:40'),
	(6224, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 04:28:40'),
	(6225, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 04:28:40'),
	(6226, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 04:28:40'),
	(6227, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 04:28:40'),
	(6228, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 04:28:40'),
	(6229, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 04:28:40'),
	(6230, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 04:28:40'),
	(6231, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 04:28:40'),
	(6232, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 04:28:40'),
	(6233, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 04:28:40'),
	(6234, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 04:32:21'),
	(6235, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 04:32:21'),
	(6236, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 04:32:21'),
	(6237, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 04:32:21'),
	(6238, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 04:32:21'),
	(6239, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 04:32:21'),
	(6240, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 04:32:21'),
	(6241, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 04:32:21'),
	(6242, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 04:32:21'),
	(6243, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 04:32:21'),
	(6244, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 04:32:21'),
	(6245, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 04:32:21'),
	(6246, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 04:32:21'),
	(6247, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 04:32:21'),
	(6248, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 04:32:21'),
	(6249, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 04:32:21'),
	(6250, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 04:32:21'),
	(6251, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 04:32:21'),
	(6252, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 04:32:21'),
	(6253, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 04:32:21'),
	(6254, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 04:32:21'),
	(6255, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 04:32:21'),
	(6256, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 04:32:21'),
	(6257, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 04:33:48'),
	(6258, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 04:33:48'),
	(6259, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 04:33:48'),
	(6260, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 04:33:48'),
	(6261, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 04:33:48'),
	(6262, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 04:33:48'),
	(6263, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 04:33:48'),
	(6264, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 04:33:48'),
	(6265, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 04:33:48'),
	(6266, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 04:33:48'),
	(6267, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 04:33:48'),
	(6268, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 04:33:48'),
	(6269, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 04:33:48'),
	(6270, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 04:33:48'),
	(6271, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 04:33:48'),
	(6272, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 04:33:48'),
	(6273, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 04:33:48'),
	(6274, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 04:33:48'),
	(6275, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 04:33:48'),
	(6276, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 04:33:48'),
	(6277, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 04:33:48'),
	(6278, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 04:33:48'),
	(6279, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 04:33:48'),
	(6280, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 04:35:38'),
	(6281, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 04:35:38'),
	(6282, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 04:35:38'),
	(6283, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 04:35:38'),
	(6284, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 04:35:38'),
	(6285, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 04:35:38'),
	(6286, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 04:35:38'),
	(6287, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 04:35:38'),
	(6288, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 04:35:38'),
	(6289, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 04:35:38'),
	(6290, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 04:35:38'),
	(6291, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 04:35:38'),
	(6292, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 04:35:38'),
	(6293, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 04:35:38'),
	(6294, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 04:35:38'),
	(6295, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 04:35:38'),
	(6296, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 04:35:38'),
	(6297, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 04:35:38'),
	(6298, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 04:35:38'),
	(6299, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 04:35:38'),
	(6300, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 04:35:38'),
	(6301, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 04:35:38'),
	(6302, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 04:35:38'),
	(6303, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 04:49:54'),
	(6304, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 04:49:54'),
	(6305, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 04:49:54'),
	(6306, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 04:49:54'),
	(6307, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 04:49:54'),
	(6308, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 04:49:54'),
	(6309, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 04:49:54'),
	(6310, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 04:49:54'),
	(6311, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 04:49:54'),
	(6312, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 04:49:54'),
	(6313, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 04:49:54'),
	(6314, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 04:49:54'),
	(6315, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 04:49:54'),
	(6316, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 04:49:54'),
	(6317, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 04:49:54'),
	(6318, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 04:49:54'),
	(6319, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 04:49:54'),
	(6320, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 04:49:54'),
	(6321, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 04:49:54'),
	(6322, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 04:49:54'),
	(6323, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 04:49:54'),
	(6324, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 04:49:54'),
	(6325, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 04:49:54'),
	(6326, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 04:55:09'),
	(6327, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 04:55:09'),
	(6328, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 04:55:09'),
	(6329, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 04:55:09'),
	(6330, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 04:55:09'),
	(6331, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 04:55:09'),
	(6332, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 04:55:09'),
	(6333, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 04:55:09'),
	(6334, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 04:55:09'),
	(6335, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 04:55:09'),
	(6336, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 04:55:09'),
	(6337, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 04:55:09'),
	(6338, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 04:55:09'),
	(6339, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 04:55:09'),
	(6340, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 04:55:09'),
	(6341, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 04:55:09'),
	(6342, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 04:55:09'),
	(6343, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 04:55:09'),
	(6344, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 04:55:09'),
	(6345, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 04:55:09'),
	(6346, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 04:55:09'),
	(6347, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 04:55:09'),
	(6348, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 04:55:09'),
	(6349, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:04:26'),
	(6350, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:04:26'),
	(6351, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:04:26'),
	(6352, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:04:26'),
	(6353, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:04:26'),
	(6354, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:04:26'),
	(6355, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:04:26'),
	(6356, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:04:26'),
	(6357, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:04:26'),
	(6358, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:04:26'),
	(6359, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:04:26'),
	(6360, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:04:26'),
	(6361, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:04:26'),
	(6362, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:04:26'),
	(6363, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:04:26'),
	(6364, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:04:26'),
	(6365, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:04:26'),
	(6366, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:04:26'),
	(6367, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:04:26'),
	(6368, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:04:26'),
	(6369, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:04:26'),
	(6370, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:04:26'),
	(6371, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:04:26'),
	(6372, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:09:39'),
	(6373, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:09:39'),
	(6374, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:09:39'),
	(6375, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:09:39'),
	(6376, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:09:39'),
	(6377, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:09:39'),
	(6378, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:09:39'),
	(6379, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:09:39'),
	(6380, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:09:39'),
	(6381, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:09:39'),
	(6382, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:09:39'),
	(6383, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:09:39'),
	(6384, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:09:39'),
	(6385, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:09:39'),
	(6386, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:09:39'),
	(6387, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:09:39'),
	(6388, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:09:39'),
	(6389, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:09:39'),
	(6390, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:09:39'),
	(6391, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:09:39'),
	(6392, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:09:39'),
	(6393, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:09:39'),
	(6394, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:09:39'),
	(6395, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:15:09'),
	(6396, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:15:09'),
	(6397, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:15:09'),
	(6398, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:15:09'),
	(6399, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:15:09'),
	(6400, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:15:09'),
	(6401, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:15:09'),
	(6402, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:15:09'),
	(6403, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:15:09'),
	(6404, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:15:09'),
	(6405, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:15:09'),
	(6406, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:15:09'),
	(6407, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:15:09'),
	(6408, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:15:09'),
	(6409, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:15:09'),
	(6410, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:15:09'),
	(6411, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:15:09'),
	(6412, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:15:09'),
	(6413, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:15:09'),
	(6414, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:15:09'),
	(6415, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:15:09'),
	(6416, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:15:09'),
	(6417, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:15:09'),
	(6418, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:18:53'),
	(6419, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:18:53'),
	(6420, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:18:53'),
	(6421, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:18:53'),
	(6422, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:18:53'),
	(6423, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:18:53'),
	(6424, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:18:53'),
	(6425, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:18:53'),
	(6426, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:18:53'),
	(6427, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:18:53'),
	(6428, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:18:53'),
	(6429, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:18:53'),
	(6430, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:18:53'),
	(6431, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:18:53'),
	(6432, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:18:53'),
	(6433, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:18:53'),
	(6434, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:18:53'),
	(6435, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:18:53'),
	(6436, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:18:53'),
	(6437, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:18:53'),
	(6438, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:18:53'),
	(6439, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:18:53'),
	(6440, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:18:53'),
	(6441, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:24:11'),
	(6442, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:24:11'),
	(6443, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:24:11'),
	(6444, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:24:11'),
	(6445, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:24:11'),
	(6446, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:24:11'),
	(6447, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:24:11'),
	(6448, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:24:11'),
	(6449, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:24:11'),
	(6450, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:24:11'),
	(6451, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:24:11'),
	(6452, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:24:11'),
	(6453, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:24:11'),
	(6454, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:24:11'),
	(6455, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:24:11'),
	(6456, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:24:11'),
	(6457, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:24:11'),
	(6458, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:24:11'),
	(6459, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:24:11'),
	(6460, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:24:11'),
	(6461, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:24:11'),
	(6462, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:24:11'),
	(6463, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:24:11'),
	(6464, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:27:25'),
	(6465, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:27:25'),
	(6466, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:27:25'),
	(6467, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:27:25'),
	(6468, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:27:25'),
	(6469, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:27:25'),
	(6470, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:27:25'),
	(6471, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:27:25'),
	(6472, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:27:25'),
	(6473, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:27:25'),
	(6474, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:27:25'),
	(6475, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:27:25'),
	(6476, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:27:25'),
	(6477, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:27:25'),
	(6478, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:27:25'),
	(6479, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:27:25'),
	(6480, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:27:25'),
	(6481, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:27:25'),
	(6482, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:27:25'),
	(6483, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:27:25'),
	(6484, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:27:25'),
	(6485, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:27:25'),
	(6486, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:27:25'),
	(6487, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:33:12'),
	(6488, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:33:12'),
	(6489, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:33:12'),
	(6490, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:33:12'),
	(6491, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:33:12'),
	(6492, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:33:12'),
	(6493, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:33:12'),
	(6494, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:33:12'),
	(6495, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:33:12'),
	(6496, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:33:12'),
	(6497, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:33:12'),
	(6498, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:33:12'),
	(6499, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:33:12'),
	(6500, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:33:12'),
	(6501, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:33:12'),
	(6502, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:33:12'),
	(6503, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:33:12'),
	(6504, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:33:12'),
	(6505, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:33:12'),
	(6506, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:33:12'),
	(6507, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:33:12'),
	(6508, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:33:12'),
	(6509, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:33:12'),
	(6510, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:36:47'),
	(6511, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:36:47'),
	(6512, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:36:47'),
	(6513, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:36:47'),
	(6514, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:36:47'),
	(6515, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:36:47'),
	(6516, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:36:47'),
	(6517, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:36:47'),
	(6518, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:36:47'),
	(6519, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:36:47'),
	(6520, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:36:47'),
	(6521, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:36:47'),
	(6522, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:36:47'),
	(6523, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:36:47'),
	(6524, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:36:47'),
	(6525, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:36:47'),
	(6526, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:36:47'),
	(6527, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:36:47'),
	(6528, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:36:47'),
	(6529, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:36:47'),
	(6530, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:36:47'),
	(6531, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:36:47'),
	(6532, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:36:47'),
	(6533, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:40:16'),
	(6534, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:40:16'),
	(6535, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:40:16'),
	(6536, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:40:16'),
	(6537, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:40:16'),
	(6538, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:40:16'),
	(6539, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:40:16'),
	(6540, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:40:16'),
	(6541, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:40:16'),
	(6542, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:40:16'),
	(6543, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:40:16'),
	(6544, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:40:16'),
	(6545, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:40:16'),
	(6546, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:40:16'),
	(6547, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:40:16'),
	(6548, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:40:16'),
	(6549, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:40:16'),
	(6550, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:40:16'),
	(6551, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:40:16'),
	(6552, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:40:16'),
	(6553, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:40:16'),
	(6554, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:40:16'),
	(6555, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:40:16'),
	(6556, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:46:15'),
	(6557, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:46:15'),
	(6558, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:46:15'),
	(6559, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:46:15'),
	(6560, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:46:15'),
	(6561, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:46:15'),
	(6562, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:46:15'),
	(6563, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:46:15'),
	(6564, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:46:15'),
	(6565, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:46:15'),
	(6566, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:46:15'),
	(6567, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:46:15'),
	(6568, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:46:15'),
	(6569, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:46:15'),
	(6570, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:46:15'),
	(6571, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:46:15'),
	(6572, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:46:15'),
	(6573, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:46:15'),
	(6574, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:46:15'),
	(6575, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:46:15'),
	(6576, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:46:15'),
	(6577, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:46:15'),
	(6578, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:46:15'),
	(6579, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:48:35'),
	(6580, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:48:35'),
	(6581, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:48:35'),
	(6582, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:48:35'),
	(6583, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:48:35'),
	(6584, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:48:35'),
	(6585, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:48:35'),
	(6586, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:48:35'),
	(6587, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:48:35'),
	(6588, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:48:35'),
	(6589, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:48:35'),
	(6590, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:48:35'),
	(6591, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:48:35'),
	(6592, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:48:35'),
	(6593, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:48:35'),
	(6594, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:48:35'),
	(6595, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:48:35'),
	(6596, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:48:35'),
	(6597, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:48:35'),
	(6598, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:48:35'),
	(6599, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:48:35'),
	(6600, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:48:35'),
	(6601, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:48:35'),
	(6602, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:54:00'),
	(6603, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:54:00'),
	(6604, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:54:00'),
	(6605, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:54:00'),
	(6606, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:54:00'),
	(6607, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:54:00'),
	(6608, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:54:00'),
	(6609, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:54:00'),
	(6610, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:54:00'),
	(6611, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:54:00'),
	(6612, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:54:00'),
	(6613, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:54:00'),
	(6614, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:54:00'),
	(6615, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:54:00'),
	(6616, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:54:00'),
	(6617, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:54:00'),
	(6618, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:54:00'),
	(6619, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:54:00'),
	(6620, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:54:00'),
	(6621, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:54:00'),
	(6622, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:54:00'),
	(6623, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:54:00'),
	(6624, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:54:00'),
	(6625, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 05:57:01'),
	(6626, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 05:57:01'),
	(6627, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 05:57:01'),
	(6628, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 05:57:01'),
	(6629, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 05:57:01'),
	(6630, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 05:57:01'),
	(6631, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 05:57:01'),
	(6632, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 05:57:01'),
	(6633, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 05:57:01'),
	(6634, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 05:57:01'),
	(6635, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 05:57:01'),
	(6636, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 05:57:01'),
	(6637, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 05:57:01'),
	(6638, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 05:57:01'),
	(6639, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 05:57:01'),
	(6640, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 05:57:01'),
	(6641, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 05:57:01'),
	(6642, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 05:57:01'),
	(6643, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 05:57:01'),
	(6644, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 05:57:01'),
	(6645, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 05:57:01'),
	(6646, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 05:57:01'),
	(6647, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 05:57:01'),
	(6648, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 06:03:30'),
	(6649, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 06:03:30'),
	(6650, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 06:03:30'),
	(6651, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 06:03:30'),
	(6652, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 06:03:30'),
	(6653, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 06:03:30'),
	(6654, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 06:03:30'),
	(6655, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 06:03:30'),
	(6656, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 06:03:30'),
	(6657, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 06:03:30'),
	(6658, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 06:03:30'),
	(6659, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 06:03:30'),
	(6660, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 06:03:30'),
	(6661, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 06:03:30'),
	(6662, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 06:03:30'),
	(6663, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 06:03:30'),
	(6664, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 06:03:30'),
	(6665, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 06:03:30'),
	(6666, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 06:03:30'),
	(6667, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 06:03:30'),
	(6668, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 06:03:30'),
	(6669, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 06:03:30'),
	(6670, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 06:03:30'),
	(6671, 1, 'USD', 42.535300, 42.497000, 42.573600, 'tcmb', '2025-12-10 06:05:32'),
	(6672, 1, 'AUD', 28.242400, 28.150600, 28.334200, 'tcmb', '2025-12-10 06:05:32'),
	(6673, 1, 'DKK', 6.631850, 6.615600, 6.648100, 'tcmb', '2025-12-10 06:05:32'),
	(6674, 1, 'EUR', 49.532050, 49.487500, 49.576600, 'tcmb', '2025-12-10 06:05:32'),
	(6675, 1, 'GBP', 56.726200, 56.578700, 56.873700, 'tcmb', '2025-12-10 06:05:32'),
	(6676, 1, 'CHF', 52.769000, 52.600100, 52.937900, 'tcmb', '2025-12-10 06:05:32'),
	(6677, 1, 'SEK', 4.540050, 4.516700, 4.563400, 'tcmb', '2025-12-10 06:05:32'),
	(6678, 1, 'CAD', 30.713800, 30.644700, 30.782900, 'tcmb', '2025-12-10 06:05:32'),
	(6679, 1, 'KWD', 138.539500, 137.639000, 139.440000, 'tcmb', '2025-12-10 06:05:32'),
	(6680, 1, 'NOK', 4.203050, 4.189000, 4.217100, 'tcmb', '2025-12-10 06:05:32'),
	(6681, 1, 'SAR', 11.334100, 11.323900, 11.344300, 'tcmb', '2025-12-10 06:05:32'),
	(6682, 1, 'JPY', 0.272406, 0.271507, 0.273305, 'tcmb', '2025-12-10 06:05:32'),
	(6683, 1, 'BGN', 25.325050, 25.160400, 25.489700, 'tcmb', '2025-12-10 06:05:32'),
	(6684, 1, 'RON', 9.731850, 9.668600, 9.795100, 'tcmb', '2025-12-10 06:05:32'),
	(6685, 1, 'RUB', 0.554375, 0.550770, 0.557980, 'tcmb', '2025-12-10 06:05:32'),
	(6686, 1, 'CNY', 6.019050, 5.979900, 6.058200, 'tcmb', '2025-12-10 06:05:32'),
	(6687, 1, 'PKR', 0.151735, 0.150750, 0.152720, 'tcmb', '2025-12-10 06:05:32'),
	(6688, 1, 'QAR', 11.669500, 11.593600, 11.745400, 'tcmb', '2025-12-10 06:05:32'),
	(6689, 1, 'KRW', 0.028970, 0.028780, 0.029160, 'tcmb', '2025-12-10 06:05:32'),
	(6690, 1, 'AZN', 25.020750, 24.858100, 25.183400, 'tcmb', '2025-12-10 06:05:32'),
	(6691, 1, 'AED', 11.581050, 11.505800, 11.656300, 'tcmb', '2025-12-10 06:05:32'),
	(6692, 1, 'KZT', 0.082475, 0.081940, 0.083010, 'tcmb', '2025-12-10 06:05:32'),
	(6693, 1, 'XDR', 28.987050, 57.974100, 0.000000, 'tcmb', '2025-12-10 06:05:32'),
	(6694, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 14:56:31'),
	(6695, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 14:56:31'),
	(6696, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 14:56:31'),
	(6697, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 14:56:31'),
	(6698, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 14:56:31'),
	(6699, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 14:56:31'),
	(6700, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 14:56:31'),
	(6701, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 14:56:31'),
	(6702, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 14:56:31'),
	(6703, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 14:56:31'),
	(6704, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 14:56:31'),
	(6705, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 14:56:31'),
	(6706, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 14:56:31'),
	(6707, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 14:56:31'),
	(6708, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 14:56:31'),
	(6709, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 14:56:31'),
	(6710, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 14:56:31'),
	(6711, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 14:56:31'),
	(6712, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 14:56:31'),
	(6713, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 14:56:31'),
	(6714, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 14:56:31'),
	(6715, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 14:56:31'),
	(6716, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 14:56:31'),
	(6717, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 15:17:41'),
	(6718, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 15:17:41'),
	(6719, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 15:17:41'),
	(6720, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 15:17:41'),
	(6721, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 15:17:41'),
	(6722, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 15:17:41'),
	(6723, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 15:17:41'),
	(6724, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 15:17:41'),
	(6725, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 15:17:41'),
	(6726, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 15:17:41'),
	(6727, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 15:17:41'),
	(6728, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 15:17:41'),
	(6729, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 15:17:41'),
	(6730, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 15:17:41'),
	(6731, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 15:17:41'),
	(6732, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 15:17:41'),
	(6733, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 15:17:41'),
	(6734, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 15:17:41'),
	(6735, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 15:17:41'),
	(6736, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 15:17:41'),
	(6737, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 15:17:41'),
	(6738, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 15:17:41'),
	(6739, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 15:17:41'),
	(6740, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 15:22:43'),
	(6741, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 15:22:43'),
	(6742, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 15:22:43'),
	(6743, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 15:22:43'),
	(6744, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 15:22:43'),
	(6745, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 15:22:43'),
	(6746, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 15:22:43'),
	(6747, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 15:22:43'),
	(6748, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 15:22:43'),
	(6749, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 15:22:43'),
	(6750, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 15:22:43'),
	(6751, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 15:22:43'),
	(6752, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 15:22:43'),
	(6753, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 15:22:43'),
	(6754, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 15:22:43'),
	(6755, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 15:22:43'),
	(6756, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 15:22:43'),
	(6757, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 15:22:43'),
	(6758, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 15:22:43'),
	(6759, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 15:22:43'),
	(6760, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 15:22:43'),
	(6761, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 15:22:43'),
	(6762, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 15:22:43'),
	(6763, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 15:26:54'),
	(6764, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 15:26:54'),
	(6765, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 15:26:54'),
	(6766, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 15:26:54'),
	(6767, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 15:26:54'),
	(6768, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 15:26:54'),
	(6769, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 15:26:54'),
	(6770, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 15:26:54'),
	(6771, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 15:26:54'),
	(6772, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 15:26:54'),
	(6773, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 15:26:54'),
	(6774, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 15:26:54'),
	(6775, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 15:26:54'),
	(6776, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 15:26:54'),
	(6777, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 15:26:54'),
	(6778, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 15:26:54'),
	(6779, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 15:26:54'),
	(6780, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 15:26:54'),
	(6781, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 15:26:54'),
	(6782, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 15:26:54'),
	(6783, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 15:26:54'),
	(6784, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 15:26:54'),
	(6785, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 15:26:54'),
	(6786, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 15:31:11'),
	(6787, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 15:31:11'),
	(6788, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 15:31:11'),
	(6789, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 15:31:11'),
	(6790, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 15:31:11'),
	(6791, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 15:31:11'),
	(6792, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 15:31:11'),
	(6793, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 15:31:11'),
	(6794, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 15:31:11'),
	(6795, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 15:31:11'),
	(6796, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 15:31:11'),
	(6797, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 15:31:11'),
	(6798, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 15:31:11'),
	(6799, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 15:31:11'),
	(6800, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 15:31:11'),
	(6801, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 15:31:11'),
	(6802, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 15:31:11'),
	(6803, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 15:31:11'),
	(6804, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 15:31:11'),
	(6805, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 15:31:11'),
	(6806, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 15:31:11'),
	(6807, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 15:31:11'),
	(6808, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 15:31:11'),
	(6809, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 15:38:48'),
	(6810, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 15:38:48'),
	(6811, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 15:38:48'),
	(6812, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 15:38:48'),
	(6813, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 15:38:48'),
	(6814, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 15:38:48'),
	(6815, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 15:38:48'),
	(6816, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 15:38:48'),
	(6817, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 15:38:48'),
	(6818, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 15:38:48'),
	(6819, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 15:38:48'),
	(6820, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 15:38:48'),
	(6821, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 15:38:48'),
	(6822, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 15:38:48'),
	(6823, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 15:38:48'),
	(6824, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 15:38:48'),
	(6825, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 15:38:48'),
	(6826, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 15:38:48'),
	(6827, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 15:38:48'),
	(6828, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 15:38:48'),
	(6829, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 15:38:48'),
	(6830, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 15:38:48'),
	(6831, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 15:38:48'),
	(6832, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 15:41:10'),
	(6833, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 15:41:10'),
	(6834, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 15:41:10'),
	(6835, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 15:41:10'),
	(6836, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 15:41:10'),
	(6837, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 15:41:10'),
	(6838, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 15:41:10'),
	(6839, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 15:41:10'),
	(6840, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 15:41:10'),
	(6841, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 15:41:10'),
	(6842, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 15:41:10'),
	(6843, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 15:41:10'),
	(6844, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 15:41:10'),
	(6845, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 15:41:10'),
	(6846, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 15:41:10'),
	(6847, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 15:41:10'),
	(6848, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 15:41:10'),
	(6849, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 15:41:10'),
	(6850, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 15:41:10'),
	(6851, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 15:41:10'),
	(6852, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 15:41:10'),
	(6853, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 15:41:10'),
	(6854, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 15:41:10'),
	(6855, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 15:45:36'),
	(6856, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 15:45:36'),
	(6857, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 15:45:36'),
	(6858, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 15:45:36'),
	(6859, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 15:45:36'),
	(6860, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 15:45:36'),
	(6861, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 15:45:36'),
	(6862, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 15:45:36'),
	(6863, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 15:45:36'),
	(6864, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 15:45:36'),
	(6865, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 15:45:36'),
	(6866, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 15:45:36'),
	(6867, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 15:45:36'),
	(6868, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 15:45:36'),
	(6869, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 15:45:36'),
	(6870, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 15:45:36'),
	(6871, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 15:45:36'),
	(6872, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 15:45:36'),
	(6873, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 15:45:36'),
	(6874, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 15:45:36'),
	(6875, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 15:45:36'),
	(6876, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 15:45:36'),
	(6877, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 15:45:36'),
	(6878, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 15:48:32'),
	(6879, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 15:48:32'),
	(6880, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 15:48:32'),
	(6881, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 15:48:32'),
	(6882, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 15:48:32'),
	(6883, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 15:48:32'),
	(6884, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 15:48:32'),
	(6885, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 15:48:32'),
	(6886, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 15:48:32'),
	(6887, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 15:48:32'),
	(6888, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 15:48:32'),
	(6889, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 15:48:32'),
	(6890, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 15:48:32'),
	(6891, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 15:48:32'),
	(6892, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 15:48:32'),
	(6893, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 15:48:32'),
	(6894, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 15:48:32'),
	(6895, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 15:48:32'),
	(6896, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 15:48:32'),
	(6897, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 15:48:32'),
	(6898, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 15:48:32'),
	(6899, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 15:48:32'),
	(6900, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 15:48:32'),
	(6901, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:00:34'),
	(6902, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:00:34'),
	(6903, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:00:34'),
	(6904, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:00:34'),
	(6905, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:00:34'),
	(6906, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:00:34'),
	(6907, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:00:34'),
	(6908, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:00:34'),
	(6909, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:00:34'),
	(6910, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:00:35'),
	(6911, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:00:35'),
	(6912, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:00:35'),
	(6913, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:00:35'),
	(6914, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:00:35'),
	(6915, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:00:35'),
	(6916, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:00:35'),
	(6917, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:00:35'),
	(6918, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:00:35'),
	(6919, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:00:35'),
	(6920, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:00:35'),
	(6921, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:00:35'),
	(6922, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:00:35'),
	(6923, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:00:35'),
	(6924, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:03:44'),
	(6925, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:03:44'),
	(6926, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:03:44'),
	(6927, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:03:44'),
	(6928, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:03:44'),
	(6929, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:03:44'),
	(6930, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:03:44'),
	(6931, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:03:44'),
	(6932, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:03:44'),
	(6933, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:03:44'),
	(6934, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:03:44'),
	(6935, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:03:44'),
	(6936, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:03:44'),
	(6937, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:03:44'),
	(6938, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:03:44'),
	(6939, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:03:44'),
	(6940, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:03:44'),
	(6941, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:03:44'),
	(6942, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:03:44'),
	(6943, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:03:44'),
	(6944, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:03:44'),
	(6945, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:03:44'),
	(6946, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:03:44'),
	(6947, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:07:38'),
	(6948, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:07:38'),
	(6949, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:07:38'),
	(6950, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:07:38'),
	(6951, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:07:38'),
	(6952, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:07:38'),
	(6953, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:07:38'),
	(6954, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:07:38'),
	(6955, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:07:38'),
	(6956, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:07:38'),
	(6957, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:07:38'),
	(6958, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:07:38'),
	(6959, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:07:38'),
	(6960, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:07:38'),
	(6961, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:07:38'),
	(6962, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:07:38'),
	(6963, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:07:38'),
	(6964, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:07:38'),
	(6965, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:07:38'),
	(6966, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:07:38'),
	(6967, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:07:38'),
	(6968, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:07:38'),
	(6969, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:07:38'),
	(6970, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:09:27'),
	(6971, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:09:27'),
	(6972, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:09:27'),
	(6973, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:09:27'),
	(6974, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:09:27'),
	(6975, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:09:27'),
	(6976, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:09:27'),
	(6977, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:09:27'),
	(6978, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:09:27'),
	(6979, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:09:27'),
	(6980, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:09:27'),
	(6981, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:09:27'),
	(6982, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:09:27'),
	(6983, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:09:27'),
	(6984, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:09:27'),
	(6985, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:09:27'),
	(6986, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:09:27'),
	(6987, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:09:27'),
	(6988, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:09:27'),
	(6989, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:09:27'),
	(6990, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:09:27'),
	(6991, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:09:27'),
	(6992, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:09:27'),
	(6993, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:10:13'),
	(6994, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:10:13'),
	(6995, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:10:13'),
	(6996, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:10:13'),
	(6997, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:10:13'),
	(6998, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:10:13'),
	(6999, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:10:13'),
	(7000, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:10:13'),
	(7001, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:10:13'),
	(7002, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:10:13'),
	(7003, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:10:13'),
	(7004, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:10:13'),
	(7005, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:10:13'),
	(7006, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:10:13'),
	(7007, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:10:13'),
	(7008, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:10:13'),
	(7009, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:10:13'),
	(7010, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:10:13'),
	(7011, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:10:13'),
	(7012, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:10:13'),
	(7013, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:10:13'),
	(7014, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:10:13'),
	(7015, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:10:13'),
	(7016, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:12:21'),
	(7017, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:12:21'),
	(7018, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:12:21'),
	(7019, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:12:21'),
	(7020, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:12:21'),
	(7021, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:12:21'),
	(7022, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:12:21'),
	(7023, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:12:21'),
	(7024, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:12:21'),
	(7025, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:12:21'),
	(7026, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:12:21'),
	(7027, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:12:21'),
	(7028, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:12:21'),
	(7029, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:12:21'),
	(7030, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:12:21'),
	(7031, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:12:21'),
	(7032, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:12:21'),
	(7033, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:12:21'),
	(7034, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:12:21'),
	(7035, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:12:21'),
	(7036, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:12:21'),
	(7037, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:12:21'),
	(7038, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:12:21'),
	(7039, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:14:16'),
	(7040, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:14:16'),
	(7041, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:14:16'),
	(7042, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:14:16'),
	(7043, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:14:16'),
	(7044, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:14:16'),
	(7045, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:14:16'),
	(7046, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:14:16'),
	(7047, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:14:16'),
	(7048, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:14:16'),
	(7049, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:14:16'),
	(7050, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:14:16'),
	(7051, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:14:16'),
	(7052, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:14:16'),
	(7053, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:14:16'),
	(7054, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:14:16'),
	(7055, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:14:16'),
	(7056, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:14:16'),
	(7057, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:14:16'),
	(7058, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:14:16'),
	(7059, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:14:16'),
	(7060, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:14:16'),
	(7061, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:14:16'),
	(7062, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:14:44'),
	(7063, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:14:44'),
	(7064, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:14:44'),
	(7065, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:14:44'),
	(7066, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:14:44'),
	(7067, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:14:44'),
	(7068, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:14:44'),
	(7069, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:14:44'),
	(7070, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:14:44'),
	(7071, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:14:44'),
	(7072, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:14:44'),
	(7073, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:14:44'),
	(7074, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:14:44'),
	(7075, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:14:44'),
	(7076, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:14:44'),
	(7077, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:14:44'),
	(7078, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:14:44'),
	(7079, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:14:44'),
	(7080, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:14:44'),
	(7081, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:14:44'),
	(7082, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:14:44'),
	(7083, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:14:44'),
	(7084, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:14:44'),
	(7085, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:17:22'),
	(7086, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:17:22'),
	(7087, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:17:22'),
	(7088, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:17:22'),
	(7089, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:17:22'),
	(7090, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:17:22'),
	(7091, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:17:22'),
	(7092, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:17:22'),
	(7093, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:17:22'),
	(7094, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:17:22'),
	(7095, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:17:22'),
	(7096, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:17:22'),
	(7097, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:17:22'),
	(7098, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:17:22'),
	(7099, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:17:22'),
	(7100, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:17:22'),
	(7101, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:17:22'),
	(7102, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:17:22'),
	(7103, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:17:22'),
	(7104, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:17:22'),
	(7105, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:17:22'),
	(7106, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:17:22'),
	(7107, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:17:22'),
	(7108, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:18:04'),
	(7109, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:18:04'),
	(7110, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:18:04'),
	(7111, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:18:04'),
	(7112, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:18:04'),
	(7113, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:18:04'),
	(7114, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:18:04'),
	(7115, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:18:04'),
	(7116, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:18:04'),
	(7117, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:18:04'),
	(7118, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:18:04'),
	(7119, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:18:04'),
	(7120, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:18:04'),
	(7121, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:18:04'),
	(7122, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:18:04'),
	(7123, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:18:04'),
	(7124, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:18:04'),
	(7125, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:18:04'),
	(7126, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:18:04'),
	(7127, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:18:04'),
	(7128, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:18:04'),
	(7129, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:18:04'),
	(7130, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:18:04'),
	(7131, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:20:42'),
	(7132, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:20:42'),
	(7133, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:20:42'),
	(7134, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:20:42'),
	(7135, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:20:42'),
	(7136, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:20:42'),
	(7137, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:20:42'),
	(7138, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:20:42'),
	(7139, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:20:42'),
	(7140, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:20:42'),
	(7141, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:20:42'),
	(7142, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:20:42'),
	(7143, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:20:42'),
	(7144, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:20:42'),
	(7145, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:20:42'),
	(7146, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:20:42'),
	(7147, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:20:42'),
	(7148, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:20:42'),
	(7149, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:20:42'),
	(7150, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:20:42'),
	(7151, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:20:42'),
	(7152, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:20:42'),
	(7153, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:20:42'),
	(7154, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:21:19'),
	(7155, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:21:19'),
	(7156, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:21:19'),
	(7157, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:21:19'),
	(7158, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:21:19'),
	(7159, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:21:19'),
	(7160, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:21:19'),
	(7161, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:21:19'),
	(7162, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:21:19'),
	(7163, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:21:19'),
	(7164, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:21:19'),
	(7165, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:21:19'),
	(7166, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:21:19'),
	(7167, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:21:19'),
	(7168, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:21:19'),
	(7169, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:21:19'),
	(7170, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:21:19'),
	(7171, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:21:19'),
	(7172, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:21:19'),
	(7173, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:21:19'),
	(7174, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:21:19'),
	(7175, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:21:19'),
	(7176, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:21:19'),
	(7177, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:25:43'),
	(7178, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:25:43'),
	(7179, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:25:43'),
	(7180, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:25:43'),
	(7181, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:25:43'),
	(7182, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:25:43'),
	(7183, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:25:43'),
	(7184, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:25:43'),
	(7185, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:25:43'),
	(7186, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:25:43'),
	(7187, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:25:43'),
	(7188, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:25:43'),
	(7189, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:25:43'),
	(7190, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:25:43'),
	(7191, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:25:43'),
	(7192, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:25:43'),
	(7193, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:25:43'),
	(7194, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:25:43'),
	(7195, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:25:43'),
	(7196, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:25:43'),
	(7197, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:25:43'),
	(7198, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:25:43'),
	(7199, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:25:43'),
	(7200, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:29:00'),
	(7201, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:29:00'),
	(7202, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:29:00'),
	(7203, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:29:00'),
	(7204, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:29:00'),
	(7205, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:29:00'),
	(7206, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:29:00'),
	(7207, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:29:00'),
	(7208, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:29:00'),
	(7209, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:29:00'),
	(7210, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:29:00'),
	(7211, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:29:00'),
	(7212, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:29:00'),
	(7213, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:29:00'),
	(7214, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:29:00'),
	(7215, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:29:00'),
	(7216, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:29:00'),
	(7217, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:29:00'),
	(7218, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:29:00'),
	(7219, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:29:00'),
	(7220, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:29:00'),
	(7221, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:29:00'),
	(7222, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:29:00'),
	(7223, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:34:24'),
	(7224, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:34:24'),
	(7225, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:34:24'),
	(7226, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:34:24'),
	(7227, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:34:24'),
	(7228, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:34:24'),
	(7229, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:34:24'),
	(7230, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:34:24'),
	(7231, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:34:24'),
	(7232, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:34:24'),
	(7233, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:34:24'),
	(7234, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:34:24'),
	(7235, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:34:24'),
	(7236, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:34:24'),
	(7237, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:34:24'),
	(7238, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:34:24'),
	(7239, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:34:24'),
	(7240, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:34:24'),
	(7241, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:34:24'),
	(7242, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:34:24'),
	(7243, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:34:24'),
	(7244, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:34:24'),
	(7245, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:34:24'),
	(7246, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 16:35:00'),
	(7247, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 16:35:00'),
	(7248, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 16:35:00'),
	(7249, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 16:35:00'),
	(7250, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 16:35:00'),
	(7251, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 16:35:00'),
	(7252, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 16:35:00'),
	(7253, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 16:35:00'),
	(7254, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 16:35:00'),
	(7255, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 16:35:00'),
	(7256, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 16:35:00'),
	(7257, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 16:35:00'),
	(7258, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 16:35:00'),
	(7259, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 16:35:00'),
	(7260, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 16:35:00'),
	(7261, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 16:35:00'),
	(7262, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 16:35:00'),
	(7263, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 16:35:00'),
	(7264, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 16:35:00'),
	(7265, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 16:35:00'),
	(7266, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 16:35:00'),
	(7267, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 16:35:00'),
	(7268, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 16:35:00'),
	(7269, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:02:15'),
	(7270, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:02:15'),
	(7271, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:02:15'),
	(7272, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:02:15'),
	(7273, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:02:15'),
	(7274, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:02:15'),
	(7275, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:02:15'),
	(7276, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:02:15'),
	(7277, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:02:15'),
	(7278, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:02:15'),
	(7279, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:02:15'),
	(7280, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:02:15'),
	(7281, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:02:15'),
	(7282, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:02:15'),
	(7283, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:02:15'),
	(7284, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:02:15'),
	(7285, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:02:15'),
	(7286, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:02:15'),
	(7287, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:02:15'),
	(7288, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:02:15'),
	(7289, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:02:15'),
	(7290, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:02:15'),
	(7291, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:02:15'),
	(7292, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:13:58'),
	(7293, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:13:58'),
	(7294, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:13:58'),
	(7295, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:13:58'),
	(7296, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:13:58'),
	(7297, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:13:58'),
	(7298, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:13:58'),
	(7299, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:13:58'),
	(7300, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:13:58'),
	(7301, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:13:58'),
	(7302, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:13:58'),
	(7303, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:13:58'),
	(7304, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:13:58'),
	(7305, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:13:58'),
	(7306, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:13:58'),
	(7307, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:13:58'),
	(7308, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:13:58'),
	(7309, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:13:58'),
	(7310, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:13:58'),
	(7311, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:13:58'),
	(7312, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:13:58'),
	(7313, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:13:58'),
	(7314, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:13:58'),
	(7315, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:18:50'),
	(7316, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:18:50'),
	(7317, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:18:50'),
	(7318, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:18:50'),
	(7319, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:18:50'),
	(7320, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:18:50'),
	(7321, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:18:50'),
	(7322, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:18:50'),
	(7323, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:18:50'),
	(7324, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:18:50'),
	(7325, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:18:50'),
	(7326, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:18:50'),
	(7327, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:18:50'),
	(7328, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:18:50'),
	(7329, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:18:50'),
	(7330, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:18:50'),
	(7331, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:18:50'),
	(7332, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:18:50'),
	(7333, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:18:50'),
	(7334, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:18:50'),
	(7335, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:18:50'),
	(7336, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:18:50'),
	(7337, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:18:50'),
	(7338, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:19:46'),
	(7339, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:19:46'),
	(7340, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:19:46'),
	(7341, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:19:46'),
	(7342, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:19:46'),
	(7343, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:19:46'),
	(7344, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:19:46'),
	(7345, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:19:46'),
	(7346, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:19:46'),
	(7347, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:19:46'),
	(7348, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:19:46'),
	(7349, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:19:46'),
	(7350, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:19:46'),
	(7351, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:19:46'),
	(7352, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:19:46'),
	(7353, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:19:46'),
	(7354, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:19:46'),
	(7355, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:19:46'),
	(7356, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:19:46'),
	(7357, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:19:46'),
	(7358, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:19:46'),
	(7359, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:19:46'),
	(7360, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:19:46'),
	(7361, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:22:43'),
	(7362, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:22:43'),
	(7363, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:22:43'),
	(7364, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:22:43'),
	(7365, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:22:43'),
	(7366, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:22:43'),
	(7367, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:22:43'),
	(7368, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:22:43'),
	(7369, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:22:43'),
	(7370, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:22:43'),
	(7371, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:22:43'),
	(7372, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:22:43'),
	(7373, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:22:43'),
	(7374, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:22:43'),
	(7375, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:22:43'),
	(7376, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:22:43'),
	(7377, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:22:43'),
	(7378, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:22:43'),
	(7379, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:22:43'),
	(7380, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:22:43'),
	(7381, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:22:43'),
	(7382, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:22:43'),
	(7383, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:22:43'),
	(7384, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:23:19'),
	(7385, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:23:19'),
	(7386, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:23:19'),
	(7387, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:23:19'),
	(7388, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:23:19'),
	(7389, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:23:19'),
	(7390, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:23:19'),
	(7391, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:23:19'),
	(7392, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:23:19'),
	(7393, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:23:19'),
	(7394, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:23:19'),
	(7395, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:23:19'),
	(7396, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:23:19'),
	(7397, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:23:19'),
	(7398, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:23:19'),
	(7399, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:23:19'),
	(7400, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:23:19'),
	(7401, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:23:19'),
	(7402, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:23:19'),
	(7403, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:23:19'),
	(7404, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:23:19'),
	(7405, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:23:19'),
	(7406, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:23:19'),
	(7407, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:28:20'),
	(7408, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:28:20'),
	(7409, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:28:20'),
	(7410, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:28:20'),
	(7411, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:28:20'),
	(7412, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:28:20'),
	(7413, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:28:20'),
	(7414, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:28:20'),
	(7415, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:28:20'),
	(7416, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:28:20'),
	(7417, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:28:20'),
	(7418, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:28:20'),
	(7419, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:28:20'),
	(7420, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:28:20'),
	(7421, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:28:20'),
	(7422, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:28:20'),
	(7423, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:28:20'),
	(7424, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:28:20'),
	(7425, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:28:20'),
	(7426, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:28:20'),
	(7427, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:28:20'),
	(7428, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:28:20'),
	(7429, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:28:20'),
	(7430, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:30:55'),
	(7431, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:30:55'),
	(7432, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:30:55'),
	(7433, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:30:55'),
	(7434, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:30:55'),
	(7435, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:30:55'),
	(7436, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:30:55'),
	(7437, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:30:55'),
	(7438, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:30:55'),
	(7439, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:30:55'),
	(7440, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:30:55'),
	(7441, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:30:55'),
	(7442, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:30:55'),
	(7443, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:30:55'),
	(7444, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:30:55'),
	(7445, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:30:55'),
	(7446, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:30:55'),
	(7447, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:30:55'),
	(7448, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:30:55'),
	(7449, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:30:55'),
	(7450, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:30:55'),
	(7451, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:30:55'),
	(7452, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:30:55'),
	(7453, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:32:46'),
	(7454, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:32:46'),
	(7455, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:32:46'),
	(7456, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:32:46'),
	(7457, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:32:46'),
	(7458, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:32:46'),
	(7459, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:32:46'),
	(7460, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:32:46'),
	(7461, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:32:46'),
	(7462, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:32:46'),
	(7463, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:32:46'),
	(7464, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:32:46'),
	(7465, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:32:46'),
	(7466, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:32:46'),
	(7467, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:32:46'),
	(7468, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:32:46'),
	(7469, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:32:46'),
	(7470, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:32:46'),
	(7471, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:32:46'),
	(7472, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:32:46'),
	(7473, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:32:46'),
	(7474, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:32:46'),
	(7475, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:32:46'),
	(7476, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:41:40'),
	(7477, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:41:40'),
	(7478, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:41:40'),
	(7479, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:41:40'),
	(7480, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:41:40'),
	(7481, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:41:40'),
	(7482, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:41:40'),
	(7483, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:41:40'),
	(7484, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:41:40'),
	(7485, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:41:40'),
	(7486, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:41:40'),
	(7487, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:41:40'),
	(7488, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:41:40'),
	(7489, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:41:40'),
	(7490, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:41:40'),
	(7491, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:41:40'),
	(7492, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:41:40'),
	(7493, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:41:40'),
	(7494, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:41:40'),
	(7495, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:41:40'),
	(7496, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:41:40'),
	(7497, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:41:40'),
	(7498, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:41:40'),
	(7499, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:43:49'),
	(7500, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:43:49'),
	(7501, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:43:49'),
	(7502, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:43:49'),
	(7503, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:43:49'),
	(7504, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:43:49'),
	(7505, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:43:49'),
	(7506, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:43:49'),
	(7507, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:43:49'),
	(7508, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:43:49'),
	(7509, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:43:49'),
	(7510, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:43:49'),
	(7511, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:43:49'),
	(7512, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:43:49'),
	(7513, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:43:49'),
	(7514, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:43:49'),
	(7515, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:43:49'),
	(7516, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:43:49'),
	(7517, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:43:49'),
	(7518, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:43:49'),
	(7519, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:43:49'),
	(7520, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:43:49'),
	(7521, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:43:49'),
	(7522, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:45:18'),
	(7523, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:45:18'),
	(7524, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:45:18'),
	(7525, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:45:18'),
	(7526, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:45:18'),
	(7527, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:45:18'),
	(7528, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:45:18'),
	(7529, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:45:18'),
	(7530, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:45:18'),
	(7531, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:45:18'),
	(7532, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:45:18'),
	(7533, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:45:18'),
	(7534, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:45:18'),
	(7535, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:45:18'),
	(7536, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:45:18'),
	(7537, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:45:18'),
	(7538, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:45:18'),
	(7539, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:45:18'),
	(7540, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:45:18'),
	(7541, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:45:18'),
	(7542, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:45:18'),
	(7543, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:45:18'),
	(7544, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:45:18'),
	(7545, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:46:53'),
	(7546, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:46:53'),
	(7547, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:46:53'),
	(7548, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:46:53'),
	(7549, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:46:53'),
	(7550, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:46:53'),
	(7551, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:46:53'),
	(7552, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:46:53'),
	(7553, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:46:53'),
	(7554, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:46:53'),
	(7555, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:46:53'),
	(7556, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:46:53'),
	(7557, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:46:53'),
	(7558, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:46:53'),
	(7559, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:46:53'),
	(7560, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:46:53'),
	(7561, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:46:53'),
	(7562, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:46:53'),
	(7563, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:46:53'),
	(7564, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:46:53'),
	(7565, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:46:53'),
	(7566, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:46:53'),
	(7567, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:46:53'),
	(7568, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:48:37'),
	(7569, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:48:37'),
	(7570, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:48:37'),
	(7571, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:48:37'),
	(7572, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:48:37'),
	(7573, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:48:37'),
	(7574, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:48:37'),
	(7575, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:48:37'),
	(7576, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:48:37'),
	(7577, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:48:37'),
	(7578, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:48:37'),
	(7579, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:48:37'),
	(7580, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:48:37'),
	(7581, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:48:37'),
	(7582, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:48:37'),
	(7583, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:48:37'),
	(7584, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:48:37'),
	(7585, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:48:37'),
	(7586, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:48:37'),
	(7587, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:48:37'),
	(7588, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:48:37'),
	(7589, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:48:37'),
	(7590, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:48:37'),
	(7591, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 17:50:24'),
	(7592, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 17:50:24'),
	(7593, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 17:50:24'),
	(7594, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 17:50:24'),
	(7595, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 17:50:24'),
	(7596, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 17:50:24'),
	(7597, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 17:50:24'),
	(7598, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 17:50:24'),
	(7599, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 17:50:24'),
	(7600, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 17:50:24'),
	(7601, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 17:50:24'),
	(7602, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 17:50:24'),
	(7603, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 17:50:24'),
	(7604, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 17:50:24'),
	(7605, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 17:50:24'),
	(7606, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 17:50:24'),
	(7607, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 17:50:24'),
	(7608, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 17:50:24'),
	(7609, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 17:50:24'),
	(7610, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 17:50:24'),
	(7611, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 17:50:24'),
	(7612, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 17:50:24'),
	(7613, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 17:50:24'),
	(7614, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:02:24'),
	(7615, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:02:24'),
	(7616, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:02:24'),
	(7617, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:02:24'),
	(7618, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:02:24'),
	(7619, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:02:24'),
	(7620, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:02:24'),
	(7621, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:02:24'),
	(7622, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:02:24'),
	(7623, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:02:24'),
	(7624, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:02:24'),
	(7625, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:02:24'),
	(7626, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:02:24'),
	(7627, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:02:24'),
	(7628, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:02:24'),
	(7629, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:02:24'),
	(7630, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:02:24'),
	(7631, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:02:24'),
	(7632, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:02:24'),
	(7633, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:02:24'),
	(7634, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:02:24'),
	(7635, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:02:24'),
	(7636, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:02:24'),
	(7637, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:07:19'),
	(7638, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:07:19'),
	(7639, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:07:19'),
	(7640, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:07:19'),
	(7641, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:07:19'),
	(7642, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:07:19'),
	(7643, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:07:19'),
	(7644, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:07:19'),
	(7645, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:07:19'),
	(7646, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:07:19'),
	(7647, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:07:19'),
	(7648, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:07:19'),
	(7649, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:07:19'),
	(7650, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:07:19'),
	(7651, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:07:19'),
	(7652, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:07:19'),
	(7653, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:07:19'),
	(7654, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:07:19'),
	(7655, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:07:19'),
	(7656, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:07:19'),
	(7657, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:07:19'),
	(7658, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:07:19'),
	(7659, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:07:19'),
	(7660, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:23:07'),
	(7661, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:23:07'),
	(7662, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:23:07'),
	(7663, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:23:07'),
	(7664, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:23:07'),
	(7665, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:23:07'),
	(7666, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:23:07'),
	(7667, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:23:07'),
	(7668, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:23:07'),
	(7669, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:23:07'),
	(7670, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:23:07'),
	(7671, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:23:07'),
	(7672, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:23:07'),
	(7673, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:23:07'),
	(7674, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:23:07'),
	(7675, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:23:07'),
	(7676, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:23:07'),
	(7677, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:23:07'),
	(7678, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:23:07'),
	(7679, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:23:07'),
	(7680, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:23:07'),
	(7681, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:23:07'),
	(7682, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:23:07'),
	(7683, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:26:44'),
	(7684, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:26:44'),
	(7685, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:26:44'),
	(7686, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:26:44'),
	(7687, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:26:44'),
	(7688, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:26:44'),
	(7689, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:26:44'),
	(7690, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:26:44'),
	(7691, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:26:44'),
	(7692, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:26:44'),
	(7693, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:26:44'),
	(7694, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:26:44'),
	(7695, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:26:44'),
	(7696, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:26:44'),
	(7697, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:26:44'),
	(7698, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:26:44'),
	(7699, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:26:44'),
	(7700, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:26:44'),
	(7701, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:26:44'),
	(7702, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:26:44'),
	(7703, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:26:44'),
	(7704, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:26:44'),
	(7705, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:26:44'),
	(7706, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:29:25'),
	(7707, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:29:25'),
	(7708, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:29:25'),
	(7709, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:29:25'),
	(7710, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:29:25'),
	(7711, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:29:25'),
	(7712, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:29:25'),
	(7713, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:29:25'),
	(7714, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:29:25'),
	(7715, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:29:25'),
	(7716, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:29:25'),
	(7717, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:29:25'),
	(7718, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:29:25'),
	(7719, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:29:25'),
	(7720, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:29:25'),
	(7721, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:29:25'),
	(7722, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:29:25'),
	(7723, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:29:25'),
	(7724, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:29:25'),
	(7725, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:29:25'),
	(7726, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:29:25'),
	(7727, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:29:25'),
	(7728, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:29:25'),
	(7729, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:31:56'),
	(7730, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:31:56'),
	(7731, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:31:56'),
	(7732, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:31:56'),
	(7733, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:31:56'),
	(7734, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:31:56'),
	(7735, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:31:56'),
	(7736, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:31:56'),
	(7737, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:31:56'),
	(7738, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:31:56'),
	(7739, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:31:56'),
	(7740, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:31:56'),
	(7741, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:31:56'),
	(7742, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:31:56'),
	(7743, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:31:56'),
	(7744, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:31:56'),
	(7745, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:31:56'),
	(7746, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:31:56'),
	(7747, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:31:56'),
	(7748, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:31:56'),
	(7749, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:31:56'),
	(7750, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:31:56'),
	(7751, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:31:56'),
	(7752, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:33:57'),
	(7753, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:33:57'),
	(7754, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:33:57'),
	(7755, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:33:57'),
	(7756, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:33:57'),
	(7757, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:33:57'),
	(7758, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:33:57'),
	(7759, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:33:57'),
	(7760, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:33:57'),
	(7761, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:33:57'),
	(7762, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:33:57'),
	(7763, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:33:57'),
	(7764, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:33:57'),
	(7765, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:33:57'),
	(7766, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:33:57'),
	(7767, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:33:57'),
	(7768, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:33:57'),
	(7769, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:33:58'),
	(7770, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:33:58'),
	(7771, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:33:58'),
	(7772, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:33:58'),
	(7773, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:33:58'),
	(7774, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:33:58'),
	(7775, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:36:46'),
	(7776, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:36:46'),
	(7777, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:36:46'),
	(7778, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:36:46'),
	(7779, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:36:46'),
	(7780, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:36:46'),
	(7781, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:36:46'),
	(7782, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:36:46'),
	(7783, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:36:46'),
	(7784, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:36:46'),
	(7785, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:36:46'),
	(7786, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:36:46'),
	(7787, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:36:46'),
	(7788, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:36:46'),
	(7789, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:36:46'),
	(7790, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:36:46'),
	(7791, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:36:46'),
	(7792, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:36:46'),
	(7793, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:36:46'),
	(7794, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:36:46'),
	(7795, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:36:46'),
	(7796, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:36:46'),
	(7797, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:36:46'),
	(7798, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:39:43'),
	(7799, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:39:43'),
	(7800, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:39:43'),
	(7801, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:39:43'),
	(7802, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:39:43'),
	(7803, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:39:43'),
	(7804, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:39:43'),
	(7805, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:39:43'),
	(7806, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:39:43'),
	(7807, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:39:43'),
	(7808, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:39:43'),
	(7809, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:39:43'),
	(7810, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:39:43'),
	(7811, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:39:43'),
	(7812, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:39:43'),
	(7813, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:39:43'),
	(7814, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:39:43'),
	(7815, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:39:43'),
	(7816, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:39:43'),
	(7817, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:39:43'),
	(7818, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:39:43'),
	(7819, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:39:43'),
	(7820, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:39:43'),
	(7821, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:42:14'),
	(7822, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:42:14'),
	(7823, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:42:14'),
	(7824, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:42:14'),
	(7825, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:42:14'),
	(7826, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:42:14'),
	(7827, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:42:14'),
	(7828, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:42:14'),
	(7829, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:42:14'),
	(7830, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:42:14'),
	(7831, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:42:14'),
	(7832, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:42:14'),
	(7833, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:42:14'),
	(7834, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:42:14'),
	(7835, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:42:14'),
	(7836, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:42:14'),
	(7837, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:42:14'),
	(7838, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:42:14'),
	(7839, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:42:14'),
	(7840, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:42:14'),
	(7841, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:42:14'),
	(7842, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:42:14'),
	(7843, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:42:14'),
	(7844, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:44:00'),
	(7845, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:44:00'),
	(7846, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:44:00'),
	(7847, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:44:00'),
	(7848, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:44:00'),
	(7849, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:44:00'),
	(7850, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:44:00'),
	(7851, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:44:00'),
	(7852, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:44:00'),
	(7853, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:44:00'),
	(7854, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:44:00'),
	(7855, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:44:00'),
	(7856, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:44:00'),
	(7857, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:44:00'),
	(7858, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:44:00'),
	(7859, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:44:00'),
	(7860, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:44:00'),
	(7861, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:44:00'),
	(7862, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:44:00'),
	(7863, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:44:00'),
	(7864, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:44:00'),
	(7865, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:44:00'),
	(7866, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:44:00'),
	(7867, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:46:24'),
	(7868, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:46:24'),
	(7869, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:46:24'),
	(7870, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:46:24'),
	(7871, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:46:24'),
	(7872, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:46:24'),
	(7873, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:46:24'),
	(7874, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:46:24'),
	(7875, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:46:24'),
	(7876, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:46:24'),
	(7877, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:46:24'),
	(7878, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:46:24'),
	(7879, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:46:24'),
	(7880, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:46:24'),
	(7881, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:46:24'),
	(7882, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:46:24'),
	(7883, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:46:24'),
	(7884, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:46:24'),
	(7885, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:46:24'),
	(7886, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:46:24'),
	(7887, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:46:24'),
	(7888, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:46:24'),
	(7889, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:46:24'),
	(7890, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:51:43'),
	(7891, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:51:43'),
	(7892, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:51:43'),
	(7893, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:51:43'),
	(7894, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:51:43'),
	(7895, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:51:43'),
	(7896, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:51:43'),
	(7897, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:51:43'),
	(7898, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:51:43'),
	(7899, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:51:43'),
	(7900, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:51:43'),
	(7901, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:51:43'),
	(7902, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:51:43'),
	(7903, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:51:43'),
	(7904, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:51:43'),
	(7905, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:51:43'),
	(7906, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:51:43'),
	(7907, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:51:43'),
	(7908, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:51:43'),
	(7909, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:51:43'),
	(7910, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:51:43'),
	(7911, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:51:43'),
	(7912, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:51:43'),
	(7913, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:53:11'),
	(7914, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:53:11'),
	(7915, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:53:11'),
	(7916, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:53:11'),
	(7917, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:53:11'),
	(7918, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:53:11'),
	(7919, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:53:11'),
	(7920, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:53:11'),
	(7921, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:53:11'),
	(7922, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:53:11'),
	(7923, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:53:11'),
	(7924, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:53:11'),
	(7925, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:53:11'),
	(7926, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:53:11'),
	(7927, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:53:11'),
	(7928, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:53:11'),
	(7929, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:53:11'),
	(7930, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:53:11'),
	(7931, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:53:11'),
	(7932, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:53:11'),
	(7933, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:53:11'),
	(7934, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:53:11'),
	(7935, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:53:11'),
	(7936, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:57:01'),
	(7937, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:57:01'),
	(7938, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:57:01'),
	(7939, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:57:01'),
	(7940, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:57:01'),
	(7941, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:57:01'),
	(7942, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:57:01'),
	(7943, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:57:01'),
	(7944, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:57:01'),
	(7945, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:57:01'),
	(7946, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:57:01'),
	(7947, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:57:01'),
	(7948, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:57:01'),
	(7949, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:57:01'),
	(7950, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:57:01'),
	(7951, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:57:01'),
	(7952, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:57:01'),
	(7953, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:57:01'),
	(7954, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:57:01'),
	(7955, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:57:01'),
	(7956, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:57:01'),
	(7957, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:57:01'),
	(7958, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:57:01'),
	(7959, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:58:40'),
	(7960, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:58:40'),
	(7961, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:58:40'),
	(7962, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:58:40'),
	(7963, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:58:40'),
	(7964, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:58:40'),
	(7965, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:58:40'),
	(7966, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:58:40'),
	(7967, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:58:40'),
	(7968, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:58:40'),
	(7969, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:58:40'),
	(7970, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:58:40'),
	(7971, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:58:40'),
	(7972, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:58:40'),
	(7973, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:58:40'),
	(7974, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:58:40'),
	(7975, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:58:40'),
	(7976, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:58:40'),
	(7977, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:58:40'),
	(7978, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:58:40'),
	(7979, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:58:40'),
	(7980, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:58:40'),
	(7981, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:58:40'),
	(7982, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 18:59:37'),
	(7983, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 18:59:37'),
	(7984, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 18:59:37'),
	(7985, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 18:59:37'),
	(7986, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 18:59:37'),
	(7987, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 18:59:37'),
	(7988, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 18:59:37'),
	(7989, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 18:59:37'),
	(7990, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 18:59:37'),
	(7991, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 18:59:37'),
	(7992, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 18:59:37'),
	(7993, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 18:59:37'),
	(7994, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 18:59:37'),
	(7995, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 18:59:37'),
	(7996, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 18:59:37'),
	(7997, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 18:59:37'),
	(7998, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 18:59:37'),
	(7999, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 18:59:37'),
	(8000, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 18:59:37'),
	(8001, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 18:59:37'),
	(8002, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 18:59:37'),
	(8003, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 18:59:37'),
	(8004, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 18:59:37'),
	(8005, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 21:46:44'),
	(8006, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 21:46:44'),
	(8007, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 21:46:44'),
	(8008, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 21:46:44'),
	(8009, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 21:46:44'),
	(8010, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 21:46:44'),
	(8011, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 21:46:44'),
	(8012, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 21:46:44'),
	(8013, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 21:46:44'),
	(8014, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 21:46:44'),
	(8015, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 21:46:44'),
	(8016, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 21:46:44'),
	(8017, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 21:46:44'),
	(8018, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 21:46:44'),
	(8019, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 21:46:44'),
	(8020, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 21:46:44'),
	(8021, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 21:46:44'),
	(8022, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 21:46:44'),
	(8023, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 21:46:44'),
	(8024, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 21:46:44'),
	(8025, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 21:46:44'),
	(8026, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 21:46:44'),
	(8027, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 21:46:44'),
	(8028, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 21:51:09'),
	(8029, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 21:51:09'),
	(8030, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 21:51:09'),
	(8031, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 21:51:09'),
	(8032, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 21:51:09'),
	(8033, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 21:51:09'),
	(8034, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 21:51:09'),
	(8035, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 21:51:09'),
	(8036, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 21:51:09'),
	(8037, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 21:51:09'),
	(8038, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 21:51:09'),
	(8039, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 21:51:09'),
	(8040, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 21:51:09'),
	(8041, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 21:51:09'),
	(8042, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 21:51:09'),
	(8043, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 21:51:09'),
	(8044, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 21:51:09'),
	(8045, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 21:51:09'),
	(8046, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 21:51:09'),
	(8047, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 21:51:09'),
	(8048, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 21:51:09'),
	(8049, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 21:51:09'),
	(8050, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 21:51:09'),
	(8051, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 21:53:42'),
	(8052, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 21:53:42'),
	(8053, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 21:53:42'),
	(8054, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 21:53:42'),
	(8055, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 21:53:42'),
	(8056, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 21:53:42'),
	(8057, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 21:53:42'),
	(8058, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 21:53:42'),
	(8059, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 21:53:42'),
	(8060, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 21:53:42'),
	(8061, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 21:53:42'),
	(8062, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 21:53:42'),
	(8063, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 21:53:42'),
	(8064, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 21:53:42'),
	(8065, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 21:53:42'),
	(8066, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 21:53:42'),
	(8067, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 21:53:42'),
	(8068, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 21:53:42'),
	(8069, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 21:53:42'),
	(8070, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 21:53:42'),
	(8071, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 21:53:42'),
	(8072, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 21:53:42'),
	(8073, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 21:53:42'),
	(8074, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 21:59:28'),
	(8075, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 21:59:28'),
	(8076, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 21:59:28'),
	(8077, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 21:59:28'),
	(8078, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 21:59:28'),
	(8079, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 21:59:28'),
	(8080, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 21:59:28'),
	(8081, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 21:59:28'),
	(8082, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 21:59:28'),
	(8083, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 21:59:28'),
	(8084, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 21:59:28'),
	(8085, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 21:59:28'),
	(8086, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 21:59:28'),
	(8087, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 21:59:28'),
	(8088, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 21:59:28'),
	(8089, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 21:59:28'),
	(8090, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 21:59:28'),
	(8091, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 21:59:28'),
	(8092, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 21:59:28'),
	(8093, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 21:59:28'),
	(8094, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 21:59:28'),
	(8095, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 21:59:28'),
	(8096, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 21:59:28'),
	(8097, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:03:42'),
	(8098, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:03:42'),
	(8099, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:03:42'),
	(8100, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:03:42'),
	(8101, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:03:42'),
	(8102, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:03:42'),
	(8103, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:03:42'),
	(8104, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:03:42'),
	(8105, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:03:42'),
	(8106, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:03:42'),
	(8107, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:03:42'),
	(8108, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:03:42'),
	(8109, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:03:42'),
	(8110, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:03:42'),
	(8111, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:03:42'),
	(8112, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:03:42'),
	(8113, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:03:42'),
	(8114, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:03:42'),
	(8115, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:03:42'),
	(8116, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:03:42'),
	(8117, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:03:42'),
	(8118, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:03:42'),
	(8119, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:03:42'),
	(8120, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:05:35'),
	(8121, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:05:35'),
	(8122, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:05:35'),
	(8123, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:05:35'),
	(8124, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:05:35'),
	(8125, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:05:35'),
	(8126, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:05:35'),
	(8127, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:05:35'),
	(8128, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:05:35'),
	(8129, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:05:35'),
	(8130, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:05:35'),
	(8131, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:05:35'),
	(8132, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:05:35'),
	(8133, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:05:35'),
	(8134, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:05:35'),
	(8135, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:05:35'),
	(8136, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:05:35'),
	(8137, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:05:35'),
	(8138, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:05:35'),
	(8139, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:05:35'),
	(8140, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:05:35'),
	(8141, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:05:35'),
	(8142, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:05:35'),
	(8143, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:07:26'),
	(8144, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:07:26'),
	(8145, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:07:26'),
	(8146, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:07:26'),
	(8147, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:07:26'),
	(8148, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:07:26'),
	(8149, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:07:26'),
	(8150, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:07:26'),
	(8151, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:07:26'),
	(8152, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:07:26'),
	(8153, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:07:26'),
	(8154, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:07:26'),
	(8155, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:07:26'),
	(8156, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:07:26'),
	(8157, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:07:26'),
	(8158, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:07:26'),
	(8159, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:07:26'),
	(8160, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:07:26'),
	(8161, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:07:26'),
	(8162, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:07:26'),
	(8163, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:07:26'),
	(8164, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:07:26'),
	(8165, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:07:26'),
	(8166, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:09:03'),
	(8167, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:09:03'),
	(8168, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:09:03'),
	(8169, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:09:03'),
	(8170, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:09:03'),
	(8171, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:09:03'),
	(8172, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:09:03'),
	(8173, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:09:03'),
	(8174, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:09:03'),
	(8175, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:09:03'),
	(8176, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:09:03'),
	(8177, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:09:03'),
	(8178, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:09:03'),
	(8179, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:09:03'),
	(8180, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:09:03'),
	(8181, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:09:03'),
	(8182, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:09:03'),
	(8183, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:09:03'),
	(8184, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:09:03'),
	(8185, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:09:03'),
	(8186, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:09:03'),
	(8187, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:09:03'),
	(8188, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:09:03'),
	(8189, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:10:33'),
	(8190, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:10:33'),
	(8191, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:10:33'),
	(8192, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:10:33'),
	(8193, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:10:33'),
	(8194, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:10:33'),
	(8195, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:10:33'),
	(8196, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:10:33'),
	(8197, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:10:33'),
	(8198, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:10:33'),
	(8199, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:10:33'),
	(8200, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:10:33'),
	(8201, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:10:33'),
	(8202, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:10:33'),
	(8203, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:10:33'),
	(8204, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:10:33'),
	(8205, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:10:33'),
	(8206, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:10:33'),
	(8207, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:10:33'),
	(8208, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:10:33'),
	(8209, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:10:33'),
	(8210, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:10:33'),
	(8211, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:10:33'),
	(8212, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:12:52'),
	(8213, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:12:52'),
	(8214, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:12:52'),
	(8215, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:12:52'),
	(8216, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:12:52'),
	(8217, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:12:52'),
	(8218, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:12:52'),
	(8219, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:12:52'),
	(8220, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:12:52'),
	(8221, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:12:52'),
	(8222, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:12:52'),
	(8223, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:12:52'),
	(8224, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:12:52'),
	(8225, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:12:52'),
	(8226, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:12:52'),
	(8227, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:12:52'),
	(8228, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:12:52'),
	(8229, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:12:52'),
	(8230, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:12:52'),
	(8231, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:12:52'),
	(8232, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:12:52'),
	(8233, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:12:52'),
	(8234, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:12:52'),
	(8235, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:13:48'),
	(8236, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:13:48'),
	(8237, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:13:48'),
	(8238, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:13:48'),
	(8239, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:13:48'),
	(8240, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:13:48'),
	(8241, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:13:48'),
	(8242, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:13:48'),
	(8243, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:13:48'),
	(8244, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:13:48'),
	(8245, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:13:48'),
	(8246, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:13:48'),
	(8247, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:13:48'),
	(8248, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:13:48'),
	(8249, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:13:48'),
	(8250, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:13:48'),
	(8251, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:13:48'),
	(8252, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:13:48'),
	(8253, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:13:48'),
	(8254, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:13:48'),
	(8255, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:13:48'),
	(8256, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:13:48'),
	(8257, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:13:48'),
	(8258, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:15:44'),
	(8259, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:15:44'),
	(8260, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:15:44'),
	(8261, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:15:44'),
	(8262, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:15:44'),
	(8263, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:15:44'),
	(8264, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:15:44'),
	(8265, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:15:44'),
	(8266, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:15:44'),
	(8267, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:15:44'),
	(8268, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:15:44'),
	(8269, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:15:44'),
	(8270, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:15:44'),
	(8271, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:15:44'),
	(8272, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:15:44'),
	(8273, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:15:44'),
	(8274, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:15:44'),
	(8275, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:15:44'),
	(8276, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:15:44'),
	(8277, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:15:44'),
	(8278, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:15:44'),
	(8279, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:15:44'),
	(8280, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:15:44'),
	(8281, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:16:58'),
	(8282, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:16:58'),
	(8283, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:16:58'),
	(8284, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:16:58'),
	(8285, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:16:58'),
	(8286, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:16:58'),
	(8287, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:16:58'),
	(8288, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:16:58'),
	(8289, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:16:58'),
	(8290, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:16:58'),
	(8291, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:16:58'),
	(8292, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:16:58'),
	(8293, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:16:58'),
	(8294, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:16:58'),
	(8295, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:16:58'),
	(8296, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:16:58'),
	(8297, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:16:58'),
	(8298, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:16:58'),
	(8299, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:16:58'),
	(8300, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:16:58'),
	(8301, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:16:58'),
	(8302, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:16:58'),
	(8303, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:16:58'),
	(8304, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:20:49'),
	(8305, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:20:49'),
	(8306, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:20:49'),
	(8307, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:20:49'),
	(8308, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:20:49'),
	(8309, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:20:49'),
	(8310, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:20:49'),
	(8311, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:20:49'),
	(8312, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:20:49'),
	(8313, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:20:49'),
	(8314, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:20:49'),
	(8315, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:20:49'),
	(8316, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:20:49'),
	(8317, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:20:49'),
	(8318, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:20:49'),
	(8319, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:20:49'),
	(8320, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:20:49'),
	(8321, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:20:49'),
	(8322, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:20:49'),
	(8323, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:20:49'),
	(8324, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:20:49'),
	(8325, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:20:49'),
	(8326, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:20:49'),
	(8327, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:20:59'),
	(8328, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:20:59'),
	(8329, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:20:59'),
	(8330, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:20:59'),
	(8331, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:20:59'),
	(8332, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:20:59'),
	(8333, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:20:59'),
	(8334, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:20:59'),
	(8335, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:20:59'),
	(8336, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:20:59'),
	(8337, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:20:59'),
	(8338, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:20:59'),
	(8339, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:20:59'),
	(8340, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:20:59'),
	(8341, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:20:59'),
	(8342, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:20:59'),
	(8343, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:20:59'),
	(8344, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:20:59'),
	(8345, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:20:59'),
	(8346, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:20:59'),
	(8347, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:20:59'),
	(8348, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:20:59'),
	(8349, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:20:59'),
	(8350, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:22:51'),
	(8351, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:22:51'),
	(8352, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:22:51'),
	(8353, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:22:51'),
	(8354, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:22:51'),
	(8355, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:22:51'),
	(8356, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:22:51'),
	(8357, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:22:51'),
	(8358, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:22:51'),
	(8359, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:22:51'),
	(8360, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:22:51'),
	(8361, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:22:51'),
	(8362, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:22:51'),
	(8363, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:22:51'),
	(8364, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:22:51'),
	(8365, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:22:51'),
	(8366, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:22:51'),
	(8367, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:22:51'),
	(8368, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:22:51'),
	(8369, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:22:51'),
	(8370, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:22:51'),
	(8371, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:22:51'),
	(8372, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:22:51'),
	(8373, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:23:49'),
	(8374, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:23:49'),
	(8375, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:23:49'),
	(8376, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:23:49'),
	(8377, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:23:49'),
	(8378, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:23:49'),
	(8379, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:23:49'),
	(8380, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:23:49'),
	(8381, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:23:49'),
	(8382, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:23:49'),
	(8383, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:23:49'),
	(8384, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:23:49'),
	(8385, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:23:49'),
	(8386, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:23:49'),
	(8387, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:23:49'),
	(8388, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:23:49'),
	(8389, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:23:49'),
	(8390, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:23:49'),
	(8391, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:23:49'),
	(8392, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:23:49'),
	(8393, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:23:49'),
	(8394, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:23:49'),
	(8395, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:23:49'),
	(8396, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:24:34'),
	(8397, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:24:34'),
	(8398, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:24:34'),
	(8399, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:24:34'),
	(8400, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:24:34'),
	(8401, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:24:34'),
	(8402, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:24:34'),
	(8403, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:24:34'),
	(8404, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:24:34'),
	(8405, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:24:34'),
	(8406, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:24:34'),
	(8407, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:24:34'),
	(8408, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:24:34'),
	(8409, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:24:34'),
	(8410, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:24:34'),
	(8411, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:24:34'),
	(8412, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:24:34'),
	(8413, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:24:34'),
	(8414, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:24:34'),
	(8415, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:24:34'),
	(8416, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:24:34'),
	(8417, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:24:34'),
	(8418, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:24:34'),
	(8419, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:27:07'),
	(8420, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:27:07'),
	(8421, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:27:07'),
	(8422, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:27:07'),
	(8423, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:27:07'),
	(8424, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:27:07'),
	(8425, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:27:07'),
	(8426, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:27:07'),
	(8427, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:27:07'),
	(8428, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:27:07'),
	(8429, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:27:07'),
	(8430, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:27:07'),
	(8431, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:27:07'),
	(8432, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:27:07'),
	(8433, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:27:07'),
	(8434, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:27:07'),
	(8435, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:27:07'),
	(8436, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:27:07'),
	(8437, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:27:07'),
	(8438, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:27:07'),
	(8439, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:27:07'),
	(8440, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:27:07'),
	(8441, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:27:07'),
	(8442, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:28:44'),
	(8443, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:28:44'),
	(8444, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:28:44'),
	(8445, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:28:44'),
	(8446, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:28:44'),
	(8447, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:28:44'),
	(8448, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:28:44'),
	(8449, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:28:44'),
	(8450, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:28:44'),
	(8451, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:28:44'),
	(8452, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:28:44'),
	(8453, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:28:44'),
	(8454, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:28:44'),
	(8455, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:28:44'),
	(8456, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:28:44'),
	(8457, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:28:44'),
	(8458, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:28:44'),
	(8459, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:28:44'),
	(8460, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:28:44'),
	(8461, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:28:44'),
	(8462, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:28:44'),
	(8463, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:28:44'),
	(8464, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:28:44'),
	(8465, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:30:29'),
	(8466, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:30:29'),
	(8467, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:30:29'),
	(8468, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:30:29'),
	(8469, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:30:29'),
	(8470, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:30:29'),
	(8471, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:30:29'),
	(8472, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:30:29'),
	(8473, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:30:29'),
	(8474, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:30:29'),
	(8475, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:30:29'),
	(8476, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:30:29'),
	(8477, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:30:29'),
	(8478, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:30:29'),
	(8479, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:30:29'),
	(8480, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:30:29'),
	(8481, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:30:29'),
	(8482, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:30:29'),
	(8483, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:30:29'),
	(8484, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:30:29'),
	(8485, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:30:29'),
	(8486, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:30:29'),
	(8487, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:30:29'),
	(8488, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:32:31'),
	(8489, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:32:31'),
	(8490, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:32:31'),
	(8491, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:32:31'),
	(8492, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:32:31'),
	(8493, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:32:31'),
	(8494, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:32:31'),
	(8495, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:32:31'),
	(8496, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:32:31'),
	(8497, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:32:31'),
	(8498, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:32:31'),
	(8499, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:32:31'),
	(8500, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:32:31'),
	(8501, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:32:31'),
	(8502, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:32:31'),
	(8503, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:32:31'),
	(8504, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:32:31'),
	(8505, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:32:31'),
	(8506, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:32:31'),
	(8507, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:32:31'),
	(8508, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:32:31'),
	(8509, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:32:31'),
	(8510, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:32:31'),
	(8511, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:45:51'),
	(8512, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:45:51'),
	(8513, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:45:51'),
	(8514, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:45:51'),
	(8515, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:45:51'),
	(8516, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:45:51'),
	(8517, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:45:51'),
	(8518, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:45:51'),
	(8519, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:45:51'),
	(8520, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:45:51'),
	(8521, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:45:51'),
	(8522, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:45:51'),
	(8523, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:45:51'),
	(8524, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:45:51'),
	(8525, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:45:51'),
	(8526, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:45:51'),
	(8527, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:45:51'),
	(8528, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:45:51'),
	(8529, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:45:51'),
	(8530, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:45:51'),
	(8531, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:45:51'),
	(8532, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:45:51'),
	(8533, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:45:51'),
	(8534, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:47:37'),
	(8535, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:47:37'),
	(8536, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:47:37'),
	(8537, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:47:37'),
	(8538, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:47:37'),
	(8539, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:47:37'),
	(8540, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:47:37'),
	(8541, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:47:37'),
	(8542, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:47:37'),
	(8543, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:47:37'),
	(8544, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:47:37'),
	(8545, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:47:37'),
	(8546, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:47:37'),
	(8547, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:47:37'),
	(8548, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:47:37'),
	(8549, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:47:37'),
	(8550, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:47:37'),
	(8551, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:47:37'),
	(8552, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:47:37'),
	(8553, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:47:37'),
	(8554, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:47:37'),
	(8555, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:47:37'),
	(8556, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:47:37'),
	(8557, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 22:56:14'),
	(8558, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 22:56:14'),
	(8559, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 22:56:14'),
	(8560, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 22:56:14'),
	(8561, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 22:56:14'),
	(8562, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 22:56:14'),
	(8563, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 22:56:14'),
	(8564, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 22:56:14'),
	(8565, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 22:56:14'),
	(8566, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 22:56:14'),
	(8567, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 22:56:14'),
	(8568, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 22:56:14'),
	(8569, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 22:56:14'),
	(8570, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 22:56:14'),
	(8571, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 22:56:14'),
	(8572, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 22:56:14'),
	(8573, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 22:56:14'),
	(8574, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 22:56:14'),
	(8575, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 22:56:14'),
	(8576, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 22:56:14'),
	(8577, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 22:56:14'),
	(8578, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 22:56:14'),
	(8579, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 22:56:14'),
	(8580, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:03:01'),
	(8581, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:03:01'),
	(8582, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:03:01'),
	(8583, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:03:01'),
	(8584, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:03:01'),
	(8585, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:03:01'),
	(8586, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:03:01'),
	(8587, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:03:01'),
	(8588, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:03:01'),
	(8589, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:03:01'),
	(8590, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:03:01'),
	(8591, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:03:01'),
	(8592, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:03:01'),
	(8593, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:03:01'),
	(8594, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:03:01'),
	(8595, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:03:01'),
	(8596, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:03:01'),
	(8597, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:03:01'),
	(8598, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:03:01'),
	(8599, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:03:01'),
	(8600, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:03:01'),
	(8601, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:03:01'),
	(8602, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:03:01'),
	(8603, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:08:15'),
	(8604, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:08:15'),
	(8605, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:08:15'),
	(8606, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:08:15'),
	(8607, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:08:15'),
	(8608, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:08:15'),
	(8609, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:08:15'),
	(8610, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:08:15'),
	(8611, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:08:15'),
	(8612, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:08:15'),
	(8613, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:08:15'),
	(8614, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:08:15'),
	(8615, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:08:15'),
	(8616, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:08:15'),
	(8617, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:08:15'),
	(8618, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:08:15'),
	(8619, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:08:15'),
	(8620, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:08:15'),
	(8621, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:08:15'),
	(8622, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:08:15'),
	(8623, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:08:15'),
	(8624, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:08:15'),
	(8625, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:08:15'),
	(8626, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:09:56'),
	(8627, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:09:56'),
	(8628, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:09:56'),
	(8629, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:09:56'),
	(8630, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:09:56'),
	(8631, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:09:56'),
	(8632, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:09:56'),
	(8633, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:09:56'),
	(8634, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:09:56'),
	(8635, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:09:56'),
	(8636, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:09:56'),
	(8637, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:09:56'),
	(8638, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:09:56'),
	(8639, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:09:56'),
	(8640, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:09:56'),
	(8641, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:09:56'),
	(8642, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:09:56'),
	(8643, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:09:56'),
	(8644, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:09:56'),
	(8645, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:09:56'),
	(8646, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:09:56'),
	(8647, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:09:56'),
	(8648, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:09:56'),
	(8649, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:14:41'),
	(8650, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:14:41'),
	(8651, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:14:41'),
	(8652, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:14:41'),
	(8653, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:14:41'),
	(8654, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:14:41'),
	(8655, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:14:41'),
	(8656, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:14:41'),
	(8657, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:14:41'),
	(8658, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:14:41'),
	(8659, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:14:41'),
	(8660, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:14:41'),
	(8661, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:14:41'),
	(8662, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:14:41'),
	(8663, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:14:41'),
	(8664, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:14:41'),
	(8665, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:14:41'),
	(8666, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:14:41'),
	(8667, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:14:41'),
	(8668, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:14:41'),
	(8669, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:14:41'),
	(8670, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:14:41'),
	(8671, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:14:41'),
	(8672, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:17:17'),
	(8673, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:17:17'),
	(8674, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:17:17'),
	(8675, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:17:17'),
	(8676, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:17:17'),
	(8677, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:17:17'),
	(8678, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:17:17'),
	(8679, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:17:17'),
	(8680, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:17:17'),
	(8681, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:17:17'),
	(8682, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:17:17'),
	(8683, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:17:17'),
	(8684, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:17:17'),
	(8685, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:17:17'),
	(8686, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:17:17'),
	(8687, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:17:17'),
	(8688, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:17:17'),
	(8689, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:17:17'),
	(8690, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:17:17'),
	(8691, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:17:17'),
	(8692, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:17:17'),
	(8693, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:17:17'),
	(8694, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:17:17'),
	(8695, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:19:04'),
	(8696, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:19:04'),
	(8697, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:19:04'),
	(8698, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:19:04'),
	(8699, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:19:04'),
	(8700, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:19:04'),
	(8701, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:19:04'),
	(8702, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:19:04'),
	(8703, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:19:04'),
	(8704, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:19:04'),
	(8705, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:19:04'),
	(8706, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:19:04'),
	(8707, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:19:04'),
	(8708, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:19:04'),
	(8709, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:19:04'),
	(8710, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:19:04'),
	(8711, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:19:04'),
	(8712, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:19:04'),
	(8713, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:19:04'),
	(8714, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:19:04'),
	(8715, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:19:04'),
	(8716, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:19:04'),
	(8717, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:19:04'),
	(8718, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:20:49'),
	(8719, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:20:49'),
	(8720, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:20:49'),
	(8721, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:20:49'),
	(8722, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:20:49'),
	(8723, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:20:49'),
	(8724, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:20:49'),
	(8725, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:20:49'),
	(8726, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:20:49'),
	(8727, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:20:49'),
	(8728, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:20:49'),
	(8729, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:20:49'),
	(8730, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:20:49'),
	(8731, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:20:49'),
	(8732, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:20:49'),
	(8733, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:20:49'),
	(8734, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:20:49'),
	(8735, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:20:49'),
	(8736, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:20:49'),
	(8737, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:20:49'),
	(8738, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:20:49'),
	(8739, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:20:49'),
	(8740, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:20:49'),
	(8741, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:23:28'),
	(8742, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:23:28'),
	(8743, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:23:28'),
	(8744, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:23:28'),
	(8745, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:23:28'),
	(8746, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:23:28'),
	(8747, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:23:28'),
	(8748, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:23:28'),
	(8749, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:23:28'),
	(8750, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:23:28'),
	(8751, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:23:28'),
	(8752, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:23:28'),
	(8753, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:23:28'),
	(8754, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:23:28'),
	(8755, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:23:28'),
	(8756, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:23:28'),
	(8757, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:23:28'),
	(8758, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:23:28'),
	(8759, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:23:28'),
	(8760, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:23:28'),
	(8761, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:23:28'),
	(8762, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:23:28'),
	(8763, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:23:28'),
	(8764, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:26:51'),
	(8765, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:26:51'),
	(8766, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:26:51'),
	(8767, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:26:51'),
	(8768, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:26:51'),
	(8769, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:26:51'),
	(8770, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:26:51'),
	(8771, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:26:51'),
	(8772, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:26:51'),
	(8773, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:26:51'),
	(8774, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:26:51'),
	(8775, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:26:51'),
	(8776, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:26:51'),
	(8777, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:26:51'),
	(8778, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:26:51'),
	(8779, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:26:51'),
	(8780, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:26:51'),
	(8781, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:26:51'),
	(8782, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:26:51'),
	(8783, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:26:51'),
	(8784, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:26:51'),
	(8785, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:26:51'),
	(8786, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:26:51'),
	(8787, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:28:42'),
	(8788, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:28:42'),
	(8789, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:28:42'),
	(8790, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:28:42'),
	(8791, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:28:42'),
	(8792, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:28:42'),
	(8793, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:28:42'),
	(8794, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:28:42'),
	(8795, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:28:42'),
	(8796, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:28:42'),
	(8797, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:28:42'),
	(8798, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:28:42'),
	(8799, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:28:42'),
	(8800, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:28:42'),
	(8801, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:28:42'),
	(8802, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:28:42'),
	(8803, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:28:42'),
	(8804, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:28:42'),
	(8805, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:28:42'),
	(8806, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:28:42'),
	(8807, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:28:42'),
	(8808, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:28:42'),
	(8809, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:28:42'),
	(8810, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:29:31'),
	(8811, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:29:31'),
	(8812, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:29:31'),
	(8813, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:29:31'),
	(8814, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:29:31'),
	(8815, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:29:31'),
	(8816, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:29:31'),
	(8817, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:29:31'),
	(8818, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:29:31'),
	(8819, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:29:31'),
	(8820, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:29:31'),
	(8821, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:29:31'),
	(8822, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:29:31'),
	(8823, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:29:31'),
	(8824, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:29:31'),
	(8825, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:29:31'),
	(8826, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:29:31'),
	(8827, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:29:31'),
	(8828, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:29:31'),
	(8829, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:29:31'),
	(8830, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:29:31'),
	(8831, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:29:31'),
	(8832, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:29:31'),
	(8833, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:29:50'),
	(8834, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:29:50'),
	(8835, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:29:50'),
	(8836, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:29:50'),
	(8837, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:29:50'),
	(8838, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:29:50'),
	(8839, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:29:50'),
	(8840, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:29:50'),
	(8841, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:29:50'),
	(8842, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:29:50'),
	(8843, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:29:50'),
	(8844, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:29:50'),
	(8845, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:29:50'),
	(8846, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:29:50'),
	(8847, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:29:50'),
	(8848, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:29:50'),
	(8849, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:29:50'),
	(8850, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:29:50'),
	(8851, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:29:50'),
	(8852, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:29:50'),
	(8853, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:29:50'),
	(8854, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:29:50'),
	(8855, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:29:50'),
	(8856, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:31:43'),
	(8857, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:31:43'),
	(8858, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:31:43'),
	(8859, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:31:43'),
	(8860, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:31:43'),
	(8861, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:31:43'),
	(8862, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:31:43'),
	(8863, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:31:43'),
	(8864, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:31:43'),
	(8865, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:31:43'),
	(8866, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:31:43'),
	(8867, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:31:43'),
	(8868, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:31:43'),
	(8869, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:31:43'),
	(8870, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:31:43'),
	(8871, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:31:43'),
	(8872, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:31:43'),
	(8873, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:31:43'),
	(8874, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:31:43'),
	(8875, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:31:43'),
	(8876, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:31:43'),
	(8877, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:31:43'),
	(8878, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:31:43'),
	(8879, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:32:30'),
	(8880, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:32:30'),
	(8881, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:32:30'),
	(8882, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:32:30'),
	(8883, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:32:30'),
	(8884, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:32:30'),
	(8885, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:32:30'),
	(8886, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:32:30'),
	(8887, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:32:30'),
	(8888, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:32:30'),
	(8889, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:32:30'),
	(8890, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:32:30'),
	(8891, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:32:30'),
	(8892, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:32:30'),
	(8893, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:32:30'),
	(8894, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:32:30'),
	(8895, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:32:30'),
	(8896, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:32:30'),
	(8897, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:32:30'),
	(8898, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:32:30'),
	(8899, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:32:30'),
	(8900, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:32:30'),
	(8901, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:32:30'),
	(8902, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:35:19'),
	(8903, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:35:19'),
	(8904, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:35:19'),
	(8905, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:35:19'),
	(8906, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:35:19'),
	(8907, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:35:19'),
	(8908, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:35:19'),
	(8909, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:35:19'),
	(8910, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:35:19'),
	(8911, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:35:19'),
	(8912, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:35:19'),
	(8913, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:35:19'),
	(8914, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:35:19'),
	(8915, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:35:19'),
	(8916, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:35:19'),
	(8917, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:35:19'),
	(8918, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:35:19'),
	(8919, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:35:19'),
	(8920, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:35:19'),
	(8921, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:35:19'),
	(8922, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:35:19'),
	(8923, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:35:19'),
	(8924, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:35:19'),
	(8925, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:36:35'),
	(8926, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:36:35'),
	(8927, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:36:35'),
	(8928, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:36:35'),
	(8929, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:36:35'),
	(8930, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:36:35'),
	(8931, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:36:35'),
	(8932, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:36:35'),
	(8933, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:36:35'),
	(8934, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:36:35'),
	(8935, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:36:35'),
	(8936, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:36:35'),
	(8937, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:36:35'),
	(8938, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:36:35'),
	(8939, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:36:35'),
	(8940, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:36:35'),
	(8941, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:36:35'),
	(8942, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:36:35'),
	(8943, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:36:35'),
	(8944, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:36:35'),
	(8945, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:36:35'),
	(8946, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:36:35'),
	(8947, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:36:35'),
	(8948, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:38:22'),
	(8949, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:38:22'),
	(8950, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:38:22'),
	(8951, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:38:22'),
	(8952, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:38:22'),
	(8953, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:38:22'),
	(8954, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:38:22'),
	(8955, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:38:22'),
	(8956, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:38:22'),
	(8957, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:38:22'),
	(8958, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:38:22'),
	(8959, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:38:22'),
	(8960, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:38:22'),
	(8961, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:38:22'),
	(8962, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:38:22'),
	(8963, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:38:22'),
	(8964, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:38:22'),
	(8965, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:38:22'),
	(8966, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:38:22'),
	(8967, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:38:22'),
	(8968, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:38:22'),
	(8969, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:38:22'),
	(8970, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:38:22'),
	(8971, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:41:16'),
	(8972, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:41:16'),
	(8973, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:41:16'),
	(8974, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:41:16'),
	(8975, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:41:16'),
	(8976, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:41:16'),
	(8977, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:41:16'),
	(8978, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:41:16'),
	(8979, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:41:16'),
	(8980, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:41:16'),
	(8981, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:41:16'),
	(8982, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:41:16'),
	(8983, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:41:16'),
	(8984, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:41:16'),
	(8985, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:41:16'),
	(8986, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:41:16'),
	(8987, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:41:16'),
	(8988, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:41:16'),
	(8989, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:41:16'),
	(8990, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:41:16'),
	(8991, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:41:16'),
	(8992, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:41:16'),
	(8993, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:41:16'),
	(8994, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:41:27'),
	(8995, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:41:27'),
	(8996, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:41:27'),
	(8997, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:41:27'),
	(8998, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:41:27'),
	(8999, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:41:27'),
	(9000, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:41:27'),
	(9001, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:41:27'),
	(9002, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:41:27'),
	(9003, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:41:27'),
	(9004, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:41:27'),
	(9005, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:41:27'),
	(9006, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:41:27'),
	(9007, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:41:27'),
	(9008, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:41:27'),
	(9009, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:41:27'),
	(9010, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:41:27'),
	(9011, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:41:27'),
	(9012, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:41:27'),
	(9013, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:41:27'),
	(9014, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:41:27'),
	(9015, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:41:27'),
	(9016, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:41:27'),
	(9017, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:42:01'),
	(9018, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:42:01'),
	(9019, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:42:01'),
	(9020, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:42:01'),
	(9021, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:42:01'),
	(9022, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:42:01'),
	(9023, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:42:01'),
	(9024, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:42:01'),
	(9025, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:42:01'),
	(9026, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:42:01'),
	(9027, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:42:01'),
	(9028, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:42:01'),
	(9029, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:42:01'),
	(9030, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:42:01'),
	(9031, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:42:01'),
	(9032, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:42:01'),
	(9033, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:42:01'),
	(9034, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:42:01'),
	(9035, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:42:01'),
	(9036, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:42:01'),
	(9037, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:42:01'),
	(9038, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:42:01'),
	(9039, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:42:01'),
	(9040, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:42:27'),
	(9041, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:42:27'),
	(9042, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:42:27'),
	(9043, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:42:27'),
	(9044, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:42:27'),
	(9045, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:42:27'),
	(9046, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:42:27'),
	(9047, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:42:27'),
	(9048, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:42:27'),
	(9049, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:42:27'),
	(9050, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:42:27'),
	(9051, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:42:27'),
	(9052, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:42:27'),
	(9053, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:42:27'),
	(9054, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:42:27'),
	(9055, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:42:27'),
	(9056, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:42:27'),
	(9057, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:42:27'),
	(9058, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:42:27'),
	(9059, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:42:27'),
	(9060, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:42:27'),
	(9061, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:42:27'),
	(9062, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:42:27'),
	(9063, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:44:48'),
	(9064, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:44:48'),
	(9065, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:44:48'),
	(9066, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:44:48'),
	(9067, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:44:48'),
	(9068, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:44:48'),
	(9069, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:44:48'),
	(9070, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:44:48'),
	(9071, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:44:48'),
	(9072, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:44:48'),
	(9073, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:44:48'),
	(9074, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:44:48'),
	(9075, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:44:48'),
	(9076, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:44:48'),
	(9077, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:44:48'),
	(9078, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:44:48'),
	(9079, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:44:48'),
	(9080, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:44:48'),
	(9081, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:44:48'),
	(9082, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:44:48'),
	(9083, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:44:48'),
	(9084, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:44:48'),
	(9085, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:44:48'),
	(9086, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:46:28'),
	(9087, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:46:28'),
	(9088, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:46:28'),
	(9089, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:46:28'),
	(9090, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:46:28'),
	(9091, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:46:28'),
	(9092, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:46:28'),
	(9093, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:46:28'),
	(9094, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:46:28'),
	(9095, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:46:28'),
	(9096, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:46:28'),
	(9097, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:46:28'),
	(9098, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:46:28'),
	(9099, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:46:28'),
	(9100, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:46:28'),
	(9101, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:46:28'),
	(9102, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:46:28'),
	(9103, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:46:28'),
	(9104, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:46:28'),
	(9105, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:46:28'),
	(9106, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:46:28'),
	(9107, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:46:28'),
	(9108, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:46:28'),
	(9109, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:50:59'),
	(9110, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:50:59'),
	(9111, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:50:59'),
	(9112, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:50:59'),
	(9113, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:50:59'),
	(9114, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:50:59'),
	(9115, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:50:59'),
	(9116, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:50:59'),
	(9117, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:50:59'),
	(9118, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:50:59'),
	(9119, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:50:59'),
	(9120, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:50:59'),
	(9121, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:50:59'),
	(9122, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:50:59'),
	(9123, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:50:59'),
	(9124, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:50:59'),
	(9125, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:50:59'),
	(9126, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:50:59'),
	(9127, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:50:59'),
	(9128, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:50:59'),
	(9129, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:50:59'),
	(9130, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:50:59'),
	(9131, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:50:59'),
	(9132, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:53:01'),
	(9133, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:53:01'),
	(9134, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:53:01'),
	(9135, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:53:01'),
	(9136, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:53:01'),
	(9137, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:53:01'),
	(9138, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:53:01'),
	(9139, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:53:01'),
	(9140, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:53:01'),
	(9141, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:53:01'),
	(9142, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:53:01'),
	(9143, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:53:01'),
	(9144, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:53:01'),
	(9145, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:53:01'),
	(9146, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:53:01'),
	(9147, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:53:01'),
	(9148, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:53:01'),
	(9149, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:53:01'),
	(9150, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:53:01'),
	(9151, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:53:01'),
	(9152, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:53:01'),
	(9153, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:53:01'),
	(9154, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:53:01'),
	(9155, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:58:02'),
	(9156, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:58:02'),
	(9157, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:58:02'),
	(9158, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:58:02'),
	(9159, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:58:02'),
	(9160, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:58:02'),
	(9161, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:58:02'),
	(9162, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:58:02'),
	(9163, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:58:02'),
	(9164, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:58:02'),
	(9165, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:58:02'),
	(9166, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:58:02'),
	(9167, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:58:02'),
	(9168, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:58:02'),
	(9169, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:58:02'),
	(9170, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:58:02'),
	(9171, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:58:02'),
	(9172, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:58:02'),
	(9173, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:58:02'),
	(9174, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:58:02'),
	(9175, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:58:02'),
	(9176, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:58:02'),
	(9177, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:58:02'),
	(9178, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-10 23:59:49'),
	(9179, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-10 23:59:49'),
	(9180, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-10 23:59:49'),
	(9181, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-10 23:59:49'),
	(9182, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-10 23:59:49'),
	(9183, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-10 23:59:49'),
	(9184, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-10 23:59:49'),
	(9185, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-10 23:59:49'),
	(9186, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-10 23:59:49'),
	(9187, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-10 23:59:49'),
	(9188, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-10 23:59:49'),
	(9189, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-10 23:59:49'),
	(9190, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-10 23:59:49'),
	(9191, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-10 23:59:49'),
	(9192, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-10 23:59:49'),
	(9193, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-10 23:59:49'),
	(9194, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-10 23:59:49'),
	(9195, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-10 23:59:49'),
	(9196, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-10 23:59:49'),
	(9197, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-10 23:59:49'),
	(9198, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-10 23:59:49'),
	(9199, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-10 23:59:49'),
	(9200, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-10 23:59:49'),
	(9201, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:00:44'),
	(9202, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:00:44'),
	(9203, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:00:44'),
	(9204, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:00:44'),
	(9205, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:00:44'),
	(9206, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:00:44'),
	(9207, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:00:44'),
	(9208, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:00:44'),
	(9209, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:00:44'),
	(9210, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:00:44'),
	(9211, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:00:44'),
	(9212, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:00:44'),
	(9213, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:00:44'),
	(9214, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:00:44'),
	(9215, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:00:44'),
	(9216, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:00:44'),
	(9217, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:00:44'),
	(9218, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:00:44'),
	(9219, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:00:44'),
	(9220, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:00:44'),
	(9221, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:00:44'),
	(9222, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:00:44'),
	(9223, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:00:44'),
	(9224, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:03:52'),
	(9225, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:03:52'),
	(9226, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:03:52'),
	(9227, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:03:52'),
	(9228, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:03:52'),
	(9229, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:03:52'),
	(9230, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:03:52'),
	(9231, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:03:52'),
	(9232, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:03:52'),
	(9233, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:03:52'),
	(9234, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:03:52'),
	(9235, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:03:52'),
	(9236, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:03:52'),
	(9237, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:03:52'),
	(9238, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:03:52'),
	(9239, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:03:52'),
	(9240, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:03:52'),
	(9241, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:03:52'),
	(9242, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:03:52'),
	(9243, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:03:52'),
	(9244, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:03:52'),
	(9245, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:03:52'),
	(9246, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:03:52'),
	(9247, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:04:44'),
	(9248, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:04:44'),
	(9249, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:04:44'),
	(9250, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:04:44'),
	(9251, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:04:44'),
	(9252, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:04:44'),
	(9253, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:04:44'),
	(9254, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:04:44'),
	(9255, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:04:44'),
	(9256, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:04:44'),
	(9257, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:04:44'),
	(9258, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:04:44'),
	(9259, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:04:44'),
	(9260, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:04:44'),
	(9261, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:04:44'),
	(9262, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:04:44'),
	(9263, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:04:44'),
	(9264, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:04:44'),
	(9265, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:04:44'),
	(9266, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:04:44'),
	(9267, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:04:44'),
	(9268, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:04:44'),
	(9269, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:04:44'),
	(9270, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:06:05'),
	(9271, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:06:05'),
	(9272, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:06:05'),
	(9273, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:06:05'),
	(9274, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:06:05'),
	(9275, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:06:05'),
	(9276, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:06:05'),
	(9277, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:06:05'),
	(9278, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:06:05'),
	(9279, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:06:05'),
	(9280, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:06:05'),
	(9281, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:06:05'),
	(9282, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:06:05'),
	(9283, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:06:05'),
	(9284, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:06:05'),
	(9285, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:06:05'),
	(9286, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:06:05'),
	(9287, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:06:05'),
	(9288, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:06:05'),
	(9289, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:06:05'),
	(9290, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:06:05'),
	(9291, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:06:05'),
	(9292, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:06:05'),
	(9293, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:12:11'),
	(9294, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:12:11'),
	(9295, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:12:11'),
	(9296, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:12:11'),
	(9297, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:12:11'),
	(9298, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:12:11'),
	(9299, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:12:11'),
	(9300, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:12:11'),
	(9301, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:12:11'),
	(9302, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:12:11'),
	(9303, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:12:11'),
	(9304, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:12:11'),
	(9305, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:12:11'),
	(9306, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:12:11'),
	(9307, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:12:11'),
	(9308, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:12:11'),
	(9309, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:12:11'),
	(9310, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:12:11'),
	(9311, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:12:11'),
	(9312, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:12:11'),
	(9313, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:12:11'),
	(9314, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:12:11'),
	(9315, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:12:11'),
	(9316, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:16:39'),
	(9317, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:16:39'),
	(9318, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:16:39'),
	(9319, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:16:39'),
	(9320, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:16:39'),
	(9321, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:16:39'),
	(9322, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:16:39'),
	(9323, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:16:39'),
	(9324, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:16:39'),
	(9325, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:16:39'),
	(9326, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:16:39'),
	(9327, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:16:39'),
	(9328, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:16:39'),
	(9329, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:16:39'),
	(9330, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:16:39'),
	(9331, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:16:39'),
	(9332, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:16:39'),
	(9333, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:16:39'),
	(9334, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:16:39'),
	(9335, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:16:39'),
	(9336, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:16:39'),
	(9337, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:16:39'),
	(9338, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:16:39'),
	(9339, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:22:40'),
	(9340, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:22:40'),
	(9341, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:22:40'),
	(9342, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:22:40'),
	(9343, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:22:40'),
	(9344, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:22:40'),
	(9345, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:22:40'),
	(9346, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:22:40'),
	(9347, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:22:40'),
	(9348, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:22:40'),
	(9349, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:22:40'),
	(9350, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:22:40'),
	(9351, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:22:40'),
	(9352, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:22:40'),
	(9353, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:22:40'),
	(9354, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:22:40'),
	(9355, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:22:40'),
	(9356, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:22:40'),
	(9357, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:22:40'),
	(9358, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:22:40'),
	(9359, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:22:40'),
	(9360, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:22:40'),
	(9361, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:22:40'),
	(9362, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:25:47'),
	(9363, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:25:47'),
	(9364, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:25:47'),
	(9365, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:25:47'),
	(9366, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:25:47'),
	(9367, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:25:47'),
	(9368, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:25:47'),
	(9369, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:25:47'),
	(9370, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:25:47'),
	(9371, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:25:47'),
	(9372, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:25:47'),
	(9373, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:25:47'),
	(9374, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:25:47'),
	(9375, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:25:47'),
	(9376, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:25:47'),
	(9377, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:25:47'),
	(9378, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:25:47'),
	(9379, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:25:47'),
	(9380, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:25:47'),
	(9381, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:25:47'),
	(9382, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:25:47'),
	(9383, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:25:47'),
	(9384, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:25:47'),
	(9385, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:30:10'),
	(9386, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:30:10'),
	(9387, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:30:10'),
	(9388, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:30:10'),
	(9389, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:30:10'),
	(9390, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:30:10'),
	(9391, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:30:10'),
	(9392, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:30:10'),
	(9393, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:30:10'),
	(9394, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:30:10'),
	(9395, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:30:10'),
	(9396, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:30:10'),
	(9397, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:30:10'),
	(9398, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:30:10'),
	(9399, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:30:10'),
	(9400, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:30:10'),
	(9401, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:30:10'),
	(9402, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:30:10'),
	(9403, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:30:10'),
	(9404, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:30:10'),
	(9405, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:30:10'),
	(9406, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:30:10'),
	(9407, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:30:10'),
	(9408, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:32:44'),
	(9409, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:32:44'),
	(9410, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:32:44'),
	(9411, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:32:44'),
	(9412, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:32:44'),
	(9413, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:32:44'),
	(9414, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:32:44'),
	(9415, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:32:44'),
	(9416, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:32:44'),
	(9417, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:32:44'),
	(9418, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:32:44'),
	(9419, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:32:44'),
	(9420, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:32:44'),
	(9421, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:32:44'),
	(9422, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:32:44'),
	(9423, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:32:44'),
	(9424, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:32:44'),
	(9425, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:32:44'),
	(9426, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:32:44'),
	(9427, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:32:44'),
	(9428, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:32:44'),
	(9429, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:32:44'),
	(9430, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:32:44'),
	(9431, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:34:16'),
	(9432, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:34:16'),
	(9433, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:34:16'),
	(9434, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:34:16'),
	(9435, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:34:16'),
	(9436, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:34:16'),
	(9437, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:34:16'),
	(9438, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:34:16'),
	(9439, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:34:16'),
	(9440, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:34:16'),
	(9441, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:34:16'),
	(9442, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:34:16'),
	(9443, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:34:16'),
	(9444, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:34:16'),
	(9445, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:34:16'),
	(9446, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:34:16'),
	(9447, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:34:16'),
	(9448, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:34:16'),
	(9449, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:34:16'),
	(9450, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:34:16'),
	(9451, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:34:16'),
	(9452, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:34:16'),
	(9453, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:34:16'),
	(9454, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:34:40'),
	(9455, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:34:40'),
	(9456, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:34:40'),
	(9457, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:34:40'),
	(9458, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:34:40'),
	(9459, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:34:40'),
	(9460, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:34:40'),
	(9461, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:34:40'),
	(9462, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:34:40'),
	(9463, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:34:40'),
	(9464, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:34:40'),
	(9465, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:34:40'),
	(9466, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:34:40'),
	(9467, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:34:40'),
	(9468, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:34:40'),
	(9469, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:34:40'),
	(9470, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:34:40'),
	(9471, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:34:40'),
	(9472, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:34:40'),
	(9473, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:34:40'),
	(9474, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:34:40'),
	(9475, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:34:40'),
	(9476, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:34:40'),
	(9477, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:35:47'),
	(9478, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:35:47'),
	(9479, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:35:47'),
	(9480, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:35:47'),
	(9481, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:35:47'),
	(9482, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:35:47'),
	(9483, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:35:47'),
	(9484, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:35:47'),
	(9485, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:35:47'),
	(9486, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:35:47'),
	(9487, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:35:47'),
	(9488, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:35:47'),
	(9489, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:35:47'),
	(9490, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:35:47'),
	(9491, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:35:47'),
	(9492, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:35:47'),
	(9493, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:35:47'),
	(9494, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:35:47'),
	(9495, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:35:47'),
	(9496, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:35:47'),
	(9497, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:35:47'),
	(9498, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:35:47'),
	(9499, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:35:47'),
	(9500, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:38:08'),
	(9501, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:38:08'),
	(9502, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:38:08'),
	(9503, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:38:08'),
	(9504, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:38:08'),
	(9505, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:38:08'),
	(9506, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:38:08'),
	(9507, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:38:08'),
	(9508, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:38:08'),
	(9509, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:38:08'),
	(9510, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:38:08'),
	(9511, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:38:08'),
	(9512, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:38:08'),
	(9513, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:38:08'),
	(9514, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:38:08'),
	(9515, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:38:08'),
	(9516, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:38:08'),
	(9517, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:38:08'),
	(9518, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:38:08'),
	(9519, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:38:08'),
	(9520, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:38:08'),
	(9521, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:38:08'),
	(9522, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:38:08'),
	(9523, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:38:29'),
	(9524, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:38:29'),
	(9525, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:38:29'),
	(9526, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:38:29'),
	(9527, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:38:29'),
	(9528, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:38:29'),
	(9529, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:38:29'),
	(9530, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:38:29'),
	(9531, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:38:29'),
	(9532, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:38:29'),
	(9533, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:38:29'),
	(9534, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:38:29'),
	(9535, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:38:29'),
	(9536, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:38:29'),
	(9537, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:38:29'),
	(9538, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:38:29'),
	(9539, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:38:29'),
	(9540, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:38:29'),
	(9541, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:38:29'),
	(9542, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:38:29'),
	(9543, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:38:29'),
	(9544, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:38:29'),
	(9545, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:38:29'),
	(9546, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:41:32'),
	(9547, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:41:32'),
	(9548, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:41:32'),
	(9549, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:41:32'),
	(9550, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:41:32'),
	(9551, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:41:32'),
	(9552, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:41:32'),
	(9553, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:41:32'),
	(9554, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:41:32'),
	(9555, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:41:32'),
	(9556, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:41:32'),
	(9557, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:41:32'),
	(9558, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:41:32'),
	(9559, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:41:32'),
	(9560, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:41:32'),
	(9561, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:41:32'),
	(9562, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:41:32'),
	(9563, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:41:32'),
	(9564, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:41:32'),
	(9565, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:41:32'),
	(9566, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:41:32'),
	(9567, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:41:32'),
	(9568, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:41:32'),
	(9569, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:42:37'),
	(9570, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:42:37'),
	(9571, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:42:37'),
	(9572, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:42:37'),
	(9573, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:42:37'),
	(9574, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:42:37'),
	(9575, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:42:37'),
	(9576, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:42:37'),
	(9577, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:42:37'),
	(9578, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:42:37'),
	(9579, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:42:37'),
	(9580, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:42:37'),
	(9581, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:42:37'),
	(9582, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:42:37'),
	(9583, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:42:37'),
	(9584, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:42:37'),
	(9585, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:42:37'),
	(9586, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:42:37'),
	(9587, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:42:37'),
	(9588, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:42:37'),
	(9589, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:42:37'),
	(9590, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:42:37'),
	(9591, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:42:37'),
	(9592, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:43:31'),
	(9593, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:43:31'),
	(9594, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:43:31'),
	(9595, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:43:31'),
	(9596, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:43:31'),
	(9597, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:43:31'),
	(9598, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:43:31'),
	(9599, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:43:31'),
	(9600, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:43:31'),
	(9601, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:43:31'),
	(9602, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:43:31'),
	(9603, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:43:31'),
	(9604, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:43:31'),
	(9605, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:43:31'),
	(9606, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:43:31'),
	(9607, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:43:31'),
	(9608, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:43:31'),
	(9609, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:43:31'),
	(9610, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:43:31'),
	(9611, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:43:31'),
	(9612, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:43:31'),
	(9613, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:43:31'),
	(9614, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:43:31'),
	(9615, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:44:12'),
	(9616, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:44:12'),
	(9617, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:44:12'),
	(9618, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:44:12'),
	(9619, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:44:12'),
	(9620, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:44:12'),
	(9621, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:44:12'),
	(9622, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:44:12'),
	(9623, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:44:12'),
	(9624, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:44:12'),
	(9625, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:44:12'),
	(9626, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:44:12'),
	(9627, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:44:12'),
	(9628, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:44:12'),
	(9629, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:44:12'),
	(9630, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:44:12'),
	(9631, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:44:12'),
	(9632, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:44:12'),
	(9633, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:44:12'),
	(9634, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:44:12'),
	(9635, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:44:12'),
	(9636, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:44:12'),
	(9637, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:44:12'),
	(9638, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:44:50'),
	(9639, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:44:50'),
	(9640, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:44:50'),
	(9641, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:44:50'),
	(9642, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:44:50'),
	(9643, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:44:50'),
	(9644, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:44:50'),
	(9645, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:44:50'),
	(9646, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:44:50'),
	(9647, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:44:50'),
	(9648, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:44:50'),
	(9649, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:44:50'),
	(9650, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:44:50'),
	(9651, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:44:50'),
	(9652, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:44:50'),
	(9653, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:44:50'),
	(9654, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:44:50'),
	(9655, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:44:50'),
	(9656, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:44:50'),
	(9657, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:44:50'),
	(9658, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:44:50'),
	(9659, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:44:50'),
	(9660, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:44:50'),
	(9661, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:51:47'),
	(9662, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:51:47'),
	(9663, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:51:47'),
	(9664, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:51:47'),
	(9665, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:51:47'),
	(9666, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:51:47'),
	(9667, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:51:47'),
	(9668, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:51:47'),
	(9669, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:51:47'),
	(9670, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:51:47'),
	(9671, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:51:47'),
	(9672, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:51:47'),
	(9673, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:51:47'),
	(9674, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:51:47'),
	(9675, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:51:47'),
	(9676, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:51:47'),
	(9677, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:51:47'),
	(9678, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:51:47'),
	(9679, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:51:47'),
	(9680, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:51:47'),
	(9681, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:51:47'),
	(9682, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:51:47'),
	(9683, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:51:47'),
	(9684, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 00:58:34'),
	(9685, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 00:58:34'),
	(9686, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 00:58:34'),
	(9687, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 00:58:34'),
	(9688, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 00:58:34'),
	(9689, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 00:58:34'),
	(9690, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 00:58:34'),
	(9691, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 00:58:34'),
	(9692, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 00:58:34'),
	(9693, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 00:58:34'),
	(9694, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 00:58:34'),
	(9695, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 00:58:34'),
	(9696, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 00:58:34'),
	(9697, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 00:58:34'),
	(9698, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 00:58:34'),
	(9699, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 00:58:34'),
	(9700, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 00:58:34'),
	(9701, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 00:58:34'),
	(9702, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 00:58:34'),
	(9703, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 00:58:34'),
	(9704, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 00:58:34'),
	(9705, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 00:58:34'),
	(9706, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 00:58:34'),
	(9707, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:00:54'),
	(9708, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:00:54'),
	(9709, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:00:54'),
	(9710, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:00:54'),
	(9711, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:00:54'),
	(9712, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:00:54'),
	(9713, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:00:54'),
	(9714, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:00:54'),
	(9715, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:00:54'),
	(9716, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:00:54'),
	(9717, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:00:54'),
	(9718, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:00:54'),
	(9719, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:00:54'),
	(9720, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:00:54'),
	(9721, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:00:54'),
	(9722, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:00:54'),
	(9723, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:00:54'),
	(9724, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:00:54'),
	(9725, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:00:54'),
	(9726, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:00:54'),
	(9727, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:00:54'),
	(9728, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:00:54'),
	(9729, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:00:54'),
	(9730, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:02:49'),
	(9731, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:02:49'),
	(9732, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:02:49'),
	(9733, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:02:49'),
	(9734, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:02:49'),
	(9735, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:02:49'),
	(9736, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:02:49'),
	(9737, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:02:49'),
	(9738, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:02:49'),
	(9739, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:02:49'),
	(9740, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:02:49'),
	(9741, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:02:49'),
	(9742, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:02:49'),
	(9743, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:02:49'),
	(9744, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:02:49'),
	(9745, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:02:49'),
	(9746, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:02:49'),
	(9747, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:02:49'),
	(9748, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:02:49'),
	(9749, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:02:49'),
	(9750, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:02:49'),
	(9751, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:02:49'),
	(9752, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:02:49'),
	(9753, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:06:13'),
	(9754, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:06:13'),
	(9755, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:06:13'),
	(9756, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:06:13'),
	(9757, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:06:13'),
	(9758, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:06:13'),
	(9759, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:06:13'),
	(9760, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:06:13'),
	(9761, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:06:13'),
	(9762, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:06:13'),
	(9763, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:06:13'),
	(9764, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:06:13'),
	(9765, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:06:13'),
	(9766, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:06:13'),
	(9767, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:06:13'),
	(9768, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:06:13'),
	(9769, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:06:13'),
	(9770, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:06:13'),
	(9771, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:06:13'),
	(9772, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:06:13'),
	(9773, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:06:13'),
	(9774, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:06:13'),
	(9775, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:06:13'),
	(9776, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:09:11'),
	(9777, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:09:11'),
	(9778, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:09:11'),
	(9779, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:09:11'),
	(9780, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:09:11'),
	(9781, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:09:11'),
	(9782, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:09:11'),
	(9783, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:09:11'),
	(9784, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:09:11'),
	(9785, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:09:11'),
	(9786, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:09:11'),
	(9787, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:09:11'),
	(9788, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:09:11'),
	(9789, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:09:11'),
	(9790, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:09:11'),
	(9791, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:09:11'),
	(9792, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:09:11'),
	(9793, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:09:11'),
	(9794, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:09:11'),
	(9795, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:09:11'),
	(9796, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:09:11'),
	(9797, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:09:11'),
	(9798, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:09:11'),
	(9799, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:19:16'),
	(9800, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:19:16'),
	(9801, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:19:16'),
	(9802, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:19:16'),
	(9803, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:19:16'),
	(9804, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:19:16'),
	(9805, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:19:16'),
	(9806, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:19:16'),
	(9807, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:19:16'),
	(9808, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:19:16'),
	(9809, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:19:16'),
	(9810, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:19:16'),
	(9811, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:19:16'),
	(9812, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:19:16'),
	(9813, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:19:16'),
	(9814, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:19:16'),
	(9815, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:19:16'),
	(9816, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:19:16'),
	(9817, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:19:16'),
	(9818, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:19:16'),
	(9819, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:19:16'),
	(9820, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:19:16'),
	(9821, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:19:16'),
	(9822, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:22:31'),
	(9823, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:22:31'),
	(9824, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:22:31'),
	(9825, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:22:31'),
	(9826, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:22:31'),
	(9827, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:22:31'),
	(9828, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:22:31'),
	(9829, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:22:31'),
	(9830, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:22:31'),
	(9831, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:22:31'),
	(9832, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:22:31'),
	(9833, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:22:31'),
	(9834, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:22:31'),
	(9835, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:22:31'),
	(9836, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:22:31'),
	(9837, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:22:31'),
	(9838, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:22:31'),
	(9839, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:22:31'),
	(9840, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:22:31'),
	(9841, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:22:31'),
	(9842, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:22:31'),
	(9843, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:22:31'),
	(9844, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:22:31'),
	(9845, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:28:13'),
	(9846, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:28:13'),
	(9847, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:28:13'),
	(9848, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:28:13'),
	(9849, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:28:13'),
	(9850, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:28:13'),
	(9851, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:28:13'),
	(9852, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:28:13'),
	(9853, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:28:13'),
	(9854, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:28:13'),
	(9855, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:28:13'),
	(9856, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:28:13'),
	(9857, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:28:13'),
	(9858, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:28:13'),
	(9859, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:28:13'),
	(9860, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:28:13'),
	(9861, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:28:13'),
	(9862, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:28:13'),
	(9863, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:28:13'),
	(9864, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:28:13'),
	(9865, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:28:13'),
	(9866, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:28:13'),
	(9867, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:28:13'),
	(9868, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:32:16'),
	(9869, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:32:16'),
	(9870, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:32:16'),
	(9871, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:32:16'),
	(9872, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:32:16'),
	(9873, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:32:16'),
	(9874, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:32:16'),
	(9875, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:32:16'),
	(9876, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:32:16'),
	(9877, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:32:16'),
	(9878, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:32:16'),
	(9879, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:32:16'),
	(9880, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:32:16'),
	(9881, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:32:16'),
	(9882, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:32:16'),
	(9883, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:32:16'),
	(9884, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:32:16'),
	(9885, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:32:16'),
	(9886, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:32:16'),
	(9887, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:32:16'),
	(9888, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:32:16'),
	(9889, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:32:16'),
	(9890, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:32:16'),
	(9891, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:36:26'),
	(9892, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:36:26'),
	(9893, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:36:26'),
	(9894, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:36:26'),
	(9895, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:36:26'),
	(9896, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:36:26'),
	(9897, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:36:26'),
	(9898, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:36:26'),
	(9899, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:36:26'),
	(9900, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:36:26'),
	(9901, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:36:26'),
	(9902, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:36:26'),
	(9903, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:36:26'),
	(9904, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:36:26'),
	(9905, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:36:26'),
	(9906, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:36:26'),
	(9907, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:36:26'),
	(9908, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:36:26'),
	(9909, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:36:26'),
	(9910, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:36:26'),
	(9911, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:36:26'),
	(9912, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:36:26'),
	(9913, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:36:26'),
	(9914, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:38:51'),
	(9915, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:38:51'),
	(9916, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:38:51'),
	(9917, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:38:51'),
	(9918, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:38:51'),
	(9919, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:38:51'),
	(9920, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:38:51'),
	(9921, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:38:51'),
	(9922, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:38:51'),
	(9923, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:38:51'),
	(9924, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:38:51'),
	(9925, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:38:51'),
	(9926, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:38:51'),
	(9927, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:38:51'),
	(9928, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:38:51'),
	(9929, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:38:51'),
	(9930, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:38:51'),
	(9931, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:38:51'),
	(9932, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:38:51'),
	(9933, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:38:51'),
	(9934, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:38:51'),
	(9935, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:38:51'),
	(9936, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:38:51'),
	(9937, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:43:12'),
	(9938, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:43:12'),
	(9939, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:43:12'),
	(9940, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:43:12'),
	(9941, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:43:12'),
	(9942, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:43:12'),
	(9943, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:43:12'),
	(9944, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:43:12'),
	(9945, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:43:12'),
	(9946, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:43:12'),
	(9947, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:43:12'),
	(9948, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:43:12'),
	(9949, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:43:12'),
	(9950, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:43:12'),
	(9951, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:43:12'),
	(9952, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:43:12'),
	(9953, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:43:12'),
	(9954, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:43:12'),
	(9955, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:43:12'),
	(9956, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:43:12'),
	(9957, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:43:12'),
	(9958, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:43:12'),
	(9959, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:43:12'),
	(9960, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:45:05'),
	(9961, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:45:05'),
	(9962, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:45:05'),
	(9963, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:45:05'),
	(9964, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:45:05'),
	(9965, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:45:05'),
	(9966, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:45:05'),
	(9967, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:45:05'),
	(9968, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:45:05'),
	(9969, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:45:05'),
	(9970, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:45:05'),
	(9971, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:45:05'),
	(9972, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:45:05'),
	(9973, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:45:05'),
	(9974, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:45:05'),
	(9975, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:45:05'),
	(9976, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:45:05'),
	(9977, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:45:05'),
	(9978, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:45:05'),
	(9979, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:45:05'),
	(9980, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:45:05'),
	(9981, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:45:05'),
	(9982, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:45:05'),
	(9983, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 01:48:39'),
	(9984, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 01:48:39'),
	(9985, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 01:48:39'),
	(9986, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 01:48:39'),
	(9987, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 01:48:39'),
	(9988, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 01:48:39'),
	(9989, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 01:48:39'),
	(9990, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 01:48:39'),
	(9991, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 01:48:39'),
	(9992, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 01:48:39'),
	(9993, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 01:48:39'),
	(9994, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 01:48:39'),
	(9995, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 01:48:39'),
	(9996, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 01:48:39'),
	(9997, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 01:48:39'),
	(9998, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 01:48:39'),
	(9999, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 01:48:39'),
	(10000, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 01:48:39');
REPLACE INTO `doviz_kur_gecmisi` (`id`, `firma_id`, `currency_code`, `rate`, `buying_rate`, `selling_rate`, `source`, `recorded_at`) VALUES
	(10001, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 01:48:39'),
	(10002, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 01:48:39'),
	(10003, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 01:48:39'),
	(10004, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 01:48:39'),
	(10005, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 01:48:39'),
	(10006, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 02:10:15'),
	(10007, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 02:10:15'),
	(10008, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 02:10:15'),
	(10009, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 02:10:15'),
	(10010, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 02:10:15'),
	(10011, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 02:10:15'),
	(10012, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 02:10:15'),
	(10013, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 02:10:15'),
	(10014, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 02:10:15'),
	(10015, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 02:10:15'),
	(10016, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 02:10:15'),
	(10017, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 02:10:15'),
	(10018, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 02:10:15'),
	(10019, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 02:10:15'),
	(10020, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 02:10:15'),
	(10021, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 02:10:15'),
	(10022, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 02:10:15'),
	(10023, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 02:10:15'),
	(10024, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 02:10:15'),
	(10025, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 02:10:15'),
	(10026, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 02:10:15'),
	(10027, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 02:10:15'),
	(10028, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 02:10:15'),
	(10029, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 02:11:44'),
	(10030, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 02:11:44'),
	(10031, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 02:11:44'),
	(10032, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 02:11:44'),
	(10033, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 02:11:44'),
	(10034, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 02:11:44'),
	(10035, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 02:11:44'),
	(10036, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 02:11:44'),
	(10037, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 02:11:44'),
	(10038, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 02:11:44'),
	(10039, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 02:11:44'),
	(10040, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 02:11:44'),
	(10041, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 02:11:44'),
	(10042, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 02:11:44'),
	(10043, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 02:11:44'),
	(10044, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 02:11:44'),
	(10045, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 02:11:44'),
	(10046, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 02:11:44'),
	(10047, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 02:11:44'),
	(10048, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 02:11:44'),
	(10049, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 02:11:44'),
	(10050, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 02:11:44'),
	(10051, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 02:11:44'),
	(10052, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 02:24:26'),
	(10053, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 02:24:26'),
	(10054, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 02:24:26'),
	(10055, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 02:24:26'),
	(10056, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 02:24:26'),
	(10057, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 02:24:26'),
	(10058, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 02:24:26'),
	(10059, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 02:24:26'),
	(10060, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 02:24:26'),
	(10061, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 02:24:26'),
	(10062, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 02:24:26'),
	(10063, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 02:24:26'),
	(10064, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 02:24:26'),
	(10065, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 02:24:26'),
	(10066, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 02:24:26'),
	(10067, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 02:24:26'),
	(10068, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 02:24:26'),
	(10069, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 02:24:26'),
	(10070, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 02:24:26'),
	(10071, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 02:24:26'),
	(10072, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 02:24:26'),
	(10073, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 02:24:26'),
	(10074, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 02:24:26'),
	(10075, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 02:24:52'),
	(10076, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 02:24:52'),
	(10077, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 02:24:52'),
	(10078, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 02:24:52'),
	(10079, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 02:24:52'),
	(10080, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 02:24:52'),
	(10081, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 02:24:52'),
	(10082, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 02:24:52'),
	(10083, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 02:24:52'),
	(10084, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 02:24:52'),
	(10085, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 02:24:52'),
	(10086, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 02:24:52'),
	(10087, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 02:24:52'),
	(10088, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 02:24:52'),
	(10089, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 02:24:52'),
	(10090, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 02:24:52'),
	(10091, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 02:24:52'),
	(10092, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 02:24:52'),
	(10093, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 02:24:52'),
	(10094, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 02:24:52'),
	(10095, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 02:24:52'),
	(10096, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 02:24:52'),
	(10097, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 02:24:52'),
	(10098, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 02:25:00'),
	(10099, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 02:25:00'),
	(10100, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 02:25:00'),
	(10101, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 02:25:00'),
	(10102, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 02:25:00'),
	(10103, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 02:25:00'),
	(10104, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 02:25:00'),
	(10105, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 02:25:00'),
	(10106, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 02:25:00'),
	(10107, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 02:25:00'),
	(10108, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 02:25:00'),
	(10109, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 02:25:00'),
	(10110, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 02:25:00'),
	(10111, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 02:25:00'),
	(10112, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 02:25:00'),
	(10113, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 02:25:00'),
	(10114, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 02:25:00'),
	(10115, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 02:25:00'),
	(10116, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 02:25:00'),
	(10117, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 02:25:00'),
	(10118, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 02:25:00'),
	(10119, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 02:25:00'),
	(10120, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 02:25:00'),
	(10121, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 02:26:19'),
	(10122, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 02:26:19'),
	(10123, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 02:26:19'),
	(10124, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 02:26:19'),
	(10125, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 02:26:19'),
	(10126, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 02:26:19'),
	(10127, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 02:26:19'),
	(10128, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 02:26:19'),
	(10129, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 02:26:19'),
	(10130, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 02:26:19'),
	(10131, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 02:26:19'),
	(10132, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 02:26:19'),
	(10133, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 02:26:19'),
	(10134, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 02:26:19'),
	(10135, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 02:26:19'),
	(10136, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 02:26:19'),
	(10137, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 02:26:19'),
	(10138, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 02:26:19'),
	(10139, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 02:26:19'),
	(10140, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 02:26:19'),
	(10141, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 02:26:19'),
	(10142, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 02:26:19'),
	(10143, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 02:26:19'),
	(10144, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 04:35:47'),
	(10145, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 04:35:47'),
	(10146, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 04:35:47'),
	(10147, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 04:35:47'),
	(10148, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 04:35:47'),
	(10149, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 04:35:47'),
	(10150, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 04:35:47'),
	(10151, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 04:35:47'),
	(10152, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 04:35:47'),
	(10153, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 04:35:47'),
	(10154, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 04:35:47'),
	(10155, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 04:35:47'),
	(10156, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 04:35:47'),
	(10157, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 04:35:47'),
	(10158, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 04:35:47'),
	(10159, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 04:35:47'),
	(10160, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 04:35:47'),
	(10161, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 04:35:47'),
	(10162, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 04:35:47'),
	(10163, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 04:35:47'),
	(10164, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 04:35:47'),
	(10165, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 04:35:47'),
	(10166, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 04:35:47'),
	(10167, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 04:37:35'),
	(10168, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 04:37:35'),
	(10169, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 04:37:35'),
	(10170, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 04:37:35'),
	(10171, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 04:37:35'),
	(10172, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 04:37:35'),
	(10173, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 04:37:35'),
	(10174, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 04:37:35'),
	(10175, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 04:37:35'),
	(10176, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 04:37:35'),
	(10177, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 04:37:35'),
	(10178, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 04:37:35'),
	(10179, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 04:37:35'),
	(10180, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 04:37:35'),
	(10181, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 04:37:35'),
	(10182, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 04:37:35'),
	(10183, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 04:37:35'),
	(10184, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 04:37:35'),
	(10185, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 04:37:35'),
	(10186, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 04:37:35'),
	(10187, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 04:37:35'),
	(10188, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 04:37:35'),
	(10189, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 04:37:35'),
	(10190, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 04:38:08'),
	(10191, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 04:38:08'),
	(10192, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 04:38:08'),
	(10193, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 04:38:08'),
	(10194, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 04:38:08'),
	(10195, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 04:38:08'),
	(10196, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 04:38:08'),
	(10197, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 04:38:08'),
	(10198, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 04:38:08'),
	(10199, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 04:38:08'),
	(10200, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 04:38:08'),
	(10201, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 04:38:08'),
	(10202, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 04:38:08'),
	(10203, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 04:38:08'),
	(10204, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 04:38:08'),
	(10205, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 04:38:08'),
	(10206, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 04:38:08'),
	(10207, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 04:38:08'),
	(10208, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 04:38:08'),
	(10209, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 04:38:08'),
	(10210, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 04:38:08'),
	(10211, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 04:38:08'),
	(10212, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 04:38:08'),
	(10213, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 04:40:17'),
	(10214, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 04:40:17'),
	(10215, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 04:40:17'),
	(10216, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 04:40:17'),
	(10217, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 04:40:17'),
	(10218, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 04:40:17'),
	(10219, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 04:40:17'),
	(10220, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 04:40:17'),
	(10221, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 04:40:17'),
	(10222, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 04:40:17'),
	(10223, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 04:40:17'),
	(10224, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 04:40:17'),
	(10225, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 04:40:17'),
	(10226, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 04:40:17'),
	(10227, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 04:40:17'),
	(10228, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 04:40:17'),
	(10229, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 04:40:17'),
	(10230, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 04:40:17'),
	(10231, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 04:40:17'),
	(10232, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 04:40:17'),
	(10233, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 04:40:17'),
	(10234, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 04:40:17'),
	(10235, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 04:40:17'),
	(10236, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 04:43:09'),
	(10237, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 04:43:09'),
	(10238, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 04:43:09'),
	(10239, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 04:43:09'),
	(10240, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 04:43:09'),
	(10241, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 04:43:09'),
	(10242, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 04:43:09'),
	(10243, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 04:43:09'),
	(10244, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 04:43:09'),
	(10245, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 04:43:09'),
	(10246, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 04:43:09'),
	(10247, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 04:43:09'),
	(10248, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 04:43:09'),
	(10249, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 04:43:09'),
	(10250, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 04:43:09'),
	(10251, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 04:43:09'),
	(10252, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 04:43:09'),
	(10253, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 04:43:09'),
	(10254, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 04:43:09'),
	(10255, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 04:43:09'),
	(10256, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 04:43:09'),
	(10257, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 04:43:09'),
	(10258, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 04:43:09'),
	(10259, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 04:52:49'),
	(10260, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 04:52:49'),
	(10261, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 04:52:49'),
	(10262, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 04:52:49'),
	(10263, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 04:52:49'),
	(10264, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 04:52:49'),
	(10265, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 04:52:49'),
	(10266, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 04:52:49'),
	(10267, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 04:52:49'),
	(10268, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 04:52:49'),
	(10269, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 04:52:49'),
	(10270, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 04:52:49'),
	(10271, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 04:52:49'),
	(10272, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 04:52:49'),
	(10273, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 04:52:49'),
	(10274, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 04:52:49'),
	(10275, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 04:52:49'),
	(10276, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 04:52:49'),
	(10277, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 04:52:49'),
	(10278, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 04:52:49'),
	(10279, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 04:52:49'),
	(10280, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 04:52:49'),
	(10281, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 04:52:49'),
	(10282, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 04:57:14'),
	(10283, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 04:57:14'),
	(10284, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 04:57:14'),
	(10285, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 04:57:14'),
	(10286, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 04:57:14'),
	(10287, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 04:57:14'),
	(10288, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 04:57:14'),
	(10289, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 04:57:14'),
	(10290, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 04:57:14'),
	(10291, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 04:57:14'),
	(10292, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 04:57:14'),
	(10293, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 04:57:14'),
	(10294, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 04:57:14'),
	(10295, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 04:57:14'),
	(10296, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 04:57:14'),
	(10297, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 04:57:14'),
	(10298, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 04:57:14'),
	(10299, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 04:57:14'),
	(10300, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 04:57:14'),
	(10301, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 04:57:14'),
	(10302, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 04:57:14'),
	(10303, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 04:57:14'),
	(10304, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 04:57:14'),
	(10305, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 06:29:22'),
	(10306, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 06:29:22'),
	(10307, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 06:29:22'),
	(10308, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 06:29:22'),
	(10309, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 06:29:22'),
	(10310, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 06:29:22'),
	(10311, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 06:29:22'),
	(10312, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 06:29:22'),
	(10313, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 06:29:22'),
	(10314, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 06:29:22'),
	(10315, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 06:29:22'),
	(10316, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 06:29:22'),
	(10317, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 06:29:22'),
	(10318, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 06:29:22'),
	(10319, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 06:29:22'),
	(10320, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 06:29:22'),
	(10321, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 06:29:22'),
	(10322, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 06:29:22'),
	(10323, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 06:29:22'),
	(10324, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 06:29:22'),
	(10325, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 06:29:22'),
	(10326, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 06:29:22'),
	(10327, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 06:29:22'),
	(10328, 1, 'USD', 42.556200, 42.517900, 42.594500, 'tcmb', '2025-12-11 06:31:11'),
	(10329, 1, 'AUD', 28.294150, 28.202200, 28.386100, 'tcmb', '2025-12-11 06:31:11'),
	(10330, 1, 'DKK', 6.632450, 6.616200, 6.648700, 'tcmb', '2025-12-11 06:31:11'),
	(10331, 1, 'EUR', 49.538200, 49.493600, 49.582800, 'tcmb', '2025-12-11 06:31:11'),
	(10332, 1, 'GBP', 56.665650, 56.518300, 56.813000, 'tcmb', '2025-12-11 06:31:11'),
	(10333, 1, 'CHF', 52.853850, 52.684700, 53.023000, 'tcmb', '2025-12-11 06:31:11'),
	(10334, 1, 'SEK', 4.552850, 4.529400, 4.576300, 'tcmb', '2025-12-11 06:31:11'),
	(10335, 1, 'CAD', 30.722950, 30.653800, 30.792100, 'tcmb', '2025-12-11 06:31:11'),
	(10336, 1, 'KWD', 138.581050, 137.680300, 139.481800, 'tcmb', '2025-12-11 06:31:11'),
	(10337, 1, 'NOK', 4.193850, 4.179800, 4.207900, 'tcmb', '2025-12-11 06:31:11'),
	(10338, 1, 'SAR', 11.340250, 11.330000, 11.350500, 'tcmb', '2025-12-11 06:31:11'),
	(10339, 1, 'JPY', 0.271546, 0.270649, 0.272442, 'tcmb', '2025-12-11 06:31:11'),
	(10340, 1, 'BGN', 25.315250, 25.150700, 25.479800, 'tcmb', '2025-12-11 06:31:11'),
	(10341, 1, 'RON', 9.733250, 9.670000, 9.796500, 'tcmb', '2025-12-11 06:31:11'),
	(10342, 1, 'RUB', 0.548890, 0.545320, 0.552460, 'tcmb', '2025-12-11 06:31:11'),
	(10343, 1, 'CNY', 6.025150, 5.986000, 6.064300, 'tcmb', '2025-12-11 06:31:11'),
	(10344, 1, 'PKR', 0.151395, 0.150410, 0.152380, 'tcmb', '2025-12-11 06:31:11'),
	(10345, 1, 'QAR', 11.678100, 11.602200, 11.754000, 'tcmb', '2025-12-11 06:31:11'),
	(10346, 1, 'KRW', 0.028945, 0.028760, 0.029130, 'tcmb', '2025-12-11 06:31:11'),
	(10347, 1, 'AZN', 25.033050, 24.870300, 25.195800, 'tcmb', '2025-12-11 06:31:11'),
	(10348, 1, 'AED', 11.587250, 11.511900, 11.662600, 'tcmb', '2025-12-11 06:31:11'),
	(10349, 1, 'KZT', 0.082145, 0.081610, 0.082680, 'tcmb', '2025-12-11 06:31:11'),
	(10350, 1, 'XDR', 28.989350, 57.978700, 0.000000, 'tcmb', '2025-12-11 06:31:11'),
	(10351, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 16:04:13'),
	(10352, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 16:04:13'),
	(10353, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 16:04:13'),
	(10354, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 16:04:13'),
	(10355, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 16:04:13'),
	(10356, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 16:04:13'),
	(10357, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 16:04:13'),
	(10358, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 16:04:13'),
	(10359, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 16:04:13'),
	(10360, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 16:04:13'),
	(10361, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 16:04:13'),
	(10362, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 16:04:13'),
	(10363, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 16:04:13'),
	(10364, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 16:04:13'),
	(10365, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 16:04:13'),
	(10366, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 16:04:13'),
	(10367, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 16:04:13'),
	(10368, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 16:04:13'),
	(10369, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 16:04:13'),
	(10370, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 16:04:13'),
	(10371, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 16:04:13'),
	(10372, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 16:04:13'),
	(10373, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 16:04:13'),
	(10374, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 18:40:59'),
	(10375, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 18:40:59'),
	(10376, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 18:40:59'),
	(10377, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 18:40:59'),
	(10378, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 18:40:59'),
	(10379, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 18:40:59'),
	(10380, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 18:40:59'),
	(10381, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 18:40:59'),
	(10382, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 18:40:59'),
	(10383, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 18:40:59'),
	(10384, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 18:40:59'),
	(10385, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 18:40:59'),
	(10386, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 18:40:59'),
	(10387, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 18:40:59'),
	(10388, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 18:40:59'),
	(10389, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 18:40:59'),
	(10390, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 18:40:59'),
	(10391, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 18:40:59'),
	(10392, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 18:40:59'),
	(10393, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 18:40:59'),
	(10394, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 18:40:59'),
	(10395, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 18:40:59'),
	(10396, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 18:40:59'),
	(10397, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:15:42'),
	(10398, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:15:42'),
	(10399, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:15:42'),
	(10400, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:15:42'),
	(10401, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:15:42'),
	(10402, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:15:42'),
	(10403, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:15:42'),
	(10404, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:15:42'),
	(10405, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:15:42'),
	(10406, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:15:42'),
	(10407, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:15:42'),
	(10408, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:15:42'),
	(10409, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:15:42'),
	(10410, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:15:42'),
	(10411, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:15:42'),
	(10412, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:15:42'),
	(10413, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:15:42'),
	(10414, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:15:42'),
	(10415, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:15:42'),
	(10416, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:15:42'),
	(10417, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:15:42'),
	(10418, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:15:42'),
	(10419, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:15:42'),
	(10420, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:16:25'),
	(10421, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:16:25'),
	(10422, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:16:25'),
	(10423, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:16:25'),
	(10424, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:16:25'),
	(10425, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:16:25'),
	(10426, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:16:25'),
	(10427, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:16:25'),
	(10428, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:16:25'),
	(10429, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:16:25'),
	(10430, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:16:25'),
	(10431, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:16:25'),
	(10432, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:16:25'),
	(10433, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:16:25'),
	(10434, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:16:25'),
	(10435, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:16:25'),
	(10436, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:16:25'),
	(10437, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:16:25'),
	(10438, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:16:25'),
	(10439, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:16:25'),
	(10440, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:16:25'),
	(10441, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:16:25'),
	(10442, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:16:25'),
	(10443, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:22:31'),
	(10444, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:22:31'),
	(10445, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:22:31'),
	(10446, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:22:31'),
	(10447, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:22:31'),
	(10448, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:22:31'),
	(10449, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:22:31'),
	(10450, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:22:31'),
	(10451, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:22:31'),
	(10452, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:22:31'),
	(10453, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:22:31'),
	(10454, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:22:31'),
	(10455, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:22:31'),
	(10456, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:22:31'),
	(10457, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:22:31'),
	(10458, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:22:31'),
	(10459, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:22:31'),
	(10460, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:22:31'),
	(10461, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:22:31'),
	(10462, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:22:31'),
	(10463, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:22:31'),
	(10464, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:22:31'),
	(10465, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:22:31'),
	(10466, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:23:46'),
	(10467, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:23:46'),
	(10468, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:23:46'),
	(10469, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:23:46'),
	(10470, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:23:46'),
	(10471, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:23:46'),
	(10472, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:23:46'),
	(10473, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:23:46'),
	(10474, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:23:46'),
	(10475, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:23:46'),
	(10476, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:23:46'),
	(10477, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:23:46'),
	(10478, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:23:46'),
	(10479, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:23:46'),
	(10480, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:23:46'),
	(10481, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:23:46'),
	(10482, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:23:46'),
	(10483, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:23:46'),
	(10484, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:23:46'),
	(10485, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:23:46'),
	(10486, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:23:46'),
	(10487, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:23:46'),
	(10488, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:23:46'),
	(10489, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:30:56'),
	(10490, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:30:56'),
	(10491, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:30:56'),
	(10492, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:30:56'),
	(10493, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:30:56'),
	(10494, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:30:56'),
	(10495, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:30:56'),
	(10496, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:30:56'),
	(10497, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:30:56'),
	(10498, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:30:56'),
	(10499, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:30:56'),
	(10500, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:30:56'),
	(10501, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:30:56'),
	(10502, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:30:56'),
	(10503, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:30:56'),
	(10504, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:30:56'),
	(10505, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:30:56'),
	(10506, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:30:56'),
	(10507, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:30:56'),
	(10508, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:30:56'),
	(10509, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:30:56'),
	(10510, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:30:56'),
	(10511, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:30:56'),
	(10512, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:36:27'),
	(10513, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:36:27'),
	(10514, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:36:27'),
	(10515, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:36:27'),
	(10516, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:36:27'),
	(10517, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:36:27'),
	(10518, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:36:27'),
	(10519, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:36:27'),
	(10520, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:36:27'),
	(10521, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:36:27'),
	(10522, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:36:27'),
	(10523, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:36:27'),
	(10524, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:36:27'),
	(10525, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:36:27'),
	(10526, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:36:27'),
	(10527, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:36:27'),
	(10528, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:36:27'),
	(10529, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:36:27'),
	(10530, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:36:27'),
	(10531, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:36:27'),
	(10532, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:36:27'),
	(10533, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:36:27'),
	(10534, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:36:27'),
	(10535, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:38:09'),
	(10536, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:38:09'),
	(10537, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:38:09'),
	(10538, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:38:09'),
	(10539, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:38:09'),
	(10540, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:38:09'),
	(10541, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:38:09'),
	(10542, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:38:09'),
	(10543, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:38:09'),
	(10544, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:38:09'),
	(10545, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:38:09'),
	(10546, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:38:09'),
	(10547, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:38:09'),
	(10548, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:38:09'),
	(10549, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:38:09'),
	(10550, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:38:09'),
	(10551, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:38:09'),
	(10552, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:38:09'),
	(10553, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:38:09'),
	(10554, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:38:09'),
	(10555, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:38:09'),
	(10556, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:38:09'),
	(10557, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:38:09'),
	(10558, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:43:34'),
	(10559, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:43:34'),
	(10560, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:43:34'),
	(10561, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:43:34'),
	(10562, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:43:34'),
	(10563, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:43:34'),
	(10564, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:43:34'),
	(10565, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:43:34'),
	(10566, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:43:34'),
	(10567, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:43:34'),
	(10568, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:43:34'),
	(10569, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:43:34'),
	(10570, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:43:34'),
	(10571, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:43:34'),
	(10572, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:43:34'),
	(10573, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:43:34'),
	(10574, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:43:34'),
	(10575, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:43:34'),
	(10576, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:43:34'),
	(10577, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:43:34'),
	(10578, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:43:34'),
	(10579, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:43:34'),
	(10580, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:43:34'),
	(10581, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:47:44'),
	(10582, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:47:44'),
	(10583, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:47:44'),
	(10584, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:47:44'),
	(10585, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:47:44'),
	(10586, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:47:44'),
	(10587, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:47:44'),
	(10588, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:47:44'),
	(10589, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:47:44'),
	(10590, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:47:44'),
	(10591, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:47:44'),
	(10592, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:47:44'),
	(10593, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:47:44'),
	(10594, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:47:44'),
	(10595, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:47:44'),
	(10596, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:47:44'),
	(10597, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:47:44'),
	(10598, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:47:44'),
	(10599, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:47:44'),
	(10600, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:47:44'),
	(10601, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:47:44'),
	(10602, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:47:44'),
	(10603, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:47:44'),
	(10604, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:52:28'),
	(10605, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:52:28'),
	(10606, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:52:28'),
	(10607, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:52:28'),
	(10608, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:52:28'),
	(10609, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:52:28'),
	(10610, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:52:28'),
	(10611, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:52:28'),
	(10612, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:52:28'),
	(10613, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:52:28'),
	(10614, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:52:28'),
	(10615, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:52:28'),
	(10616, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:52:28'),
	(10617, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:52:28'),
	(10618, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:52:28'),
	(10619, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:52:28'),
	(10620, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:52:28'),
	(10621, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:52:28'),
	(10622, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:52:28'),
	(10623, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:52:28'),
	(10624, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:52:28'),
	(10625, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:52:28'),
	(10626, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:52:28'),
	(10627, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:53:38'),
	(10628, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:53:38'),
	(10629, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:53:38'),
	(10630, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:53:38'),
	(10631, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:53:38'),
	(10632, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:53:38'),
	(10633, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:53:38'),
	(10634, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:53:38'),
	(10635, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:53:38'),
	(10636, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:53:38'),
	(10637, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:53:38'),
	(10638, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:53:38'),
	(10639, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:53:38'),
	(10640, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:53:38'),
	(10641, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:53:38'),
	(10642, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:53:38'),
	(10643, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:53:38'),
	(10644, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:53:38'),
	(10645, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:53:38'),
	(10646, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:53:38'),
	(10647, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:53:38'),
	(10648, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:53:38'),
	(10649, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:53:38'),
	(10650, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:55:32'),
	(10651, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:55:32'),
	(10652, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:55:32'),
	(10653, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:55:32'),
	(10654, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:55:32'),
	(10655, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:55:32'),
	(10656, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:55:32'),
	(10657, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:55:32'),
	(10658, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:55:32'),
	(10659, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:55:32'),
	(10660, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:55:32'),
	(10661, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:55:32'),
	(10662, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:55:32'),
	(10663, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:55:32'),
	(10664, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:55:32'),
	(10665, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:55:32'),
	(10666, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:55:32'),
	(10667, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:55:32'),
	(10668, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:55:32'),
	(10669, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:55:32'),
	(10670, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:55:32'),
	(10671, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:55:32'),
	(10672, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:55:32'),
	(10673, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:57:12'),
	(10674, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:57:12'),
	(10675, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:57:12'),
	(10676, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:57:12'),
	(10677, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:57:12'),
	(10678, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:57:12'),
	(10679, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:57:12'),
	(10680, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:57:12'),
	(10681, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:57:12'),
	(10682, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:57:12'),
	(10683, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:57:12'),
	(10684, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:57:12'),
	(10685, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:57:12'),
	(10686, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:57:12'),
	(10687, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:57:12'),
	(10688, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:57:12'),
	(10689, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:57:12'),
	(10690, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:57:12'),
	(10691, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:57:12'),
	(10692, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:57:12'),
	(10693, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:57:12'),
	(10694, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:57:12'),
	(10695, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:57:12'),
	(10696, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-11 23:58:11'),
	(10697, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-11 23:58:11'),
	(10698, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-11 23:58:11'),
	(10699, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-11 23:58:11'),
	(10700, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-11 23:58:11'),
	(10701, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-11 23:58:11'),
	(10702, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-11 23:58:11'),
	(10703, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-11 23:58:11'),
	(10704, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-11 23:58:11'),
	(10705, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-11 23:58:11'),
	(10706, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-11 23:58:11'),
	(10707, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-11 23:58:11'),
	(10708, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-11 23:58:11'),
	(10709, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-11 23:58:12'),
	(10710, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-11 23:58:12'),
	(10711, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-11 23:58:12'),
	(10712, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-11 23:58:12'),
	(10713, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-11 23:58:12'),
	(10714, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-11 23:58:12'),
	(10715, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-11 23:58:12'),
	(10716, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-11 23:58:12'),
	(10717, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-11 23:58:12'),
	(10718, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-11 23:58:12'),
	(10719, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:00:27'),
	(10720, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:00:27'),
	(10721, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:00:27'),
	(10722, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:00:27'),
	(10723, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:00:27'),
	(10724, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:00:27'),
	(10725, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:00:27'),
	(10726, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:00:27'),
	(10727, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:00:27'),
	(10728, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:00:27'),
	(10729, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:00:27'),
	(10730, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:00:27'),
	(10731, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:00:27'),
	(10732, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:00:27'),
	(10733, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:00:27'),
	(10734, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:00:27'),
	(10735, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:00:27'),
	(10736, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:00:27'),
	(10737, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:00:27'),
	(10738, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:00:27'),
	(10739, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:00:27'),
	(10740, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:00:27'),
	(10741, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:00:27'),
	(10742, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:05:23'),
	(10743, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:05:23'),
	(10744, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:05:23'),
	(10745, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:05:23'),
	(10746, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:05:23'),
	(10747, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:05:23'),
	(10748, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:05:23'),
	(10749, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:05:23'),
	(10750, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:05:23'),
	(10751, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:05:23'),
	(10752, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:05:23'),
	(10753, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:05:23'),
	(10754, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:05:23'),
	(10755, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:05:23'),
	(10756, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:05:23'),
	(10757, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:05:23'),
	(10758, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:05:23'),
	(10759, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:05:23'),
	(10760, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:05:23'),
	(10761, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:05:23'),
	(10762, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:05:23'),
	(10763, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:05:23'),
	(10764, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:05:23'),
	(10765, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:08:10'),
	(10766, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:08:10'),
	(10767, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:08:10'),
	(10768, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:08:10'),
	(10769, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:08:10'),
	(10770, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:08:10'),
	(10771, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:08:10'),
	(10772, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:08:10'),
	(10773, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:08:10'),
	(10774, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:08:10'),
	(10775, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:08:10'),
	(10776, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:08:10'),
	(10777, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:08:10'),
	(10778, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:08:10'),
	(10779, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:08:10'),
	(10780, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:08:10'),
	(10781, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:08:10'),
	(10782, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:08:10'),
	(10783, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:08:10'),
	(10784, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:08:10'),
	(10785, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:08:10'),
	(10786, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:08:10'),
	(10787, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:08:10'),
	(10788, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:12:03'),
	(10789, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:12:03'),
	(10790, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:12:03'),
	(10791, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:12:03'),
	(10792, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:12:03'),
	(10793, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:12:03'),
	(10794, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:12:03'),
	(10795, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:12:03'),
	(10796, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:12:03'),
	(10797, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:12:03'),
	(10798, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:12:03'),
	(10799, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:12:03'),
	(10800, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:12:03'),
	(10801, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:12:03'),
	(10802, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:12:03'),
	(10803, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:12:03'),
	(10804, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:12:03'),
	(10805, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:12:03'),
	(10806, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:12:03'),
	(10807, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:12:03'),
	(10808, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:12:03'),
	(10809, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:12:03'),
	(10810, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:12:03'),
	(10811, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:17:12'),
	(10812, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:17:12'),
	(10813, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:17:12'),
	(10814, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:17:12'),
	(10815, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:17:12'),
	(10816, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:17:12'),
	(10817, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:17:12'),
	(10818, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:17:12'),
	(10819, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:17:12'),
	(10820, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:17:12'),
	(10821, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:17:12'),
	(10822, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:17:12'),
	(10823, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:17:12'),
	(10824, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:17:12'),
	(10825, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:17:12'),
	(10826, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:17:12'),
	(10827, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:17:12'),
	(10828, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:17:12'),
	(10829, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:17:12'),
	(10830, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:17:12'),
	(10831, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:17:12'),
	(10832, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:17:12'),
	(10833, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:17:12'),
	(10834, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:24:15'),
	(10835, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:24:15'),
	(10836, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:24:15'),
	(10837, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:24:15'),
	(10838, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:24:15'),
	(10839, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:24:15'),
	(10840, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:24:15'),
	(10841, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:24:15'),
	(10842, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:24:15'),
	(10843, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:24:15'),
	(10844, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:24:15'),
	(10845, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:24:15'),
	(10846, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:24:15'),
	(10847, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:24:15'),
	(10848, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:24:15'),
	(10849, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:24:15'),
	(10850, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:24:15'),
	(10851, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:24:15'),
	(10852, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:24:15'),
	(10853, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:24:15'),
	(10854, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:24:15'),
	(10855, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:24:15'),
	(10856, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:24:15'),
	(10857, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:28:57'),
	(10858, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:28:57'),
	(10859, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:28:57'),
	(10860, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:28:57'),
	(10861, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:28:57'),
	(10862, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:28:57'),
	(10863, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:28:57'),
	(10864, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:28:57'),
	(10865, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:28:57'),
	(10866, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:28:57'),
	(10867, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:28:57'),
	(10868, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:28:57'),
	(10869, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:28:57'),
	(10870, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:28:57'),
	(10871, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:28:57'),
	(10872, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:28:57'),
	(10873, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:28:57'),
	(10874, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:28:57'),
	(10875, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:28:57'),
	(10876, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:28:57'),
	(10877, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:28:57'),
	(10878, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:28:57'),
	(10879, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:28:57'),
	(10880, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:30:34'),
	(10881, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:30:34'),
	(10882, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:30:34'),
	(10883, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:30:34'),
	(10884, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:30:34'),
	(10885, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:30:34'),
	(10886, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:30:34'),
	(10887, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:30:34'),
	(10888, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:30:34'),
	(10889, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:30:34'),
	(10890, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:30:34'),
	(10891, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:30:34'),
	(10892, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:30:34'),
	(10893, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:30:34'),
	(10894, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:30:34'),
	(10895, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:30:34'),
	(10896, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:30:34'),
	(10897, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:30:34'),
	(10898, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:30:34'),
	(10899, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:30:34'),
	(10900, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:30:34'),
	(10901, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:30:34'),
	(10902, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:30:34'),
	(10903, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:33:07'),
	(10904, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:33:07'),
	(10905, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:33:07'),
	(10906, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:33:07'),
	(10907, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:33:07'),
	(10908, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:33:07'),
	(10909, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:33:07'),
	(10910, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:33:07'),
	(10911, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:33:07'),
	(10912, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:33:07'),
	(10913, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:33:07'),
	(10914, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:33:07'),
	(10915, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:33:07'),
	(10916, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:33:07'),
	(10917, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:33:07'),
	(10918, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:33:07'),
	(10919, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:33:07'),
	(10920, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:33:07'),
	(10921, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:33:07'),
	(10922, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:33:07'),
	(10923, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:33:07'),
	(10924, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:33:07'),
	(10925, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:33:07'),
	(10926, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:40:16'),
	(10927, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:40:16'),
	(10928, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:40:16'),
	(10929, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:40:16'),
	(10930, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:40:16'),
	(10931, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:40:16'),
	(10932, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:40:16'),
	(10933, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:40:16'),
	(10934, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:40:16'),
	(10935, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:40:16'),
	(10936, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:40:16'),
	(10937, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:40:16'),
	(10938, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:40:16'),
	(10939, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:40:16'),
	(10940, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:40:16'),
	(10941, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:40:16'),
	(10942, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:40:16'),
	(10943, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:40:16'),
	(10944, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:40:16'),
	(10945, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:40:16'),
	(10946, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:40:16'),
	(10947, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:40:16'),
	(10948, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:40:16'),
	(10949, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:41:43'),
	(10950, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:41:43'),
	(10951, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:41:43'),
	(10952, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:41:43'),
	(10953, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:41:43'),
	(10954, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:41:43'),
	(10955, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:41:43'),
	(10956, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:41:43'),
	(10957, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:41:43'),
	(10958, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:41:43'),
	(10959, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:41:43'),
	(10960, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:41:43'),
	(10961, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:41:43'),
	(10962, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:41:43'),
	(10963, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:41:43'),
	(10964, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:41:43'),
	(10965, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:41:43'),
	(10966, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:41:43'),
	(10967, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:41:43'),
	(10968, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:41:43'),
	(10969, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:41:43'),
	(10970, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:41:43'),
	(10971, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:41:43'),
	(10972, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:46:41'),
	(10973, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:46:41'),
	(10974, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:46:41'),
	(10975, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:46:41'),
	(10976, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:46:41'),
	(10977, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:46:41'),
	(10978, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:46:41'),
	(10979, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:46:41'),
	(10980, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:46:41'),
	(10981, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:46:41'),
	(10982, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:46:41'),
	(10983, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:46:41'),
	(10984, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:46:41'),
	(10985, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:46:41'),
	(10986, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:46:41'),
	(10987, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:46:41'),
	(10988, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:46:41'),
	(10989, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:46:41'),
	(10990, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:46:41'),
	(10991, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:46:41'),
	(10992, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:46:41'),
	(10993, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:46:41'),
	(10994, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:46:41'),
	(10995, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:51:21'),
	(10996, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:51:21'),
	(10997, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:51:21'),
	(10998, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:51:21'),
	(10999, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:51:21'),
	(11000, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:51:21'),
	(11001, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:51:21'),
	(11002, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:51:21'),
	(11003, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:51:21'),
	(11004, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:51:21'),
	(11005, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:51:21'),
	(11006, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:51:21'),
	(11007, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:51:21'),
	(11008, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:51:21'),
	(11009, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:51:21'),
	(11010, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:51:21'),
	(11011, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:51:21'),
	(11012, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:51:21'),
	(11013, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:51:21'),
	(11014, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:51:21'),
	(11015, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:51:21'),
	(11016, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:51:21'),
	(11017, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:51:21'),
	(11018, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:53:27'),
	(11019, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:53:27'),
	(11020, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:53:27'),
	(11021, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:53:27'),
	(11022, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:53:27'),
	(11023, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:53:27'),
	(11024, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:53:27'),
	(11025, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:53:27'),
	(11026, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:53:27'),
	(11027, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:53:27'),
	(11028, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:53:27'),
	(11029, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:53:27'),
	(11030, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:53:27'),
	(11031, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:53:27'),
	(11032, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:53:27'),
	(11033, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:53:27'),
	(11034, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:53:27'),
	(11035, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:53:27'),
	(11036, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:53:27'),
	(11037, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:53:27'),
	(11038, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:53:27'),
	(11039, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:53:27'),
	(11040, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:53:27'),
	(11041, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 00:54:02'),
	(11042, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 00:54:02'),
	(11043, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 00:54:02'),
	(11044, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 00:54:02'),
	(11045, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 00:54:02'),
	(11046, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 00:54:02'),
	(11047, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 00:54:02'),
	(11048, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 00:54:02'),
	(11049, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 00:54:02'),
	(11050, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 00:54:02'),
	(11051, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 00:54:02'),
	(11052, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 00:54:02'),
	(11053, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 00:54:02'),
	(11054, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 00:54:02'),
	(11055, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 00:54:02'),
	(11056, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 00:54:02'),
	(11057, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 00:54:02'),
	(11058, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 00:54:02'),
	(11059, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 00:54:02'),
	(11060, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 00:54:02'),
	(11061, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 00:54:02'),
	(11062, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 00:54:02'),
	(11063, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 00:54:02'),
	(11064, 1, 'USD', 42.572600, 42.534300, 42.610900, 'tcmb', '2025-12-12 12:06:38'),
	(11065, 1, 'AUD', 28.302250, 28.210300, 28.394200, 'tcmb', '2025-12-12 12:06:38'),
	(11066, 1, 'DKK', 6.669150, 6.652800, 6.685500, 'tcmb', '2025-12-12 12:06:38'),
	(11067, 1, 'EUR', 49.812050, 49.767200, 49.856900, 'tcmb', '2025-12-12 12:06:38'),
	(11068, 1, 'GBP', 56.935150, 56.787100, 57.083200, 'tcmb', '2025-12-12 12:06:38'),
	(11069, 1, 'CHF', 53.326250, 53.155600, 53.496900, 'tcmb', '2025-12-12 12:06:38'),
	(11070, 1, 'SEK', 4.595600, 4.571900, 4.619300, 'tcmb', '2025-12-12 12:06:38'),
	(11071, 1, 'CAD', 30.829200, 30.759800, 30.898600, 'tcmb', '2025-12-12 12:06:38'),
	(11072, 1, 'KWD', 138.755750, 137.853800, 139.657700, 'tcmb', '2025-12-12 12:06:38'),
	(11073, 1, 'NOK', 4.213200, 4.199100, 4.227300, 'tcmb', '2025-12-12 12:06:38'),
	(11074, 1, 'SAR', 11.344200, 11.334000, 11.354400, 'tcmb', '2025-12-12 12:06:38'),
	(11075, 1, 'JPY', 0.273081, 0.272179, 0.273982, 'tcmb', '2025-12-12 12:06:38'),
	(11076, 1, 'BGN', 25.430900, 25.265600, 25.596200, 'tcmb', '2025-12-12 12:06:38'),
	(11077, 1, 'RON', 9.786200, 9.722600, 9.849800, 'tcmb', '2025-12-12 12:06:38'),
	(11078, 1, 'RUB', 0.538200, 0.534700, 0.541700, 'tcmb', '2025-12-12 12:06:38'),
	(11079, 1, 'CNY', 6.031300, 5.992100, 6.070500, 'tcmb', '2025-12-12 12:06:38'),
	(11080, 1, 'PKR', 0.151635, 0.150650, 0.152620, 'tcmb', '2025-12-12 12:06:38'),
	(11081, 1, 'QAR', 11.679700, 11.603800, 11.755600, 'tcmb', '2025-12-12 12:06:38'),
	(11082, 1, 'KRW', 0.028910, 0.028720, 0.029100, 'tcmb', '2025-12-12 12:06:38'),
	(11083, 1, 'AZN', 25.042700, 24.879900, 25.205500, 'tcmb', '2025-12-12 12:06:38'),
	(11084, 1, 'AED', 11.591450, 11.516100, 11.666800, 'tcmb', '2025-12-12 12:06:38'),
	(11085, 1, 'KZT', 0.081835, 0.081300, 0.082370, 'tcmb', '2025-12-12 12:06:38'),
	(11086, 1, 'XDR', 29.069850, 58.139700, 0.000000, 'tcmb', '2025-12-12 12:06:38'),
	(11087, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 12:48:44'),
	(11088, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 12:48:44'),
	(11089, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 12:48:44'),
	(11090, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 12:48:44'),
	(11091, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 12:48:44'),
	(11092, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 12:48:44'),
	(11093, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 12:48:44'),
	(11094, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 12:48:44'),
	(11095, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 12:48:44'),
	(11096, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 12:48:44'),
	(11097, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 12:48:44'),
	(11098, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 12:48:44'),
	(11099, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 12:48:44'),
	(11100, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 12:48:44'),
	(11101, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 12:48:44'),
	(11102, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 12:48:44'),
	(11103, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 12:48:44'),
	(11104, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 12:48:44'),
	(11105, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 12:48:44'),
	(11106, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 12:48:44'),
	(11107, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 12:48:44'),
	(11108, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 12:48:44'),
	(11109, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 12:48:44'),
	(11110, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 16:51:22'),
	(11111, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 16:51:22'),
	(11112, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 16:51:22'),
	(11113, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 16:51:22'),
	(11114, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 16:51:22'),
	(11115, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 16:51:22'),
	(11116, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 16:51:22'),
	(11117, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 16:51:22'),
	(11118, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 16:51:22'),
	(11119, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 16:51:22'),
	(11120, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 16:51:22'),
	(11121, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 16:51:22'),
	(11122, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 16:51:22'),
	(11123, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 16:51:22'),
	(11124, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 16:51:22'),
	(11125, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 16:51:22'),
	(11126, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 16:51:22'),
	(11127, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 16:51:22'),
	(11128, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 16:51:22'),
	(11129, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 16:51:22'),
	(11130, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 16:51:22'),
	(11131, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 16:51:22'),
	(11132, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 16:51:22'),
	(11133, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 16:51:59'),
	(11134, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 16:51:59'),
	(11135, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 16:51:59'),
	(11136, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 16:51:59'),
	(11137, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 16:51:59'),
	(11138, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 16:51:59'),
	(11139, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 16:51:59'),
	(11140, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 16:51:59'),
	(11141, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 16:51:59'),
	(11142, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 16:51:59'),
	(11143, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 16:51:59'),
	(11144, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 16:51:59'),
	(11145, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 16:51:59'),
	(11146, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 16:51:59'),
	(11147, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 16:51:59'),
	(11148, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 16:51:59'),
	(11149, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 16:51:59'),
	(11150, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 16:51:59'),
	(11151, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 16:51:59'),
	(11152, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 16:51:59'),
	(11153, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 16:51:59'),
	(11154, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 16:51:59'),
	(11155, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 16:51:59'),
	(11156, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 16:52:35'),
	(11157, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 16:52:35'),
	(11158, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 16:52:35'),
	(11159, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 16:52:35'),
	(11160, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 16:52:35'),
	(11161, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 16:52:35'),
	(11162, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 16:52:35'),
	(11163, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 16:52:35'),
	(11164, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 16:52:35'),
	(11165, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 16:52:35'),
	(11166, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 16:52:35'),
	(11167, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 16:52:35'),
	(11168, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 16:52:35'),
	(11169, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 16:52:35'),
	(11170, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 16:52:35'),
	(11171, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 16:52:35'),
	(11172, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 16:52:35'),
	(11173, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 16:52:35'),
	(11174, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 16:52:35'),
	(11175, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 16:52:35'),
	(11176, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 16:52:35'),
	(11177, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 16:52:35'),
	(11178, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 16:52:35'),
	(11179, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 16:55:57'),
	(11180, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 16:55:57'),
	(11181, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 16:55:57'),
	(11182, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 16:55:57'),
	(11183, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 16:55:57'),
	(11184, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 16:55:57'),
	(11185, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 16:55:57'),
	(11186, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 16:55:57'),
	(11187, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 16:55:57'),
	(11188, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 16:55:57'),
	(11189, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 16:55:57'),
	(11190, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 16:55:57'),
	(11191, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 16:55:57'),
	(11192, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 16:55:57'),
	(11193, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 16:55:57'),
	(11194, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 16:55:57'),
	(11195, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 16:55:57'),
	(11196, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 16:55:57'),
	(11197, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 16:55:57'),
	(11198, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 16:55:57'),
	(11199, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 16:55:57'),
	(11200, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 16:55:57'),
	(11201, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 16:55:57'),
	(11202, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 16:59:39'),
	(11203, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 16:59:39'),
	(11204, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 16:59:39'),
	(11205, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 16:59:39'),
	(11206, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 16:59:39'),
	(11207, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 16:59:39'),
	(11208, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 16:59:39'),
	(11209, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 16:59:39'),
	(11210, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 16:59:39'),
	(11211, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 16:59:39'),
	(11212, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 16:59:39'),
	(11213, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 16:59:39'),
	(11214, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 16:59:39'),
	(11215, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 16:59:39'),
	(11216, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 16:59:39'),
	(11217, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 16:59:39'),
	(11218, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 16:59:39'),
	(11219, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 16:59:39'),
	(11220, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 16:59:39'),
	(11221, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 16:59:39'),
	(11222, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 16:59:39'),
	(11223, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 16:59:39'),
	(11224, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 16:59:39'),
	(11225, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:01:14'),
	(11226, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:01:14'),
	(11227, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:01:14'),
	(11228, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:01:14'),
	(11229, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:01:14'),
	(11230, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:01:14'),
	(11231, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:01:14'),
	(11232, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:01:14'),
	(11233, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:01:14'),
	(11234, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:01:14'),
	(11235, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:01:14'),
	(11236, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:01:14'),
	(11237, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:01:14'),
	(11238, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:01:14'),
	(11239, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:01:14'),
	(11240, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:01:14'),
	(11241, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:01:14'),
	(11242, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:01:14'),
	(11243, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:01:14'),
	(11244, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:01:14'),
	(11245, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:01:14'),
	(11246, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:01:14'),
	(11247, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:01:14'),
	(11248, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:03:36'),
	(11249, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:03:36'),
	(11250, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:03:36'),
	(11251, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:03:36'),
	(11252, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:03:36'),
	(11253, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:03:36'),
	(11254, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:03:36'),
	(11255, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:03:36'),
	(11256, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:03:36'),
	(11257, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:03:36'),
	(11258, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:03:36'),
	(11259, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:03:36'),
	(11260, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:03:36'),
	(11261, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:03:36'),
	(11262, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:03:36'),
	(11263, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:03:36'),
	(11264, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:03:36'),
	(11265, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:03:36'),
	(11266, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:03:36'),
	(11267, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:03:36'),
	(11268, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:03:36'),
	(11269, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:03:36'),
	(11270, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:03:36'),
	(11271, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:04:54'),
	(11272, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:04:54'),
	(11273, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:04:54'),
	(11274, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:04:54'),
	(11275, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:04:54'),
	(11276, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:04:54'),
	(11277, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:04:54'),
	(11278, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:04:54'),
	(11279, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:04:54'),
	(11280, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:04:54'),
	(11281, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:04:54'),
	(11282, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:04:54'),
	(11283, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:04:54'),
	(11284, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:04:54'),
	(11285, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:04:54'),
	(11286, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:04:54'),
	(11287, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:04:54'),
	(11288, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:04:54'),
	(11289, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:04:54'),
	(11290, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:04:54'),
	(11291, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:04:54'),
	(11292, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:04:54'),
	(11293, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:04:54'),
	(11294, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:08:07'),
	(11295, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:08:07'),
	(11296, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:08:07'),
	(11297, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:08:07'),
	(11298, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:08:07'),
	(11299, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:08:07'),
	(11300, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:08:07'),
	(11301, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:08:07'),
	(11302, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:08:07'),
	(11303, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:08:07'),
	(11304, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:08:07'),
	(11305, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:08:07'),
	(11306, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:08:07'),
	(11307, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:08:07'),
	(11308, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:08:07'),
	(11309, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:08:07'),
	(11310, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:08:07'),
	(11311, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:08:07'),
	(11312, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:08:07'),
	(11313, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:08:07'),
	(11314, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:08:07'),
	(11315, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:08:07'),
	(11316, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:08:07'),
	(11317, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:08:57'),
	(11318, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:08:57'),
	(11319, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:08:57'),
	(11320, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:08:57'),
	(11321, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:08:57'),
	(11322, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:08:57'),
	(11323, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:08:57'),
	(11324, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:08:57'),
	(11325, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:08:57'),
	(11326, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:08:57'),
	(11327, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:08:57'),
	(11328, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:08:57'),
	(11329, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:08:57'),
	(11330, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:08:57'),
	(11331, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:08:57'),
	(11332, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:08:57'),
	(11333, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:08:57'),
	(11334, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:08:57'),
	(11335, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:08:57'),
	(11336, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:08:57'),
	(11337, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:08:57'),
	(11338, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:08:57'),
	(11339, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:08:57'),
	(11340, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:13:04'),
	(11341, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:13:04'),
	(11342, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:13:04'),
	(11343, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:13:04'),
	(11344, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:13:04'),
	(11345, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:13:04'),
	(11346, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:13:04'),
	(11347, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:13:04'),
	(11348, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:13:04'),
	(11349, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:13:04'),
	(11350, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:13:04'),
	(11351, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:13:04'),
	(11352, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:13:04'),
	(11353, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:13:04'),
	(11354, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:13:04'),
	(11355, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:13:04'),
	(11356, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:13:04'),
	(11357, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:13:04'),
	(11358, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:13:04'),
	(11359, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:13:04'),
	(11360, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:13:04'),
	(11361, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:13:04'),
	(11362, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:13:04'),
	(11363, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:19:03'),
	(11364, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:19:03'),
	(11365, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:19:03'),
	(11366, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:19:03'),
	(11367, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:19:03'),
	(11368, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:19:03'),
	(11369, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:19:03'),
	(11370, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:19:03'),
	(11371, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:19:03'),
	(11372, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:19:03'),
	(11373, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:19:03'),
	(11374, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:19:03'),
	(11375, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:19:03'),
	(11376, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:19:03'),
	(11377, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:19:03'),
	(11378, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:19:03'),
	(11379, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:19:03'),
	(11380, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:19:03'),
	(11381, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:19:03'),
	(11382, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:19:03'),
	(11383, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:19:03'),
	(11384, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:19:03'),
	(11385, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:19:03'),
	(11386, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:20:55'),
	(11387, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:20:55'),
	(11388, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:20:55'),
	(11389, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:20:55'),
	(11390, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:20:55'),
	(11391, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:20:55'),
	(11392, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:20:55'),
	(11393, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:20:55'),
	(11394, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:20:55'),
	(11395, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:20:55'),
	(11396, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:20:55'),
	(11397, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:20:55'),
	(11398, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:20:55'),
	(11399, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:20:55'),
	(11400, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:20:55'),
	(11401, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:20:55'),
	(11402, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:20:55'),
	(11403, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:20:55'),
	(11404, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:20:55'),
	(11405, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:20:55'),
	(11406, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:20:55'),
	(11407, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:20:55'),
	(11408, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:20:55'),
	(11409, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:25:07'),
	(11410, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:25:07'),
	(11411, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:25:07'),
	(11412, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:25:07'),
	(11413, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:25:07'),
	(11414, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:25:07'),
	(11415, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:25:07'),
	(11416, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:25:07'),
	(11417, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:25:07'),
	(11418, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:25:07'),
	(11419, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:25:07'),
	(11420, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:25:07'),
	(11421, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:25:07'),
	(11422, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:25:07'),
	(11423, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:25:07'),
	(11424, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:25:07'),
	(11425, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:25:07'),
	(11426, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:25:07'),
	(11427, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:25:07'),
	(11428, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:25:07'),
	(11429, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:25:07'),
	(11430, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:25:07'),
	(11431, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:25:07'),
	(11432, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:27:38'),
	(11433, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:27:38'),
	(11434, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:27:38'),
	(11435, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:27:38'),
	(11436, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:27:38'),
	(11437, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:27:38'),
	(11438, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:27:38'),
	(11439, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:27:38'),
	(11440, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:27:38'),
	(11441, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:27:38'),
	(11442, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:27:38'),
	(11443, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:27:38'),
	(11444, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:27:38'),
	(11445, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:27:38'),
	(11446, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:27:38'),
	(11447, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:27:38'),
	(11448, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:27:38'),
	(11449, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:27:38'),
	(11450, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:27:38'),
	(11451, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:27:38'),
	(11452, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:27:38'),
	(11453, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:27:38'),
	(11454, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:27:38'),
	(11455, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:30:47'),
	(11456, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:30:47'),
	(11457, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:30:47'),
	(11458, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:30:47'),
	(11459, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:30:47'),
	(11460, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:30:47'),
	(11461, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:30:47'),
	(11462, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:30:47'),
	(11463, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:30:47'),
	(11464, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:30:47'),
	(11465, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:30:47'),
	(11466, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:30:47'),
	(11467, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:30:47'),
	(11468, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:30:47'),
	(11469, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:30:47'),
	(11470, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:30:47'),
	(11471, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:30:47'),
	(11472, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:30:47'),
	(11473, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:30:47'),
	(11474, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:30:47'),
	(11475, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:30:47'),
	(11476, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:30:47'),
	(11477, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:30:47'),
	(11478, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:31:40'),
	(11479, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:31:40'),
	(11480, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:31:40'),
	(11481, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:31:40'),
	(11482, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:31:40'),
	(11483, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:31:40'),
	(11484, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:31:40'),
	(11485, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:31:40'),
	(11486, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:31:40'),
	(11487, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:31:40'),
	(11488, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:31:40'),
	(11489, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:31:40'),
	(11490, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:31:40'),
	(11491, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:31:40'),
	(11492, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:31:40'),
	(11493, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:31:40'),
	(11494, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:31:40'),
	(11495, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:31:40'),
	(11496, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:31:40'),
	(11497, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:31:40'),
	(11498, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:31:40'),
	(11499, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:31:40'),
	(11500, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:31:40'),
	(11501, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:33:02'),
	(11502, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:33:02'),
	(11503, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:33:02'),
	(11504, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:33:02'),
	(11505, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:33:02'),
	(11506, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:33:02'),
	(11507, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:33:02'),
	(11508, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:33:02'),
	(11509, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:33:02'),
	(11510, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:33:02'),
	(11511, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:33:02'),
	(11512, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:33:02'),
	(11513, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:33:02'),
	(11514, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:33:02'),
	(11515, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:33:02'),
	(11516, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:33:02'),
	(11517, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:33:02'),
	(11518, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:33:02'),
	(11519, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:33:02'),
	(11520, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:33:02'),
	(11521, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:33:02'),
	(11522, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:33:02'),
	(11523, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:33:02'),
	(11524, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:35:05'),
	(11525, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:35:05'),
	(11526, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:35:05'),
	(11527, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:35:05'),
	(11528, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:35:05'),
	(11529, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:35:05'),
	(11530, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:35:05'),
	(11531, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:35:05'),
	(11532, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:35:05'),
	(11533, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:35:05'),
	(11534, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:35:05'),
	(11535, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:35:05'),
	(11536, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:35:05'),
	(11537, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:35:05'),
	(11538, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:35:05'),
	(11539, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:35:05'),
	(11540, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:35:05'),
	(11541, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:35:05'),
	(11542, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:35:05'),
	(11543, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:35:05'),
	(11544, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:35:05'),
	(11545, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:35:05'),
	(11546, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:35:05'),
	(11547, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:35:57'),
	(11548, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:35:57'),
	(11549, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:35:57'),
	(11550, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:35:57'),
	(11551, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:35:57'),
	(11552, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:35:57'),
	(11553, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:35:57'),
	(11554, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:35:57'),
	(11555, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:35:57'),
	(11556, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:35:57'),
	(11557, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:35:57'),
	(11558, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:35:57'),
	(11559, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:35:57'),
	(11560, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:35:57'),
	(11561, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:35:57'),
	(11562, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:35:57'),
	(11563, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:35:57'),
	(11564, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:35:57'),
	(11565, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:35:57'),
	(11566, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:35:57'),
	(11567, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:35:57'),
	(11568, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:35:57'),
	(11569, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:35:57'),
	(11570, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:39:54'),
	(11571, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:39:54'),
	(11572, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:39:54'),
	(11573, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:39:54'),
	(11574, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:39:54'),
	(11575, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:39:54'),
	(11576, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:39:54'),
	(11577, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:39:54'),
	(11578, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:39:54'),
	(11579, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:39:54'),
	(11580, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:39:54'),
	(11581, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:39:54'),
	(11582, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:39:54'),
	(11583, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:39:54'),
	(11584, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:39:54'),
	(11585, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:39:54'),
	(11586, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:39:54'),
	(11587, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:39:54'),
	(11588, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:39:54'),
	(11589, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:39:54'),
	(11590, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:39:54'),
	(11591, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:39:54'),
	(11592, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:39:54'),
	(11593, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:46:19'),
	(11594, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:46:19'),
	(11595, 1, 'DKK', 6.686650, 6.670300, 6.703000, 'tcmb', '2025-12-12 17:46:19'),
	(11596, 1, 'EUR', 49.945950, 49.901000, 49.990900, 'tcmb', '2025-12-12 17:46:19'),
	(11597, 1, 'GBP', 56.971850, 56.823700, 57.120000, 'tcmb', '2025-12-12 17:46:19'),
	(11598, 1, 'CHF', 53.545550, 53.374200, 53.716900, 'tcmb', '2025-12-12 17:46:19'),
	(11599, 1, 'SEK', 4.592850, 4.569200, 4.616500, 'tcmb', '2025-12-12 17:46:19'),
	(11600, 1, 'CAD', 30.934400, 30.864800, 31.004000, 'tcmb', '2025-12-12 17:46:19'),
	(11601, 1, 'KWD', 138.808150, 137.905900, 139.710400, 'tcmb', '2025-12-12 17:46:19'),
	(11602, 1, 'NOK', 4.219900, 4.205800, 4.234000, 'tcmb', '2025-12-12 17:46:19'),
	(11603, 1, 'SAR', 11.344750, 11.334500, 11.355000, 'tcmb', '2025-12-12 17:46:19'),
	(11604, 1, 'JPY', 0.273235, 0.272333, 0.274136, 'tcmb', '2025-12-12 17:46:19'),
	(11605, 1, 'BGN', 25.532750, 25.366800, 25.698700, 'tcmb', '2025-12-12 17:46:19'),
	(11606, 1, 'RON', 9.812800, 9.749000, 9.876600, 'tcmb', '2025-12-12 17:46:19'),
	(11607, 1, 'RUB', 0.534485, 0.531010, 0.537960, 'tcmb', '2025-12-12 17:46:19'),
	(11608, 1, 'CNY', 6.034200, 5.995000, 6.073400, 'tcmb', '2025-12-12 17:46:19'),
	(11609, 1, 'PKR', 0.151910, 0.150920, 0.152900, 'tcmb', '2025-12-12 17:46:19'),
	(11610, 1, 'QAR', 11.679750, 11.603800, 11.755700, 'tcmb', '2025-12-12 17:46:19'),
	(11611, 1, 'KRW', 0.028830, 0.028640, 0.029020, 'tcmb', '2025-12-12 17:46:19'),
	(11612, 1, 'AZN', 25.042750, 24.880000, 25.205500, 'tcmb', '2025-12-12 17:46:19'),
	(11613, 1, 'AED', 11.591550, 11.516200, 11.666900, 'tcmb', '2025-12-12 17:46:19'),
	(11614, 1, 'KZT', 0.081575, 0.081040, 0.082110, 'tcmb', '2025-12-12 17:46:19'),
	(11615, 1, 'XDR', 29.099050, 58.198100, 0.000000, 'tcmb', '2025-12-12 17:46:19'),
	(11616, 1, 'USD', 42.572700, 42.534400, 42.611000, 'tcmb', '2025-12-12 17:48:55'),
	(11617, 1, 'AUD', 28.390650, 28.298400, 28.482900, 'tcmb', '2025-12-12 17:48:55'),
	(11618, 1